/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.system.device.windows;

import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.bread_experts_group.api.feature.FeatureExpression;
import org.bread_experts_group.api.feature.FeatureProvider;
import org.bread_experts_group.api.feature.ImplementationSource;
import org.bread_experts_group.api.system.device.SystemDevice;
import org.bread_experts_group.api.system.device.SystemDeviceFeatures;
import org.bread_experts_group.api.system.device.feature.SystemDeviceBasicIdentifierFeature;
import org.bread_experts_group.api.system.device.feature.SystemDeviceMoveFeature;
import org.bread_experts_group.api.system.device.feature.move.SystemDeviceMoveFeatureImplementation;
import org.bread_experts_group.api.system.device.feature.move.SystemDeviceMoveHandle;
import org.bread_experts_group.api.system.device.feature.move.feature.routine.MoveProgressRoutineFeature;
import org.bread_experts_group.api.system.device.feature.move.feature.routine.MoveProgressRoutineFeatureImplementation;
import org.bread_experts_group.api.system.device.feature.move.feature.routine.MoveProgressRoutineFeatures;
import org.bread_experts_group.api.system.device.feature.move.feature.routine.WindowsMoveProgressRoutineReturns;
import org.bread_experts_group.api.system.device.feature.move.feature.routine.feature.MoveProgressRoutineNumericBytesFeature;
import org.bread_experts_group.api.system.device.feature.move.feature.routine.feature.MoveProgressRoutineSystemIdentifierFeature;
import org.bread_experts_group.api.system.device.feature.move.feature.windows.WindowsSystemDeviceMoveProgressRoutineFeature;
import org.bread_experts_group.api.system.device.move.MoveSystemDeviceFeatureIdentifier;
import org.bread_experts_group.api.system.device.move.WindowsMoveSystemDeviceFeatures;
import org.bread_experts_group.ffi.ForeignFunctionInterfaceKt;
import org.bread_experts_group.ffi.windows.WindowsKernelHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsLayoutsKt;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lorg/bread_experts_group/api/system/device/windows/WindowsSystemDeviceMoveFeature;", "Lorg/bread_experts_group/api/system/device/feature/SystemDeviceMoveFeature;", "pathSegment", "Ljava/lang/foreign/MemorySegment;", "<init>", "(Ljava/lang/foreign/MemorySegment;)V", "source", "Lorg/bread_experts_group/api/feature/ImplementationSource;", "getSource", "()Lorg/bread_experts_group/api/feature/ImplementationSource;", "supported", "", "move", "Lorg/bread_experts_group/api/system/device/feature/move/SystemDeviceMoveHandle;", "destination", "Lorg/bread_experts_group/api/system/device/SystemDevice;", "bread_server_lib"})
public final class WindowsSystemDeviceMoveFeature
extends SystemDeviceMoveFeature {
    @NotNull
    private final MemorySegment pathSegment;
    @NotNull
    private final ImplementationSource source;

    public WindowsSystemDeviceMoveFeature(@NotNull MemorySegment pathSegment) {
        Intrinsics.checkNotNullParameter(pathSegment, "pathSegment");
        this.pathSegment = pathSegment;
        this.source = ImplementationSource.SYSTEM_NATIVE;
    }

    @Override
    @NotNull
    public ImplementationSource getSource() {
        return this.source;
    }

    @Override
    public boolean supported() {
        return WindowsKernelHandlesKt.getNativeMoveFileWithProgressW() != null;
    }

    @Override
    @NotNull
    public SystemDeviceMoveHandle move(@NotNull SystemDevice destination) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        return new SystemDeviceMoveHandle(destination, this){
            private final WindowsSystemDeviceMoveProgressRoutineFeature rtFeature;
            private final List<SystemDeviceMoveFeatureImplementation<?>> features;
            final /* synthetic */ SystemDevice $destination;
            final /* synthetic */ WindowsSystemDeviceMoveFeature this$0;
            {
                this.$destination = $destination;
                this.this$0 = $receiver;
                this.rtFeature = new WindowsSystemDeviceMoveProgressRoutineFeature();
                SystemDeviceMoveFeatureImplementation[] systemDeviceMoveFeatureImplementationArray = new SystemDeviceMoveFeatureImplementation[]{this.rtFeature};
                this.features = CollectionsKt.mutableListOf(systemDeviceMoveFeatureImplementationArray);
            }

            public List<SystemDeviceMoveFeatureImplementation<?>> getFeatures() {
                return this.features;
            }

            public final int progressRoutine(long totalFileSize, long totalFileTransferred, long totalStreamSize, long totalStreamTransferred, int streamNumber, int callbackReason, MemorySegment sourceFile, MemorySegment destinationFile, MemorySegment lpData) {
                int n;
                Intrinsics.checkNotNullParameter(sourceFile, "sourceFile");
                Intrinsics.checkNotNullParameter(destinationFile, "destinationFile");
                Intrinsics.checkNotNullParameter(lpData, "lpData");
                Function1<FeatureProvider<MoveProgressRoutineFeatureImplementation<?>>, List<MoveProgressRoutineFeature>> routine = this.rtFeature.getRoutine();
                if (routine != null) {
                    MoveProgressRoutineFeatureImplementation[] moveProgressRoutineFeatureImplementationArray = new MoveProgressRoutineFeatureImplementation[]{new MoveProgressRoutineNumericBytesFeature(MoveProgressRoutineFeatures.INSTANCE.getTOTAL_SIZE_BYTES(), ImplementationSource.SYSTEM_NATIVE, totalFileSize), new MoveProgressRoutineNumericBytesFeature(MoveProgressRoutineFeatures.INSTANCE.getTOTAL_TRANSFERRED_BYTES(), ImplementationSource.SYSTEM_NATIVE, totalFileTransferred), new MoveProgressRoutineNumericBytesFeature(MoveProgressRoutineFeatures.INSTANCE.getFILE_STREAM_TOTAL_SIZE_BYTES(), ImplementationSource.SYSTEM_NATIVE, totalStreamSize), new MoveProgressRoutineNumericBytesFeature(MoveProgressRoutineFeatures.INSTANCE.getFILE_STREAM_TOTAL_TRANSFERRED_BYTES(), ImplementationSource.SYSTEM_NATIVE, totalStreamTransferred), new MoveProgressRoutineSystemIdentifierFeature(MoveProgressRoutineFeatures.INSTANCE.getFILE_STREAM_SYSTEM_IDENTIFIER(), ImplementationSource.SYSTEM_NATIVE, streamNumber), new MoveProgressRoutineSystemIdentifierFeature(MoveProgressRoutineFeatures.INSTANCE.getCALL_REASON_SYSTEM_IDENTIFIER(), ImplementationSource.SYSTEM_NATIVE, callbackReason)};
                    List<MoveProgressRoutineFeatureImplementation<?>> features2 = CollectionsKt.mutableListOf(moveProgressRoutineFeatureImplementationArray);
                    List<MoveProgressRoutineFeature> actions2 = routine.invoke(new FeatureProvider<MoveProgressRoutineFeatureImplementation<?>>(features2){
                        private final Map<FeatureExpression<? extends MoveProgressRoutineFeatureImplementation<?>>, List<MoveProgressRoutineFeatureImplementation<?>>> supportedFeatures;
                        private final List<MoveProgressRoutineFeatureImplementation<?>> features;
                        {
                            this.supportedFeatures = new LinkedHashMap<K, V>();
                            this.features = $features;
                        }

                        public Logger getLogger() {
                            String string = "Not yet implemented";
                            throw new NotImplementedError("An operation is not implemented: " + string);
                        }

                        public Map<FeatureExpression<? extends MoveProgressRoutineFeatureImplementation<?>>, List<MoveProgressRoutineFeatureImplementation<?>>> getSupportedFeatures() {
                            return this.supportedFeatures;
                        }

                        public List<MoveProgressRoutineFeatureImplementation<?>> getFeatures() {
                            return this.features;
                        }
                    });
                    n = actions2.contains(WindowsMoveProgressRoutineReturns.STOP_COPY_AND_DELETE_DESTINATION) ? 1 : (actions2.contains(WindowsMoveProgressRoutineReturns.STOP_COPY_AND_RETAIN_DESTINATION) ? 2 : (actions2.contains(WindowsMoveProgressRoutineReturns.STOP_CALLING_ROUTINE) ? 3 : 0));
                } else {
                    n = 0;
                }
                return n;
            }

            public List<MoveSystemDeviceFeatureIdentifier> start(MoveSystemDeviceFeatureIdentifier ... features2) {
                Intrinsics.checkNotNullParameter(features2, "features");
                List supportedFeatures = new ArrayList<E>();
                int flags = 0;
                if (ArraysKt.contains(features2, WindowsMoveSystemDeviceFeatures.OVERWRITE)) {
                    flags |= 1;
                    supportedFeatures.add(WindowsMoveSystemDeviceFeatures.OVERWRITE);
                }
                if (ArraysKt.contains(features2, WindowsMoveSystemDeviceFeatures.COPY_ALLOWED)) {
                    flags |= 2;
                    supportedFeatures.add(WindowsMoveSystemDeviceFeatures.MOVE_ON_RESTART);
                }
                if (ArraysKt.contains(features2, WindowsMoveSystemDeviceFeatures.MOVE_ON_RESTART)) {
                    flags |= 4;
                    supportedFeatures.add(WindowsMoveSystemDeviceFeatures.MOVE_ON_RESTART);
                }
                if (ArraysKt.contains(features2, WindowsMoveSystemDeviceFeatures.WRITE_THROUGH)) {
                    flags |= 8;
                    supportedFeatures.add(WindowsMoveSystemDeviceFeatures.WRITE_THROUGH);
                }
                if (ArraysKt.contains(features2, WindowsMoveSystemDeviceFeatures.FAIL_IF_NOT_TRACKABLE)) {
                    flags |= 0x20;
                    supportedFeatures.add(WindowsMoveSystemDeviceFeatures.FAIL_IF_NOT_TRACKABLE);
                }
                Arena arena = Arena.ofConfined();
                Object object = ((SystemDeviceBasicIdentifierFeature)FeatureProvider.get$default(this.$destination, SystemDeviceFeatures.INSTANCE.getSYSTEM_IDENTIFIER(), false, 2, null)).getIdentity();
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.String");
                MemorySegment destinationSegment = arena.allocateFrom((String)object, Charsets.UTF_16LE);
                MethodHandle methodHandle = WindowsKernelHandlesKt.getNativeMoveFileWithProgressW();
                Intrinsics.checkNotNull(methodHandle);
                Object[] objectArray = new Class[]{Long.TYPE, Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, MemorySegment.class, MemorySegment.class, MemorySegment.class};
                MethodHandle methodHandle2 = MethodHandles.lookup().findSpecial(this.getClass(), "progressRoutine", MethodType.methodType(Integer.TYPE, Long.TYPE, objectArray), this.getClass()).bindTo(this);
                objectArray = new MemoryLayout[]{WindowsLayoutsKt.getLARGE_INTEGER(), WindowsLayoutsKt.getLARGE_INTEGER(), WindowsLayoutsKt.getLARGE_INTEGER(), WindowsLayoutsKt.getLARGE_INTEGER(), WindowsUtilitiesKt.getDWORD(), WindowsUtilitiesKt.getDWORD(), WindowsUtilitiesKt.getHANDLE(), WindowsUtilitiesKt.getHANDLE(), WindowsUtilitiesKt.getLPVOID()};
                int status = methodHandle.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), WindowsSystemDeviceMoveFeature.access$getPathSegment$p(this.this$0), destinationSegment, ForeignFunctionInterfaceKt.getNativeLinker().upcallStub(methodHandle2, FunctionDescriptor.of(WindowsUtilitiesKt.getDWORD(), (MemoryLayout[])objectArray), arena, new Linker.Option[0]), MemorySegment.NULL, flags);
                arena.close();
                if (status == 0) {
                    WindowsUtilitiesKt.throwLastError();
                    throw new KotlinNothingValueException();
                }
                return supportedFeatures;
            }
        };
    }

    public static final /* synthetic */ MemorySegment access$getPathSegment$p(WindowsSystemDeviceMoveFeature $this) {
        return $this.pathSegment;
    }
}

