/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.system.device.windows;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.invoke.MethodHandle;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.api.feature.ImplementationSource;
import org.bread_experts_group.api.system.device.SystemDevice;
import org.bread_experts_group.api.system.device.feature.SystemDeviceParentFeature;
import org.bread_experts_group.api.system.device.windows.WindowsDeviceUtilityKt;
import org.bread_experts_group.ffi.windows.WindowsKernelBaseHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001b\u0010\f\u001a\u00020\r8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lorg/bread_experts_group/api/system/device/windows/WindowsSystemDeviceParentFeature;", "Lorg/bread_experts_group/api/system/device/feature/SystemDeviceParentFeature;", "pathSegment", "Ljava/lang/foreign/MemorySegment;", "<init>", "(Ljava/lang/foreign/MemorySegment;)V", "source", "Lorg/bread_experts_group/api/feature/ImplementationSource;", "getSource", "()Lorg/bread_experts_group/api/feature/ImplementationSource;", "supported", "", "parent", "Lorg/bread_experts_group/api/system/device/SystemDevice;", "getParent", "()Lorg/bread_experts_group/api/system/device/SystemDevice;", "parent$delegate", "Lkotlin/Lazy;", "bread_server_lib"})
public final class WindowsSystemDeviceParentFeature
extends SystemDeviceParentFeature {
    @NotNull
    private final MemorySegment pathSegment;
    @NotNull
    private final ImplementationSource source;
    @NotNull
    private final Lazy parent$delegate;

    public WindowsSystemDeviceParentFeature(@NotNull MemorySegment pathSegment) {
        Intrinsics.checkNotNullParameter(pathSegment, "pathSegment");
        this.pathSegment = pathSegment;
        this.source = ImplementationSource.SYSTEM_NATIVE;
        this.parent$delegate = LazyKt.lazy(() -> WindowsSystemDeviceParentFeature.parent_delegate$lambda$0(this));
    }

    @Override
    @NotNull
    public ImplementationSource getSource() {
        return this.source;
    }

    @Override
    public boolean supported() {
        return WindowsKernelBaseHandlesKt.getNativePathCchRemoveBackslash() != null && WindowsKernelBaseHandlesKt.getNativePathCchRemoveFileSpec() != null;
    }

    @Override
    @NotNull
    public SystemDevice getParent() {
        Lazy lazy = this.parent$delegate;
        return (SystemDevice)lazy.getValue();
    }

    private static final SystemDevice parent_delegate$lambda$0(WindowsSystemDeviceParentFeature this$0) {
        Arena copyArena = Arena.ofShared();
        MemorySegment copied = copyArena.allocate(this$0.pathSegment.byteSize()).copyFrom(this$0.pathSegment);
        MethodHandle methodHandle = WindowsKernelBaseHandlesKt.getNativePathCchRemoveFileSpec();
        Intrinsics.checkNotNull(methodHandle);
        int status = methodHandle.invokeExact(copied, copied.byteSize() / (long)2);
        if (status != 1) {
            WindowsUtilitiesKt.decodeWin32Error(status);
        }
        Intrinsics.checkNotNull(copyArena);
        Intrinsics.checkNotNull(copied);
        return WindowsDeviceUtilityKt.createPathDevice(copyArena, copied);
    }
}

