/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.system.device.windows;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.invoke.MethodHandle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.bread_experts_group.api.feature.ImplementationSource;
import org.bread_experts_group.api.system.device.SystemDevice;
import org.bread_experts_group.api.system.device.feature.SystemDevicePathAppendFeature;
import org.bread_experts_group.api.system.device.windows.WindowsDeviceUtilityKt;
import org.bread_experts_group.ffi.windows.WindowsKernelBaseHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lorg/bread_experts_group/api/system/device/windows/WindowsSystemDevicePathAppendFeature;", "Lorg/bread_experts_group/api/system/device/feature/SystemDevicePathAppendFeature;", "pathSegment", "Ljava/lang/foreign/MemorySegment;", "<init>", "(Ljava/lang/foreign/MemorySegment;)V", "source", "Lorg/bread_experts_group/api/feature/ImplementationSource;", "getSource", "()Lorg/bread_experts_group/api/feature/ImplementationSource;", "supported", "", "append", "Lorg/bread_experts_group/api/system/device/SystemDevice;", "element", "", "bread_server_lib"})
public final class WindowsSystemDevicePathAppendFeature
extends SystemDevicePathAppendFeature {
    @NotNull
    private final MemorySegment pathSegment;
    @NotNull
    private final ImplementationSource source;

    public WindowsSystemDevicePathAppendFeature(@NotNull MemorySegment pathSegment) {
        Intrinsics.checkNotNullParameter(pathSegment, "pathSegment");
        this.pathSegment = pathSegment;
        this.source = ImplementationSource.SYSTEM_NATIVE;
    }

    @Override
    @NotNull
    public ImplementationSource getSource() {
        return this.source;
    }

    @Override
    public boolean supported() {
        return WindowsKernelBaseHandlesKt.getNativePathCchAppendEx() != null;
    }

    @Override
    @NotNull
    public SystemDevice append(@NotNull String element) {
        Intrinsics.checkNotNullParameter(element, "element");
        Arena appendArena = Arena.ofShared();
        MemorySegment append = appendArena.allocateFrom(element, Charsets.UTF_16LE);
        MemorySegment buffer = appendArena.allocate(this.pathSegment.byteSize() + (long)(element.length() * 2) + (long)4).copyFrom(this.pathSegment);
        MethodHandle methodHandle = WindowsKernelBaseHandlesKt.getNativePathCchAppendEx();
        Intrinsics.checkNotNull(methodHandle);
        WindowsUtilitiesKt.decodeWin32Error(methodHandle.invokeExact(buffer, buffer.byteSize() / (long)2, append, 3));
        Intrinsics.checkNotNull(appendArena);
        Intrinsics.checkNotNull(buffer);
        return WindowsDeviceUtilityKt.createPathDevice(appendArena, buffer);
    }
}

