/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.system.device.windows;

import java.lang.foreign.MemorySegment;
import java.lang.invoke.MethodHandle;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.api.feature.ImplementationSource;
import org.bread_experts_group.api.system.device.feature.SystemDeviceQueryTransparentEncryptionFeature;
import org.bread_experts_group.api.system.device.transparent_encrypt.TransparentEncryptionSystemDeviceStatusIdentifier;
import org.bread_experts_group.api.system.device.transparent_encrypt.WindowsTransparentEncryptionStatuses;
import org.bread_experts_group.ffi.ForeignFunctionInterfaceKt;
import org.bread_experts_group.ffi.windows.WindowsAdvAPIHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lorg/bread_experts_group/api/system/device/windows/WindowsSystemDeviceQueryTransparentEncryptionFeature;", "Lorg/bread_experts_group/api/system/device/feature/SystemDeviceQueryTransparentEncryptionFeature;", "pathSegment", "Ljava/lang/foreign/MemorySegment;", "<init>", "(Ljava/lang/foreign/MemorySegment;)V", "source", "Lorg/bread_experts_group/api/feature/ImplementationSource;", "getSource", "()Lorg/bread_experts_group/api/feature/ImplementationSource;", "supported", "", "query", "", "Lorg/bread_experts_group/api/system/device/transparent_encrypt/TransparentEncryptionSystemDeviceStatusIdentifier;", "bread_server_lib"})
public final class WindowsSystemDeviceQueryTransparentEncryptionFeature
extends SystemDeviceQueryTransparentEncryptionFeature {
    @NotNull
    private final MemorySegment pathSegment;
    @NotNull
    private final ImplementationSource source;

    public WindowsSystemDeviceQueryTransparentEncryptionFeature(@NotNull MemorySegment pathSegment) {
        Intrinsics.checkNotNullParameter(pathSegment, "pathSegment");
        this.pathSegment = pathSegment;
        this.source = ImplementationSource.SYSTEM_NATIVE;
    }

    @Override
    @NotNull
    public ImplementationSource getSource() {
        return this.source;
    }

    @Override
    public boolean supported() {
        return WindowsAdvAPIHandlesKt.getNativeFileEncryptionStatusW() != null;
    }

    @Override
    @NotNull
    public List<TransparentEncryptionSystemDeviceStatusIdentifier> query() {
        MethodHandle methodHandle = WindowsAdvAPIHandlesKt.getNativeFileEncryptionStatusW();
        Intrinsics.checkNotNull(methodHandle);
        int status = methodHandle.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), this.pathSegment, WindowsUtilitiesKt.getThreadLocalDWORD0());
        if (status == 0) {
            WindowsUtilitiesKt.throwLastError();
            throw new KotlinNothingValueException();
        }
        return switch (WindowsUtilitiesKt.getThreadLocalDWORD0().get(WindowsUtilitiesKt.getDWORD(), 0L)) {
            case 0 -> CollectionsKt.listOf(WindowsTransparentEncryptionStatuses.ENCRYPTABLE);
            case 1 -> CollectionsKt.listOf(WindowsTransparentEncryptionStatuses.ENCRYPTED);
            case 2 -> CollectionsKt.listOf(WindowsTransparentEncryptionStatuses.NOT_ENCRYPTED_SYSTEM_FILE);
            case 3 -> CollectionsKt.listOf(WindowsTransparentEncryptionStatuses.NOT_ENCRYPTED_ROOT_DIRECTORY);
            case 4 -> CollectionsKt.listOf(WindowsTransparentEncryptionStatuses.NOT_ENCRYPTED_SYSTEM_DIRECTORY);
            case 5 -> CollectionsKt.listOf(WindowsTransparentEncryptionStatuses.UNKNOWN);
            case 6 -> CollectionsKt.listOf(WindowsTransparentEncryptionStatuses.NOT_ENCRYPTED_FILE_SYSTEM_UNSUPPORTED);
            case 8 -> CollectionsKt.listOf(WindowsTransparentEncryptionStatuses.NOT_ENCRYPTABLE_READ_ONLY);
            default -> CollectionsKt.emptyList();
        };
    }
}

