/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.system.device.windows;

import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.api.feature.ImplementationSource;
import org.bread_experts_group.api.system.device.feature.SystemDeviceTransparentEncryptionRawIODeviceFeature;
import org.bread_experts_group.api.system.device.io.IODevice;
import org.bread_experts_group.api.system.device.io.IODeviceFeatureImplementation;
import org.bread_experts_group.api.system.device.io.feature.IODeviceReadCallbackFeature;
import org.bread_experts_group.api.system.device.io.feature.IODeviceReleaseFeature;
import org.bread_experts_group.api.system.device.io.transparent_encrpytion.OpenTransparentEncryptionRawIODeviceFeatureIdentifier;
import org.bread_experts_group.api.system.device.io.transparent_encrpytion.WindowsOpenTransparentEncryptionRawIODeviceFeatures;
import org.bread_experts_group.api.system.device.windows.WindowsSystemDeviceTransparentEncryptionRawIODeviceFeature;
import org.bread_experts_group.ffi.ForeignFunctionInterfaceKt;
import org.bread_experts_group.ffi.windows.WindowsAdvAPIHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J5\u0010\f\u001a\u0016\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0018\u00010\r2\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0012\"\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lorg/bread_experts_group/api/system/device/windows/WindowsSystemDeviceTransparentEncryptionRawIODeviceFeature;", "Lorg/bread_experts_group/api/system/device/feature/SystemDeviceTransparentEncryptionRawIODeviceFeature;", "pathSegment", "Ljava/lang/foreign/MemorySegment;", "<init>", "(Ljava/lang/foreign/MemorySegment;)V", "source", "Lorg/bread_experts_group/api/feature/ImplementationSource;", "getSource", "()Lorg/bread_experts_group/api/feature/ImplementationSource;", "supported", "", "open", "Lkotlin/Pair;", "Lorg/bread_experts_group/api/system/device/io/IODevice;", "", "Lorg/bread_experts_group/api/system/device/io/transparent_encrpytion/OpenTransparentEncryptionRawIODeviceFeatureIdentifier;", "features", "", "([Lorg/bread_experts_group/api/system/device/io/transparent_encrpytion/OpenTransparentEncryptionRawIODeviceFeatureIdentifier;)Lkotlin/Pair;", "bread_server_lib"})
public final class WindowsSystemDeviceTransparentEncryptionRawIODeviceFeature
extends SystemDeviceTransparentEncryptionRawIODeviceFeature {
    @NotNull
    private final MemorySegment pathSegment;
    @NotNull
    private final ImplementationSource source;

    public WindowsSystemDeviceTransparentEncryptionRawIODeviceFeature(@NotNull MemorySegment pathSegment) {
        Intrinsics.checkNotNullParameter(pathSegment, "pathSegment");
        this.pathSegment = pathSegment;
        this.source = ImplementationSource.SYSTEM_NATIVE;
    }

    @Override
    @NotNull
    public ImplementationSource getSource() {
        return this.source;
    }

    @Override
    public boolean supported() {
        return WindowsAdvAPIHandlesKt.getNativeOpenEncryptedFileRawW() != null;
    }

    @Override
    @Nullable
    public Pair<IODevice, List<OpenTransparentEncryptionRawIODeviceFeatureIdentifier>> open(OpenTransparentEncryptionRawIODeviceFeatureIdentifier ... features2) {
        Pair<IODevice, List<OpenTransparentEncryptionRawIODeviceFeatureIdentifier>> pair;
        Intrinsics.checkNotNullParameter(features2, "features");
        List supportedFeatures = new ArrayList();
        if (ArraysKt.contains(features2, WindowsOpenTransparentEncryptionRawIODeviceFeatures.EXPORT)) {
            supportedFeatures.add(WindowsOpenTransparentEncryptionRawIODeviceFeatures.EXPORT);
            MethodHandle methodHandle = WindowsAdvAPIHandlesKt.getNativeOpenEncryptedFileRawW();
            Intrinsics.checkNotNull(methodHandle);
            WindowsUtilitiesKt.decodeWin32Error(methodHandle.invokeExact(this.pathSegment, 0, WindowsUtilitiesKt.getThreadLocalPTR()));
            MemorySegment encHandle = WindowsUtilitiesKt.getThreadLocalPTR().get(WindowsUtilitiesKt.getPVOID(), 0L);
            pair = TuplesKt.to(new IODevice(encHandle){
                private final List<IODeviceFeatureImplementation<?>> features;
                {
                    IODeviceFeatureImplementation[] iODeviceFeatureImplementationArray = new IODeviceFeatureImplementation[]{new IODeviceReleaseFeature($encHandle){
                        private final ImplementationSource source;
                        final /* synthetic */ MemorySegment $encHandle;
                        {
                            this.$encHandle = $encHandle;
                            this.source = ImplementationSource.SYSTEM_NATIVE;
                        }

                        public ImplementationSource getSource() {
                            return this.source;
                        }

                        public boolean supported() {
                            return WindowsAdvAPIHandlesKt.getNativeCloseEncryptedFileRaw() != null;
                        }

                        public void close() {
                            MethodHandle methodHandle = WindowsAdvAPIHandlesKt.getNativeCloseEncryptedFileRaw();
                            Intrinsics.checkNotNull(methodHandle);
                            methodHandle.invokeExact(this.$encHandle);
                        }
                    }, new IODeviceReadCallbackFeature($encHandle){
                        private final ImplementationSource source;
                        private Function1<? super MemorySegment, Unit> internal;
                        final /* synthetic */ MemorySegment $encHandle;
                        {
                            this.$encHandle = $encHandle;
                            this.source = ImplementationSource.SYSTEM_NATIVE;
                            this.internal = open.features.2::internal$lambda$0;
                        }

                        public ImplementationSource getSource() {
                            return this.source;
                        }

                        public boolean supported() {
                            return WindowsAdvAPIHandlesKt.getNativeReadEncryptedFileRaw() != null;
                        }

                        public final int decode(MemorySegment pbData, MemorySegment pvCallbackContext, int ulLength) {
                            Intrinsics.checkNotNullParameter(pbData, "pbData");
                            Intrinsics.checkNotNullParameter(pvCallbackContext, "pvCallbackContext");
                            MemorySegment memorySegment = pbData.reinterpret(ulLength);
                            Intrinsics.checkNotNullExpressionValue(memorySegment, "reinterpret(...)");
                            this.internal.invoke(memorySegment);
                            return 0;
                        }

                        public void read(Function1<? super MemorySegment, Unit> into) {
                            Intrinsics.checkNotNullParameter(into, "into");
                            this.internal = into;
                            Arena arena = Arena.ofConfined();
                            MethodHandle methodHandle = WindowsAdvAPIHandlesKt.getNativeReadEncryptedFileRaw();
                            Intrinsics.checkNotNull(methodHandle);
                            Object[] objectArray = new Class[]{MemorySegment.class, Integer.TYPE};
                            MethodHandle methodHandle2 = MethodHandles.lookup().findSpecial(this.getClass(), "decode", MethodType.methodType(Integer.TYPE, MemorySegment.class, objectArray), this.getClass()).bindTo(this);
                            objectArray = new MemoryLayout[]{WindowsUtilitiesKt.getPBYTE(), WindowsUtilitiesKt.getPVOID(), WindowsUtilitiesKt.getULONG()};
                            WindowsUtilitiesKt.decodeWin32Error(methodHandle.invokeExact(ForeignFunctionInterfaceKt.getNativeLinker().upcallStub(methodHandle2, FunctionDescriptor.of(WindowsUtilitiesKt.getDWORD(), (MemoryLayout[])objectArray), arena, new Linker.Option[0]), MemorySegment.NULL, this.$encHandle));
                            arena.close();
                        }

                        private static final Unit internal$lambda$0(MemorySegment it) {
                            Intrinsics.checkNotNullParameter(it, "it");
                            return Unit.INSTANCE;
                        }
                    }};
                    this.features = CollectionsKt.mutableListOf(iODeviceFeatureImplementationArray);
                }

                public List<IODeviceFeatureImplementation<?>> getFeatures() {
                    return this.features;
                }
            }, supportedFeatures);
        } else {
            if (ArraysKt.contains(features2, WindowsOpenTransparentEncryptionRawIODeviceFeatures.IMPORT_FILE)) {
                supportedFeatures.add(WindowsOpenTransparentEncryptionRawIODeviceFeatures.IMPORT_FILE);
                MethodHandle methodHandle = WindowsAdvAPIHandlesKt.getNativeOpenEncryptedFileRawW();
                Intrinsics.checkNotNull(methodHandle);
                WindowsUtilitiesKt.decodeWin32Error(methodHandle.invokeExact(this.pathSegment, 1, WindowsUtilitiesKt.getThreadLocalPTR()));
                String string = "!";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            if (ArraysKt.contains(features2, WindowsOpenTransparentEncryptionRawIODeviceFeatures.IMPORT_DIRECTORY)) {
                supportedFeatures.add(WindowsOpenTransparentEncryptionRawIODeviceFeatures.IMPORT_DIRECTORY);
                MethodHandle methodHandle = WindowsAdvAPIHandlesKt.getNativeOpenEncryptedFileRawW();
                Intrinsics.checkNotNull(methodHandle);
                WindowsUtilitiesKt.decodeWin32Error(methodHandle.invokeExact(this.pathSegment, 2, WindowsUtilitiesKt.getThreadLocalPTR()));
                String string = "!";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            if (ArraysKt.contains(features2, WindowsOpenTransparentEncryptionRawIODeviceFeatures.OVERWRITE_HIDDEN)) {
                supportedFeatures.add(WindowsOpenTransparentEncryptionRawIODeviceFeatures.OVERWRITE_HIDDEN);
                MethodHandle methodHandle = WindowsAdvAPIHandlesKt.getNativeOpenEncryptedFileRawW();
                Intrinsics.checkNotNull(methodHandle);
                WindowsUtilitiesKt.decodeWin32Error(methodHandle.invokeExact(this.pathSegment, 4, WindowsUtilitiesKt.getThreadLocalPTR()));
                String string = "!";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            pair = TuplesKt.to(new IODevice(){

                public List<IODeviceFeatureImplementation<?>> getFeatures() {
                    return new ArrayList<E>();
                }
            }, CollectionsKt.emptyList());
        }
        return pair;
    }
}

