/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.system.device.windows;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.invoke.MethodHandle;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.api.feature.ImplementationSource;
import org.bread_experts_group.api.system.SystemFeatures;
import org.bread_experts_group.api.system.device.SystemDevice;
import org.bread_experts_group.api.system.device.windows.WindowsDeviceUtilityKt;
import org.bread_experts_group.api.system.feature.SystemGetPathDeviceFeature;
import org.bread_experts_group.ffi.ForeignFunctionInterfaceKt;
import org.bread_experts_group.ffi.windows.WindowsKernelHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/bread_experts_group/api/system/device/windows/WindowsSystemGetCurrentWorkingDeviceFeature;", "Lorg/bread_experts_group/api/system/feature/SystemGetPathDeviceFeature;", "<init>", "()V", "supported", "", "device", "Lorg/bread_experts_group/api/system/device/SystemDevice;", "getDevice", "()Lorg/bread_experts_group/api/system/device/SystemDevice;", "bread_server_lib"})
public final class WindowsSystemGetCurrentWorkingDeviceFeature
extends SystemGetPathDeviceFeature {
    public WindowsSystemGetCurrentWorkingDeviceFeature() {
        super(ImplementationSource.SYSTEM_NATIVE, SystemFeatures.INSTANCE.getGET_CURRENT_WORKING_PATH_DEVICE());
    }

    @Override
    public boolean supported() {
        return WindowsKernelHandlesKt.getNativeGetCurrentDirectoryW() != null;
    }

    @Override
    @NotNull
    public SystemDevice getDevice() {
        MethodHandle methodHandle = WindowsKernelHandlesKt.getNativeGetCurrentDirectoryW();
        Intrinsics.checkNotNull(methodHandle);
        int size = methodHandle.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), 0, MemorySegment.NULL);
        if (size == 0) {
            WindowsUtilitiesKt.throwLastError();
            throw new KotlinNothingValueException();
        }
        Arena filePathArena = Arena.ofShared();
        MemorySegment filePathSegment = filePathArena.allocate((long)size * 2L);
        size = WindowsKernelHandlesKt.getNativeGetCurrentDirectoryW().invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), size, filePathSegment);
        if (size == 0) {
            WindowsUtilitiesKt.throwLastError();
            throw new KotlinNothingValueException();
        }
        Intrinsics.checkNotNull(filePathArena);
        Intrinsics.checkNotNull(filePathSegment);
        return WindowsDeviceUtilityKt.createPathDevice(filePathArena, filePathSegment);
    }
}

