/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.system.feature.windows;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.bread_experts_group.api.feature.FeatureExpression;
import org.bread_experts_group.api.feature.FeatureProvider;
import org.bread_experts_group.api.feature.ImplementationSource;
import org.bread_experts_group.api.system.feature.SystemNetworkingSocketsFeature;
import org.bread_experts_group.api.system.feature.windows.WindowsSystemNetworkingSocketsFeature;
import org.bread_experts_group.api.system.socket.SystemSocketProviderFeatures;
import org.bread_experts_group.api.system.socket.ipv4.feature.SystemInternetProtocolV4SocketProviderFeatureImplementation;
import org.bread_experts_group.api.system.socket.ipv4.feature.SystemInternetProtocolV4StreamProtocolsSocketProviderFeature;
import org.bread_experts_group.api.system.socket.ipv4.stream.feature.SystemInternetProtocolV4StreamProtocolFeatureImplementation;
import org.bread_experts_group.api.system.socket.ipv4.stream.feature.SystemInternetProtocolV4TCPFeature;
import org.bread_experts_group.api.system.socket.ipv4.stream.tcp.feature.IPV4TCPFeatureImplementation;
import org.bread_experts_group.api.system.socket.ipv4.stream.tcp.feature.IPV4TCPSystemLabelFeature;
import org.bread_experts_group.api.system.socket.ipv4.windows.WindowsIPV4TCPResolutionFeature;
import org.bread_experts_group.api.system.socket.ipv4.windows.WindowsIPV4TCPSocketFeature;
import org.bread_experts_group.api.system.socket.resolution_namespace_provider.ResolutionNamespaceProvider;
import org.bread_experts_group.api.system.socket.resolution_namespace_provider.ResolutionNamespaceProviderFeatures;
import org.bread_experts_group.api.system.socket.resolution_namespace_provider.feature.ResolutionNamespaceProviderFeatureImplementation;
import org.bread_experts_group.api.system.socket.resolution_namespace_provider.feature.ResolutionNamespaceProviderSystemIdentifierFeature;
import org.bread_experts_group.api.system.socket.resolution_namespace_provider.type.ResolutionNamespaceSystemType;
import org.bread_experts_group.api.system.socket.resolution_namespace_provider.type.ResolutionNamespaceTypeIdentifier;
import org.bread_experts_group.api.system.socket.resolution_namespace_provider.type.StandardResolutionNamespaceTypes;
import org.bread_experts_group.api.system.socket.resolution_namespace_provider.type.WindowsResolutionNamespaceTypes;
import org.bread_experts_group.api.system.socket.sys_feature.SystemSocketProvideResolutionNamespaceProvidersFeature;
import org.bread_experts_group.api.system.socket.sys_feature.SystemSocketProviderFeatureImplementation;
import org.bread_experts_group.api.system.socket.sys_feature.SystemSocketProviderInternetProtocolV4Feature;
import org.bread_experts_group.api.system.socket.sys_feature.SystemSocketProviderTextualFeature;
import org.bread_experts_group.ffi.GUID;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.bread_experts_group.ffi.windows.wsa.WindowsWinSockHandlesKt;
import org.bread_experts_group.ffi.windows.wsa.WindowsWinSockLayoutsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R%\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lorg/bread_experts_group/api/system/feature/windows/WindowsSystemNetworkingSocketsFeature;", "Lorg/bread_experts_group/api/system/feature/SystemNetworkingSocketsFeature;", "<init>", "()V", "source", "Lorg/bread_experts_group/api/feature/ImplementationSource;", "getSource", "()Lorg/bread_experts_group/api/feature/ImplementationSource;", "supported", "", "features", "", "Lorg/bread_experts_group/api/system/socket/sys_feature/SystemSocketProviderFeatureImplementation;", "getFeatures", "()Ljava/util/List;", "features$delegate", "Lkotlin/Lazy;", "Companion", "bread_server_lib"})
@SourceDebugExtension(value={"SMAP\nWindowsSystemNetworkingSocketsFeature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsSystemNetworkingSocketsFeature.kt\norg/bread_experts_group/api/system/feature/windows/WindowsSystemNetworkingSocketsFeature\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,308:1\n382#2,7:309\n*S KotlinDebug\n*F\n+ 1 WindowsSystemNetworkingSocketsFeature.kt\norg/bread_experts_group/api/system/feature/windows/WindowsSystemNetworkingSocketsFeature\n*L\n202#1:309,7\n*E\n"})
public final class WindowsSystemNetworkingSocketsFeature
extends SystemNetworkingSocketsFeature {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImplementationSource source = ImplementationSource.SYSTEM_NATIVE;
    @NotNull
    private final Lazy features$delegate = LazyKt.lazy(() -> WindowsSystemNetworkingSocketsFeature.features_delegate$lambda$0(this));
    public static final int AF_UNIX = 1;
    public static final int AF_INET = 2;
    public static final int AF_INET6 = 23;
    public static final int AF_NETDES = 28;
    public static final int AF_BTH = 32;
    public static final int AF_HYPERV = 34;
    public static final int SOCK_STREAM = 1;
    public static final int SOCK_DGRAM = 2;
    public static final int SOCK_RAW = 3;
    public static final int IPPROTO_IP = 0;
    public static final int IPPROTO_TCP = 6;
    public static final int IPPROTO_UDP = 17;
    public static final int BTHPROTO_RFCOMM = 3;
    public static final int BTHPROTO_L2CAP = 256;
    public static final int HV_PROTOCOL_RAW = 1;

    @Override
    @NotNull
    public ImplementationSource getSource() {
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supported() {
        if (WindowsWinSockHandlesKt.getNativeWSCEnumProtocols() == null) {
            return false;
        }
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            MethodHandle methodHandle;
            Arena tempArena = (Arena)autoCloseable;
            boolean bl = false;
            MemorySegment wsaData = tempArena.allocate(WindowsWinSockLayoutsKt.getWSAData());
            if (WindowsWinSockHandlesKt.getNativeWSAStartup() == null) {
                boolean bl2 = false;
                return bl2;
            }
            int status = methodHandle.invokeExact((short)514, wsaData);
            if (status != 0) {
                WindowsUtilitiesKt.decodeWin32Error(status);
            }
            List<SystemSocketProviderFeatureImplementation<?>> list = this.getFeatures();
            FeatureExpression<SystemSocketProviderTextualFeature> featureExpression = SystemSocketProviderFeatures.INSTANCE.getPROVIDER_DESCRIPTION();
            String string = WindowsWinSockLayoutsKt.getWSAData_szDescription().invokeExact(wsaData, 0L).getString(0L, Charsets.US_ASCII);
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            list.add(new SystemSocketProviderTextualFeature(ImplementationSource.SYSTEM_NATIVE, featureExpression, string));
            List<SystemSocketProviderFeatureImplementation<?>> list2 = this.getFeatures();
            FeatureExpression<SystemSocketProviderTextualFeature> featureExpression2 = SystemSocketProviderFeatures.INSTANCE.getPROVIDER_SYSTEM_STATUS();
            String string2 = WindowsWinSockLayoutsKt.getWSAData_szSystemStatus().invokeExact(wsaData, 0L).getString(0L, Charsets.US_ASCII);
            Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
            boolean bl3 = list2.add(new SystemSocketProviderTextualFeature(ImplementationSource.SYSTEM_NATIVE, featureExpression2, string2));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return true;
    }

    @Override
    @NotNull
    public List<SystemSocketProviderFeatureImplementation<?>> getFeatures() {
        Lazy lazy = this.features$delegate;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final List features_delegate$lambda$0(WindowsSystemNetworkingSocketsFeature this$0) {
        List implementations = new ArrayList();
        if (WindowsWinSockHandlesKt.getNativeWSAEnumNameSpaceProvidersW() != null) {
            implementations.add(new SystemSocketProvideResolutionNamespaceProvidersFeature(){
                private final ImplementationSource source;
                {
                    this.source = ImplementationSource.SYSTEM_NATIVE;
                }

                public ImplementationSource getSource() {
                    return this.source;
                }

                public Iterator<ResolutionNamespaceProvider> iterator() {
                    WindowsUtilitiesKt.getThreadLocalDWORD0().set(WindowsUtilitiesKt.getDWORD(), 0L, 0);
                    WindowsWinSockHandlesKt.getNativeWSAEnumNameSpaceProvidersW().invokeExact(WindowsUtilitiesKt.getThreadLocalDWORD0(), MemorySegment.NULL);
                    Arena arena = Arena.ofConfined();
                    MemorySegment providerData = arena.allocate(WindowsUtilitiesKt.getThreadLocalDWORD0().get(WindowsUtilitiesKt.getDWORD(), 0L));
                    int providers = WindowsWinSockHandlesKt.getNativeWSAEnumNameSpaceProvidersW().invokeExact(WindowsUtilitiesKt.getThreadLocalDWORD0(), providerData);
                    if (providers == -1) {
                        WindowsUtilitiesKt.throwLastWSAError();
                        throw new KotlinNothingValueException();
                    }
                    Ref.ObjectRef<MemorySegment> providerInfo = new Ref.ObjectRef<MemorySegment>();
                    providerInfo.element = providerData;
                    ArrayList<features.2.iterator.iterable.1.1> arrayList = new ArrayList<features.2.iterator.iterable.1.1>(providers);
                    int n = 0;
                    while (n < providers) {
                        ResolutionNamespaceProvider resolutionNamespaceProvider;
                        int n2;
                        int n3 = n2 = n++;
                        ArrayList<features.2.iterator.iterable.1.1> arrayList2 = arrayList;
                        boolean bl = false;
                        ResolutionNamespaceProvider it = resolutionNamespaceProvider = new ResolutionNamespaceProvider(providerInfo){
                            private final List<ResolutionNamespaceProviderFeatureImplementation<?>> features;
                            private final ResolutionNamespaceTypeIdentifier type;
                            private final boolean enabled;
                            {
                                ResolutionNamespaceProviderFeatureImplementation[] resolutionNamespaceProviderFeatureImplementationArray = new ResolutionNamespaceProviderFeatureImplementation[]{new ResolutionNamespaceProviderSystemIdentifierFeature<GUID>(ImplementationSource.SYSTEM_NATIVE, ResolutionNamespaceProviderFeatures.INSTANCE.getSYSTEM_IDENTIFIER(), new GUID(WindowsWinSockLayoutsKt.getWSANAMESPACE_INFOW_NSProviderId().invokeExact((MemorySegment)$providerInfo.element, 0L))), new ResolutionNamespaceProviderSystemIdentifierFeature<String>(ImplementationSource.SYSTEM_NATIVE, ResolutionNamespaceProviderFeatures.INSTANCE.getSYSTEM_LABEL(), WindowsWinSockLayoutsKt.getWSANAMESPACE_INFOW_lpszIdentifier().get((MemorySegment)$providerInfo.element, 0L).reinterpret(Long.MAX_VALUE).getString(0L, Charsets.UTF_16LE)), new ResolutionNamespaceProviderSystemIdentifierFeature<Integer>(ImplementationSource.SYSTEM_NATIVE, ResolutionNamespaceProviderFeatures.INSTANCE.getSYSTEM_VERSION(), WindowsWinSockLayoutsKt.getWSANAMESPACE_INFOW_dwVersion().get((MemorySegment)$providerInfo.element, 0L))};
                                this.features = CollectionsKt.mutableListOf(resolutionNamespaceProviderFeatureImplementationArray);
                                int typeRaw = WindowsWinSockLayoutsKt.getWSANAMESPACE_INFOW_dwNameSpace().get((MemorySegment)$providerInfo.element, 0L);
                                this.type = switch (typeRaw) {
                                    case 12 -> StandardResolutionNamespaceTypes.DOMAIN_NAME_SYSTEM;
                                    case 15 -> WindowsResolutionNamespaceTypes.NETWORK_LOCATION_AWARENESS;
                                    case 16 -> StandardResolutionNamespaceTypes.BLUETOOTH;
                                    case 32 -> WindowsResolutionNamespaceTypes.NT_DIRECTORY_SERVICE;
                                    case 37 -> StandardResolutionNamespaceTypes.EMAIL;
                                    case 38 -> WindowsResolutionNamespaceTypes.P2P_NAME;
                                    case 39 -> WindowsResolutionNamespaceTypes.P2P_COLLECTION;
                                    default -> new ResolutionNamespaceSystemType(typeRaw);
                                };
                                this.enabled = !Intrinsics.areEqual(WindowsWinSockLayoutsKt.getWSANAMESPACE_INFOW_fActive().get((MemorySegment)$providerInfo.element, 0), (Object)0);
                            }

                            public List<ResolutionNamespaceProviderFeatureImplementation<?>> getFeatures() {
                                return this.features;
                            }

                            public ResolutionNamespaceTypeIdentifier getType() {
                                return this.type;
                            }

                            public boolean getEnabled() {
                                return this.enabled;
                            }
                        };
                        boolean bl2 = false;
                        providerInfo.element = ((MemorySegment)providerInfo.element).asSlice(WindowsWinSockLayoutsKt.getWSANAMESPACE_INFOW().byteSize());
                        arrayList2.add(resolutionNamespaceProvider);
                    }
                    List iterable2 = arrayList;
                    arena.close();
                    return iterable2.iterator();
                }
            });
        }
        WindowsUtilitiesKt.getThreadLocalDWORD0().set(WindowsUtilitiesKt.getDWORD(), 0L, 0);
        MethodHandle methodHandle = WindowsWinSockHandlesKt.getNativeWSCEnumProtocols();
        Intrinsics.checkNotNull(methodHandle);
        methodHandle.invokeExact(MemorySegment.NULL, MemorySegment.NULL, WindowsUtilitiesKt.getThreadLocalDWORD0(), WindowsUtilitiesKt.getThreadLocalDWORD1());
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            Arena tempArena = (Arena)autoCloseable;
            boolean bl = false;
            MemorySegment protocolData = tempArena.allocate(WindowsUtilitiesKt.getThreadLocalDWORD0().get(WindowsUtilitiesKt.getDWORD(), 0L));
            int protocols = WindowsWinSockHandlesKt.getNativeWSCEnumProtocols().invokeExact(MemorySegment.NULL, protocolData, WindowsUtilitiesKt.getThreadLocalDWORD0(), WindowsUtilitiesKt.getThreadLocalDWORD1());
            if (protocols == -1) {
                WindowsUtilitiesKt.decodeWin32Error(WindowsUtilitiesKt.getThreadLocalDWORD1().get(WindowsUtilitiesKt.getDWORD(), 0L));
            }
            MemorySegment protocolInfo = null;
            protocolInfo = protocolData;
            Map ipv4 = new LinkedHashMap();
            for (int i = 0; i < protocols; ++i) {
                int it = i;
                boolean bl2 = false;
                int socketType = WindowsWinSockLayoutsKt.getWSAPROTOCOL_INFOW_iSocketType().get(protocolInfo, 0L);
                int protocol = WindowsWinSockLayoutsKt.getWSAPROTOCOL_INFOW_iProtocol().get(protocolInfo, 0L);
                String label = WindowsWinSockLayoutsKt.getWSAPROTOCOL_INFOW_szProtocol().invokeExact(protocolInfo, 0L).getString(0L, Charsets.UTF_16LE);
                int addressFamily = WindowsWinSockLayoutsKt.getWSAPROTOCOL_INFOW_iAddressFamily().get(protocolInfo, 0L);
                block2 : switch (addressFamily) {
                    case 1: {
                        if (socketType == 1) {
                            if (protocol == 0) {
                                this$0.getLogger().severe("STD/UNIX");
                                break;
                            }
                            this$0.getLogger().warning("Unknown WSA/Unix/Stream iProtocol [" + protocol + "]");
                            break;
                        }
                        this$0.getLogger().warning("Unknown WSA/Unix iSocketType [" + socketType + "]");
                        break;
                    }
                    case 2: {
                        switch (socketType) {
                            case 1: {
                                Object object;
                                void $this$getOrPut$iv;
                                Map map = ipv4;
                                Integer key$iv = 1;
                                boolean $i$f$getOrPut = false;
                                Object value$iv = $this$getOrPut$iv.get(key$iv);
                                if (value$iv == null) {
                                    boolean bl3 = false;
                                    SystemInternetProtocolV4SocketProviderFeatureImplementation answer$iv = new SystemInternetProtocolV4StreamProtocolsSocketProviderFeature(){
                                        private final ImplementationSource source;
                                        private final List<SystemInternetProtocolV4StreamProtocolFeatureImplementation<?>> features;
                                        {
                                            this.source = ImplementationSource.SYSTEM_NATIVE;
                                            this.features = new ArrayList<E>();
                                        }

                                        public ImplementationSource getSource() {
                                            return this.source;
                                        }

                                        public List<SystemInternetProtocolV4StreamProtocolFeatureImplementation<?>> getFeatures() {
                                            return this.features;
                                        }
                                    };
                                    $this$getOrPut$iv.put(key$iv, answer$iv);
                                    object = answer$iv;
                                } else {
                                    object = value$iv;
                                }
                                FeatureProvider streamProtocols2 = (FeatureProvider)object;
                                if (protocol == 6) {
                                    streamProtocols2.getFeatures().add(new SystemInternetProtocolV4TCPFeature(label){
                                        private final ImplementationSource source;
                                        private final List<IPV4TCPFeatureImplementation<?>> features;
                                        {
                                            this.source = ImplementationSource.SYSTEM_NATIVE;
                                            IPV4TCPFeatureImplementation[] iPV4TCPFeatureImplementationArray = new IPV4TCPFeatureImplementation[3];
                                            Intrinsics.checkNotNull($label);
                                            iPV4TCPFeatureImplementationArray[0] = new IPV4TCPSystemLabelFeature(ImplementationSource.SYSTEM_NATIVE, $label);
                                            iPV4TCPFeatureImplementationArray[1] = new WindowsIPV4TCPResolutionFeature();
                                            iPV4TCPFeatureImplementationArray[2] = new WindowsIPV4TCPSocketFeature();
                                            this.features = CollectionsKt.mutableListOf(iPV4TCPFeatureImplementationArray);
                                        }

                                        public ImplementationSource getSource() {
                                            return this.source;
                                        }

                                        public List<IPV4TCPFeatureImplementation<?>> getFeatures() {
                                            return this.features;
                                        }
                                    });
                                    break block2;
                                }
                                this$0.getLogger().warning("Unknown WSA/IPv4/Stream iProtocol [" + protocol + "]");
                                break block2;
                            }
                            case 2: {
                                if (protocol == 17) {
                                    this$0.getLogger().severe("UDP/IPv4");
                                    break block2;
                                }
                                this$0.getLogger().warning("Unknown WSA/IPv4/Datagram iProtocol [" + protocol + "]");
                                break block2;
                            }
                            case 3: {
                                if (protocol == 0) {
                                    this$0.getLogger().severe("Raw/IPv4");
                                    break block2;
                                }
                                this$0.getLogger().warning("Unknown WSA/IPv4/Raw iProtocol [" + protocol + "]");
                                break block2;
                            }
                        }
                        this$0.getLogger().warning("Unknown WSA/IPv4 iSocketType [" + socketType + "]");
                        break;
                    }
                    case 23: {
                        switch (socketType) {
                            case 1: {
                                if (protocol == 6) {
                                    this$0.getLogger().severe("TCP/IPv6");
                                    break block2;
                                }
                                this$0.getLogger().warning("Unknown WSA/IPv6/Stream iProtocol [" + protocol + "]");
                                break block2;
                            }
                            case 2: {
                                if (protocol == 17) {
                                    this$0.getLogger().severe("UDP/IPv6");
                                    break block2;
                                }
                                this$0.getLogger().warning("Unknown WSA/IPv6/Datagram iProtocol [" + protocol + "]");
                                break block2;
                            }
                            case 3: {
                                if (protocol == 0) {
                                    this$0.getLogger().severe("Raw/IPv6");
                                    break block2;
                                }
                                this$0.getLogger().warning("Unknown WSA/IPv6/Raw iProtocol [" + protocol + "]");
                                break block2;
                            }
                        }
                        this$0.getLogger().warning("Unknown WSA/IPv6 iSocketType [" + socketType + "]");
                        break;
                    }
                    case 28: {
                        switch (socketType) {
                            case 1: {
                                if (protocol == 0) break block2;
                                this$0.getLogger().warning("Unknown WSA/NetworkDesigners/Stream iProtocol [" + protocol + "]");
                                break;
                            }
                            case 2: {
                                if (protocol == 0) break block2;
                                this$0.getLogger().warning("Unknown WSA/NetworkDesigners/Datagram iProtocol [" + protocol + "]");
                                break;
                            }
                            default: {
                                this$0.getLogger().warning("Unknown WSA/NetworkDesigners iSocketType [" + socketType + "]");
                                break;
                            }
                        }
                        break;
                    }
                    case 32: {
                        if (socketType == 1) {
                            switch (protocol) {
                                case 3: {
                                    this$0.getLogger().severe("BTH/RFComm");
                                    break block2;
                                }
                                case 256: {
                                    this$0.getLogger().severe("BTH/L2Cap");
                                    break block2;
                                }
                            }
                            this$0.getLogger().warning("Unknown WSA/Bluetooth/Stream iProtocol [" + protocol + "]");
                            break;
                        }
                        this$0.getLogger().warning("Unknown WSA/Bluetooth iSocketType [" + socketType + "]");
                        break;
                    }
                    case 34: {
                        if (socketType == 1) {
                            if (protocol == 1) {
                                this$0.getLogger().severe("HyperV/L2Cap");
                                break;
                            }
                            this$0.getLogger().warning("Unknown WSA/HyperV/Stream iProtocol [" + protocol + "]");
                            break;
                        }
                        this$0.getLogger().warning("Unknown WSA/HyperV iSocketType [" + socketType + "]");
                        break;
                    }
                    default: {
                        this$0.getLogger().warning("Unknown WSA iAddressFamily [" + addressFamily + "]");
                    }
                }
                protocolInfo = protocolInfo.asSlice(WindowsWinSockLayoutsKt.getWSAPROTOCOL_INFOW().byteSize());
            }
            if (!ipv4.isEmpty()) {
                implementations.add(new SystemSocketProviderInternetProtocolV4Feature(ipv4){
                    private final ImplementationSource source;
                    private final List<SystemInternetProtocolV4SocketProviderFeatureImplementation<?>> features;
                    {
                        this.source = ImplementationSource.SYSTEM_NATIVE;
                        this.features = CollectionsKt.toMutableList($ipv4.values());
                    }

                    public ImplementationSource getSource() {
                        return this.source;
                    }

                    public List<SystemInternetProtocolV4SocketProviderFeatureImplementation<?>> getFeatures() {
                        return this.features;
                    }
                });
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return implementations;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000f\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/bread_experts_group/api/system/feature/windows/WindowsSystemNetworkingSocketsFeature$Companion;", "", "<init>", "()V", "AF_UNIX", "", "AF_INET", "AF_INET6", "AF_NETDES", "AF_BTH", "AF_HYPERV", "SOCK_STREAM", "SOCK_DGRAM", "SOCK_RAW", "IPPROTO_IP", "IPPROTO_TCP", "IPPROTO_UDP", "BTHPROTO_RFCOMM", "BTHPROTO_L2CAP", "HV_PROTOCOL_RAW", "bread_server_lib"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

