/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.system.socket.ipv4.windows;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.ArraysKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.bread_experts_group.api.feature.CheckedImplementation;
import org.bread_experts_group.api.feature.FeatureProvider;
import org.bread_experts_group.api.feature.ImplementationSource;
import org.bread_experts_group.api.system.socket.ipv4.InternetProtocolV4AddressData;
import org.bread_experts_group.api.system.socket.ipv4.stream.tcp.feature.IPV4TCPResolutionFeature;
import org.bread_experts_group.api.system.socket.resolution.CanonicalNameData;
import org.bread_experts_group.api.system.socket.resolution.FullyQualifiedDomainNameData;
import org.bread_experts_group.api.system.socket.resolution.ResolutionDataIdentifier;
import org.bread_experts_group.api.system.socket.resolution.ResolutionDataPart;
import org.bread_experts_group.api.system.socket.resolution.ResolutionFeatureIdentifier;
import org.bread_experts_group.api.system.socket.resolution.WindowsResolutionFeatures;
import org.bread_experts_group.api.system.socket.resolution_namespace_provider.ResolutionNamespaceProvider;
import org.bread_experts_group.api.system.socket.resolution_namespace_provider.ResolutionNamespaceProviderFeatures;
import org.bread_experts_group.api.system.socket.resolution_namespace_provider.feature.ResolutionNamespaceProviderSystemIdentifierFeature;
import org.bread_experts_group.api.system.socket.resolution_namespace_provider.type.ResolutionNamespaceTypeIdentifier;
import org.bread_experts_group.api.system.socket.resolution_namespace_provider.type.StandardResolutionNamespaceTypes;
import org.bread_experts_group.api.system.socket.resolution_namespace_provider.type.WindowsResolutionNamespaceTypes;
import org.bread_experts_group.ffi.GUID;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.bread_experts_group.ffi.windows.wsa.WindowsWinSockHandlesKt;
import org.bread_experts_group.ffi.windows.wsa.WindowsWinSockLayoutsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u00012\u00020\u0002:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J/\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\"\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/bread_experts_group/api/system/socket/ipv4/windows/WindowsIPV4TCPResolutionFeature;", "Lorg/bread_experts_group/api/system/socket/ipv4/stream/tcp/feature/IPV4TCPResolutionFeature;", "Lorg/bread_experts_group/api/feature/CheckedImplementation;", "<init>", "()V", "source", "Lorg/bread_experts_group/api/feature/ImplementationSource;", "getSource", "()Lorg/bread_experts_group/api/feature/ImplementationSource;", "supported", "", "resolve", "", "Lorg/bread_experts_group/api/system/socket/resolution/ResolutionDataIdentifier;", "hostName", "", "features", "", "Lorg/bread_experts_group/api/system/socket/resolution/ResolutionFeatureIdentifier;", "(Ljava/lang/String;[Lorg/bread_experts_group/api/system/socket/resolution/ResolutionFeatureIdentifier;)Ljava/util/List;", "Companion", "bread_server_lib"})
@SourceDebugExtension(value={"SMAP\nWindowsIPV4TCPResolutionFeature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsIPV4TCPResolutionFeature.kt\norg/bread_experts_group/api/system/socket/ipv4/windows/WindowsIPV4TCPResolutionFeature\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,199:1\n1#2:200\n*E\n"})
public final class WindowsIPV4TCPResolutionFeature
extends IPV4TCPResolutionFeature
implements CheckedImplementation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImplementationSource source = ImplementationSource.SYSTEM_NATIVE;
    public static final int NS_ALL = 0;
    public static final int NS_DNS = 12;
    public static final int NS_NLA = 15;
    public static final int NS_BTH = 16;
    public static final int NS_NTDS = 32;
    public static final int NS_EMAIL = 37;
    public static final int NS_PNRPNAME = 38;
    public static final int NS_PNRPCLOUD = 39;

    @Override
    @NotNull
    public ImplementationSource getSource() {
        return this.source;
    }

    @Override
    public boolean supported() {
        return WindowsWinSockHandlesKt.getNativeGetAddrInfoExW() != null && WindowsWinSockHandlesKt.getNativeFreeAddrInfoExW() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ResolutionDataIdentifier> resolve(@NotNull String hostName, ResolutionFeatureIdentifier ... features2) {
        Intrinsics.checkNotNullParameter(hostName, "hostName");
        Intrinsics.checkNotNullParameter(features2, "features");
        List data = new ArrayList();
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            MemorySegment memorySegment;
            GUID nspGUID;
            ResolutionNamespaceProviderSystemIdentifierFeature resolutionNamespaceProviderSystemIdentifierFeature;
            ResolutionNamespaceProvider nsp;
            ResolutionNamespaceProvider resolutionNamespaceProvider;
            int nameSpace;
            boolean cn;
            boolean fqdn;
            int flags;
            MemorySegment hints;
            MemorySegment name;
            Arena tempArena;
            block40: {
                int n;
                ResolutionNamespaceTypeIdentifier id;
                ResolutionNamespaceTypeIdentifier resolutionNamespaceTypeIdentifier;
                block39: {
                    tempArena = (Arena)autoCloseable;
                    boolean bl = false;
                    name = tempArena.allocateFrom(hostName, Charsets.UTF_16LE);
                    hints = tempArena.allocate(WindowsWinSockLayoutsKt.getADDRINFOEXW());
                    flags = 0;
                    fqdn = false;
                    cn = false;
                    if (ArraysKt.contains(features2, WindowsResolutionFeatures.PASSIVE)) {
                        flags |= 1;
                        data.add(WindowsResolutionFeatures.PASSIVE);
                    }
                    if (ArraysKt.contains(features2, WindowsResolutionFeatures.CANONICAL_NAME)) {
                        cn = true;
                        flags |= 2;
                        data.add(WindowsResolutionFeatures.CANONICAL_NAME);
                    }
                    if (ArraysKt.contains(features2, WindowsResolutionFeatures.NUMERIC_HOST)) {
                        flags |= 4;
                        data.add(WindowsResolutionFeatures.NUMERIC_HOST);
                    }
                    if (ArraysKt.contains(features2, WindowsResolutionFeatures.REQUIRE_CONFIGURED_GLOBAL_ADDRESS)) {
                        flags |= 0x400;
                        data.add(WindowsResolutionFeatures.REQUIRE_CONFIGURED_GLOBAL_ADDRESS);
                    }
                    if (ArraysKt.contains(features2, WindowsResolutionFeatures.FULLY_QUALIFIED_DOMAIN_NAME)) {
                        fqdn = true;
                        flags |= 0x20000;
                        data.add(WindowsResolutionFeatures.FULLY_QUALIFIED_DOMAIN_NAME);
                    }
                    if (ArraysKt.contains(features2, WindowsResolutionFeatures.HINT_FILE_SHARE_USE)) {
                        flags |= 0x40000;
                        data.add(WindowsResolutionFeatures.HINT_FILE_SHARE_USE);
                    }
                    if (ArraysKt.contains(features2, WindowsResolutionFeatures.DISABLE_IDN_ENCODING)) {
                        flags |= 0x80000;
                        data.add(WindowsResolutionFeatures.DISABLE_IDN_ENCODING);
                    }
                    for (ResolutionFeatureIdentifier resolutionFeatureIdentifier : features2) {
                        boolean bl2 = false;
                        resolutionNamespaceTypeIdentifier = resolutionFeatureIdentifier instanceof ResolutionNamespaceTypeIdentifier ? (ResolutionNamespaceTypeIdentifier)resolutionFeatureIdentifier : null;
                        if (resolutionNamespaceTypeIdentifier == null) {
                            continue;
                        }
                        break block39;
                    }
                    resolutionNamespaceTypeIdentifier = null;
                }
                if ((id = resolutionNamespaceTypeIdentifier) == StandardResolutionNamespaceTypes.DOMAIN_NAME_SYSTEM) {
                    data.add(id);
                    n = 12;
                } else if (id == StandardResolutionNamespaceTypes.BLUETOOTH) {
                    data.add(id);
                    n = 16;
                } else if (id == StandardResolutionNamespaceTypes.EMAIL) {
                    data.add(id);
                    n = 37;
                } else if (id == WindowsResolutionNamespaceTypes.P2P_NAME) {
                    data.add(id);
                    n = 38;
                } else if (id == WindowsResolutionNamespaceTypes.P2P_COLLECTION) {
                    data.add(id);
                    n = 39;
                } else if (id == WindowsResolutionNamespaceTypes.NT_DIRECTORY_SERVICE) {
                    data.add(id);
                    n = 32;
                } else {
                    n = 0;
                }
                nameSpace = n;
                for (ResolutionFeatureIdentifier resolutionFeatureIdentifier : features2) {
                    boolean bl = false;
                    resolutionNamespaceProvider = resolutionFeatureIdentifier instanceof ResolutionNamespaceProvider ? (ResolutionNamespaceProvider)resolutionFeatureIdentifier : null;
                    if (resolutionNamespaceProvider == null) {
                        continue;
                    }
                    break block40;
                }
                resolutionNamespaceProvider = null;
            }
            Object var14_17 = (nsp = resolutionNamespaceProvider) != null && (resolutionNamespaceProviderSystemIdentifierFeature = (ResolutionNamespaceProviderSystemIdentifierFeature)FeatureProvider.getOrNull$default(nsp, ResolutionNamespaceProviderFeatures.INSTANCE.getSYSTEM_IDENTIFIER(), false, 2, null)) != null ? resolutionNamespaceProviderSystemIdentifierFeature.getIdentifier() : null;
            GUID gUID = nspGUID = var14_17 instanceof GUID ? (GUID)var14_17 : null;
            if (nspGUID != null) {
                data.add(nsp);
                Intrinsics.checkNotNull(tempArena);
                memorySegment = nspGUID.allocate(tempArena);
            } else {
                memorySegment = MemorySegment.NULL;
            }
            MemorySegment nspArea = memorySegment;
            WindowsWinSockLayoutsKt.getADDRINFOEXW_ai_flags().set(hints, 0L, flags);
            WindowsWinSockLayoutsKt.getADDRINFOEXW_ai_family().set(hints, 0L, 2);
            WindowsWinSockLayoutsKt.getADDRINFOEXW_ai_socktype().set(hints, 0L, 1);
            WindowsWinSockLayoutsKt.getADDRINFOEXW_ai_protocol().set(hints, 0L, 6);
            MethodHandle methodHandle = WindowsWinSockHandlesKt.getNativeGetAddrInfoExW();
            Intrinsics.checkNotNull(methodHandle);
            int status = methodHandle.invokeExact(name, MemorySegment.NULL, nameSpace, nspArea, hints, WindowsUtilitiesKt.getThreadLocalPTR(), MemorySegment.NULL, MemorySegment.NULL, MemorySegment.NULL, MemorySegment.NULL);
            if (status != 0) {
                String string = "WS2 ERRORS " + status;
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            MemorySegment memorySegment2 = WindowsUtilitiesKt.getThreadLocalPTR().get(ValueLayout.ADDRESS, 0L);
            int iter = 0;
            if (fqdn && cn) {
                void var16_26;
                while (!Intrinsics.areEqual(var16_26, MemorySegment.NULL)) {
                    MemorySegment memorySegment3 = var16_26.reinterpret(WindowsWinSockLayoutsKt.getADDRINFOEX2W().byteSize());
                    List dataPart = new ArrayList();
                    if (iter++ == 0) {
                        String string = WindowsWinSockLayoutsKt.getADDRINFOEX2W_ai_canonname().get(memorySegment3, 0L).reinterpret(Long.MAX_VALUE).getString(0L, Charsets.UTF_16LE);
                        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                        dataPart.add(new CanonicalNameData(string));
                        String string2 = WindowsWinSockLayoutsKt.getADDRINFOEX2W_ai_fqdn().get(memorySegment3, 0L).reinterpret(Long.MAX_VALUE).getString(0L, Charsets.UTF_16LE);
                        Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
                        dataPart.add(new FullyQualifiedDomainNameData(string2));
                    }
                    MemorySegment addrData = WindowsWinSockLayoutsKt.getADDRINFOEX2W_ai_addr().get(memorySegment3, 0L).reinterpret(WindowsWinSockLayoutsKt.getADDRINFOEX2W_ai_addrlen().get(memorySegment3, 0L));
                    byte[] byArray = WindowsWinSockLayoutsKt.getSockaddr_in_sin_addr().invokeExact(addrData, 0L).toArray(ValueLayout.JAVA_BYTE);
                    Intrinsics.checkNotNullExpressionValue(byArray, "toArray(...)");
                    dataPart.add(new InternetProtocolV4AddressData(byArray));
                    data.add(new ResolutionDataPart(dataPart));
                    MemorySegment memorySegment4 = WindowsWinSockLayoutsKt.getADDRINFOEX2W_ai_next().get(memorySegment3, 0L);
                }
            } else {
                void var16_29;
                while (!Intrinsics.areEqual(var16_29, MemorySegment.NULL)) {
                    MemorySegment memorySegment5 = var16_29.reinterpret(WindowsWinSockLayoutsKt.getADDRINFOEXW().byteSize());
                    List dataPart = new ArrayList();
                    if (iter++ == 0 && (fqdn || cn)) {
                        String label = WindowsWinSockLayoutsKt.getADDRINFOEXW_ai_canonname().get(memorySegment5, 0L).reinterpret(Long.MAX_VALUE).getString(0L, Charsets.UTF_16LE);
                        if (fqdn) {
                            Intrinsics.checkNotNull(label);
                            v9 = dataPart.add(new FullyQualifiedDomainNameData(label));
                        } else {
                            Intrinsics.checkNotNull(label);
                            v9 = dataPart.add(new CanonicalNameData(label));
                        }
                    }
                    MemorySegment addrData = WindowsWinSockLayoutsKt.getADDRINFOEXW_ai_addr().get(memorySegment5, 0L).reinterpret(WindowsWinSockLayoutsKt.getADDRINFOEXW_ai_addrlen().get(memorySegment5, 0L));
                    byte[] byArray = WindowsWinSockLayoutsKt.getSockaddr_in_sin_addr().invokeExact(addrData, 0L).toArray(ValueLayout.JAVA_BYTE);
                    Intrinsics.checkNotNullExpressionValue(byArray, "toArray(...)");
                    dataPart.add(new InternetProtocolV4AddressData(byArray));
                    data.add(new ResolutionDataPart(dataPart));
                    MemorySegment memorySegment6 = WindowsWinSockLayoutsKt.getADDRINFOEXW_ai_next().get(memorySegment5, 0L);
                }
            }
            MethodHandle methodHandle2 = WindowsWinSockHandlesKt.getNativeFreeAddrInfoExW();
            Intrinsics.checkNotNull(methodHandle2);
            Object object = methodHandle2.invoke(WindowsUtilitiesKt.getThreadLocalPTR().get(ValueLayout.ADDRESS, 0L));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return data;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/bread_experts_group/api/system/socket/ipv4/windows/WindowsIPV4TCPResolutionFeature$Companion;", "", "<init>", "()V", "NS_ALL", "", "NS_DNS", "NS_NLA", "NS_BTH", "NS_NTDS", "NS_EMAIL", "NS_PNRPNAME", "NS_PNRPCLOUD", "bread_server_lib"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

