/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.system.socket.ipv4.windows;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.UShort;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.api.feature.CheckedImplementation;
import org.bread_experts_group.api.feature.FeatureExpression;
import org.bread_experts_group.api.feature.ImplementationSource;
import org.bread_experts_group.api.system.socket.feature.SocketConnectFeature;
import org.bread_experts_group.api.system.socket.feature.SocketFeatureImplementation;
import org.bread_experts_group.api.system.socket.feature.SocketReceiveFeature;
import org.bread_experts_group.api.system.socket.feature.SocketSendFeature;
import org.bread_experts_group.api.system.socket.feature.close.SocketCloseFeatureIdentifier;
import org.bread_experts_group.api.system.socket.feature.close.StandardCloseFeatures;
import org.bread_experts_group.api.system.socket.ipv4.IPv4Socket;
import org.bread_experts_group.api.system.socket.ipv4.IPv4SocketFeatures;
import org.bread_experts_group.api.system.socket.ipv4.InternetProtocolV4AddressData;
import org.bread_experts_group.api.system.socket.ipv4.InternetProtocolV4AddressPortData;
import org.bread_experts_group.api.system.socket.ipv4.connect.IPv4TCPConnectionDataIdentifier;
import org.bread_experts_group.api.system.socket.ipv4.connect.IPv4TCPConnectionFeatureIdentifier;
import org.bread_experts_group.api.system.socket.ipv4.connect.IPv4TCPLocalAddressPortData;
import org.bread_experts_group.api.system.socket.ipv4.connect.IPv4TCPRemoteAddressPortData;
import org.bread_experts_group.api.system.socket.ipv4.stream.tcp.feature.IPV4TCPSocketFeature;
import org.bread_experts_group.api.system.socket.ipv4.windows.WindowsIPV4TCPSocketFeature;
import org.bread_experts_group.ffi.ForeignFunctionInterfaceKt;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.bread_experts_group.ffi.windows.wsa.WindowsWinSockHandlesKt;
import org.bread_experts_group.ffi.windows.wsa.WindowsWinSockLayoutsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u00012\u00020\u0002:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lorg/bread_experts_group/api/system/socket/ipv4/windows/WindowsIPV4TCPSocketFeature;", "Lorg/bread_experts_group/api/system/socket/ipv4/stream/tcp/feature/IPV4TCPSocketFeature;", "Lorg/bread_experts_group/api/feature/CheckedImplementation;", "<init>", "()V", "source", "Lorg/bread_experts_group/api/feature/ImplementationSource;", "getSource", "()Lorg/bread_experts_group/api/feature/ImplementationSource;", "supported", "", "openSocket", "Lorg/bread_experts_group/api/system/socket/ipv4/IPv4Socket;", "Lorg/bread_experts_group/api/system/socket/ipv4/InternetProtocolV4AddressData;", "Companion", "bread_server_lib"})
public final class WindowsIPV4TCPSocketFeature
extends IPV4TCPSocketFeature
implements CheckedImplementation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImplementationSource source = ImplementationSource.SYSTEM_NATIVE;
    public static final int SOL_SOCKET = 65535;
    public static final int SO_UPDATE_CONNECT_CONTEXT = 28688;

    @Override
    @NotNull
    public ImplementationSource getSource() {
        return this.source;
    }

    @Override
    public boolean supported() {
        return WindowsWinSockHandlesKt.getNativeSocket() != null;
    }

    @Override
    @NotNull
    public IPv4Socket<InternetProtocolV4AddressData> openSocket() {
        MethodHandle methodHandle = WindowsWinSockHandlesKt.getNativeSocket();
        Intrinsics.checkNotNull(methodHandle);
        long socket = methodHandle.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), 2, 1, 6);
        if (socket == Long.MIN_VALUE) {
            WindowsUtilitiesKt.throwLastWSAError();
            throw new KotlinNothingValueException();
        }
        return new IPv4Socket<InternetProtocolV4AddressData>(socket){
            private final List<SocketFeatureImplementation<?>> features;
            final /* synthetic */ long $socket;
            {
                this.$socket = $socket;
                SocketFeatureImplementation[] socketFeatureImplementationArray = new SocketFeatureImplementation[3];
                FeatureExpression<SocketFeatureImplementation> featureExpression = IPv4SocketFeatures.INSTANCE.getCONNECT();
                socketFeatureImplementationArray[0] = new SocketConnectFeature<IPv4TCPConnectionFeatureIdentifier, IPv4TCPConnectionDataIdentifier>($socket, featureExpression){
                    private final ImplementationSource source;
                    final /* synthetic */ long $socket;
                    {
                        this.$socket = $socket;
                        super($super_call_param$1);
                        this.source = ImplementationSource.SYSTEM_NATIVE;
                    }

                    public ImplementationSource getSource() {
                        return this.source;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * WARNING - void declaration
                     */
                    public List<IPv4TCPConnectionDataIdentifier> connect(IPv4TCPConnectionFeatureIdentifier ... features2) {
                        List list;
                        Intrinsics.checkNotNullParameter(features2, "features");
                        AutoCloseable autoCloseable = Arena.ofConfined();
                        long l = this.$socket;
                        Throwable throwable = null;
                        try {
                            void $this$mapNotNullTo$iv$iv;
                            Arena tempArena = (Arena)autoCloseable;
                            boolean bl = false;
                            List data = new ArrayList<E>();
                            IPv4TCPConnectionFeatureIdentifier[] $this$mapNotNull$iv = features2;
                            boolean $i$f$mapNotNull = false;
                            IPv4TCPConnectionFeatureIdentifier[] iPv4TCPConnectionFeatureIdentifierArray = $this$mapNotNull$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$mapNotNullTo = false;
                            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                            boolean $i$f$forEach = false;
                            int n = ((void)$this$forEach$iv$iv$iv).length;
                            for (int i = 0; i < n; ++i) {
                                InternetProtocolV4AddressPortData it$iv$iv;
                                void element$iv$iv$iv;
                                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                                boolean bl2 = false;
                                void it = element$iv$iv;
                                boolean bl3 = false;
                                if ((it instanceof InternetProtocolV4AddressPortData ? (InternetProtocolV4AddressPortData)it : null) == null) continue;
                                it$iv$iv = it$iv$iv;
                                boolean bl4 = false;
                                destination$iv$iv.add(it$iv$iv);
                            }
                            List addresses = (List)destination$iv$iv;
                            if (addresses.isEmpty()) {
                                List list2 = data;
                                return list2;
                            }
                            data.addAll(addresses);
                            MemorySegment list3 = tempArena.allocate(WindowsWinSockLayoutsKt.getSOCKET_ADDRESS().byteSize() * (long)addresses.size() + (long)8);
                            list3.set(WindowsUtilitiesKt.getDWORD(), 0L, addresses.size());
                            MemorySegment nextEntry = null;
                            nextEntry = list3.asSlice(8L);
                            Iterable $this$forEach$iv = addresses;
                            boolean $i$f$forEach2 = false;
                            for (T element$iv : $this$forEach$iv) {
                                InternetProtocolV4AddressPortData it = (InternetProtocolV4AddressPortData)element$iv;
                                boolean bl5 = false;
                                MemorySegment sockAddr = tempArena.allocate(WindowsWinSockLayoutsKt.getSockaddr_in());
                                WindowsWinSockLayoutsKt.getSockaddr_in_sin_family().set(sockAddr, 0L, (short)2);
                                MethodHandle methodHandle = WindowsWinSockHandlesKt.getNativeWSAHtons();
                                Intrinsics.checkNotNull(methodHandle);
                                int status = methodHandle.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), l, it.getPort-Mh2AYeg(), WindowsUtilitiesKt.getThreadLocalDWORD0());
                                if (status != 0) {
                                    WindowsUtilitiesKt.throwLastWSAError();
                                    throw new KotlinNothingValueException();
                                }
                                WindowsWinSockLayoutsKt.getSockaddr_in_sin_port().set(sockAddr, 0L, WindowsUtilitiesKt.getThreadLocalDWORD0().get(ValueLayout.JAVA_SHORT, 0L));
                                MemorySegment.copy(it.getData(), 0, WindowsWinSockLayoutsKt.getSockaddr_in_sin_addr().invokeExact(sockAddr, 0L), ValueLayout.JAVA_BYTE, 0L, it.getData().length);
                                WindowsWinSockLayoutsKt.getSOCKET_ADDRESS_lpSockaddr().set(nextEntry, 0L, sockAddr);
                                WindowsWinSockLayoutsKt.getSOCKET_ADDRESS_iSockaddrLength().set(nextEntry, 0L, (int)sockAddr.byteSize());
                                nextEntry = nextEntry.asSlice(WindowsWinSockLayoutsKt.getSOCKET_ADDRESS().byteSize());
                            }
                            MemorySegment localAddr = tempArena.allocate(WindowsWinSockLayoutsKt.getSockaddr_in());
                            WindowsUtilitiesKt.getThreadLocalDWORD0().set(WindowsUtilitiesKt.getDWORD(), 0L, (int)localAddr.byteSize());
                            MemorySegment remoteAddr = tempArena.allocate(WindowsWinSockLayoutsKt.getSockaddr_in());
                            WindowsUtilitiesKt.getThreadLocalDWORD1().set(WindowsUtilitiesKt.getDWORD(), 0L, (int)remoteAddr.byteSize());
                            MethodHandle methodHandle = WindowsWinSockHandlesKt.getNativeWSAConnectByList();
                            Intrinsics.checkNotNull(methodHandle);
                            int status = methodHandle.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), l, list3, WindowsUtilitiesKt.getThreadLocalDWORD0(), localAddr, WindowsUtilitiesKt.getThreadLocalDWORD1(), remoteAddr, MemorySegment.NULL, MemorySegment.NULL);
                            if (status == 0) {
                                WindowsUtilitiesKt.throwLastWSAError();
                                throw new KotlinNothingValueException();
                            }
                            MethodHandle methodHandle2 = WindowsWinSockHandlesKt.getNativeSetSockOpt();
                            Intrinsics.checkNotNull(methodHandle2);
                            status = methodHandle2.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), l, 65535, 28688, MemorySegment.NULL, 0);
                            if (status != 0) {
                                WindowsUtilitiesKt.throwLastWSAError();
                                throw new KotlinNothingValueException();
                            }
                            byte[] byArray = WindowsWinSockLayoutsKt.getSockaddr_in_sin_addr().invokeExact(localAddr, 0L).toArray(ValueLayout.JAVA_BYTE);
                            Intrinsics.checkNotNullExpressionValue(byArray, "toArray(...)");
                            Intrinsics.checkNotNull(localAddr);
                            data.add(new IPv4TCPLocalAddressPortData(byArray, openSocket.features.1.connect$lambda$0$readPort(localAddr, l), null));
                            byte[] byArray2 = WindowsWinSockLayoutsKt.getSockaddr_in_sin_addr().invokeExact(remoteAddr, 0L).toArray(ValueLayout.JAVA_BYTE);
                            Intrinsics.checkNotNullExpressionValue(byArray2, "toArray(...)");
                            Intrinsics.checkNotNull(remoteAddr);
                            data.add(new IPv4TCPRemoteAddressPortData(byArray2, openSocket.features.1.connect$lambda$0$readPort(remoteAddr, l), null));
                            list = data;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            AutoCloseableKt.closeFinally(autoCloseable, throwable);
                        }
                        return list;
                    }

                    private static final short connect$lambda$0$readPort(MemorySegment $this$connect_u24lambda_u240_u24readPort, long socket) {
                        short port = WindowsWinSockLayoutsKt.getSockaddr_in_sin_port().get($this$connect_u24lambda_u240_u24readPort, 0L);
                        MethodHandle methodHandle = WindowsWinSockHandlesKt.getNativeWSANtohs();
                        Intrinsics.checkNotNull(methodHandle);
                        int status = methodHandle.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), socket, port, WindowsUtilitiesKt.getThreadLocalDWORD0());
                        if (status != 0) {
                            WindowsUtilitiesKt.throwLastWSAError();
                            throw new KotlinNothingValueException();
                        }
                        return UShort.constructor-impl(WindowsUtilitiesKt.getThreadLocalDWORD0().get(ValueLayout.JAVA_SHORT, 0L));
                    }
                };
                featureExpression = IPv4SocketFeatures.INSTANCE.getSEND();
                socketFeatureImplementationArray[1] = new SocketSendFeature<IPv4TCPConnectionFeatureIdentifier, IPv4TCPConnectionDataIdentifier>($socket, featureExpression){
                    private final ImplementationSource source;
                    final /* synthetic */ long $socket;
                    {
                        this.$socket = $socket;
                        super($super_call_param$1);
                        this.source = ImplementationSource.SYSTEM_NATIVE;
                    }

                    public ImplementationSource getSource() {
                        return this.source;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public List<IPv4TCPConnectionDataIdentifier> scatterS(Collection<? extends MemorySegment> data, IPv4TCPConnectionFeatureIdentifier ... features2) {
                        Intrinsics.checkNotNullParameter(data, "data");
                        Intrinsics.checkNotNullParameter(features2, "features");
                        AutoCloseable autoCloseable = Arena.ofConfined();
                        long l = this.$socket;
                        Throwable throwable = null;
                        try {
                            Arena tempArena = (Arena)autoCloseable;
                            boolean bl = false;
                            MemorySegment allocated = tempArena.allocate(WindowsWinSockLayoutsKt.getWSABUF(), data.size());
                            MemorySegment currentSegment = null;
                            currentSegment = allocated;
                            Iterable $this$forEach$iv = data;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                MemorySegment it = (MemorySegment)element$iv;
                                boolean bl2 = false;
                                WindowsWinSockLayoutsKt.getWSABUF_len().set(currentSegment, 0L, (int)it.byteSize());
                                WindowsWinSockLayoutsKt.getWSABUF_buf().set(currentSegment, 0L, it);
                                currentSegment = currentSegment.asSlice(WindowsWinSockLayoutsKt.getWSABUF().byteSize());
                            }
                            MethodHandle methodHandle = WindowsWinSockHandlesKt.getNativeWSASend();
                            Intrinsics.checkNotNull(methodHandle);
                            int status = methodHandle.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), l, allocated, data.size(), WindowsUtilitiesKt.getThreadLocalDWORD0(), 0, MemorySegment.NULL, MemorySegment.NULL);
                            if (status != 0) {
                                WindowsUtilitiesKt.throwLastWSAError();
                                throw new KotlinNothingValueException();
                            }
                            List<IPv4TCPConnectionDataIdentifier> list = CollectionsKt.emptyList();
                            return list;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            AutoCloseableKt.closeFinally(autoCloseable, throwable);
                        }
                    }
                };
                featureExpression = IPv4SocketFeatures.INSTANCE.getRECEIVE();
                socketFeatureImplementationArray[2] = new SocketReceiveFeature<IPv4TCPConnectionFeatureIdentifier, IPv4TCPConnectionDataIdentifier>($socket, featureExpression){
                    private final ImplementationSource source;
                    final /* synthetic */ long $socket;
                    {
                        this.$socket = $socket;
                        super($super_call_param$1);
                        this.source = ImplementationSource.SYSTEM_NATIVE;
                    }

                    public ImplementationSource getSource() {
                        return this.source;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public List<IPv4TCPConnectionDataIdentifier> gatherS(Collection<? extends MemorySegment> data, IPv4TCPConnectionFeatureIdentifier ... features2) {
                        Intrinsics.checkNotNullParameter(data, "data");
                        Intrinsics.checkNotNullParameter(features2, "features");
                        AutoCloseable autoCloseable = Arena.ofConfined();
                        long l = this.$socket;
                        Throwable throwable = null;
                        try {
                            Arena tempArena = (Arena)autoCloseable;
                            boolean bl = false;
                            MemorySegment allocated = tempArena.allocate(WindowsWinSockLayoutsKt.getWSABUF(), data.size());
                            MemorySegment currentSegment = null;
                            currentSegment = allocated;
                            Iterable $this$forEach$iv = data;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                MemorySegment it = (MemorySegment)element$iv;
                                boolean bl2 = false;
                                WindowsWinSockLayoutsKt.getWSABUF_len().set(currentSegment, 0L, (int)it.byteSize());
                                WindowsWinSockLayoutsKt.getWSABUF_buf().set(currentSegment, 0L, it);
                                currentSegment = currentSegment.asSlice(WindowsWinSockLayoutsKt.getWSABUF().byteSize());
                            }
                            WindowsUtilitiesKt.getThreadLocalDWORD1().set(WindowsUtilitiesKt.getDWORD(), 0L, 0);
                            MethodHandle methodHandle = WindowsWinSockHandlesKt.getNativeWSARecv();
                            Intrinsics.checkNotNull(methodHandle);
                            int status = methodHandle.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), l, allocated, data.size(), WindowsUtilitiesKt.getThreadLocalDWORD0(), WindowsUtilitiesKt.getThreadLocalDWORD1(), MemorySegment.NULL, MemorySegment.NULL);
                            if (status != 0) {
                                WindowsUtilitiesKt.throwLastWSAError();
                                throw new KotlinNothingValueException();
                            }
                            List<IPv4TCPConnectionDataIdentifier> list = CollectionsKt.emptyList();
                            return list;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            AutoCloseableKt.closeFinally(autoCloseable, throwable);
                        }
                    }
                };
                this.features = CollectionsKt.mutableListOf(socketFeatureImplementationArray);
            }

            public List<SocketFeatureImplementation<?>> getFeatures() {
                return this.features;
            }

            public List<SocketCloseFeatureIdentifier> close(SocketCloseFeatureIdentifier ... features2) {
                int status;
                Intrinsics.checkNotNullParameter(features2, "features");
                List supportedFeatures = new ArrayList<E>();
                boolean stopTx = ArraysKt.contains(features2, StandardCloseFeatures.STOP_TX);
                boolean stopRx = ArraysKt.contains(features2, StandardCloseFeatures.STOP_RX);
                if (stopTx || stopRx) {
                    int n;
                    MethodHandle methodHandle = WindowsWinSockHandlesKt.getNativeShutdown();
                    Intrinsics.checkNotNull(methodHandle);
                    MemorySegment memorySegment = ForeignFunctionInterfaceKt.getCapturedStateSegment();
                    if (stopTx && stopRx) {
                        supportedFeatures.add(StandardCloseFeatures.STOP_TX);
                        supportedFeatures.add(StandardCloseFeatures.STOP_RX);
                        n = 2;
                    } else if (stopTx) {
                        supportedFeatures.add(StandardCloseFeatures.STOP_TX);
                        n = 1;
                    } else {
                        supportedFeatures.add(StandardCloseFeatures.STOP_RX);
                        n = 0;
                    }
                    status = methodHandle.invokeExact(memorySegment, this.$socket, n);
                    if (status != 0) {
                        WindowsUtilitiesKt.throwLastWSAError();
                        throw new KotlinNothingValueException();
                    }
                }
                if (ArraysKt.contains(features2, StandardCloseFeatures.RELEASE)) {
                    supportedFeatures.add(StandardCloseFeatures.RELEASE);
                    MethodHandle methodHandle = WindowsWinSockHandlesKt.getNativeCloseSocket();
                    Intrinsics.checkNotNull(methodHandle);
                    status = methodHandle.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), this.$socket);
                    if (status != 0) {
                        WindowsUtilitiesKt.throwLastWSAError();
                        throw new KotlinNothingValueException();
                    }
                }
                return supportedFeatures;
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/bread_experts_group/api/system/socket/ipv4/windows/WindowsIPV4TCPSocketFeature$Companion;", "", "<init>", "()V", "SOL_SOCKET", "", "SO_UPDATE_CONNECT_CONTEXT", "bread_server_lib"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

