/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.system.user.macos;

import java.lang.foreign.MemorySegment;
import java.lang.invoke.MethodHandle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.bread_experts_group.api.feature.ImplementationSource;
import org.bread_experts_group.api.system.user.feature.SystemUserGetNameFeature;
import org.bread_experts_group.api.system.user.macos.MacOSSystemUser;
import org.bread_experts_group.ffi.macos.MacOSLibCHandlesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/bread_experts_group/api/system/user/macos/MacOSSystemUserGetNameFeature;", "Lorg/bread_experts_group/api/system/user/feature/SystemUserGetNameFeature;", "user", "Lorg/bread_experts_group/api/system/user/macos/MacOSSystemUser;", "<init>", "(Lorg/bread_experts_group/api/system/user/macos/MacOSSystemUser;)V", "source", "Lorg/bread_experts_group/api/feature/ImplementationSource;", "getSource", "()Lorg/bread_experts_group/api/feature/ImplementationSource;", "supported", "", "name", "", "getName", "()Ljava/lang/String;", "bread_server_lib"})
public final class MacOSSystemUserGetNameFeature
extends SystemUserGetNameFeature {
    @NotNull
    private final MacOSSystemUser user;
    @NotNull
    private final ImplementationSource source;

    public MacOSSystemUserGetNameFeature(@NotNull MacOSSystemUser user) {
        Intrinsics.checkNotNullParameter(user, "user");
        this.user = user;
        this.source = ImplementationSource.SYSTEM_NATIVE;
    }

    @Override
    @NotNull
    public ImplementationSource getSource() {
        return this.source;
    }

    @Override
    public boolean supported() {
        return MacOSLibCHandlesKt.getNativeGetlogin() != null;
    }

    @Override
    @NotNull
    public String getName() {
        MethodHandle methodHandle = MacOSLibCHandlesKt.getNativeGetlogin();
        Intrinsics.checkNotNull(methodHandle);
        MemorySegment name = methodHandle.invokeExact();
        String string = name.reinterpret(Long.MAX_VALUE).getString(0L, Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        return string;
    }
}

