/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.system.user.windows;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.api.system.user.SystemUser;
import org.bread_experts_group.api.system.user.feature.SystemUserFeatureImplementation;
import org.bread_experts_group.api.system.user.windows.WindowsSystemUserGetLogonTimeFeature;
import org.bread_experts_group.api.system.user.windows.WindowsSystemUserGetNameFeature;
import org.bread_experts_group.ffi.windows.WindowsAdvAPIHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsLayoutsKt;
import org.bread_experts_group.ffi.windows.WindowsTokenInformationClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u001e\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lorg/bread_experts_group/api/system/user/windows/WindowsSystemUser;", "Lorg/bread_experts_group/api/system/user/SystemUser;", "accessToken", "Ljava/lang/foreign/MemorySegment;", "<init>", "(Ljava/lang/foreign/MemorySegment;)V", "features", "", "Lorg/bread_experts_group/api/system/user/feature/SystemUserFeatureImplementation;", "getFeatures", "()Ljava/util/List;", "arena", "Ljava/lang/foreign/Arena;", "kotlin.jvm.PlatformType", "sid", "getSid", "()Ljava/lang/foreign/MemorySegment;", "sessionLUID", "getSessionLUID", "bread_server_lib"})
public final class WindowsSystemUser
extends SystemUser {
    @NotNull
    private final List<SystemUserFeatureImplementation<?>> features;
    private final Arena arena;
    @NotNull
    private final MemorySegment sid;
    @NotNull
    private final MemorySegment sessionLUID;

    public WindowsSystemUser(@NotNull MemorySegment accessToken) {
        Intrinsics.checkNotNullParameter(accessToken, "accessToken");
        SystemUserFeatureImplementation[] systemUserFeatureImplementationArray = new SystemUserFeatureImplementation[]{new WindowsSystemUserGetNameFeature(this), new WindowsSystemUserGetLogonTimeFeature(this)};
        this.features = CollectionsKt.mutableListOf(systemUserFeatureImplementationArray);
        this.arena = Arena.ofAuto();
        Arena arena = this.arena;
        Intrinsics.checkNotNullExpressionValue(arena, "arena");
        MemorySegment data = WindowsAdvAPIHandlesKt.getTokenInformation(arena, accessToken, WindowsTokenInformationClass.TOKEN_USER);
        MemorySegment user = WindowsLayoutsKt.getTOKEN_USER_User().invokeExact(data, 0L);
        this.sid = WindowsLayoutsKt.getSID_AND_ATTRIBUTES_Sid().get(user, 0L);
        Arena arena2 = this.arena;
        Intrinsics.checkNotNullExpressionValue(arena2, "arena");
        data = WindowsAdvAPIHandlesKt.getTokenInformation(arena2, accessToken, WindowsTokenInformationClass.TOKEN_STATISTICS);
        this.sessionLUID = WindowsLayoutsKt.getTOKEN_STATISTICS_AuthenticationId().invokeExact(data, 0L);
    }

    @Override
    @NotNull
    public List<SystemUserFeatureImplementation<?>> getFeatures() {
        return this.features;
    }

    @NotNull
    public final MemorySegment getSid() {
        return this.sid;
    }

    @NotNull
    public final MemorySegment getSessionLUID() {
        return this.sessionLUID;
    }
}

