/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.system.user.windows;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.api.feature.ImplementationSource;
import org.bread_experts_group.api.system.user.feature.SystemUserGetLogonTimeFeature;
import org.bread_experts_group.api.system.user.windows.WindowsSystemUser;
import org.bread_experts_group.ffi.windows.WindowsLayoutsKt;
import org.bread_experts_group.ffi.windows.WindowsSecurHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/bread_experts_group/api/system/user/windows/WindowsSystemUserGetLogonTimeFeature;", "Lorg/bread_experts_group/api/system/user/feature/SystemUserGetLogonTimeFeature;", "user", "Lorg/bread_experts_group/api/system/user/windows/WindowsSystemUser;", "<init>", "(Lorg/bread_experts_group/api/system/user/windows/WindowsSystemUser;)V", "source", "Lorg/bread_experts_group/api/feature/ImplementationSource;", "getSource", "()Lorg/bread_experts_group/api/feature/ImplementationSource;", "supported", "", "logonTime", "Ljava/time/Instant;", "getLogonTime", "()Ljava/time/Instant;", "bread_server_lib"})
public final class WindowsSystemUserGetLogonTimeFeature
extends SystemUserGetLogonTimeFeature {
    @NotNull
    private final WindowsSystemUser user;
    @NotNull
    private final ImplementationSource source;

    public WindowsSystemUserGetLogonTimeFeature(@NotNull WindowsSystemUser user) {
        Intrinsics.checkNotNullParameter(user, "user");
        this.user = user;
        this.source = ImplementationSource.SYSTEM_NATIVE;
    }

    @Override
    @NotNull
    public ImplementationSource getSource() {
        return this.source;
    }

    @Override
    public boolean supported() {
        return WindowsSecurHandlesKt.getNativeLsaGetLogonSessionData() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Instant getLogonTime() {
        MethodHandle methodHandle = WindowsSecurHandlesKt.getNativeLsaGetLogonSessionData();
        Intrinsics.checkNotNull(methodHandle);
        WindowsUtilitiesKt.returnsNTSTATUS(methodHandle, this.user.getSessionLUID(), WindowsUtilitiesKt.getThreadLocalPTR());
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            Arena it = (Arena)autoCloseable;
            boolean bl = false;
            MemorySegment data = WindowsUtilitiesKt.getThreadLocalPTR().get(ValueLayout.ADDRESS, 0L).reinterpret(WindowsLayoutsKt.getSECURITY_LOGON_SESSION_DATA().byteSize(), it, WindowsSystemUserGetLogonTimeFeature::_get_logonTime_$lambda$0$0);
            Instant instant = Instant.ofEpochMilli(WindowsUtilitiesKt.FILETIMEToUnixMs(WindowsLayoutsKt.getSECURITY_LOGON_SESSION_DATA_LogonTime().get(data, 0L)));
            Intrinsics.checkNotNullExpressionValue(instant, "ofEpochMilli(...)");
            Instant instant2 = instant;
            return instant2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    private static final void _get_logonTime_$lambda$0$0(MemorySegment m) {
        MethodHandle methodHandle = WindowsSecurHandlesKt.getNativeLsaFreeReturnBuffer();
        Intrinsics.checkNotNull(methodHandle);
        Intrinsics.checkNotNull(m);
        WindowsUtilitiesKt.returnsNTSTATUS(methodHandle, m);
    }
}

