/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.system.user.windows;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.invoke.MethodHandle;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.bread_experts_group.api.feature.ImplementationSource;
import org.bread_experts_group.api.system.user.feature.SystemUserGetNameFeature;
import org.bread_experts_group.api.system.user.windows.WindowsSystemUser;
import org.bread_experts_group.ffi.ForeignFunctionInterfaceKt;
import org.bread_experts_group.ffi.windows.WindowsAdvAPIHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/bread_experts_group/api/system/user/windows/WindowsSystemUserGetNameFeature;", "Lorg/bread_experts_group/api/system/user/feature/SystemUserGetNameFeature;", "user", "Lorg/bread_experts_group/api/system/user/windows/WindowsSystemUser;", "<init>", "(Lorg/bread_experts_group/api/system/user/windows/WindowsSystemUser;)V", "source", "Lorg/bread_experts_group/api/feature/ImplementationSource;", "getSource", "()Lorg/bread_experts_group/api/feature/ImplementationSource;", "supported", "", "name", "", "getName", "()Ljava/lang/String;", "bread_server_lib"})
public final class WindowsSystemUserGetNameFeature
extends SystemUserGetNameFeature {
    @NotNull
    private final WindowsSystemUser user;
    @NotNull
    private final ImplementationSource source;

    public WindowsSystemUserGetNameFeature(@NotNull WindowsSystemUser user) {
        Intrinsics.checkNotNullParameter(user, "user");
        this.user = user;
        this.source = ImplementationSource.SYSTEM_NATIVE;
    }

    @Override
    @NotNull
    public ImplementationSource getSource() {
        return this.source;
    }

    @Override
    public boolean supported() {
        return WindowsAdvAPIHandlesKt.getNativeLookupAccountSidW() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String getName() {
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            Arena it = (Arena)autoCloseable;
            boolean bl = false;
            WindowsUtilitiesKt.getThreadLocalDWORD0().set(WindowsUtilitiesKt.getDWORD(), 0L, 0);
            WindowsUtilitiesKt.getThreadLocalDWORD1().set(WindowsUtilitiesKt.getDWORD(), 0L, 0);
            MethodHandle methodHandle = WindowsAdvAPIHandlesKt.getNativeLookupAccountSidW();
            Intrinsics.checkNotNull(methodHandle);
            methodHandle.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), MemorySegment.NULL, this.user.getSid(), MemorySegment.NULL, WindowsUtilitiesKt.getThreadLocalDWORD0(), MemorySegment.NULL, WindowsUtilitiesKt.getThreadLocalDWORD1(), WindowsUtilitiesKt.getThreadLocalDWORD2());
            MemorySegment accountName = it.allocate(WindowsUtilitiesKt.getWCHAR(), WindowsUtilitiesKt.getThreadLocalDWORD0().get(WindowsUtilitiesKt.getDWORD(), 0L) + WindowsUtilitiesKt.getThreadLocalDWORD1().get(WindowsUtilitiesKt.getDWORD(), 0L));
            MemorySegment referencedDomainName = accountName.asSlice(WindowsUtilitiesKt.getWCHAR().byteSize() * (long)WindowsUtilitiesKt.getThreadLocalDWORD0().get(WindowsUtilitiesKt.getDWORD(), 0L));
            int status = WindowsAdvAPIHandlesKt.getNativeLookupAccountSidW().invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), MemorySegment.NULL, this.user.getSid(), accountName, WindowsUtilitiesKt.getThreadLocalDWORD0(), referencedDomainName, WindowsUtilitiesKt.getThreadLocalDWORD1(), WindowsUtilitiesKt.getThreadLocalDWORD2());
            if (status == 0) {
                WindowsUtilitiesKt.throwLastError();
                throw new KotlinNothingValueException();
            }
            String string = referencedDomainName.getString(0L, Charsets.UTF_16LE) + "\\" + accountName.getString(0L, Charsets.UTF_16LE);
            return string;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }
}

