/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.coder.json;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import org.bread_experts_group.coder.json.JSONArray;
import org.bread_experts_group.coder.json.JSONBoolean;
import org.bread_experts_group.coder.json.JSONNumber;
import org.bread_experts_group.coder.json.JSONObject;
import org.bread_experts_group.coder.json.JSONString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b6\u0018\u0000 \u00142\u00020\u0001:\u0002\u0013\u0014B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u0002H\u0005\"\u0004\b\u0000\u0010\u00052\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H\u00050\u0007\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\u0010\nJ*\u0010\u000b\u001a\u0002H\u0005\"\u0004\b\u0000\u0010\u00052\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u0002H\u00050\u0007\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\u0010\nJ*\u0010\r\u001a\u0002H\u0005\"\u0004\b\u0000\u0010\u00052\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u0002H\u00050\u0007\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\u0010\nJ*\u0010\u000f\u001a\u0002H\u0005\"\u0004\b\u0000\u0010\u00052\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u0002H\u00050\u0007\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\u0010\nJ*\u0010\u0011\u001a\u0002H\u0005\"\u0004\b\u0000\u0010\u00052\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u0002H\u00050\u0007\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\u0010\n\u0082\u0001\u0005\u0012\f\u000e\b\u0010\u00a8\u0006\u0015"}, d2={"Lorg/bread_experts_group/coder/json/JSONElement;", "", "<init>", "()V", "asObject", "T", "init", "Lkotlin/Function1;", "Lorg/bread_experts_group/coder/json/JSONObject;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "asBoolean", "Lorg/bread_experts_group/coder/json/JSONBoolean;", "asNumber", "Lorg/bread_experts_group/coder/json/JSONNumber;", "asString", "Lorg/bread_experts_group/coder/json/JSONString;", "asArray", "Lorg/bread_experts_group/coder/json/JSONArray;", "TrackingBufferedReader", "Companion", "bread_server_lib"})
public abstract sealed class JSONElement
permits JSONArray, JSONBoolean, JSONNumber, JSONObject, JSONString {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private JSONElement() {
    }

    public final <T> T asObject(@NotNull Function1<? super JSONObject, ? extends T> init) {
        Intrinsics.checkNotNullParameter(init, "init");
        Intrinsics.checkNotNull(this, "null cannot be cast to non-null type org.bread_experts_group.coder.json.JSONObject");
        return init.invoke((JSONObject)this);
    }

    public final <T> T asBoolean(@NotNull Function1<? super JSONBoolean, ? extends T> init) {
        Intrinsics.checkNotNullParameter(init, "init");
        Intrinsics.checkNotNull(this, "null cannot be cast to non-null type org.bread_experts_group.coder.json.JSONBoolean");
        return init.invoke((JSONBoolean)this);
    }

    public final <T> T asNumber(@NotNull Function1<? super JSONNumber, ? extends T> init) {
        Intrinsics.checkNotNullParameter(init, "init");
        Intrinsics.checkNotNull(this, "null cannot be cast to non-null type org.bread_experts_group.coder.json.JSONNumber");
        return init.invoke((JSONNumber)this);
    }

    public final <T> T asString(@NotNull Function1<? super JSONString, ? extends T> init) {
        Intrinsics.checkNotNullParameter(init, "init");
        Intrinsics.checkNotNull(this, "null cannot be cast to non-null type org.bread_experts_group.coder.json.JSONString");
        return init.invoke((JSONString)this);
    }

    public final <T> T asArray(@NotNull Function1<? super JSONArray, ? extends T> init) {
        Intrinsics.checkNotNullParameter(init, "init");
        Intrinsics.checkNotNull(this, "null cannot be cast to non-null type org.bread_experts_group.coder.json.JSONArray");
        return init.invoke((JSONArray)this);
    }

    public /* synthetic */ JSONElement(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0003\n\u000b\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\t\u00a8\u0006\r"}, d2={"Lorg/bread_experts_group/coder/json/JSONElement$Companion;", "", "<init>", "()V", "read", "Lorg/bread_experts_group/coder/json/JSONElement;", "stream", "Lorg/bread_experts_group/coder/json/JSONElement$TrackingBufferedReader;", "json", "Ljava/io/InputStream;", "BoundsExit", "ObjectExit", "ArrayExit", "bread_server_lib"})
    @SourceDebugExtension(value={"SMAP\nJSONElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSONElement.kt\norg/bread_experts_group/coder/json/JSONElement$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1#2:75\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public final JSONElement read(@NotNull TrackingBufferedReader stream) {
            Object concatenated;
            JSONElement jSONElement;
            Intrinsics.checkNotNullParameter(stream, "stream");
            while (true) {
                char entry = stream.readWithCached();
                switch (entry) {
                    case '{': {
                        jSONElement = JSONObject.Companion.localRead(stream);
                        return jSONElement;
                    }
                    case '[': {
                        jSONElement = JSONArray.Companion.localRead(stream);
                        return jSONElement;
                    }
                    case '\"': {
                        Object concatenated2 = "";
                        while (true) {
                            char next;
                            if ((next = stream.readCharNoCache()) == '\"') {
                                jSONElement = new JSONString((String)concatenated2);
                                return jSONElement;
                            }
                            concatenated2 = (String)concatenated2 + next;
                        }
                    }
                    case 't': {
                        long it = stream.skip(3L);
                        boolean bl = false;
                        boolean bl2 = true;
                        jSONElement = new JSONBoolean(bl2);
                        return jSONElement;
                    }
                    case 'f': {
                        long it = stream.skip(4L);
                        boolean bl = false;
                        boolean bl3 = false;
                        jSONElement = new JSONBoolean(bl3);
                        return jSONElement;
                    }
                    case '}': {
                        throw new ObjectExit();
                    }
                    case ']': {
                        throw new ArrayExit();
                    }
                }
                if (Character.isDigit(entry)) {
                    char next;
                    concatenated = String.valueOf(entry);
                    while (Character.isDigit(next = stream.readCharAndCache()) || next == '.') {
                        concatenated = (String)concatenated + next;
                    }
                    break;
                }
                if (CharsKt.isWhitespace(entry)) continue;
                if (entry != ',') throw new IllegalArgumentException("JSON element entry '" + entry + "'");
            }
            jSONElement = new JSONNumber(new BigDecimal((String)concatenated));
            return jSONElement;
        }

        @NotNull
        public final JSONElement json(@NotNull InputStream stream) {
            Intrinsics.checkNotNullParameter(stream, "stream");
            return this.read(new TrackingBufferedReader(new InputStreamReader(stream, Charsets.UTF_8)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/bread_experts_group/coder/json/JSONElement$Companion$ArrayExit;", "Lorg/bread_experts_group/coder/json/JSONElement$Companion$BoundsExit;", "<init>", "()V", "bread_server_lib"})
        public static final class ArrayExit
        extends BoundsExit {
            public ArrayExit() {
                super(']');
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\b&\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/bread_experts_group/coder/json/JSONElement$Companion$BoundsExit;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "char", "", "<init>", "(C)V", "bread_server_lib"})
        public static abstract class BoundsExit
        extends RuntimeException {
            public BoundsExit(char c) {
                super("JSON element entry '" + c + "'");
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/bread_experts_group/coder/json/JSONElement$Companion$ObjectExit;", "Lorg/bread_experts_group/coder/json/JSONElement$Companion$BoundsExit;", "<init>", "()V", "bread_server_lib"})
        public static final class ObjectExit
        extends BoundsExit {
            public ObjectExit() {
                super('}');
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\t\u001a\u00020\u0007J\u0006\u0010\n\u001a\u00020\u0007J\u0006\u0010\u000b\u001a\u00020\u0007J4\u0010\f\u001a\u00020\rH\u0017b*\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u001c\b\u0011\u0012\u0018\b\u000bB\u0014\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0006\b\u0015\u0012\u0002\b\fR\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/bread_experts_group/coder/json/JSONElement$TrackingBufferedReader;", "Ljava/io/BufferedReader;", "reader", "Ljava/io/InputStreamReader;", "<init>", "(Ljava/io/InputStreamReader;)V", "lastRead", "", "Ljava/lang/Character;", "readWithCached", "readCharNoCache", "readCharAndCache", "read", "", "Lkotlin/Deprecated;", "message", "Use TrackingBufferedReader.readChar instead", "replaceWith", "Lkotlin/ReplaceWith;", "expression", "readChar()", "imports", "bread_server_lib"})
    @SourceDebugExtension(value={"SMAP\nJSONElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSONElement.kt\norg/bread_experts_group/coder/json/JSONElement$TrackingBufferedReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1#2:75\n*E\n"})
    public static final class TrackingBufferedReader
    extends BufferedReader {
        @Nullable
        private Character lastRead;

        public TrackingBufferedReader(@NotNull InputStreamReader reader) {
            Intrinsics.checkNotNullParameter(reader, "reader");
            super(reader);
        }

        public final char readWithCached() {
            char c;
            if (this.lastRead == null) {
                c = this.readCharNoCache();
            } else {
                Character c2 = this.lastRead;
                Intrinsics.checkNotNull(c2);
                Character c3 = c2;
                char it = c3.charValue();
                boolean bl = false;
                this.lastRead = null;
                c = c3.charValue();
            }
            return c;
        }

        public final char readCharNoCache() {
            int n = super.read();
            if (n < 0 || n > 65535) {
                throw new IllegalArgumentException("Invalid Char code: " + n);
            }
            return (char)n;
        }

        public final char readCharAndCache() {
            int n = super.read();
            if (n < 0 || n > 65535) {
                throw new IllegalArgumentException("Invalid Char code: " + n);
            }
            char next = (char)n;
            this.lastRead = Character.valueOf(next);
            return next;
        }

        @Override
        @Deprecated(message="Use TrackingBufferedReader.readChar instead", replaceWith=@ReplaceWith(expression="readChar()", imports={}))
        public int read() {
            throw new IllegalStateException();
        }
    }
}

