/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.command_line;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bread_experts_group.BuildInfoRetrieverKt;
import org.bread_experts_group.command_line.ArgumentConstructionError;
import org.bread_experts_group.command_line.ArgumentContainer;
import org.bread_experts_group.command_line.ArgumentParsingError;
import org.bread_experts_group.command_line.Flag;
import org.bread_experts_group.command_line.RequiredArgumentsMissingException;
import org.bread_experts_group.logging.ColoredHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\u001aE\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u001a\u0010\u0007\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\b0\u0003\"\u0006\u0012\u0002\b\u00030\b\u00a2\u0006\u0002\u0010\t\u001a;\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\r\"\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"readArgs", "Lorg/bread_experts_group/command_line/ArgumentContainer;", "args", "", "", "projectName", "projectUsage", "flags", "Lorg/bread_experts_group/command_line/Flag;", "([Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;[Lorg/bread_experts_group/command_line/Flag;)Lorg/bread_experts_group/command_line/ArgumentContainer;", "logger", "Ljava/util/logging/Logger;", "", "([Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;)Lorg/bread_experts_group/command_line/ArgumentContainer;", "bread_server_lib"})
@SourceDebugExtension(value={"SMAP\nCommandLine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandLine.kt\norg/bread_experts_group/command_line/CommandLineKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,120:1\n1869#2,2:121\n1869#2,2:125\n1869#2,2:127\n295#2,2:129\n1869#2,2:138\n1878#2,3:140\n12970#3,2:123\n382#4,7:131\n*S KotlinDebug\n*F\n+ 1 CommandLine.kt\norg/bread_experts_group/command_line/CommandLineKt\n*L\n26#1:121,2\n44#1:125,2\n50#1:127,2\n70#1:129,2\n101#1:138,2\n116#1:140,3\n32#1:123,2\n92#1:131,7\n*E\n"})
public final class CommandLineKt {
    @NotNull
    private static final Logger logger = ColoredHandler.Companion.newLoggerResourced$default(ColoredHandler.Companion, "program_argument_retrieval", null, 2, null);

    @NotNull
    public static final ArgumentContainer readArgs(@NotNull String[] args, @NotNull String projectName, @NotNull String projectUsage, Flag<?> ... flags) {
        Intrinsics.checkNotNullParameter(args, "args");
        Intrinsics.checkNotNullParameter(projectName, "projectName");
        Intrinsics.checkNotNullParameter(projectUsage, "projectUsage");
        Intrinsics.checkNotNullParameter(flags, "flags");
        return CommandLineKt.readArgs(args, ArraysKt.toList(flags), projectName, projectUsage);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ArgumentContainer readArgs(@NotNull String[] args, @NotNull List<? extends Flag<?>> flags, @NotNull String projectName, @NotNull String projectUsage) {
        boolean bl;
        block25: {
            Intrinsics.checkNotNullParameter(args, "args");
            Intrinsics.checkNotNullParameter(flags, "flags");
            Intrinsics.checkNotNullParameter(projectName, "projectName");
            Intrinsics.checkNotNullParameter(projectUsage, "projectUsage");
            boolean bl2 = false;
            String[] stringArray = new String[]{"help"};
            Set<String> argNames2 = SetsKt.mutableSetOf(stringArray);
            Iterable $this$forEach$iv = flags;
            int $i$f$forEach = 0;
            for (Object element$iv : $this$forEach$iv) {
                Flag it = (Flag)element$iv;
                boolean bl3 = false;
                if (argNames2.contains(it.getFlagName())) {
                    throw new ArgumentConstructionError("Duplicate argument parsing! [" + it.getFlagName() + "]");
                }
                argNames2.add(it.getFlagName());
            }
            String[] $this$any$iv = args;
            boolean $i$f$any = false;
            $i$f$forEach = $this$any$iv.length;
            for (int argNames2 = 0; argNames2 < $i$f$forEach; ++argNames2) {
                String element$iv;
                String it = element$iv = $this$any$iv[argNames2];
                boolean bl4 = false;
                if (!Intrinsics.areEqual(StringsKt.substringAfter$default(it, '-', null, 2, null), "help")) continue;
                bl = true;
                break block25;
            }
            bl = false;
        }
        if (bl) {
            Flag it;
            StringBuilder $i$f$any;
            String bslLocation = ColoredHandler.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            logger.info("Bread Server Library information");
            logger.info("Location     [" + bslLocation + "]");
            logger.info("Version      [" + BuildInfoRetrieverKt.bslVersion() + "]");
            logger.info("Compiled at  [" + BuildInfoRetrieverKt.bslBuildDate() + "]");
            logger.info("Project information");
            logger.info("Project      [" + projectName + "]");
            logger.info("Usage        [" + projectUsage + "]");
            StringBuilder argNames2 = $i$f$any = new StringBuilder();
            Logger logger = CommandLineKt.logger;
            int n = 0;
            int longestFlagName = 0;
            int longestFlagDescription = 0;
            Iterable $this$forEach$iv = flags;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Flag)element$iv;
                boolean bl5 = false;
                if (it.getFlagName().length() > longestFlagName) {
                    longestFlagName = it.getFlagName().length();
                }
                if (it.getFlagDescription().length() <= longestFlagDescription) continue;
                longestFlagDescription = it.getFlagDescription().length();
            }
            $this$forEach$iv = flags;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$readArgs_u24lambda_u242;
                it = (Flag)element$iv;
                boolean bl6 = false;
                $this$readArgs_u24lambda_u242.append("\t-" + StringsKt.padEnd$default(it.getFlagName(), longestFlagName, '\u0000', 2, null) + "\n");
                $this$readArgs_u24lambda_u242.append("\t\t" + StringsKt.padEnd$default(StringsKt.replace$default(it.getFlagDescription(), "\n", "\n\t\t ", false, 4, null), longestFlagDescription, '\u0000', 2, null) + "\n");
                if (it.getDefault() != null) {
                    $this$readArgs_u24lambda_u242.append("\t\tDefault [" + it.getDefault() + "]\n");
                }
                if (it.getRequired() <= 0) continue;
                $this$readArgs_u24lambda_u242.append("\t\tRequired " + it.getRequired() + " time" + (it.getRequired() > 1 ? Character.valueOf('s') : "") + "\n");
            }
            logger.info("Flag information\n" + $i$f$any.toString());
            System.exit(3319);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        Map singleArgs = new LinkedHashMap();
        Map multipleArgs = new LinkedHashMap();
        List problems = new ArrayList();
        for (String arg : args) {
            Object it;
            String string;
            Object v3;
            int equIndex;
            block26: {
                logger.finer(() -> CommandLineKt.readArgs$lambda$3(arg));
                if (arg.charAt(0) != '-') {
                    problems.add(new ArgumentParsingError("Bad argument \"" + (String)arg + "\", requires - before name", null, null, 6, null));
                    continue;
                }
                equIndex = StringsKt.indexOf$default((CharSequence)arg, '=', 0, false, 6, null);
                Iterable $this$firstOrNull$iv = flags;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Flag f = (Flag)element$iv;
                    boolean bl7 = false;
                    String string2 = f.getFlagName();
                    String string3 = arg.substring(1, equIndex == -1 ? arg.length() : equIndex);
                    Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
                    if (!Intrinsics.areEqual(string2, string3)) continue;
                    v3 = element$iv;
                    break block26;
                }
                v3 = null;
            }
            Flag flag = v3;
            if (flag == null) {
                problems.add(new ArgumentParsingError("Bad argument \"" + (String)arg + "\", not a flag; see -help", null, null, 6, null));
                continue;
            }
            if (equIndex == -1) {
                string = "true";
            } else {
                String string4 = arg.substring(equIndex + 1);
                string = string4;
                Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
            }
            String value = string;
            try {
                it = !StringsKt.isBlank(value) ? flag.getConv().invoke(value) : flag.getDefault();
            }
            catch (Throwable e) {
                problems.add(new ArgumentParsingError("Error while converting argument", flag, e));
                continue;
            }
            Iterator typedValue = it;
            logger.finer(() -> CommandLineKt.readArgs$lambda$5(typedValue));
            if (typedValue == null) continue;
            if (flag.getRepeatable()) {
                Object object;
                void $this$getOrPut$iv;
                it = multipleArgs;
                String key$iv = flag.getFlagName();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl8 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(typedValue);
                continue;
            }
            if (singleArgs.putIfAbsent(flag.getFlagName(), typedValue) == null) continue;
            problems.add(new ArgumentParsingError("Duplicate flag", flag, null, 4, null));
        }
        Iterable $this$forEach$iv = flags;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Flag it = (Flag)element$iv;
            boolean bl9 = false;
            if (!it.getRepeatable() && it.getDefault() != null && !singleArgs.containsKey(it.getFlagName())) {
                logger.finer(() -> CommandLineKt.readArgs$lambda$7$0(it));
                singleArgs.put(it.getFlagName(), it.getDefault());
            }
            if (it.getRequired() != 0 && !singleArgs.containsKey(it.getFlagName()) && !multipleArgs.containsKey(it.getFlagName())) {
                problems.add(new RequiredArgumentsMissingException(it, 0));
                continue;
            }
            if (it.getRequired() <= 1) continue;
            List a = (List)MapsKt.getValue(multipleArgs, it.getFlagName());
            boolean bl10 = false;
            if (a.size() >= it.getRequired()) continue;
            problems.add(new RequiredArgumentsMissingException(it, a.size()));
        }
        if (!((Collection)problems).isEmpty()) {
            Iterable $this$forEachIndexed$iv = problems;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void problem;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                ArgumentParsingError a = (ArgumentParsingError)item$iv;
                int i = n;
                boolean bl11 = false;
                logger.log(Level.SEVERE, (Throwable)problem, () -> CommandLineKt.readArgs$lambda$8$0(i));
            }
            System.exit(3122);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        return new ArgumentContainer(MapsKt.plus(singleArgs, multipleArgs));
    }

    private static final String readArgs$lambda$3(String $arg) {
        return "Parse argument \"" + $arg + "\"";
    }

    private static final String readArgs$lambda$5(Object $typedValue) {
        Object object = $typedValue;
        return "Conversion \"" + $typedValue + "\" " + (String)(object != null ? "(" + Reflection.getOrCreateKotlinClass(object.getClass()).getSimpleName() + ")" : "");
    }

    private static final String readArgs$lambda$7$0(Flag $it) {
        return "Using default (\"" + $it.getDefault() + "\" (" + Reflection.getOrCreateKotlinClass($it.getDefault().getClass()).getSimpleName() + ")) for flag \"" + $it.getFlagName() + "\"";
    }

    private static final String readArgs$lambda$8$0(int $i) {
        return "Argument problem [" + $i + "]";
    }
}

