/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.ffi;

import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.StructLayout;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.ranges.RangesKt;
import org.bread_experts_group.FormattingKt;
import org.bread_experts_group.logging.ColoredHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\u001a\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\n\u0010\u0007\u001a\u00020\u0006*\u00020\b\u001a\n\u0010\t\u001a\u00020\u0006*\u00020\b\u001a\u0014\u0010\n\u001a\u0004\u0018\u00010\b*\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0006\u001a+\u0010\f\u001a\u00020\r*\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\"\u00020\u0012\u00a2\u0006\u0002\u0010\u0013\u001a+\u0010\u0014\u001a\u00020\r*\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\"\u00020\u0012\u00a2\u0006\u0002\u0010\u0013\u001aC\u0010\f\u001a\u0004\u0018\u00010\r*\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u00062\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u00112\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0016\u00a2\u0006\u0002\u0010\u0018\u001a7\u0010\f\u001a\u0004\u0018\u00010\r*\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u00062\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\"\u00020\u0012\u00a2\u0006\u0002\u0010\u0019\u001a7\u0010\u0014\u001a\u0004\u0018\u00010\r*\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u00062\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\"\u00020\u0012\u00a2\u0006\u0002\u0010\u0019\u001a\n\u0010*\u001a\u00020+*\u00020\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u001a\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\"\u0011\u0010\u001d\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\"\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\"2\u0010$\u001a&\u0012\f\u0012\n &*\u0004\u0018\u00010\b0\b &*\u0012\u0012\f\u0012\n &*\u0004\u0018\u00010\b0\b\u0018\u00010%0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010'\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006,"}, d2={"nativeLogger", "Ljava/util/logging/Logger;", "getLookup", "Ljava/lang/foreign/SymbolLookup;", "Ljava/lang/foreign/Arena;", "library", "", "composeFlags", "Ljava/lang/foreign/MemorySegment;", "debugString", "getAddress", "name", "getDowncall", "Ljava/lang/invoke/MethodHandle;", "linker", "Ljava/lang/foreign/Linker;", "layouts", "", "Ljava/lang/foreign/ValueLayout;", "(Ljava/lang/foreign/MemorySegment;Ljava/lang/foreign/Linker;[Ljava/lang/foreign/ValueLayout;)Ljava/lang/invoke/MethodHandle;", "getDowncallVoid", "options", "", "Ljava/lang/foreign/Linker$Option;", "(Ljava/lang/foreign/SymbolLookup;Ljava/lang/foreign/Linker;Ljava/lang/String;[Ljava/lang/foreign/ValueLayout;Ljava/util/List;)Ljava/lang/invoke/MethodHandle;", "(Ljava/lang/foreign/SymbolLookup;Ljava/lang/foreign/Linker;Ljava/lang/String;[Ljava/lang/foreign/ValueLayout;)Ljava/lang/invoke/MethodHandle;", "globalArena", "getGlobalArena", "()Ljava/lang/foreign/Arena;", "nativeLinker", "getNativeLinker", "()Ljava/lang/foreign/Linker;", "capturedStateLayout", "Ljava/lang/foreign/StructLayout;", "getCapturedStateLayout", "()Ljava/lang/foreign/StructLayout;", "tlsCSS", "Ljava/lang/ThreadLocal;", "kotlin.jvm.PlatformType", "capturedStateSegment", "getCapturedStateSegment", "()Ljava/lang/foreign/MemorySegment;", "getFirstNull2Offset", "", "bread_server_lib"})
@SourceDebugExtension(value={"SMAP\nForeignFunctionInterface.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForeignFunctionInterface.kt\norg/bread_experts_group/ffi/ForeignFunctionInterfaceKt\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,97:1\n37#2,2:98\n*S KotlinDebug\n*F\n+ 1 ForeignFunctionInterface.kt\norg/bread_experts_group/ffi/ForeignFunctionInterfaceKt\n*L\n62#1:98,2\n*E\n"})
public final class ForeignFunctionInterfaceKt {
    @NotNull
    private static final Logger nativeLogger = ColoredHandler.Companion.newLoggerResourced$default(ColoredHandler.Companion, "ffi", null, 2, null);
    @NotNull
    private static final StructLayout capturedStateLayout;
    private static final ThreadLocal<MemorySegment> tlsCSS;

    @Nullable
    public static final SymbolLookup getLookup(@NotNull Arena $this$getLookup, @NotNull String library) {
        SymbolLookup symbolLookup;
        Intrinsics.checkNotNullParameter($this$getLookup, "<this>");
        Intrinsics.checkNotNullParameter(library, "library");
        try {
            nativeLogger.finer(() -> ForeignFunctionInterfaceKt.getLookup$lambda$0(library));
            SymbolLookup it = symbolLookup = SymbolLookup.libraryLookup(library, $this$getLookup);
            boolean bl = false;
            nativeLogger.fine(() -> ForeignFunctionInterfaceKt.getLookup$lambda$1$0(library));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            nativeLogger.warning(() -> ForeignFunctionInterfaceKt.getLookup$lambda$2(library));
            symbolLookup = null;
        }
        return symbolLookup;
    }

    @NotNull
    public static final String composeFlags(@NotNull MemorySegment $this$composeFlags) {
        Intrinsics.checkNotNullParameter($this$composeFlags, "<this>");
        char c = '[';
        Object object = CollectionsKt.createListBuilder();
        List<String> $this$composeFlags_u24lambda_u240 = object;
        boolean bl = false;
        if ($this$composeFlags.isMapped()) {
            boolean bl2 = $this$composeFlags.isLoaded() ? $this$composeFlags_u24lambda_u240.add("M.LOADED") : $this$composeFlags_u24lambda_u240.add("MAPPED");
        }
        if ($this$composeFlags.isNative()) {
            $this$composeFlags_u24lambda_u240.add("NATIVE");
        }
        if ($this$composeFlags.isReadOnly()) {
            $this$composeFlags_u24lambda_u240.add("READONLY");
        }
        object = CollectionsKt.joinToString$default(CollectionsKt.build(object), ",", null, null, 0, null, null, 62, null);
        return c + (String)object + "]";
    }

    @NotNull
    public static final String debugString(@NotNull MemorySegment $this$debugString) {
        Intrinsics.checkNotNullParameter($this$debugString, "<this>");
        return "{" + FormattingKt.hex-VKZWuLQ(ULong.constructor-impl($this$debugString.address())) + "}; " + ForeignFunctionInterfaceKt.composeFlags($this$debugString);
    }

    @Nullable
    public static final MemorySegment getAddress(@NotNull SymbolLookup $this$getAddress, @NotNull String name) {
        Intrinsics.checkNotNullParameter($this$getAddress, "<this>");
        Intrinsics.checkNotNullParameter(name, "name");
        nativeLogger.finer(() -> ForeignFunctionInterfaceKt.getAddress$lambda$0(name));
        Optional<MemorySegment> optional = $this$getAddress.find(name);
        Intrinsics.checkNotNullExpressionValue(optional, "find(...)");
        MemorySegment address = OptionalsKt.getOrNull(optional);
        if (address == null) {
            nativeLogger.warning(() -> ForeignFunctionInterfaceKt.getAddress$lambda$1(name));
            return null;
        }
        nativeLogger.fine(() -> ForeignFunctionInterfaceKt.getAddress$lambda$2(name, address));
        return address;
    }

    @NotNull
    public static final MethodHandle getDowncall(@NotNull MemorySegment $this$getDowncall, @NotNull Linker linker, ValueLayout ... layouts) {
        Intrinsics.checkNotNullParameter($this$getDowncall, "<this>");
        Intrinsics.checkNotNullParameter(linker, "linker");
        Intrinsics.checkNotNullParameter(layouts, "layouts");
        ValueLayout[] valueLayoutArray = ArraysKt.sliceArray(layouts, RangesKt.until(1, layouts.length));
        FunctionDescriptor descriptor2 = FunctionDescriptor.of(layouts[0], Arrays.copyOf(valueLayoutArray, valueLayoutArray.length));
        MethodHandle methodHandle = linker.downcallHandle($this$getDowncall, descriptor2, new Linker.Option[0]);
        Intrinsics.checkNotNullExpressionValue(methodHandle, "downcallHandle(...)");
        return methodHandle;
    }

    @NotNull
    public static final MethodHandle getDowncallVoid(@NotNull MemorySegment $this$getDowncallVoid, @NotNull Linker linker, ValueLayout ... layouts) {
        Intrinsics.checkNotNullParameter($this$getDowncallVoid, "<this>");
        Intrinsics.checkNotNullParameter(linker, "linker");
        Intrinsics.checkNotNullParameter(layouts, "layouts");
        FunctionDescriptor descriptor2 = FunctionDescriptor.ofVoid(Arrays.copyOf(layouts, layouts.length));
        MethodHandle methodHandle = linker.downcallHandle($this$getDowncallVoid, descriptor2, new Linker.Option[0]);
        Intrinsics.checkNotNullExpressionValue(methodHandle, "downcallHandle(...)");
        return methodHandle;
    }

    @Nullable
    public static final MethodHandle getDowncall(@Nullable SymbolLookup $this$getDowncall, @NotNull Linker linker, @NotNull String name, @NotNull ValueLayout[] layouts, @NotNull List<? extends Linker.Option> options) {
        Intrinsics.checkNotNullParameter(linker, "linker");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(layouts, "layouts");
        Intrinsics.checkNotNullParameter(options, "options");
        Object[] objectArray = ArraysKt.sliceArray(layouts, RangesKt.until(1, layouts.length));
        FunctionDescriptor descriptor2 = FunctionDescriptor.of(layouts[0], Arrays.copyOf(objectArray, objectArray.length));
        Object object = $this$getDowncall;
        if (object == null || (object = ForeignFunctionInterfaceKt.getAddress((SymbolLookup)object, name)) == null) {
            return null;
        }
        Collection $this$toTypedArray$iv = options;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        objectArray = thisCollection$iv.toArray(new Linker.Option[0]);
        return linker.downcallHandle((MemorySegment)object, descriptor2, (Linker.Option[])Arrays.copyOf(objectArray, objectArray.length));
    }

    @Nullable
    public static final MethodHandle getDowncall(@Nullable SymbolLookup $this$getDowncall, @NotNull Linker linker, @NotNull String name, ValueLayout ... layouts) {
        Intrinsics.checkNotNullParameter(linker, "linker");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(layouts, "layouts");
        SymbolLookup symbolLookup = $this$getDowncall;
        return symbolLookup != null ? ForeignFunctionInterfaceKt.getDowncall(symbolLookup, linker, name, layouts, CollectionsKt.emptyList()) : null;
    }

    @Nullable
    public static final MethodHandle getDowncallVoid(@Nullable SymbolLookup $this$getDowncallVoid, @NotNull Linker linker, @NotNull String name, ValueLayout ... layouts) {
        Intrinsics.checkNotNullParameter(linker, "linker");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(layouts, "layouts");
        FunctionDescriptor descriptor2 = FunctionDescriptor.ofVoid(Arrays.copyOf(layouts, layouts.length));
        Object object = $this$getDowncallVoid;
        if (object == null || (object = ForeignFunctionInterfaceKt.getAddress((SymbolLookup)object, name)) == null) {
            return null;
        }
        return linker.downcallHandle((MemorySegment)object, descriptor2, new Linker.Option[0]);
    }

    @NotNull
    public static final Arena getGlobalArena() {
        Arena arena = Arena.global();
        Intrinsics.checkNotNullExpressionValue(arena, "global(...)");
        return arena;
    }

    @NotNull
    public static final Linker getNativeLinker() {
        Linker linker = Linker.nativeLinker();
        Intrinsics.checkNotNullExpressionValue(linker, "nativeLinker(...)");
        return linker;
    }

    @NotNull
    public static final StructLayout getCapturedStateLayout() {
        return capturedStateLayout;
    }

    @NotNull
    public static final MemorySegment getCapturedStateSegment() {
        MemorySegment memorySegment = tlsCSS.get();
        Intrinsics.checkNotNullExpressionValue(memorySegment, "get(...)");
        return memorySegment;
    }

    public static final long getFirstNull2Offset(@NotNull MemorySegment $this$getFirstNull2Offset) {
        Intrinsics.checkNotNullParameter($this$getFirstNull2Offset, "<this>");
        for (long offset = 0L; offset < $this$getFirstNull2Offset.byteSize(); offset += (long)2) {
            if ($this$getFirstNull2Offset.get(ValueLayout.JAVA_SHORT, offset) != 0) continue;
            return offset;
        }
        return -1L;
    }

    private static final String getLookup$lambda$0(String $library) {
        return "Getting the library lookup for \"" + $library + "\"";
    }

    private static final String getLookup$lambda$1$0(String $library) {
        return "Library lookup for \"" + $library + "\" created";
    }

    private static final String getLookup$lambda$2(String $library) {
        return "Library \"" + $library + "\" was not located.";
    }

    private static final String getAddress$lambda$0(String $name) {
        return "Getting the address for \"" + $name + "\"";
    }

    private static final String getAddress$lambda$1(String $name) {
        return "\"" + $name + "\" was not located.";
    }

    private static final String getAddress$lambda$2(String $name, MemorySegment $address) {
        return "\"" + $name + "\" was located at the address " + ForeignFunctionInterfaceKt.debugString($address);
    }

    private static final MemorySegment tlsCSS$lambda$0() {
        return ForeignFunctionInterfaceKt.getGlobalArena().allocate(capturedStateLayout);
    }

    static {
        StructLayout structLayout = Linker.Option.captureStateLayout();
        Intrinsics.checkNotNullExpressionValue(structLayout, "captureStateLayout(...)");
        capturedStateLayout = structLayout;
        tlsCSS = ThreadLocal.withInitial(ForeignFunctionInterfaceKt::tlsCSS$lambda$0);
    }
}

