/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.ffi.windows;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.ffi.ForeignFunctionInterfaceKt;
import org.bread_experts_group.ffi.windows.WindowsKernelHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsTokenInformationClass;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\u001a\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f\"\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0013\u0010\r\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0005\"\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0005\"\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0005\"\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0005\"\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0005\"\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0005\"\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0005\"\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0005\u00a8\u0006\u001d"}, d2={"advapi32Lookup", "Ljava/lang/foreign/SymbolLookup;", "nativeGetTokenInformation", "Ljava/lang/invoke/MethodHandle;", "getNativeGetTokenInformation", "()Ljava/lang/invoke/MethodHandle;", "getTokenInformation", "Ljava/lang/foreign/MemorySegment;", "arena", "Ljava/lang/foreign/Arena;", "token", "infoClass", "Lorg/bread_experts_group/ffi/windows/WindowsTokenInformationClass;", "nativeLookupAccountSidW", "getNativeLookupAccountSidW", "nativeFileEncryptionStatusW", "getNativeFileEncryptionStatusW", "nativeOpenEncryptedFileRawW", "getNativeOpenEncryptedFileRawW", "nativeReadEncryptedFileRaw", "getNativeReadEncryptedFileRaw", "nativeEncryptFileW", "getNativeEncryptFileW", "nativeDecryptFileW", "getNativeDecryptFileW", "nativeEncryptionDisable", "getNativeEncryptionDisable", "nativeCloseEncryptedFileRaw", "getNativeCloseEncryptedFileRaw", "bread_server_lib"})
public final class WindowsAdvAPIHandlesKt {
    @Nullable
    private static final SymbolLookup advapi32Lookup = ForeignFunctionInterfaceKt.getLookup(ForeignFunctionInterfaceKt.getGlobalArena(), "Advapi32.dll");
    @Nullable
    private static final MethodHandle nativeGetTokenInformation;
    @Nullable
    private static final MethodHandle nativeLookupAccountSidW;
    @Nullable
    private static final MethodHandle nativeFileEncryptionStatusW;
    @Nullable
    private static final MethodHandle nativeOpenEncryptedFileRawW;
    @Nullable
    private static final MethodHandle nativeReadEncryptedFileRaw;
    @Nullable
    private static final MethodHandle nativeEncryptFileW;
    @Nullable
    private static final MethodHandle nativeDecryptFileW;
    @Nullable
    private static final MethodHandle nativeEncryptionDisable;
    @Nullable
    private static final MethodHandle nativeCloseEncryptedFileRaw;

    @Nullable
    public static final MethodHandle getNativeGetTokenInformation() {
        return nativeGetTokenInformation;
    }

    @NotNull
    public static final MemorySegment getTokenInformation(@NotNull Arena arena, @NotNull MemorySegment token, @NotNull WindowsTokenInformationClass infoClass) {
        Intrinsics.checkNotNullParameter(arena, "arena");
        Intrinsics.checkNotNullParameter(token, "token");
        Intrinsics.checkNotNullParameter(infoClass, "infoClass");
        MethodHandle methodHandle = nativeGetTokenInformation;
        Intrinsics.checkNotNull(methodHandle);
        methodHandle.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), token, infoClass.getId-pVg5ArA(), MemorySegment.NULL, 0, WindowsUtilitiesKt.getThreadLocalDWORD0());
        MemorySegment data = arena.allocate(WindowsUtilitiesKt.getThreadLocalDWORD0().get(WindowsUtilitiesKt.getDWORD(), 0L));
        int status = nativeGetTokenInformation.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), token, infoClass.getId-pVg5ArA(), data, (int)data.byteSize(), WindowsUtilitiesKt.getThreadLocalDWORD0());
        if (status == 0) {
            WindowsUtilitiesKt.throwLastError();
            throw new KotlinNothingValueException();
        }
        Intrinsics.checkNotNull(data);
        return data;
    }

    @Nullable
    public static final MethodHandle getNativeLookupAccountSidW() {
        return nativeLookupAccountSidW;
    }

    @Nullable
    public static final MethodHandle getNativeFileEncryptionStatusW() {
        return nativeFileEncryptionStatusW;
    }

    @Nullable
    public static final MethodHandle getNativeOpenEncryptedFileRawW() {
        return nativeOpenEncryptedFileRawW;
    }

    @Nullable
    public static final MethodHandle getNativeReadEncryptedFileRaw() {
        return nativeReadEncryptedFileRaw;
    }

    @Nullable
    public static final MethodHandle getNativeEncryptFileW() {
        return nativeEncryptFileW;
    }

    @Nullable
    public static final MethodHandle getNativeDecryptFileW() {
        return nativeDecryptFileW;
    }

    @Nullable
    public static final MethodHandle getNativeEncryptionDisable() {
        return nativeEncryptionDisable;
    }

    @Nullable
    public static final MethodHandle getNativeCloseEncryptedFileRaw() {
        return nativeCloseEncryptedFileRaw;
    }

    static {
        ValueLayout[] valueLayoutArray = new ValueLayout[]{WindowsUtilitiesKt.getBOOL(), WindowsUtilitiesKt.getHANDLE(), ValueLayout.JAVA_INT, WindowsUtilitiesKt.getLPVOID(), WindowsUtilitiesKt.getDWORD(), WindowsUtilitiesKt.getPDWORD()};
        nativeGetTokenInformation = ForeignFunctionInterfaceKt.getDowncall(advapi32Lookup, ForeignFunctionInterfaceKt.getNativeLinker(), "GetTokenInformation", valueLayoutArray, CollectionsKt.listOf(WindowsKernelHandlesKt.getGleCapture()));
        valueLayoutArray = new ValueLayout[]{WindowsUtilitiesKt.getBOOL(), WindowsUtilitiesKt.getLPCWSTR(), ValueLayout.ADDRESS, WindowsUtilitiesKt.getLPWSTR(), WindowsUtilitiesKt.getLPDWORD(), WindowsUtilitiesKt.getLPWSTR(), WindowsUtilitiesKt.getLPDWORD(), ValueLayout.ADDRESS};
        nativeLookupAccountSidW = ForeignFunctionInterfaceKt.getDowncall(advapi32Lookup, ForeignFunctionInterfaceKt.getNativeLinker(), "LookupAccountSidW", valueLayoutArray, CollectionsKt.listOf(WindowsKernelHandlesKt.getGleCapture()));
        valueLayoutArray = new ValueLayout[]{WindowsUtilitiesKt.getBOOL(), WindowsUtilitiesKt.getLPCWSTR(), WindowsUtilitiesKt.getLPDWORD()};
        nativeFileEncryptionStatusW = ForeignFunctionInterfaceKt.getDowncall(advapi32Lookup, ForeignFunctionInterfaceKt.getNativeLinker(), "FileEncryptionStatusW", valueLayoutArray, CollectionsKt.listOf(WindowsKernelHandlesKt.getGleCapture()));
        valueLayoutArray = new ValueLayout[]{WindowsUtilitiesKt.getDWORD(), WindowsUtilitiesKt.getLPCWSTR(), WindowsUtilitiesKt.getULONG(), WindowsUtilitiesKt.getPVOID()};
        nativeOpenEncryptedFileRawW = ForeignFunctionInterfaceKt.getDowncall(advapi32Lookup, ForeignFunctionInterfaceKt.getNativeLinker(), "OpenEncryptedFileRawW", valueLayoutArray, CollectionsKt.emptyList());
        valueLayoutArray = new ValueLayout[]{WindowsUtilitiesKt.getDWORD(), ValueLayout.ADDRESS, WindowsUtilitiesKt.getPVOID(), WindowsUtilitiesKt.getPVOID()};
        nativeReadEncryptedFileRaw = ForeignFunctionInterfaceKt.getDowncall(advapi32Lookup, ForeignFunctionInterfaceKt.getNativeLinker(), "ReadEncryptedFileRaw", valueLayoutArray, CollectionsKt.emptyList());
        valueLayoutArray = new ValueLayout[]{WindowsUtilitiesKt.getBOOL(), WindowsUtilitiesKt.getLPCWSTR()};
        nativeEncryptFileW = ForeignFunctionInterfaceKt.getDowncall(advapi32Lookup, ForeignFunctionInterfaceKt.getNativeLinker(), "EncryptFileW", valueLayoutArray, CollectionsKt.listOf(WindowsKernelHandlesKt.getGleCapture()));
        valueLayoutArray = new ValueLayout[]{WindowsUtilitiesKt.getBOOL(), WindowsUtilitiesKt.getLPCWSTR(), WindowsUtilitiesKt.getDWORD()};
        nativeDecryptFileW = ForeignFunctionInterfaceKt.getDowncall(advapi32Lookup, ForeignFunctionInterfaceKt.getNativeLinker(), "DecryptFileW", valueLayoutArray, CollectionsKt.listOf(WindowsKernelHandlesKt.getGleCapture()));
        valueLayoutArray = new ValueLayout[]{WindowsUtilitiesKt.getBOOL(), WindowsUtilitiesKt.getLPCWSTR(), WindowsUtilitiesKt.getBOOL()};
        nativeEncryptionDisable = ForeignFunctionInterfaceKt.getDowncall(advapi32Lookup, ForeignFunctionInterfaceKt.getNativeLinker(), "EncryptionDisable", valueLayoutArray, CollectionsKt.listOf(WindowsKernelHandlesKt.getGleCapture()));
        valueLayoutArray = new ValueLayout[]{WindowsUtilitiesKt.getPVOID()};
        nativeCloseEncryptedFileRaw = ForeignFunctionInterfaceKt.getDowncallVoid(advapi32Lookup, ForeignFunctionInterfaceKt.getNativeLinker(), "CloseEncryptedFileRaw", valueLayoutArray);
    }
}

