/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.ffi.windows;

import java.lang.foreign.AddressLayout;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.ffi.ForeignFunctionInterfaceKt;
import org.bread_experts_group.ffi.windows.WindowsKernelHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\"\u0013\u0010\n\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\"\u0013\u0010\f\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006\u000e"}, d2={"HDC", "Ljava/lang/foreign/AddressLayout;", "getHDC", "()Ljava/lang/foreign/AddressLayout;", "gdi32Lookup", "Ljava/lang/foreign/SymbolLookup;", "nativeSetPixelFormat", "Ljava/lang/invoke/MethodHandle;", "getNativeSetPixelFormat", "()Ljava/lang/invoke/MethodHandle;", "nativeChoosePixelFormat", "getNativeChoosePixelFormat", "nativeSwapBuffers", "getNativeSwapBuffers", "bread_server_lib"})
public final class WindowsGDIHandlesKt {
    @NotNull
    private static final AddressLayout HDC;
    @Nullable
    private static final SymbolLookup gdi32Lookup;
    @Nullable
    private static final MethodHandle nativeSetPixelFormat;
    @Nullable
    private static final MethodHandle nativeChoosePixelFormat;
    @Nullable
    private static final MethodHandle nativeSwapBuffers;

    @NotNull
    public static final AddressLayout getHDC() {
        return HDC;
    }

    @Nullable
    public static final MethodHandle getNativeSetPixelFormat() {
        return nativeSetPixelFormat;
    }

    @Nullable
    public static final MethodHandle getNativeChoosePixelFormat() {
        return nativeChoosePixelFormat;
    }

    @Nullable
    public static final MethodHandle getNativeSwapBuffers() {
        return nativeSwapBuffers;
    }

    static {
        AddressLayout addressLayout = ValueLayout.ADDRESS;
        Intrinsics.checkNotNullExpressionValue(addressLayout, "ADDRESS");
        HDC = addressLayout;
        gdi32Lookup = ForeignFunctionInterfaceKt.getLookup(ForeignFunctionInterfaceKt.getGlobalArena(), "Gdi32.dll");
        ValueLayout[] valueLayoutArray = new ValueLayout[]{WindowsUtilitiesKt.getBOOL(), HDC, ValueLayout.JAVA_INT, ValueLayout.ADDRESS};
        nativeSetPixelFormat = ForeignFunctionInterfaceKt.getDowncall(gdi32Lookup, ForeignFunctionInterfaceKt.getNativeLinker(), "SetPixelFormat", valueLayoutArray, CollectionsKt.listOf(WindowsKernelHandlesKt.getGleCapture()));
        valueLayoutArray = new ValueLayout[]{ValueLayout.JAVA_INT, HDC, ValueLayout.ADDRESS};
        nativeChoosePixelFormat = ForeignFunctionInterfaceKt.getDowncall(gdi32Lookup, ForeignFunctionInterfaceKt.getNativeLinker(), "ChoosePixelFormat", valueLayoutArray, CollectionsKt.listOf(WindowsKernelHandlesKt.getGleCapture()));
        valueLayoutArray = new ValueLayout[]{WindowsUtilitiesKt.getBOOL(), HDC};
        nativeSwapBuffers = ForeignFunctionInterfaceKt.getDowncall(gdi32Lookup, ForeignFunctionInterfaceKt.getNativeLinker(), "SwapBuffers", valueLayoutArray);
    }
}

