/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.ffi.windows;

import java.lang.foreign.AddressLayout;
import java.lang.foreign.Linker;
import java.lang.foreign.StructLayout;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.ffi.ForeignFunctionInterfaceKt;
import org.bread_experts_group.ffi.windows.WindowsLayoutsKt;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\"\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"IID", "Ljava/lang/foreign/StructLayout;", "getIID", "()Ljava/lang/foreign/StructLayout;", "REFIID", "Ljava/lang/foreign/AddressLayout;", "getREFIID", "()Ljava/lang/foreign/AddressLayout;", "REFCLSID", "getREFCLSID", "ole32Lookup", "Ljava/lang/foreign/SymbolLookup;", "nativeCoCreateGuid", "Ljava/lang/invoke/MethodHandle;", "getNativeCoCreateGuid", "()Ljava/lang/invoke/MethodHandle;", "bread_server_lib"})
public final class WindowsOLEHandlesKt {
    @NotNull
    private static final StructLayout IID = WindowsLayoutsKt.getGUID();
    @NotNull
    private static final AddressLayout REFIID;
    @NotNull
    private static final AddressLayout REFCLSID;
    @Nullable
    private static final SymbolLookup ole32Lookup;
    @Nullable
    private static final MethodHandle nativeCoCreateGuid;

    @NotNull
    public static final StructLayout getIID() {
        return IID;
    }

    @NotNull
    public static final AddressLayout getREFIID() {
        return REFIID;
    }

    @NotNull
    public static final AddressLayout getREFCLSID() {
        return REFCLSID;
    }

    @Nullable
    public static final MethodHandle getNativeCoCreateGuid() {
        return nativeCoCreateGuid;
    }

    static {
        AddressLayout addressLayout = ValueLayout.ADDRESS;
        Intrinsics.checkNotNullExpressionValue(addressLayout, "ADDRESS");
        REFCLSID = REFIID = addressLayout;
        ole32Lookup = ForeignFunctionInterfaceKt.getLookup(ForeignFunctionInterfaceKt.getGlobalArena(), "Ole32.dll");
        Linker linker = ForeignFunctionInterfaceKt.getNativeLinker();
        ValueLayout[] valueLayoutArray = new ValueLayout[2];
        valueLayoutArray[0] = WindowsUtilitiesKt.getHRESULT();
        Intrinsics.checkNotNullExpressionValue(ValueLayout.ADDRESS, "ADDRESS");
        nativeCoCreateGuid = ForeignFunctionInterfaceKt.getDowncall(ole32Lookup, linker, "CoCreateGuid", valueLayoutArray);
    }
}

