/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.ffi.windows;

import java.lang.foreign.AddressLayout;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.ffi.ForeignFunctionInterfaceKt;
import org.bread_experts_group.ffi.windows.WindowsGDIHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsKernelHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\"\u0013\u0010\n\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\"\u0013\u0010\f\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\"\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\t\u00a8\u0006\u0010"}, d2={"HGLRC", "Ljava/lang/foreign/AddressLayout;", "getHGLRC", "()Ljava/lang/foreign/AddressLayout;", "opengl32Lookup", "Ljava/lang/foreign/SymbolLookup;", "nativeWGLCreateContext", "Ljava/lang/invoke/MethodHandle;", "getNativeWGLCreateContext", "()Ljava/lang/invoke/MethodHandle;", "nativeWGLDeleteContext", "getNativeWGLDeleteContext", "nativeWGLMakeCurrent", "getNativeWGLMakeCurrent", "nativeWGLGetProcAddress", "getNativeWGLGetProcAddress", "bread_server_lib"})
public final class WindowsOpenGLHandlesKt {
    @NotNull
    private static final AddressLayout HGLRC;
    @Nullable
    private static final SymbolLookup opengl32Lookup;
    @Nullable
    private static final MethodHandle nativeWGLCreateContext;
    @Nullable
    private static final MethodHandle nativeWGLDeleteContext;
    @Nullable
    private static final MethodHandle nativeWGLMakeCurrent;
    @Nullable
    private static final MethodHandle nativeWGLGetProcAddress;

    @NotNull
    public static final AddressLayout getHGLRC() {
        return HGLRC;
    }

    @Nullable
    public static final MethodHandle getNativeWGLCreateContext() {
        return nativeWGLCreateContext;
    }

    @Nullable
    public static final MethodHandle getNativeWGLDeleteContext() {
        return nativeWGLDeleteContext;
    }

    @Nullable
    public static final MethodHandle getNativeWGLMakeCurrent() {
        return nativeWGLMakeCurrent;
    }

    @Nullable
    public static final MethodHandle getNativeWGLGetProcAddress() {
        return nativeWGLGetProcAddress;
    }

    static {
        AddressLayout addressLayout = ValueLayout.ADDRESS;
        Intrinsics.checkNotNullExpressionValue(addressLayout, "ADDRESS");
        HGLRC = addressLayout;
        opengl32Lookup = ForeignFunctionInterfaceKt.getLookup(ForeignFunctionInterfaceKt.getGlobalArena(), "OpenGL32.dll");
        ValueLayout[] valueLayoutArray = new AddressLayout[]{HGLRC, WindowsGDIHandlesKt.getHDC()};
        nativeWGLCreateContext = ForeignFunctionInterfaceKt.getDowncall(opengl32Lookup, ForeignFunctionInterfaceKt.getNativeLinker(), "wglCreateContext", valueLayoutArray, CollectionsKt.listOf(WindowsKernelHandlesKt.getGleCapture()));
        valueLayoutArray = new ValueLayout[]{WindowsUtilitiesKt.getBOOL(), HGLRC};
        nativeWGLDeleteContext = ForeignFunctionInterfaceKt.getDowncall(opengl32Lookup, ForeignFunctionInterfaceKt.getNativeLinker(), "wglDeleteContext", valueLayoutArray);
        valueLayoutArray = new ValueLayout[]{WindowsUtilitiesKt.getBOOL(), WindowsGDIHandlesKt.getHDC(), HGLRC};
        nativeWGLMakeCurrent = ForeignFunctionInterfaceKt.getDowncall(opengl32Lookup, ForeignFunctionInterfaceKt.getNativeLinker(), "wglMakeCurrent", valueLayoutArray, CollectionsKt.listOf(WindowsKernelHandlesKt.getGleCapture()));
        valueLayoutArray = new AddressLayout[]{WindowsUtilitiesKt.getPROC(), WindowsUtilitiesKt.getLPCSTR()};
        nativeWGLGetProcAddress = ForeignFunctionInterfaceKt.getDowncall(opengl32Lookup, ForeignFunctionInterfaceKt.getNativeLinker(), "wglGetProcAddress", valueLayoutArray, CollectionsKt.listOf(WindowsKernelHandlesKt.getGleCapture()));
    }
}

