/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.ffi.windows;

import java.lang.foreign.AddressLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.UInt;
import kotlin.enums.EnumEntries;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.bread_experts_group.Mappable;
import org.bread_experts_group.MappedEnumeration;
import org.bread_experts_group.ffi.ForeignFunctionInterfaceKt;
import org.bread_experts_group.ffi.OperatingSystemException;
import org.bread_experts_group.ffi.exception.IOAbortedException;
import org.bread_experts_group.ffi.windows.WindowsKernelHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsLastErrorException;
import org.bread_experts_group.ffi.windows.WindowsLayoutsKt;
import org.bread_experts_group.ffi.windows.WindowsNTSTATUSException;
import org.bread_experts_group.ffi.windows.WindowsNTStatus;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\bI\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0002\u001a\u0011\u0010\u007f\u001a\u00030\u0080\u00012\b\u0010\u0081\u0001\u001a\u00030\u0082\u0001\u001a\b\u0010\u0088\u0001\u001a\u00030\u0089\u0001\u001a\b\u0010\u008a\u0001\u001a\u00030\u0089\u0001\u001a\u0017\u0010\u008b\u0001\u001a\u00030\u0080\u0001*\u00030\u008c\u00012\b\u0010\u008d\u0001\u001a\u00030\u008e\u0001\u001a!\u0010\u008b\u0001\u001a\u00030\u0080\u0001*\u00030\u008c\u00012\b\u0010\u008d\u0001\u001a\u00030\u008e\u00012\b\u0010\u008f\u0001\u001a\u00030\u008e\u0001\u001a5\u0010\u008b\u0001\u001a\u00030\u0080\u0001*\u00030\u008c\u00012\b\u0010\u008d\u0001\u001a\u00030\u008e\u00012\b\u0010\u008f\u0001\u001a\u00030\u008e\u00012\b\u0010\u0090\u0001\u001a\u00030\u008e\u00012\b\u0010\u0091\u0001\u001a\u00030\u008e\u0001\u001a?\u0010\u008b\u0001\u001a\u00030\u0080\u0001*\u00030\u008c\u00012\b\u0010\u008d\u0001\u001a\u00030\u008e\u00012\b\u0010\u008f\u0001\u001a\u00030\u008e\u00012\b\u0010\u0090\u0001\u001a\u00030\u008e\u00012\b\u0010\u0091\u0001\u001a\u00030\u008e\u00012\b\u0010\u0092\u0001\u001a\u00030\u008e\u0001\u001aI\u0010\u008b\u0001\u001a\u00030\u0080\u0001*\u00030\u008c\u00012\b\u0010\u008d\u0001\u001a\u00030\u008e\u00012\b\u0010\u008f\u0001\u001a\u00030\u008e\u00012\b\u0010\u0090\u0001\u001a\u00030\u008e\u00012\b\u0010\u0091\u0001\u001a\u00030\u008e\u00012\b\u0010\u0092\u0001\u001a\u00030\u008e\u00012\b\u0010\u0093\u0001\u001a\u00030\u008e\u0001\u001aS\u0010\u008b\u0001\u001a\u00030\u0080\u0001*\u00030\u008c\u00012\b\u0010\u008d\u0001\u001a\u00030\u008e\u00012\b\u0010\u008f\u0001\u001a\u00030\u008e\u00012\b\u0010\u0090\u0001\u001a\u00030\u008e\u00012\b\u0010\u0091\u0001\u001a\u00030\u008e\u00012\b\u0010\u0092\u0001\u001a\u00030\u008e\u00012\b\u0010\u0093\u0001\u001a\u00030\u008e\u00012\b\u0010\u0094\u0001\u001a\u00030\u008e\u0001\u001a]\u0010\u008b\u0001\u001a\u00030\u0080\u0001*\u00030\u008c\u00012\b\u0010\u008d\u0001\u001a\u00030\u008e\u00012\b\u0010\u008f\u0001\u001a\u00030\u008e\u00012\b\u0010\u0090\u0001\u001a\u00030\u008e\u00012\b\u0010\u0091\u0001\u001a\u00030\u008e\u00012\b\u0010\u0092\u0001\u001a\u00030\u008e\u00012\b\u0010\u0093\u0001\u001a\u00030\u008e\u00012\b\u0010\u0094\u0001\u001a\u00030\u008e\u00012\b\u0010\u0095\u0001\u001a\u00030\u008e\u0001\u001a\u000f\u0010\u0096\u0001\u001a\u00030\u0080\u0001*\u00030\u0082\u0001H\u0002\u001a\u0012\u0010\u0097\u0001\u001a\u00030\u0098\u00012\b\u0010\u0099\u0001\u001a\u00030\u0098\u0001\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\"\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\"\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0011\u0010\u0014\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000f\"\u0011\u0010\u0016\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000f\"\u0011\u0010\u0018\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000f\"\u0011\u0010\u001a\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013\"\u0011\u0010\u001c\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0013\"\u0011\u0010\u001e\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0013\"\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\"\u0011\u0010$\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\t\"\u0011\u0010&\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u000f\"\u0011\u0010(\u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010#\"\u0011\u0010*\u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010#\"\u0011\u0010,\u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010#\"\u0011\u0010.\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u000f\"\u0011\u00100\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\t\"\u0011\u00102\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\t\"\u0011\u00104\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u0003\"\u0011\u00106\u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010#\"\u0011\u00108\u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010#\"\u0011\u0010:\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010\u0013\"\u0011\u0010<\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010\u0013\"\u0011\u0010>\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010\u0013\"\u0011\u0010@\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010\u0013\"\u0011\u0010B\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010\u0013\"\u0011\u0010D\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010\u0013\"\u0011\u0010F\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010\u0013\"\u0011\u0010H\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010\u0013\"\u0011\u0010J\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010\u0013\"\u0011\u0010L\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010\u0013\"\u0011\u0010N\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010\u0013\"\u0011\u0010P\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\bQ\u0010\u0013\"\u0011\u0010R\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\bS\u0010\u0013\"\u0011\u0010T\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010\u0013\"\u0011\u0010V\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\bW\u0010\u0013\"\u0011\u0010X\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\bY\u0010\u0013\"\u0011\u0010Z\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b[\u0010\u0013\"\u0011\u0010\\\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b]\u0010\u0013\"\u0011\u0010^\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b_\u0010\u0013\"\u0011\u0010`\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\ba\u0010\u0013\"\u0011\u0010b\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\bc\u0010\u0013\"\u0011\u0010d\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\be\u0010\u0013\"\u0011\u0010f\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\bg\u0010\u0013\"\u0011\u0010h\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\bi\u0010\u000f\"\u0011\u0010j\u001a\u00020k\u00a2\u0006\b\n\u0000\u001a\u0004\bl\u0010m\"2\u0010n\u001a&\u0012\f\u0012\n p*\u0004\u0018\u00010k0k p*\u0012\u0012\f\u0012\n p*\u0004\u0018\u00010k0k\u0018\u00010o0oX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"2\u0010q\u001a&\u0012\f\u0012\n p*\u0004\u0018\u00010k0k p*\u0012\u0012\f\u0012\n p*\u0004\u0018\u00010k0k\u0018\u00010o0oX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"2\u0010r\u001a&\u0012\f\u0012\n p*\u0004\u0018\u00010k0k p*\u0012\u0012\f\u0012\n p*\u0004\u0018\u00010k0k\u0018\u00010o0oX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"2\u0010s\u001a&\u0012\f\u0012\n p*\u0004\u0018\u00010k0k p*\u0012\u0012\f\u0012\n p*\u0004\u0018\u00010k0k\u0018\u00010o0oX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"2\u0010t\u001a&\u0012\f\u0012\n p*\u0004\u0018\u00010k0k p*\u0012\u0012\f\u0012\n p*\u0004\u0018\u00010k0k\u0018\u00010o0oX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010u\u001a\u00020k8F\u00a2\u0006\u0006\u001a\u0004\bv\u0010m\"\u0011\u0010w\u001a\u00020k8F\u00a2\u0006\u0006\u001a\u0004\bx\u0010m\"\u0011\u0010y\u001a\u00020k8F\u00a2\u0006\u0006\u001a\u0004\bz\u0010m\"\u0011\u0010{\u001a\u00020k8F\u00a2\u0006\u0006\u001a\u0004\b|\u0010m\"\u0011\u0010}\u001a\u00020k8F\u00a2\u0006\u0006\u001a\u0004\b~\u0010m\"\u0015\u0010\u0083\u0001\u001a\u00030\u0082\u00018F\u00a2\u0006\b\u001a\u0006\b\u0084\u0001\u0010\u0085\u0001\"\u0015\u0010\u0086\u0001\u001a\u00030\u0082\u00018F\u00a2\u0006\b\u001a\u0006\b\u0087\u0001\u0010\u0085\u0001\u00a8\u0006\u009a\u0001"}, d2={"char", "Ljava/lang/foreign/ValueLayout$OfByte;", "getChar", "()Ljava/lang/foreign/ValueLayout$OfByte;", "BYTE", "getBYTE", "WORD", "Ljava/lang/foreign/ValueLayout$OfShort;", "getWORD", "()Ljava/lang/foreign/ValueLayout$OfShort;", "ATOM", "getATOM", "DWORD", "Ljava/lang/foreign/ValueLayout$OfInt;", "getDWORD", "()Ljava/lang/foreign/ValueLayout$OfInt;", "PDWORD", "Ljava/lang/foreign/AddressLayout;", "getPDWORD", "()Ljava/lang/foreign/AddressLayout;", "BOOL", "getBOOL", "LONG", "getLONG", "ULONG", "getULONG", "ULONG_PTR", "getULONG_PTR", "PULONG", "getPULONG", "PBYTE", "getPBYTE", "ULONGLONG", "Ljava/lang/foreign/ValueLayout$OfLong;", "getULONGLONG", "()Ljava/lang/foreign/ValueLayout$OfLong;", "USHORT", "getUSHORT", "HRESULT", "getHRESULT", "LONG_PTR", "getLONG_PTR", "UINT_PTR", "getUINT_PTR", "LRESULT", "getLRESULT", "UINT", "getUINT", "SHORT", "getSHORT", "WCHAR", "getWCHAR", "CHAR", "getCHAR", "WPARAM", "getWPARAM", "LPARAM", "getLPARAM", "PWSTR", "getPWSTR", "LPDWORD", "getLPDWORD", "LPINT", "getLPINT", "LPWSTR", "getLPWSTR", "LPCWSTR", "getLPCWSTR", "LPCSTR", "getLPCSTR", "LPCVOID", "getLPCVOID", "LPVOID", "getLPVOID", "PVOID", "getPVOID", "HANDLE", "getHANDLE", "HLOCAL", "getHLOCAL", "HMENU", "getHMENU", "HINSTANCE", "getHINSTANCE", "HRGN", "getHRGN", "HWND", "getHWND", "HMODULE", "getHMODULE", "HWINSTA", "getHWINSTA", "HDESK", "getHDESK", "HICON", "getHICON", "HCURSOR", "getHCURSOR", "HBRUSH", "getHBRUSH", "FARPROC", "getFARPROC", "PROC", "getPROC", "ACCESS_MASK", "getACCESS_MASK", "INVALID_HANDLE_VALUE", "Ljava/lang/foreign/MemorySegment;", "getINVALID_HANDLE_VALUE", "()Ljava/lang/foreign/MemorySegment;", "tlsDWORD0", "Ljava/lang/ThreadLocal;", "kotlin.jvm.PlatformType", "tlsDWORD1", "tlsDWORD2", "tlsLARGE_INTEGER0", "tlsPTR", "threadLocalDWORD0", "getThreadLocalDWORD0", "threadLocalDWORD1", "getThreadLocalDWORD1", "threadLocalDWORD2", "getThreadLocalDWORD2", "threadLocalLARGE_INTEGER0", "getThreadLocalLARGE_INTEGER0", "threadLocalPTR", "getThreadLocalPTR", "decodeWin32Error", "", "err", "", "win32LastError", "getWin32LastError", "()I", "wsaLastError", "getWsaLastError", "throwLastError", "", "throwLastWSAError", "returnsNTSTATUS", "Ljava/lang/invoke/MethodHandle;", "p0", "", "p1", "p2", "p3", "p4", "p5", "p6", "p7", "decodeNTSTATUS", "FILETIMEToUnixMs", "", "fileTime", "bread_server_lib"})
@SourceDebugExtension(value={"SMAP\nWindowsUtilities.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsUtilities.kt\norg/bread_experts_group/ffi/windows/WindowsUtilitiesKt\n+ 2 Mappable.kt\norg/bread_experts_group/Mappable$Companion\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,169:1\n14#2,2:170\n16#2:173\n18#2,2:175\n295#3:172\n296#3:174\n*S KotlinDebug\n*F\n+ 1 WindowsUtilities.kt\norg/bread_experts_group/ffi/windows/WindowsUtilitiesKt\n*L\n164#1:170,2\n164#1:173\n164#1:175,2\n164#1:172\n164#1:174\n*E\n"})
public final class WindowsUtilitiesKt {
    @NotNull
    private static final ValueLayout.OfByte char;
    @NotNull
    private static final ValueLayout.OfByte BYTE;
    @NotNull
    private static final ValueLayout.OfShort WORD;
    @NotNull
    private static final ValueLayout.OfShort ATOM;
    @NotNull
    private static final ValueLayout.OfInt DWORD;
    @NotNull
    private static final AddressLayout PDWORD;
    @NotNull
    private static final ValueLayout.OfInt BOOL;
    @NotNull
    private static final ValueLayout.OfInt LONG;
    @NotNull
    private static final ValueLayout.OfInt ULONG;
    @NotNull
    private static final AddressLayout ULONG_PTR;
    @NotNull
    private static final AddressLayout PULONG;
    @NotNull
    private static final AddressLayout PBYTE;
    @NotNull
    private static final ValueLayout.OfLong ULONGLONG;
    @NotNull
    private static final ValueLayout.OfShort USHORT;
    @NotNull
    private static final ValueLayout.OfInt HRESULT;
    @NotNull
    private static final ValueLayout.OfLong LONG_PTR;
    @NotNull
    private static final ValueLayout.OfLong UINT_PTR;
    @NotNull
    private static final ValueLayout.OfLong LRESULT;
    @NotNull
    private static final ValueLayout.OfInt UINT;
    @NotNull
    private static final ValueLayout.OfShort SHORT;
    @NotNull
    private static final ValueLayout.OfShort WCHAR;
    @NotNull
    private static final ValueLayout.OfByte CHAR;
    @NotNull
    private static final ValueLayout.OfLong WPARAM;
    @NotNull
    private static final ValueLayout.OfLong LPARAM;
    @NotNull
    private static final AddressLayout PWSTR;
    @NotNull
    private static final AddressLayout LPDWORD;
    @NotNull
    private static final AddressLayout LPINT;
    @NotNull
    private static final AddressLayout LPWSTR;
    @NotNull
    private static final AddressLayout LPCWSTR;
    @NotNull
    private static final AddressLayout LPCSTR;
    @NotNull
    private static final AddressLayout LPCVOID;
    @NotNull
    private static final AddressLayout LPVOID;
    @NotNull
    private static final AddressLayout PVOID;
    @NotNull
    private static final AddressLayout HANDLE;
    @NotNull
    private static final AddressLayout HLOCAL;
    @NotNull
    private static final AddressLayout HMENU;
    @NotNull
    private static final AddressLayout HINSTANCE;
    @NotNull
    private static final AddressLayout HRGN;
    @NotNull
    private static final AddressLayout HWND;
    @NotNull
    private static final AddressLayout HMODULE;
    @NotNull
    private static final AddressLayout HWINSTA;
    @NotNull
    private static final AddressLayout HDESK;
    @NotNull
    private static final AddressLayout HICON;
    @NotNull
    private static final AddressLayout HCURSOR;
    @NotNull
    private static final AddressLayout HBRUSH;
    @NotNull
    private static final AddressLayout FARPROC;
    @NotNull
    private static final AddressLayout PROC;
    @NotNull
    private static final ValueLayout.OfInt ACCESS_MASK;
    @NotNull
    private static final MemorySegment INVALID_HANDLE_VALUE;
    private static final ThreadLocal<MemorySegment> tlsDWORD0;
    private static final ThreadLocal<MemorySegment> tlsDWORD1;
    private static final ThreadLocal<MemorySegment> tlsDWORD2;
    private static final ThreadLocal<MemorySegment> tlsLARGE_INTEGER0;
    private static final ThreadLocal<MemorySegment> tlsPTR;

    @NotNull
    public static final ValueLayout.OfByte getChar() {
        return char;
    }

    @NotNull
    public static final ValueLayout.OfByte getBYTE() {
        return BYTE;
    }

    @NotNull
    public static final ValueLayout.OfShort getWORD() {
        return WORD;
    }

    @NotNull
    public static final ValueLayout.OfShort getATOM() {
        return ATOM;
    }

    @NotNull
    public static final ValueLayout.OfInt getDWORD() {
        return DWORD;
    }

    @NotNull
    public static final AddressLayout getPDWORD() {
        return PDWORD;
    }

    @NotNull
    public static final ValueLayout.OfInt getBOOL() {
        return BOOL;
    }

    @NotNull
    public static final ValueLayout.OfInt getLONG() {
        return LONG;
    }

    @NotNull
    public static final ValueLayout.OfInt getULONG() {
        return ULONG;
    }

    @NotNull
    public static final AddressLayout getULONG_PTR() {
        return ULONG_PTR;
    }

    @NotNull
    public static final AddressLayout getPULONG() {
        return PULONG;
    }

    @NotNull
    public static final AddressLayout getPBYTE() {
        return PBYTE;
    }

    @NotNull
    public static final ValueLayout.OfLong getULONGLONG() {
        return ULONGLONG;
    }

    @NotNull
    public static final ValueLayout.OfShort getUSHORT() {
        return USHORT;
    }

    @NotNull
    public static final ValueLayout.OfInt getHRESULT() {
        return HRESULT;
    }

    @NotNull
    public static final ValueLayout.OfLong getLONG_PTR() {
        return LONG_PTR;
    }

    @NotNull
    public static final ValueLayout.OfLong getUINT_PTR() {
        return UINT_PTR;
    }

    @NotNull
    public static final ValueLayout.OfLong getLRESULT() {
        return LRESULT;
    }

    @NotNull
    public static final ValueLayout.OfInt getUINT() {
        return UINT;
    }

    @NotNull
    public static final ValueLayout.OfShort getSHORT() {
        return SHORT;
    }

    @NotNull
    public static final ValueLayout.OfShort getWCHAR() {
        return WCHAR;
    }

    @NotNull
    public static final ValueLayout.OfByte getCHAR() {
        return CHAR;
    }

    @NotNull
    public static final ValueLayout.OfLong getWPARAM() {
        return WPARAM;
    }

    @NotNull
    public static final ValueLayout.OfLong getLPARAM() {
        return LPARAM;
    }

    @NotNull
    public static final AddressLayout getPWSTR() {
        return PWSTR;
    }

    @NotNull
    public static final AddressLayout getLPDWORD() {
        return LPDWORD;
    }

    @NotNull
    public static final AddressLayout getLPINT() {
        return LPINT;
    }

    @NotNull
    public static final AddressLayout getLPWSTR() {
        return LPWSTR;
    }

    @NotNull
    public static final AddressLayout getLPCWSTR() {
        return LPCWSTR;
    }

    @NotNull
    public static final AddressLayout getLPCSTR() {
        return LPCSTR;
    }

    @NotNull
    public static final AddressLayout getLPCVOID() {
        return LPCVOID;
    }

    @NotNull
    public static final AddressLayout getLPVOID() {
        return LPVOID;
    }

    @NotNull
    public static final AddressLayout getPVOID() {
        return PVOID;
    }

    @NotNull
    public static final AddressLayout getHANDLE() {
        return HANDLE;
    }

    @NotNull
    public static final AddressLayout getHLOCAL() {
        return HLOCAL;
    }

    @NotNull
    public static final AddressLayout getHMENU() {
        return HMENU;
    }

    @NotNull
    public static final AddressLayout getHINSTANCE() {
        return HINSTANCE;
    }

    @NotNull
    public static final AddressLayout getHRGN() {
        return HRGN;
    }

    @NotNull
    public static final AddressLayout getHWND() {
        return HWND;
    }

    @NotNull
    public static final AddressLayout getHMODULE() {
        return HMODULE;
    }

    @NotNull
    public static final AddressLayout getHWINSTA() {
        return HWINSTA;
    }

    @NotNull
    public static final AddressLayout getHDESK() {
        return HDESK;
    }

    @NotNull
    public static final AddressLayout getHICON() {
        return HICON;
    }

    @NotNull
    public static final AddressLayout getHCURSOR() {
        return HCURSOR;
    }

    @NotNull
    public static final AddressLayout getHBRUSH() {
        return HBRUSH;
    }

    @NotNull
    public static final AddressLayout getFARPROC() {
        return FARPROC;
    }

    @NotNull
    public static final AddressLayout getPROC() {
        return PROC;
    }

    @NotNull
    public static final ValueLayout.OfInt getACCESS_MASK() {
        return ACCESS_MASK;
    }

    @NotNull
    public static final MemorySegment getINVALID_HANDLE_VALUE() {
        return INVALID_HANDLE_VALUE;
    }

    @NotNull
    public static final MemorySegment getThreadLocalDWORD0() {
        MemorySegment memorySegment = tlsDWORD0.get();
        Intrinsics.checkNotNullExpressionValue(memorySegment, "get(...)");
        return memorySegment;
    }

    @NotNull
    public static final MemorySegment getThreadLocalDWORD1() {
        MemorySegment memorySegment = tlsDWORD1.get();
        Intrinsics.checkNotNullExpressionValue(memorySegment, "get(...)");
        return memorySegment;
    }

    @NotNull
    public static final MemorySegment getThreadLocalDWORD2() {
        MemorySegment memorySegment = tlsDWORD2.get();
        Intrinsics.checkNotNullExpressionValue(memorySegment, "get(...)");
        return memorySegment;
    }

    @NotNull
    public static final MemorySegment getThreadLocalLARGE_INTEGER0() {
        MemorySegment memorySegment = tlsLARGE_INTEGER0.get();
        Intrinsics.checkNotNullExpressionValue(memorySegment, "get(...)");
        return memorySegment;
    }

    @NotNull
    public static final MemorySegment getThreadLocalPTR() {
        MemorySegment memorySegment = tlsPTR.get();
        Intrinsics.checkNotNullExpressionValue(memorySegment, "get(...)");
        return memorySegment;
    }

    public static final void decodeWin32Error(int err2) {
        switch (err2) {
            case 995: {
                throw new IOAbortedException();
            }
            case 0: {
                break;
            }
            default: {
                MethodHandle methodHandle = WindowsKernelHandlesKt.getNativeFormatMessageW();
                Intrinsics.checkNotNull(methodHandle);
                int count = methodHandle.invokeExact(4352, MemorySegment.NULL, err2, 0, WindowsUtilitiesKt.getThreadLocalPTR(), 0, MemorySegment.NULL);
                if (count == 0) {
                    String string = "Formatting error on error code: " + err2;
                    throw new NotImplementedError("An operation is not implemented: " + string);
                }
                byte[] byArray = WindowsUtilitiesKt.getThreadLocalPTR().get(ValueLayout.ADDRESS, 0L).reinterpret((long)count * (long)2).toArray(ValueLayout.JAVA_BYTE);
                Intrinsics.checkNotNullExpressionValue(byArray, "toArray(...)");
                byte[] byArray2 = byArray;
                Object object = Charsets.UTF_16LE;
                String asString = ((Object)StringsKt.trim((CharSequence)new String(byArray2, (Charset)object))).toString();
                MethodHandle methodHandle2 = WindowsKernelHandlesKt.getNativeLocalFree();
                Intrinsics.checkNotNull(methodHandle2);
                MemorySegment deallocated = methodHandle2.invokeExact(WindowsUtilitiesKt.getThreadLocalPTR().get(ValueLayout.ADDRESS, 0L));
                if (!Intrinsics.areEqual(deallocated, MemorySegment.NULL)) {
                    object = "LOCAL FREE GET LAST ERROR";
                    throw new NotImplementedError("An operation is not implemented: " + (String)object);
                }
                throw new WindowsLastErrorException(UInt.constructor-impl(err2), asString, null);
            }
        }
    }

    public static final int getWin32LastError() {
        return WindowsKernelHandlesKt.getNativeGetLastError().get(ForeignFunctionInterfaceKt.getCapturedStateSegment(), 0L);
    }

    public static final int getWsaLastError() {
        return WindowsKernelHandlesKt.getNativeWSAGetLastError().get(ForeignFunctionInterfaceKt.getCapturedStateSegment(), 0L);
    }

    @NotNull
    public static final Void throwLastError() {
        WindowsUtilitiesKt.decodeWin32Error(WindowsUtilitiesKt.getWin32LastError());
        throw new OperatingSystemException("General exception (GetLastError did not produce error code).");
    }

    @NotNull
    public static final Void throwLastWSAError() {
        WindowsUtilitiesKt.decodeWin32Error(WindowsUtilitiesKt.getWsaLastError());
        throw new OperatingSystemException("General exception (WSAGetLastError did not produce error code).");
    }

    public static final void returnsNTSTATUS(@NotNull MethodHandle $this$returnsNTSTATUS, @NotNull Object p0) {
        Intrinsics.checkNotNullParameter($this$returnsNTSTATUS, "<this>");
        Intrinsics.checkNotNullParameter(p0, "p0");
        WindowsUtilitiesKt.decodeNTSTATUS($this$returnsNTSTATUS.invoke(p0));
    }

    public static final void returnsNTSTATUS(@NotNull MethodHandle $this$returnsNTSTATUS, @NotNull Object p0, @NotNull Object p1) {
        Intrinsics.checkNotNullParameter($this$returnsNTSTATUS, "<this>");
        Intrinsics.checkNotNullParameter(p0, "p0");
        Intrinsics.checkNotNullParameter(p1, "p1");
        WindowsUtilitiesKt.decodeNTSTATUS($this$returnsNTSTATUS.invoke(p0, p1));
    }

    public static final void returnsNTSTATUS(@NotNull MethodHandle $this$returnsNTSTATUS, @NotNull Object p0, @NotNull Object p1, @NotNull Object p2, @NotNull Object p3) {
        Intrinsics.checkNotNullParameter($this$returnsNTSTATUS, "<this>");
        Intrinsics.checkNotNullParameter(p0, "p0");
        Intrinsics.checkNotNullParameter(p1, "p1");
        Intrinsics.checkNotNullParameter(p2, "p2");
        Intrinsics.checkNotNullParameter(p3, "p3");
        WindowsUtilitiesKt.decodeNTSTATUS($this$returnsNTSTATUS.invoke(p0, p1, p2, p3));
    }

    public static final void returnsNTSTATUS(@NotNull MethodHandle $this$returnsNTSTATUS, @NotNull Object p0, @NotNull Object p1, @NotNull Object p2, @NotNull Object p3, @NotNull Object p4) {
        Intrinsics.checkNotNullParameter($this$returnsNTSTATUS, "<this>");
        Intrinsics.checkNotNullParameter(p0, "p0");
        Intrinsics.checkNotNullParameter(p1, "p1");
        Intrinsics.checkNotNullParameter(p2, "p2");
        Intrinsics.checkNotNullParameter(p3, "p3");
        Intrinsics.checkNotNullParameter(p4, "p4");
        WindowsUtilitiesKt.decodeNTSTATUS($this$returnsNTSTATUS.invoke(p0, p1, p2, p3, p4));
    }

    public static final void returnsNTSTATUS(@NotNull MethodHandle $this$returnsNTSTATUS, @NotNull Object p0, @NotNull Object p1, @NotNull Object p2, @NotNull Object p3, @NotNull Object p4, @NotNull Object p5) {
        Intrinsics.checkNotNullParameter($this$returnsNTSTATUS, "<this>");
        Intrinsics.checkNotNullParameter(p0, "p0");
        Intrinsics.checkNotNullParameter(p1, "p1");
        Intrinsics.checkNotNullParameter(p2, "p2");
        Intrinsics.checkNotNullParameter(p3, "p3");
        Intrinsics.checkNotNullParameter(p4, "p4");
        Intrinsics.checkNotNullParameter(p5, "p5");
        WindowsUtilitiesKt.decodeNTSTATUS($this$returnsNTSTATUS.invoke(p0, p1, p2, p3, p4, p5));
    }

    public static final void returnsNTSTATUS(@NotNull MethodHandle $this$returnsNTSTATUS, @NotNull Object p0, @NotNull Object p1, @NotNull Object p2, @NotNull Object p3, @NotNull Object p4, @NotNull Object p5, @NotNull Object p6) {
        Intrinsics.checkNotNullParameter($this$returnsNTSTATUS, "<this>");
        Intrinsics.checkNotNullParameter(p0, "p0");
        Intrinsics.checkNotNullParameter(p1, "p1");
        Intrinsics.checkNotNullParameter(p2, "p2");
        Intrinsics.checkNotNullParameter(p3, "p3");
        Intrinsics.checkNotNullParameter(p4, "p4");
        Intrinsics.checkNotNullParameter(p5, "p5");
        Intrinsics.checkNotNullParameter(p6, "p6");
        WindowsUtilitiesKt.decodeNTSTATUS($this$returnsNTSTATUS.invoke(p0, p1, p2, p3, p4, p5, p6));
    }

    public static final void returnsNTSTATUS(@NotNull MethodHandle $this$returnsNTSTATUS, @NotNull Object p0, @NotNull Object p1, @NotNull Object p2, @NotNull Object p3, @NotNull Object p4, @NotNull Object p5, @NotNull Object p6, @NotNull Object p7) {
        Intrinsics.checkNotNullParameter($this$returnsNTSTATUS, "<this>");
        Intrinsics.checkNotNullParameter(p0, "p0");
        Intrinsics.checkNotNullParameter(p1, "p1");
        Intrinsics.checkNotNullParameter(p2, "p2");
        Intrinsics.checkNotNullParameter(p3, "p3");
        Intrinsics.checkNotNullParameter(p4, "p4");
        Intrinsics.checkNotNullParameter(p5, "p5");
        Intrinsics.checkNotNullParameter(p6, "p6");
        Intrinsics.checkNotNullParameter(p7, "p7");
        WindowsUtilitiesKt.decodeNTSTATUS($this$returnsNTSTATUS.invoke(p0, p1, p2, p3, p4, p5, p6, p7));
    }

    /*
     * WARNING - void declaration
     */
    private static final void decodeNTSTATUS(int $this$decodeNTSTATUS) {
        Object v0;
        void n$iv;
        block2: {
            void $this$id$iv;
            Mappable.Companion companion = Mappable.Companion;
            EnumEntries<WindowsNTStatus> enumEntries = WindowsNTStatus.getEntries();
            UInt uInt = UInt.box-impl(UInt.constructor-impl($this$decodeNTSTATUS));
            boolean $i$f$id = false;
            Iterable $this$firstOrNull$iv$iv = (Iterable)$this$id$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                Enum it$iv = (Enum)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(((Mappable)((Object)it$iv)).getId(), n$iv)) continue;
                v0 = element$iv$iv;
                break block2;
            }
            v0 = null;
        }
        void var12_11 = n$iv;
        Enum enum_ = v0;
        MappedEnumeration<void, Enum> status = new MappedEnumeration<void, Enum>(enum_, var12_11);
        if (status.getEnum() != WindowsNTStatus.STATUS_SUCCESS) {
            throw new WindowsNTSTATUSException(status);
        }
    }

    public static final long FILETIMEToUnixMs(long fileTime) {
        return fileTime / (long)10000 - 11644473600000L;
    }

    private static final MemorySegment tlsDWORD0$lambda$0() {
        return ForeignFunctionInterfaceKt.getGlobalArena().allocate(DWORD);
    }

    private static final MemorySegment tlsDWORD1$lambda$0() {
        return ForeignFunctionInterfaceKt.getGlobalArena().allocate(DWORD);
    }

    private static final MemorySegment tlsDWORD2$lambda$0() {
        return ForeignFunctionInterfaceKt.getGlobalArena().allocate(DWORD);
    }

    private static final MemorySegment tlsLARGE_INTEGER0$lambda$0() {
        return ForeignFunctionInterfaceKt.getGlobalArena().allocate(WindowsLayoutsKt.getLARGE_INTEGER());
    }

    private static final MemorySegment tlsPTR$lambda$0() {
        return ForeignFunctionInterfaceKt.getGlobalArena().allocate(ValueLayout.ADDRESS);
    }

    static {
        ValueLayout.OfByte ofByte = ValueLayout.JAVA_BYTE;
        Intrinsics.checkNotNullExpressionValue(ofByte, "JAVA_BYTE");
        char = ofByte;
        ValueLayout.OfByte ofByte2 = ValueLayout.JAVA_BYTE;
        Intrinsics.checkNotNullExpressionValue(ofByte2, "JAVA_BYTE");
        BYTE = ofByte2;
        ValueLayout.OfShort ofShort = ValueLayout.JAVA_SHORT;
        Intrinsics.checkNotNullExpressionValue(ofShort, "JAVA_SHORT");
        ATOM = WORD = ofShort;
        ValueLayout.OfInt ofInt = ValueLayout.JAVA_INT;
        Intrinsics.checkNotNullExpressionValue(ofInt, "JAVA_INT");
        DWORD = ofInt;
        AddressLayout addressLayout = ValueLayout.ADDRESS;
        Intrinsics.checkNotNullExpressionValue(addressLayout, "ADDRESS");
        PDWORD = addressLayout;
        ValueLayout.OfInt ofInt2 = ValueLayout.JAVA_INT;
        Intrinsics.checkNotNullExpressionValue(ofInt2, "JAVA_INT");
        BOOL = ofInt2;
        ValueLayout.OfInt ofInt3 = ValueLayout.JAVA_INT;
        Intrinsics.checkNotNullExpressionValue(ofInt3, "JAVA_INT");
        LONG = ofInt3;
        ValueLayout.OfInt ofInt4 = ValueLayout.JAVA_INT;
        Intrinsics.checkNotNullExpressionValue(ofInt4, "JAVA_INT");
        ULONG = ofInt4;
        AddressLayout addressLayout2 = ValueLayout.ADDRESS;
        Intrinsics.checkNotNullExpressionValue(addressLayout2, "ADDRESS");
        ULONG_PTR = addressLayout2;
        AddressLayout addressLayout3 = ValueLayout.ADDRESS;
        Intrinsics.checkNotNullExpressionValue(addressLayout3, "ADDRESS");
        PULONG = addressLayout3;
        AddressLayout addressLayout4 = ValueLayout.ADDRESS;
        Intrinsics.checkNotNullExpressionValue(addressLayout4, "ADDRESS");
        PBYTE = addressLayout4;
        ValueLayout.OfLong ofLong = ValueLayout.JAVA_LONG;
        Intrinsics.checkNotNullExpressionValue(ofLong, "JAVA_LONG");
        ULONGLONG = ofLong;
        ValueLayout.OfShort ofShort2 = ValueLayout.JAVA_SHORT;
        Intrinsics.checkNotNullExpressionValue(ofShort2, "JAVA_SHORT");
        USHORT = ofShort2;
        HRESULT = LONG;
        ValueLayout.OfLong ofLong2 = ValueLayout.JAVA_LONG;
        Intrinsics.checkNotNullExpressionValue(ofLong2, "JAVA_LONG");
        LONG_PTR = ofLong2;
        ValueLayout.OfLong ofLong3 = ValueLayout.JAVA_LONG;
        Intrinsics.checkNotNullExpressionValue(ofLong3, "JAVA_LONG");
        UINT_PTR = ofLong3;
        LRESULT = LONG_PTR;
        ValueLayout.OfInt ofInt5 = ValueLayout.JAVA_INT;
        Intrinsics.checkNotNullExpressionValue(ofInt5, "JAVA_INT");
        UINT = ofInt5;
        ValueLayout.OfShort ofShort3 = ValueLayout.JAVA_SHORT;
        Intrinsics.checkNotNullExpressionValue(ofShort3, "JAVA_SHORT");
        SHORT = ofShort3;
        ValueLayout.OfShort ofShort4 = ValueLayout.JAVA_SHORT;
        Intrinsics.checkNotNullExpressionValue(ofShort4, "JAVA_SHORT");
        WCHAR = ofShort4;
        ValueLayout.OfByte ofByte3 = ValueLayout.JAVA_BYTE;
        Intrinsics.checkNotNullExpressionValue(ofByte3, "JAVA_BYTE");
        CHAR = ofByte3;
        WPARAM = UINT_PTR;
        LPARAM = LONG_PTR;
        AddressLayout addressLayout5 = ValueLayout.ADDRESS;
        Intrinsics.checkNotNullExpressionValue(addressLayout5, "ADDRESS");
        PWSTR = addressLayout5;
        AddressLayout addressLayout6 = ValueLayout.ADDRESS;
        Intrinsics.checkNotNullExpressionValue(addressLayout6, "ADDRESS");
        LPDWORD = addressLayout6;
        AddressLayout addressLayout7 = ValueLayout.ADDRESS;
        Intrinsics.checkNotNullExpressionValue(addressLayout7, "ADDRESS");
        LPINT = addressLayout7;
        AddressLayout addressLayout8 = ValueLayout.ADDRESS;
        Intrinsics.checkNotNullExpressionValue(addressLayout8, "ADDRESS");
        LPWSTR = addressLayout8;
        AddressLayout addressLayout9 = ValueLayout.ADDRESS;
        Intrinsics.checkNotNullExpressionValue(addressLayout9, "ADDRESS");
        LPCWSTR = addressLayout9;
        AddressLayout addressLayout10 = ValueLayout.ADDRESS;
        Intrinsics.checkNotNullExpressionValue(addressLayout10, "ADDRESS");
        LPCSTR = addressLayout10;
        AddressLayout addressLayout11 = ValueLayout.ADDRESS;
        Intrinsics.checkNotNullExpressionValue(addressLayout11, "ADDRESS");
        LPCVOID = addressLayout11;
        AddressLayout addressLayout12 = AddressLayout.ADDRESS;
        Intrinsics.checkNotNullExpressionValue(addressLayout12, "ADDRESS");
        LPVOID = addressLayout12;
        AddressLayout addressLayout13 = AddressLayout.ADDRESS;
        Intrinsics.checkNotNullExpressionValue(addressLayout13, "ADDRESS");
        HLOCAL = HANDLE = (PVOID = addressLayout13);
        HMENU = HANDLE;
        HINSTANCE = HANDLE;
        HRGN = HANDLE;
        HWND = HANDLE;
        HMODULE = HINSTANCE;
        HWINSTA = HANDLE;
        HDESK = HANDLE;
        HCURSOR = HICON = HANDLE;
        HBRUSH = HANDLE;
        AddressLayout addressLayout14 = AddressLayout.ADDRESS;
        Intrinsics.checkNotNullExpressionValue(addressLayout14, "ADDRESS");
        FARPROC = addressLayout14;
        AddressLayout addressLayout15 = AddressLayout.ADDRESS;
        Intrinsics.checkNotNullExpressionValue(addressLayout15, "ADDRESS");
        PROC = addressLayout15;
        ACCESS_MASK = DWORD;
        MemorySegment memorySegment = MemorySegment.ofAddress(-1L);
        Intrinsics.checkNotNullExpressionValue(memorySegment, "ofAddress(...)");
        INVALID_HANDLE_VALUE = memorySegment;
        tlsDWORD0 = ThreadLocal.withInitial(WindowsUtilitiesKt::tlsDWORD0$lambda$0);
        tlsDWORD1 = ThreadLocal.withInitial(WindowsUtilitiesKt::tlsDWORD1$lambda$0);
        tlsDWORD2 = ThreadLocal.withInitial(WindowsUtilitiesKt::tlsDWORD2$lambda$0);
        tlsLARGE_INTEGER0 = ThreadLocal.withInitial(WindowsUtilitiesKt::tlsLARGE_INTEGER0$lambda$0);
        tlsPTR = ThreadLocal.withInitial(WindowsUtilitiesKt::tlsPTR$lambda$0);
    }
}

