/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.io.reader;

import java.io.EOFException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KCallable;
import kotlin.reflect.KMutableProperty;
import org.bread_experts_group.io.reader.ReadingByteBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/bread_experts_group/io/reader/SocketReadingByteBuffer;", "Lorg/bread_experts_group/io/reader/ReadingByteBuffer;", "selector", "Ljava/nio/channels/Selector;", "from", "Ljava/nio/channels/SocketChannel;", "buffer", "Ljava/nio/ByteBuffer;", "lengthMarker", "Lkotlin/reflect/KMutableProperty;", "", "<init>", "(Ljava/nio/channels/Selector;Ljava/nio/channels/SocketChannel;Ljava/nio/ByteBuffer;Lkotlin/reflect/KMutableProperty;)V", "refill", "", "amount", "", "bread_server_lib"})
public final class SocketReadingByteBuffer
extends ReadingByteBuffer {
    @NotNull
    private final Selector selector;

    public SocketReadingByteBuffer(@NotNull Selector selector, @NotNull SocketChannel from, @NotNull ByteBuffer buffer, @Nullable KMutableProperty<Long> lengthMarker) {
        Intrinsics.checkNotNullParameter(selector, "selector");
        Intrinsics.checkNotNullParameter(from, "from");
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        super(from, buffer, lengthMarker);
        this.selector = selector;
        from.register(this.selector, 1);
    }

    @Override
    public void refill(int amount) {
        KCallable<Long> kCallable = this.getLengthMarker();
        if (kCallable != null && (kCallable = kCallable.getSetter()) != null) {
            Object[] objectArray = new Object[]{((Number)this.getLengthMarker().getGetter().call(new Object[0])).longValue() - (long)amount};
            kCallable.call(objectArray);
        }
        int toFill = amount - this.getPresent();
        if (toFill < 1) {
            return;
        }
        this.getBuffer().compact();
        while (toFill > this.getPresent()) {
            int read = 0;
            this.selector.select();
            for (SelectionKey key : this.selector.selectedKeys()) {
                if (!key.isReadable()) continue;
                SelectableChannel selectableChannel = key.channel();
                Intrinsics.checkNotNull(selectableChannel, "null cannot be cast to non-null type java.nio.channels.ReadableByteChannel");
                int localRead = ((ReadableByteChannel)((Object)selectableChannel)).read(this.getBuffer());
                if (localRead == -1) {
                    throw new EOFException();
                }
                read = localRead;
                break;
            }
            this.setPresent(this.getPresent() + read);
        }
        this.getBuffer().flip();
    }
}

