/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.numeric.geometry;

import java.lang.foreign.MemorySegment;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.numeric.geometry.Vector4F;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB/\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0011\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\nJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\nJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006 "}, d2={"Lorg/bread_experts_group/numeric/geometry/Matrix4F;", "", "m0", "Lorg/bread_experts_group/numeric/geometry/Vector4F;", "m1", "m2", "m3", "<init>", "(Lorg/bread_experts_group/numeric/geometry/Vector4F;Lorg/bread_experts_group/numeric/geometry/Vector4F;Lorg/bread_experts_group/numeric/geometry/Vector4F;Lorg/bread_experts_group/numeric/geometry/Vector4F;)V", "d", "", "(F)V", "getM0", "()Lorg/bread_experts_group/numeric/geometry/Vector4F;", "getM1", "getM2", "getM3", "fillArray", "", "segment", "Ljava/lang/foreign/MemorySegment;", "offset", "", "plus", "v", "times", "m", "rotateX", "radians", "rotateY", "rotateZ", "Companion", "bread_server_lib"})
public final class Matrix4F {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vector4F m0;
    @NotNull
    private final Vector4F m1;
    @NotNull
    private final Vector4F m2;
    @NotNull
    private final Vector4F m3;

    public Matrix4F(@NotNull Vector4F m0, @NotNull Vector4F m1, @NotNull Vector4F m2, @NotNull Vector4F m3) {
        Intrinsics.checkNotNullParameter(m0, "m0");
        Intrinsics.checkNotNullParameter(m1, "m1");
        Intrinsics.checkNotNullParameter(m2, "m2");
        Intrinsics.checkNotNullParameter(m3, "m3");
        this.m0 = m0;
        this.m1 = m1;
        this.m2 = m2;
        this.m3 = m3;
    }

    public /* synthetic */ Matrix4F(Vector4F vector4F, Vector4F vector4F2, Vector4F vector4F3, Vector4F vector4F4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            vector4F = new Vector4F(0.0f, 0.0f, 0.0f, 0.0f);
        }
        if ((n & 2) != 0) {
            vector4F2 = new Vector4F(0.0f, 0.0f, 0.0f, 0.0f);
        }
        if ((n & 4) != 0) {
            vector4F3 = new Vector4F(0.0f, 0.0f, 0.0f, 0.0f);
        }
        if ((n & 8) != 0) {
            vector4F4 = new Vector4F(0.0f, 0.0f, 0.0f, 0.0f);
        }
        this(vector4F, vector4F2, vector4F3, vector4F4);
    }

    @NotNull
    public final Vector4F getM0() {
        return this.m0;
    }

    @NotNull
    public final Vector4F getM1() {
        return this.m1;
    }

    @NotNull
    public final Vector4F getM2() {
        return this.m2;
    }

    @NotNull
    public final Vector4F getM3() {
        return this.m3;
    }

    public Matrix4F(float d) {
        this(new Vector4F(d, 0.0f, 0.0f, 0.0f), new Vector4F(0.0f, d, 0.0f, 0.0f), new Vector4F(0.0f, 0.0f, d, 0.0f), new Vector4F(0.0f, 0.0f, 0.0f, d));
    }

    public final void fillArray(@NotNull MemorySegment segment, long offset) {
        Intrinsics.checkNotNullParameter(segment, "segment");
        long offs = Vector4F.Companion.byteSize();
        this.m0.fillArray(segment, offset);
        this.m1.fillArray(segment, offset + offs);
        this.m2.fillArray(segment, offset + offs * (long)2);
        this.m3.fillArray(segment, offset + offs * (long)3);
    }

    @NotNull
    public final Matrix4F plus(@NotNull Vector4F v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return this.times(new Matrix4F(new Vector4F(1.0f, 0.0f, 0.0f, 0.0f), new Vector4F(0.0f, 1.0f, 0.0f, 0.0f), new Vector4F(0.0f, 0.0f, 1.0f, 0.0f), new Vector4F(v.getX(), v.getY(), v.getZ(), v.getW())));
    }

    @NotNull
    public final Matrix4F times(@NotNull Matrix4F m) {
        Intrinsics.checkNotNullParameter(m, "m");
        return new Matrix4F(new Vector4F(this.m0.getX() * m.m0.getX() + this.m1.getX() * m.m0.getY() + this.m2.getX() * m.m0.getZ() + this.m3.getX() * m.m0.getW(), this.m0.getY() * m.m0.getX() + this.m1.getY() * m.m0.getY() + this.m2.getY() * m.m0.getZ() + this.m3.getY() * m.m0.getW(), this.m0.getZ() * m.m0.getX() + this.m1.getZ() * m.m0.getY() + this.m2.getZ() * m.m0.getZ() + this.m3.getZ() * m.m0.getW(), this.m0.getW() * m.m0.getX() + this.m1.getW() * m.m0.getY() + this.m2.getW() * m.m0.getZ() + this.m3.getW() * m.m0.getW()), new Vector4F(this.m0.getX() * m.m1.getX() + this.m1.getX() * m.m1.getY() + this.m2.getX() * m.m1.getZ() + this.m3.getX() * m.m1.getW(), this.m0.getY() * m.m1.getX() + this.m1.getY() * m.m1.getY() + this.m2.getY() * m.m1.getZ() + this.m3.getY() * m.m1.getW(), this.m0.getZ() * m.m1.getX() + this.m1.getZ() * m.m1.getY() + this.m2.getZ() * m.m1.getZ() + this.m3.getZ() * m.m1.getW(), this.m0.getW() * m.m1.getX() + this.m1.getW() * m.m1.getY() + this.m2.getW() * m.m1.getZ() + this.m3.getW() * m.m1.getW()), new Vector4F(this.m0.getX() * m.m2.getX() + this.m1.getX() * m.m2.getY() + this.m2.getX() * m.m2.getZ() + this.m3.getX() * m.m2.getW(), this.m0.getY() * m.m2.getX() + this.m1.getY() * m.m2.getY() + this.m2.getY() * m.m2.getZ() + this.m3.getY() * m.m2.getW(), this.m0.getZ() * m.m2.getX() + this.m1.getZ() * m.m2.getY() + this.m2.getZ() * m.m2.getZ() + this.m3.getZ() * m.m2.getW(), this.m0.getW() * m.m2.getX() + this.m1.getW() * m.m2.getY() + this.m2.getW() * m.m2.getZ() + this.m3.getW() * m.m2.getW()), new Vector4F(this.m0.getX() * m.m3.getX() + this.m1.getX() * m.m3.getY() + this.m2.getX() * m.m3.getZ() + this.m3.getX() * m.m3.getW(), this.m0.getY() * m.m3.getX() + this.m1.getY() * m.m3.getY() + this.m2.getY() * m.m3.getZ() + this.m3.getY() * m.m3.getW(), this.m0.getZ() * m.m3.getX() + this.m1.getZ() * m.m3.getY() + this.m2.getZ() * m.m3.getZ() + this.m3.getZ() * m.m3.getW(), this.m0.getW() * m.m3.getX() + this.m1.getW() * m.m3.getY() + this.m2.getW() * m.m3.getZ() + this.m3.getW() * m.m3.getW()));
    }

    @NotNull
    public final Matrix4F rotateX(float radians) {
        float cos = (float)Math.cos(radians);
        float sin = (float)Math.sin(radians);
        return new Matrix4F(new Vector4F(1.0f, 0.0f, 0.0f, 0.0f), new Vector4F(0.0f, cos, sin, 0.0f), new Vector4F(0.0f, -sin, cos, 0.0f), new Vector4F(0.0f, 0.0f, 0.0f, 1.0f)).times(this);
    }

    @NotNull
    public final Matrix4F rotateY(float radians) {
        float cos = (float)Math.cos(radians);
        float sin = (float)Math.sin(radians);
        return new Matrix4F(new Vector4F(cos, 0.0f, -sin, 0.0f), new Vector4F(0.0f, 1.0f, 0.0f, 0.0f), new Vector4F(sin, 0.0f, cos, 0.0f), new Vector4F(0.0f, 0.0f, 0.0f, 1.0f)).times(this);
    }

    @NotNull
    public final Matrix4F rotateZ(float radians) {
        float cos = (float)Math.cos(radians);
        float sin = (float)Math.sin(radians);
        return new Matrix4F(new Vector4F(cos, -sin, 0.0f, 0.0f), new Vector4F(sin, cos, 0.0f, 0.0f), new Vector4F(0.0f, 0.0f, 1.0f, 0.0f), new Vector4F(0.0f, 0.0f, 0.0f, 1.0f)).times(this);
    }

    public Matrix4F() {
        this(null, null, null, null, 15, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t\u00a8\u0006\r"}, d2={"Lorg/bread_experts_group/numeric/geometry/Matrix4F$Companion;", "", "<init>", "()V", "byteSize", "", "perspective", "Lorg/bread_experts_group/numeric/geometry/Matrix4F;", "fovYRadians", "", "aspect", "zNear", "zFar", "bread_server_lib"})
    public static final class Companion {
        private Companion() {
        }

        public final long byteSize() {
            return Vector4F.Companion.byteSize() * (long)4;
        }

        @NotNull
        public final Matrix4F perspective(float fovYRadians, float aspect, float zNear, float zFar) {
            float f = 1.0f / (float)Math.tan(fovYRadians / 2.0f);
            return new Matrix4F(new Vector4F(f / aspect, 0.0f, 0.0f, 0.0f), new Vector4F(0.0f, f, 0.0f, 0.0f), new Vector4F(0.0f, 0.0f, (zFar + zNear) / (zNear - zFar), -1.0f), new Vector4F(0.0f, 0.0f, 2.0f * zFar * zNear / (zNear - zFar), 0.0f));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

