/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.project_incubator.console;

import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.UShort;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.reflect.KMutableProperty;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.bread_experts_group.api.coding.CodingFormatImplementation;
import org.bread_experts_group.api.coding.CodingFormats;
import org.bread_experts_group.api.coding.CodingFormatsProvider;
import org.bread_experts_group.api.feature.FeatureProvider;
import org.bread_experts_group.api.graphics.GraphicsFeatures;
import org.bread_experts_group.api.graphics.GraphicsProvider;
import org.bread_experts_group.api.graphics.feature.console.GraphicsConsoleFeature;
import org.bread_experts_group.api.graphics.feature.console.feature.device.GraphicsConsoleFeatures;
import org.bread_experts_group.api.graphics.feature.console.feature.device.GraphicsConsoleIOFeature;
import org.bread_experts_group.api.graphics.feature.console.feature.device.feature.GraphicsConsoleIOCodingSetFeature;
import org.bread_experts_group.api.graphics.feature.console.feature.device.feature.GraphicsConsoleIODeviceGetFeature;
import org.bread_experts_group.api.graphics.feature.console.feature.device.feature.GraphicsConsoleIOEventGetFeature;
import org.bread_experts_group.api.graphics.feature.console.feature.device.feature.GraphicsConsoleIOFeatures;
import org.bread_experts_group.api.graphics.feature.console.feature.device.feature.GraphicsConsoleIOModeSetFeature;
import org.bread_experts_group.api.graphics.feature.console.feature.device.feature.GraphicsConsoleModes;
import org.bread_experts_group.api.system.EventListener;
import org.bread_experts_group.api.system.SystemFeatures;
import org.bread_experts_group.api.system.SystemProvider;
import org.bread_experts_group.api.system.device.SystemDevice;
import org.bread_experts_group.api.system.device.SystemDeviceFeatures;
import org.bread_experts_group.api.system.device.SystemDeviceType;
import org.bread_experts_group.api.system.device.feature.SystemDeviceAddedEventFeature;
import org.bread_experts_group.api.system.device.feature.SystemDeviceEnumerationFeature;
import org.bread_experts_group.api.system.device.feature.SystemDeviceFriendlyNameFeature;
import org.bread_experts_group.api.system.device.feature.SystemDeviceIODeviceFeature;
import org.bread_experts_group.api.system.device.feature.SystemDeviceRemovedEventFeature;
import org.bread_experts_group.api.system.device.feature.SystemDeviceSerialPortNameFeature;
import org.bread_experts_group.api.system.device.io.IODevice;
import org.bread_experts_group.api.system.device.io.IODeviceFeatures;
import org.bread_experts_group.api.system.device.io.feature.IODeviceReadFeature;
import org.bread_experts_group.api.system.device.io.feature.IODeviceWriteFeature;
import org.bread_experts_group.api.system.device.io.open.OpenIODeviceFeatureIdentifier;
import org.bread_experts_group.api.system.feature.SystemGetThreadLocalUserFeature;
import org.bread_experts_group.api.system.feature.SystemGetUptimeFeature;
import org.bread_experts_group.api.system.user.SystemUser;
import org.bread_experts_group.api.system.user.SystemUserFeatures;
import org.bread_experts_group.api.system.user.feature.SystemUserGetLogonTimeFeature;
import org.bread_experts_group.api.system.user.feature.SystemUserGetNameFeature;
import org.bread_experts_group.project_incubator.console.Console;
import org.bread_experts_group.project_incubator.console.ConsoleBank;
import org.bread_experts_group.project_incubator.console.ConsoleMessage;
import org.bread_experts_group.project_incubator.console.ContextTab;
import org.bread_experts_group.protocol.vt100d.VT100DEraseTypes;
import org.bread_experts_group.protocol.vt100d.VT100DGraphicsAttributes;
import org.bread_experts_group.protocol.vt100d.VT100DerivedConstantsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0001qB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\r\u001a\u00020\u000e*\u00020\u000fJ'\u0010_\u001a\u00020`2\u0006\u0010c\u001a\u00020U2\u0006\u0010d\u001a\u00020eR\u00020aj\u0006\u0010b\u001a\u00020a\u00a2\u0006\u0002\u0010fJ\u0016\u0010g\u001a\u00020\u000e2\u0006\u0010c\u001a\u00020U2\u0006\u0010d\u001a\u00020eJ3\u0010h\u001a\u00020`2\u0006\u0010k\u001a\u00020e2\u0006\u0010l\u001a\u00020eR\u00020iR\u00020aj\u0006\u0010j\u001a\u00020ij\u0006\u0010b\u001a\u00020a\u00a2\u0006\u0002\u0010mJ\u0006\u0010n\u001a\u00020\u000eJ#\u0010o\u001a\u00020`R\u00020iR\u00020aj\u0006\u0010j\u001a\u00020ij\u0006\u0010b\u001a\u00020a\u00a2\u0006\u0002\u0010pR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001e\"\u0004\b#\u0010 R\u001a\u0010$\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u001e\"\u0004\b&\u0010 R\u001a\u0010'\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u001e\"\u0004\b)\u0010 R\u001a\u0010*\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u001e\"\u0004\b,\u0010 R\u0011\u0010-\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u0016R\u0011\u0010/\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u0016R\u0011\u00101\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u0016R\u0011\u00103\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\u0016R\u0011\u00105\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010\u0016R\u0011\u00107\u001a\u000208\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u0011\u0010;\u001a\u00020<\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u0011\u0010?\u001a\u00020@\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010BR\u0011\u0010C\u001a\u00020D\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010FR\u0011\u0010G\u001a\u00020<\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010>R\u0011\u0010I\u001a\u00020J\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010LR\u001a\u0010M\u001a\u00020NX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010P\"\u0004\bQ\u0010RR\u0017\u0010S\u001a\b\u0012\u0004\u0012\u00020U0T\u00a2\u0006\b\n\u0000\u001a\u0004\bV\u0010WR\"\u0010X\u001a\b\u0012\u0004\u0012\u00020U0YX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010^\u001a\u0004\bZ\u0010[\"\u0004\b\\\u0010]\u00a8\u0006r"}, d2={"Lorg/bread_experts_group/project_incubator/console/Console;", "", "<init>", "()V", "messageQueue", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lorg/bread_experts_group/project_incubator/console/ConsoleMessage;", "getMessageQueue", "()Ljava/util/concurrent/LinkedBlockingQueue;", "clockFormat", "Ljava/time/format/DateTimeFormatter;", "getClockFormat", "()Ljava/time/format/DateTimeFormatter;", "format", "", "Ljava/time/Duration;", "user", "Lorg/bread_experts_group/api/system/user/SystemUser;", "getUser", "()Lorg/bread_experts_group/api/system/user/SystemUser;", "userName", "getUserName", "()Ljava/lang/String;", "logonTime", "Ljava/time/Instant;", "getLogonTime", "()Ljava/time/Instant;", "controlStatus", "", "getControlStatus", "()Z", "setControlStatus", "(Z)V", "controlSpaceStatus", "getControlSpaceStatus", "setControlSpaceStatus", "controlTabStatus", "getControlTabStatus", "setControlTabStatus", "controlCrStatus", "getControlCrStatus", "setControlCrStatus", "controlLfStatus", "getControlLfStatus", "setControlLfStatus", "controlSpace", "getControlSpace", "controlTab", "getControlTab", "controlCr", "getControlCr", "controlLf", "getControlLf", "controlEtx", "getControlEtx", "cui", "Lorg/bread_experts_group/api/graphics/feature/console/GraphicsConsoleFeature;", "getCui", "()Lorg/bread_experts_group/api/graphics/feature/console/GraphicsConsoleFeature;", "cOut", "Lorg/bread_experts_group/api/graphics/feature/console/feature/device/GraphicsConsoleIOFeature;", "getCOut", "()Lorg/bread_experts_group/api/graphics/feature/console/feature/device/GraphicsConsoleIOFeature;", "cOutDevice", "Lorg/bread_experts_group/api/system/device/io/IODevice;", "getCOutDevice", "()Lorg/bread_experts_group/api/system/device/io/IODevice;", "cOutWrite", "Lorg/bread_experts_group/api/system/device/io/feature/IODeviceWriteFeature;", "getCOutWrite", "()Lorg/bread_experts_group/api/system/device/io/feature/IODeviceWriteFeature;", "cIn", "getCIn", "cInEvents", "Lorg/bread_experts_group/api/graphics/feature/console/feature/device/feature/GraphicsConsoleIOEventGetFeature;", "getCInEvents", "()Lorg/bread_experts_group/api/graphics/feature/console/feature/device/feature/GraphicsConsoleIOEventGetFeature;", "bank", "Lorg/bread_experts_group/project_incubator/console/ConsoleBank;", "getBank", "()Lorg/bread_experts_group/project_incubator/console/ConsoleBank;", "setBank", "(Lorg/bread_experts_group/project_incubator/console/ConsoleBank;)V", "tabs", "", "Lorg/bread_experts_group/project_incubator/console/ContextTab;", "getTabs", "()Ljava/util/List;", "openTabs", "", "getOpenTabs", "()[Lorg/bread_experts_group/project_incubator/console/ContextTab;", "setOpenTabs", "([Lorg/bread_experts_group/project_incubator/console/ContextTab;)V", "[Lorg/bread_experts_group/project_incubator/console/ContextTab;", "processTab", "", "Lorg/bread_experts_group/project_incubator/console/ConsoleMessage$MouseInput;", "mouse", "tab", "depth", "", "(Lorg/bread_experts_group/project_incubator/console/ConsoleMessage$MouseInput;Lorg/bread_experts_group/project_incubator/console/ContextTab;I)V", "renderTab", "processTopLevel", "Lorg/bread_experts_group/project_incubator/console/ConsoleMessage$WindowSize;", "window", "x", "y", "(Lorg/bread_experts_group/project_incubator/console/ConsoleMessage$WindowSize;Lorg/bread_experts_group/project_incubator/console/ConsoleMessage$MouseInput;II)V", "renderTopLevel", "render", "(Lorg/bread_experts_group/project_incubator/console/ConsoleMessage$WindowSize;Lorg/bread_experts_group/project_incubator/console/ConsoleMessage$MouseInput;)V", "ToggleTab", "bread_server_lib"})
@SourceDebugExtension(value={"SMAP\nConsoleMain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsoleMain.kt\norg/bread_experts_group/project_incubator/console/Console\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,399:1\n1869#2,2:400\n1878#2,3:403\n1869#2,2:406\n1878#2,3:410\n1#3:402\n13870#4,2:408\n13872#4:413\n*S KotlinDebug\n*F\n+ 1 ConsoleMain.kt\norg/bread_experts_group/project_incubator/console/Console\n*L\n251#1:400,2\n264#1:403,3\n277#1:406,2\n281#1:410,3\n280#1:408,2\n280#1:413\n*E\n"})
public final class Console {
    @NotNull
    private final LinkedBlockingQueue<ConsoleMessage> messageQueue = new LinkedBlockingQueue();
    @NotNull
    private final DateTimeFormatter clockFormat;
    @NotNull
    private final SystemUser user;
    @NotNull
    private final String userName;
    @NotNull
    private final Instant logonTime;
    private boolean controlStatus;
    private boolean controlSpaceStatus;
    private boolean controlTabStatus;
    private boolean controlCrStatus;
    private boolean controlLfStatus;
    @NotNull
    private final String controlSpace;
    @NotNull
    private final String controlTab;
    @NotNull
    private final String controlCr;
    @NotNull
    private final String controlLf;
    @NotNull
    private final String controlEtx;
    @NotNull
    private final GraphicsConsoleFeature cui;
    @NotNull
    private final GraphicsConsoleIOFeature cOut;
    @NotNull
    private final IODevice cOutDevice;
    @NotNull
    private final IODeviceWriteFeature cOutWrite;
    @NotNull
    private final GraphicsConsoleIOFeature cIn;
    @NotNull
    private final GraphicsConsoleIOEventGetFeature cInEvents;
    @NotNull
    private ConsoleBank bank;
    @NotNull
    private final List<ContextTab> tabs;
    @NotNull
    private ContextTab[] openTabs;

    public Console() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ssZ");
        Intrinsics.checkNotNullExpressionValue(dateTimeFormatter, "ofPattern(...)");
        this.clockFormat = dateTimeFormatter;
        this.user = ((SystemGetThreadLocalUserFeature)FeatureProvider.get$default(SystemProvider.INSTANCE, SystemFeatures.INSTANCE.getGET_THREAD_LOCAL_USER(), false, 2, null)).getUser();
        this.userName = ((SystemUserGetNameFeature)FeatureProvider.get$default(this.user, SystemUserFeatures.INSTANCE.getNAME_GET(), false, 2, null)).getName();
        this.logonTime = ((SystemUserGetLogonTimeFeature)FeatureProvider.get$default(this.user, SystemUserFeatures.INSTANCE.getLOGON_TIME_GET(), false, 2, null)).getLogonTime();
        this.controlSpace = VT100DerivedConstantsKt.SET_ATTRIBUTE(VT100DGraphicsAttributes.FG_MAGENTA) + "\u2420" + VT100DerivedConstantsKt.SET_ATTRIBUTE(VT100DGraphicsAttributes.FG_DEFAULT);
        this.controlTab = VT100DerivedConstantsKt.SET_ATTRIBUTE(VT100DGraphicsAttributes.FG_MAGENTA) + "\u2409\u2423\u2423\u2423" + VT100DerivedConstantsKt.SET_ATTRIBUTE(VT100DGraphicsAttributes.FG_DEFAULT);
        this.controlCr = VT100DerivedConstantsKt.SET_ATTRIBUTE(VT100DGraphicsAttributes.FG_MAGENTA) + "\u240d" + VT100DerivedConstantsKt.SET_ATTRIBUTE(VT100DGraphicsAttributes.FG_DEFAULT);
        this.controlLf = VT100DerivedConstantsKt.SET_ATTRIBUTE(VT100DGraphicsAttributes.FG_MAGENTA) + "\u240a" + VT100DerivedConstantsKt.SET_ATTRIBUTE(VT100DGraphicsAttributes.FG_DEFAULT);
        this.controlEtx = VT100DerivedConstantsKt.SET_ATTRIBUTE(VT100DGraphicsAttributes.FG_RED) + "\u2403" + VT100DerivedConstantsKt.SET_ATTRIBUTE(VT100DGraphicsAttributes.FG_DEFAULT);
        this.cui = (GraphicsConsoleFeature)FeatureProvider.get$default(GraphicsProvider.INSTANCE, GraphicsFeatures.INSTANCE.getCUI_CONSOLE(), false, 2, null);
        this.cOut = (GraphicsConsoleIOFeature)FeatureProvider.get$default(this.cui, GraphicsConsoleFeatures.INSTANCE.getSTANDARD_OUTPUT(), false, 2, null);
        this.cOutDevice = ((GraphicsConsoleIODeviceGetFeature)FeatureProvider.get$default(this.cOut, GraphicsConsoleIOFeatures.INSTANCE.getDEVICE_GET(), false, 2, null)).getDevice();
        this.cOutWrite = (IODeviceWriteFeature)FeatureProvider.get$default(this.cOutDevice, IODeviceFeatures.INSTANCE.getWRITE(), false, 2, null);
        this.cIn = (GraphicsConsoleIOFeature)FeatureProvider.get$default(this.cui, GraphicsConsoleFeatures.INSTANCE.getSTANDARD_INPUT(), false, 2, null);
        this.cInEvents = (GraphicsConsoleIOEventGetFeature)FeatureProvider.get$default(this.cIn, GraphicsConsoleIOFeatures.INSTANCE.getEVENT_GET(), false, 2, null);
        ((GraphicsConsoleIOCodingSetFeature)FeatureProvider.get$default(this.cOut, GraphicsConsoleIOFeatures.INSTANCE.getCODING_SET(), false, 2, null)).setCoding(((CodingFormatImplementation)FeatureProvider.get$default(CodingFormatsProvider.INSTANCE, CodingFormats.INSTANCE.getUTF_8(), false, 2, null)).getCoding());
        GraphicsConsoleIOModeSetFeature graphicsConsoleIOModeSetFeature = (GraphicsConsoleIOModeSetFeature)FeatureProvider.get$default(this.cOut, GraphicsConsoleIOFeatures.INSTANCE.getMODE_SET(), false, 2, null);
        EnumSet<Enum> enumSet = EnumSet.of((Enum)GraphicsConsoleModes.OUTPUT_SYSTEM_PROCESSED, (Enum)GraphicsConsoleModes.OUTPUT_CONTROL_SEQUENCES);
        Intrinsics.checkNotNullExpressionValue(enumSet, "of(...)");
        graphicsConsoleIOModeSetFeature.setMode(enumSet);
        ((GraphicsConsoleIOCodingSetFeature)FeatureProvider.get$default(this.cIn, GraphicsConsoleIOFeatures.INSTANCE.getCODING_SET(), false, 2, null)).setCoding(((CodingFormatImplementation)FeatureProvider.get$default(CodingFormatsProvider.INSTANCE, CodingFormats.INSTANCE.getUTF_8(), false, 2, null)).getCoding());
        GraphicsConsoleIOModeSetFeature graphicsConsoleIOModeSetFeature2 = (GraphicsConsoleIOModeSetFeature)FeatureProvider.get$default(this.cIn, GraphicsConsoleIOFeatures.INSTANCE.getMODE_SET(), false, 2, null);
        EnumSet<Enum> enumSet2 = EnumSet.of((Enum)GraphicsConsoleModes.INPUT_CONTROL_SEQUENCES, (Enum)GraphicsConsoleModes.INPUT_WINDOW_EVENTS, (Enum)GraphicsConsoleModes.INPUT_MOUSE_EVENTS);
        Intrinsics.checkNotNullExpressionValue(enumSet2, "of(...)");
        graphicsConsoleIOModeSetFeature2.setMode(enumSet2);
        this.cOutWrite.write("\u001b[?1049h", Charsets.UTF_8);
        this.bank = new ConsoleBank((Queue<ConsoleMessage>)this.messageQueue);
        ContextTab[] contextTabArray = new ContextTab[3];
        ContextTab[] contextTabArray2 = new ContextTab[1];
        ContextTab[] contextTabArray3 = new ContextTab[1];
        ContextTab[] contextTabArray4 = new ContextTab[]{new ToggleTab("Enable", new MutablePropertyReference0Impl(this){

            public Object get() {
                return ((Console)this.receiver).getControlStatus();
            }

            public void set(Object value) {
                ((Console)this.receiver).setControlStatus((Boolean)value);
            }
        }), new ToggleTab("Space", new MutablePropertyReference0Impl(this){

            public Object get() {
                return ((Console)this.receiver).getControlSpaceStatus();
            }

            public void set(Object value) {
                ((Console)this.receiver).setControlSpaceStatus((Boolean)value);
            }
        }), new ToggleTab("Tab", new MutablePropertyReference0Impl(this){

            public Object get() {
                return ((Console)this.receiver).getControlTabStatus();
            }

            public void set(Object value) {
                ((Console)this.receiver).setControlTabStatus((Boolean)value);
            }
        }), new ToggleTab("Carriage Return", new MutablePropertyReference0Impl(this){

            public Object get() {
                return ((Console)this.receiver).getControlCrStatus();
            }

            public void set(Object value) {
                ((Console)this.receiver).setControlCrStatus((Boolean)value);
            }
        }), new ToggleTab("Line Feed", new MutablePropertyReference0Impl(this){

            public Object get() {
                return ((Console)this.receiver).getControlLfStatus();
            }

            public void set(Object value) {
                ((Console)this.receiver).setControlLfStatus((Boolean)value);
            }
        })};
        contextTabArray3[0] = new ContextTab("VISIBILITY", Character.valueOf('R'), contextTabArray4);
        contextTabArray2[0] = new ContextTab("CONTROL SEQ", Character.valueOf('Q'), contextTabArray3);
        contextTabArray[0] = new ContextTab("SHELL", Character.valueOf('S'), contextTabArray2);
        contextTabArray[1] = new ContextTab("EXECUTE", Character.valueOf('E'), null, 4, null);
        contextTabArray2 = new ContextTab[]{new ContextTab(this){
            private EventListener addEvent;
            private EventListener removeEvent;
            private final IdentityHashMap<SystemDevice, ContextTab> mappings;
            final /* synthetic */ Console this$0;
            {
                this.this$0 = $receiver;
                super("SERIAL", Character.valueOf('S'), null, 4, null);
                this.mappings = new IdentityHashMap<K, V>();
            }

            public final EventListener getAddEvent() {
                return this.addEvent;
            }

            public final void setAddEvent(EventListener eventListener) {
                this.addEvent = eventListener;
            }

            public final EventListener getRemoveEvent() {
                return this.removeEvent;
            }

            public final void setRemoveEvent(EventListener eventListener) {
                this.removeEvent = eventListener;
            }

            public final IdentityHashMap<SystemDevice, ContextTab> getMappings() {
                return this.mappings;
            }

            public boolean opened() {
                Map.Entry<K, V> element$iv;
                this.addEvent = ((SystemDeviceAddedEventFeature)FeatureProvider.get$default(SystemProvider.INSTANCE, SystemFeatures.INSTANCE.getDEVICE_ADDED_EVENT(), false, 2, null)).listen(arg_0 -> tabs.6.opened$lambda$0(this, this.this$0, arg_0));
                this.removeEvent = ((SystemDeviceRemovedEventFeature)FeatureProvider.get$default(SystemProvider.INSTANCE, SystemFeatures.INSTANCE.getDEVICE_REMOVED_EVENT(), false, 2, null)).listen(arg_0 -> tabs.6.opened$lambda$1(this, arg_0));
                List<SystemDevice> presentDevices = CollectionsKt.toMutableList(((SystemDeviceEnumerationFeature)FeatureProvider.get$default(SystemProvider.INSTANCE, SystemFeatures.INSTANCE.getENUMERATE_DEVICES(), false, 2, null)).enumerate(SystemDeviceType.SERIAL));
                List dropDevices = new ArrayList<E>();
                Object $this$forEach$iv = this.mappings;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<K, V>> iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    boolean bl;
                    Map.Entry<K, V> entry = element$iv = iterator2.next();
                    boolean bl2 = false;
                    SystemDevice device = (SystemDevice)entry.getKey();
                    ContextTab tab = (ContextTab)entry.getValue();
                    if (presentDevices.contains(device)) {
                        presentDevices.remove(device);
                        List<ContextTab> list = this.getTabs();
                        Intrinsics.checkNotNull(tab);
                        bl = list.add(tab);
                        continue;
                    }
                    Intrinsics.checkNotNull(device);
                    bl = dropDevices.add(device);
                }
                $this$forEach$iv = dropDevices;
                $i$f$forEach = false;
                iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv = iterator2.next();
                    SystemDevice it = (SystemDevice)((Object)element$iv);
                    boolean bl = false;
                    this.mappings.remove(it);
                }
                $this$forEach$iv = presentDevices;
                Console console = this.this$0;
                boolean $i$f$forEach2 = false;
                Iterator<T> iterator3 = $this$forEach$iv.iterator();
                while (iterator3.hasNext()) {
                    T element$iv2 = iterator3.next();
                    SystemDevice it = (SystemDevice)element$iv2;
                    boolean bl = false;
                    tabs.6.opened$addDevice(this, console, it);
                }
                return false;
            }

            public void closed() {
                block1: {
                    EventListener eventListener = this.addEvent;
                    if (eventListener != null) {
                        eventListener.teardown();
                    }
                    EventListener eventListener2 = this.removeEvent;
                    if (eventListener2 == null) break block1;
                    eventListener2.teardown();
                }
            }

            private static final void opened$addDevice(tabs.6 this$0, Console this$1, SystemDevice device) {
                if (((Map)this$0.mappings).containsKey(device)) {
                    return;
                }
                String friendlyName = ((SystemDeviceFriendlyNameFeature)FeatureProvider.get$default(device, SystemDeviceFeatures.INSTANCE.getFRIENDLY_NAME(), false, 2, null)).getName();
                SystemDeviceSerialPortNameFeature systemDeviceSerialPortNameFeature = (SystemDeviceSerialPortNameFeature)FeatureProvider.getOrNull$default(device, SystemDeviceFeatures.INSTANCE.getSERIAL_PORT_NAME(), false, 2, null);
                String serialPortName = systemDeviceSerialPortNameFeature != null ? systemDeviceSerialPortNameFeature.getName() : null;
                ContextTab newTab2 = new ContextTab(this$1, friendlyName, serialPortName, device){
                    private final ConsoleBank localBank;
                    final /* synthetic */ Console this$0;
                    final /* synthetic */ String $friendlyName;
                    final /* synthetic */ String $serialPortName;
                    final /* synthetic */ SystemDevice $device;
                    {
                        this.this$0 = $receiver;
                        this.$friendlyName = $friendlyName;
                        this.$serialPortName = $serialPortName;
                        this.$device = $device;
                        super($friendlyName, null, null, 4, null);
                        this.localBank = new ConsoleBank((Queue<ConsoleMessage>)$receiver.getMessageQueue());
                    }

                    public String getName() {
                        String string = this.this$0.getBank() == this.localBank ? "\u2717" : " ";
                        String string2 = this.$serialPortName;
                        if (string2 == null) {
                            string2 = "x";
                        }
                        return "[" + string + "] " + this.$friendlyName + " [" + string2 + "]";
                    }

                    public void setName(String string) {
                        Intrinsics.checkNotNullParameter(string, "_");
                    }

                    public boolean opened() {
                        this.this$0.setBank(this.localBank);
                        Pair<IODevice, List<OpenIODeviceFeatureIdentifier>> pair = ((SystemDeviceIODeviceFeature)FeatureProvider.get$default(this.$device, SystemDeviceFeatures.INSTANCE.getIO_DEVICE(), false, 2, null)).open(new OpenIODeviceFeatureIdentifier[0]);
                        Intrinsics.checkNotNull(pair);
                        IODevice device = pair.component1();
                        IODeviceReadFeature deviceRead = (IODeviceReadFeature)FeatureProvider.get$default(device, IODeviceFeatures.INSTANCE.getREAD(), false, 2, null);
                        Thread.ofPlatform().start(() -> tabs.opened.addDevice.newTab.1.opened$lambda$0(deviceRead, this));
                        return false;
                    }

                    private static final void opened$lambda$0(IODeviceReadFeature $deviceRead, tabs.opened.addDevice.newTab.1 this$0) {
                        byte[] buffer = new byte[512];
                        while (true) {
                            int read;
                            if ((read = IODeviceReadFeature.read$default($deviceRead, buffer, 0, 0, 6, null)) == 0) {
                                continue;
                            }
                            this$0.localBank.write(StringsKt.decodeToString$default(buffer, 0, read, false, 4, null));
                        }
                    }
                };
                ((Map)this$0.mappings).put(device, newTab2);
                this$0.getTabs().add(newTab2);
            }

            private static final Unit opened$lambda$0(tabs.6 this$0, Console this$1, SystemDevice it) {
                Intrinsics.checkNotNullParameter(it, "it");
                if (it.getType() != SystemDeviceType.SERIAL) {
                    return Unit.INSTANCE;
                }
                tabs.6.opened$addDevice(this$0, this$1, it);
                this$0.getRenderCallback().invoke();
                return Unit.INSTANCE;
            }

            private static final Unit opened$lambda$1(tabs.6 this$0, SystemDevice it) {
                Intrinsics.checkNotNullParameter(it, "it");
                if (it.getType() != SystemDeviceType.SERIAL) {
                    return Unit.INSTANCE;
                }
                Collection collection = this$0.getTabs();
                ContextTab contextTab = this$0.mappings.remove(it);
                TypeIntrinsics.asMutableCollection(collection).remove(contextTab);
                this$0.getRenderCallback().invoke();
                return Unit.INSTANCE;
            }
        }};
        contextTabArray[2] = new ContextTab("DEVICE", Character.valueOf('D'), contextTabArray2);
        this.tabs = CollectionsKt.listOf(contextTabArray);
        this.openTabs = new ContextTab[0];
    }

    @NotNull
    public final LinkedBlockingQueue<ConsoleMessage> getMessageQueue() {
        return this.messageQueue;
    }

    @NotNull
    public final DateTimeFormatter getClockFormat() {
        return this.clockFormat;
    }

    @NotNull
    public final String format(@NotNull Duration $this$format) {
        Intrinsics.checkNotNullParameter($this$format, "<this>");
        long seconds = $this$format.getSeconds();
        long minutes = seconds / (long)60;
        long hours = minutes / (long)60;
        long days = hours / (long)24;
        String string = "%02d:%02d:%02d:%02d";
        Object[] objectArray = new Object[]{days, hours % (long)24, minutes % (long)60, seconds % (long)60};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    @NotNull
    public final SystemUser getUser() {
        return this.user;
    }

    @NotNull
    public final String getUserName() {
        return this.userName;
    }

    @NotNull
    public final Instant getLogonTime() {
        return this.logonTime;
    }

    public final boolean getControlStatus() {
        return this.controlStatus;
    }

    public final void setControlStatus(boolean bl) {
        this.controlStatus = bl;
    }

    public final boolean getControlSpaceStatus() {
        return this.controlSpaceStatus;
    }

    public final void setControlSpaceStatus(boolean bl) {
        this.controlSpaceStatus = bl;
    }

    public final boolean getControlTabStatus() {
        return this.controlTabStatus;
    }

    public final void setControlTabStatus(boolean bl) {
        this.controlTabStatus = bl;
    }

    public final boolean getControlCrStatus() {
        return this.controlCrStatus;
    }

    public final void setControlCrStatus(boolean bl) {
        this.controlCrStatus = bl;
    }

    public final boolean getControlLfStatus() {
        return this.controlLfStatus;
    }

    public final void setControlLfStatus(boolean bl) {
        this.controlLfStatus = bl;
    }

    @NotNull
    public final String getControlSpace() {
        return this.controlSpace;
    }

    @NotNull
    public final String getControlTab() {
        return this.controlTab;
    }

    @NotNull
    public final String getControlCr() {
        return this.controlCr;
    }

    @NotNull
    public final String getControlLf() {
        return this.controlLf;
    }

    @NotNull
    public final String getControlEtx() {
        return this.controlEtx;
    }

    @NotNull
    public final GraphicsConsoleFeature getCui() {
        return this.cui;
    }

    @NotNull
    public final GraphicsConsoleIOFeature getCOut() {
        return this.cOut;
    }

    @NotNull
    public final IODevice getCOutDevice() {
        return this.cOutDevice;
    }

    @NotNull
    public final IODeviceWriteFeature getCOutWrite() {
        return this.cOutWrite;
    }

    @NotNull
    public final GraphicsConsoleIOFeature getCIn() {
        return this.cIn;
    }

    @NotNull
    public final GraphicsConsoleIOEventGetFeature getCInEvents() {
        return this.cInEvents;
    }

    @NotNull
    public final ConsoleBank getBank() {
        return this.bank;
    }

    public final void setBank(@NotNull ConsoleBank consoleBank) {
        Intrinsics.checkNotNullParameter(consoleBank, "<set-?>");
        this.bank = consoleBank;
    }

    @NotNull
    public final List<ContextTab> getTabs() {
        return this.tabs;
    }

    @NotNull
    public final ContextTab[] getOpenTabs() {
        return this.openTabs;
    }

    public final void setOpenTabs(@NotNull ContextTab[] contextTabArray) {
        Intrinsics.checkNotNullParameter(contextTabArray, "<set-?>");
        this.openTabs = contextTabArray;
    }

    public final void processTab(@NotNull ConsoleMessage.MouseInput mouse, @NotNull ContextTab tab, int depth) {
        Intrinsics.checkNotNullParameter(mouse, "mouse");
        Intrinsics.checkNotNullParameter(tab, "tab");
        if (!mouse.getCaptured() && !mouse.getDown() && mouse.getButton() == 0) {
            int n = tab.getX();
            int n2 = tab.getX() + tab.getW();
            int n3 = mouse.getX();
            boolean bl = n <= n3 ? n3 < n2 : false;
            if (bl && mouse.getY() == tab.getY()) {
                ContextTab[] contextTabArray;
                Console console = this;
                if (!Intrinsics.areEqual(ArraysKt.getOrNull(this.openTabs, depth), tab)) {
                    if (!tab.opened()) {
                        ContextTab[] contextTabArray2 = Arrays.copyOf(this.openTabs, depth + 1);
                        Intrinsics.checkNotNullExpressionValue(contextTabArray2, "copyOf(...)");
                        ContextTab[] newOpenTabs = contextTabArray2;
                        newOpenTabs[depth] = tab;
                        tab.getPopulate().invoke(tab.getTabs());
                        contextTabArray = newOpenTabs;
                    } else {
                        contextTabArray = this.openTabs;
                    }
                } else {
                    n2 = this.openTabs.length;
                    Console console2 = console;
                    for (int i = depth; i < n2; ++i) {
                        ContextTab tab2 = this.openTabs[i];
                        tab2.closed();
                        tab2.getTabs().clear();
                    }
                    console = console2;
                    ContextTab[] contextTabArray3 = Arrays.copyOf(this.openTabs, depth);
                    Intrinsics.checkNotNullExpressionValue(contextTabArray3, "copyOf(...)");
                    contextTabArray = contextTabArray3;
                }
                console.openTabs = contextTabArray;
                mouse.setCaptured(true);
            }
        }
    }

    @NotNull
    public final String renderTab(@NotNull ContextTab tab, int depth) {
        Intrinsics.checkNotNullParameter(tab, "tab");
        String it = StringsKt.padEnd$default(tab.getName(), tab.getW(), '\u0000', 2, null);
        boolean bl = false;
        String tabName = tab.getSelectChar() != null ? StringsKt.replace$default(it, String.valueOf(tab.getSelectChar().charValue()), VT100DerivedConstantsKt.SET_ATTRIBUTE(VT100DGraphicsAttributes.UNDERLINE) + tab.getSelectChar() + VT100DerivedConstantsKt.SET_ATTRIBUTE(VT100DGraphicsAttributes.NO_UNDERLINE), false, 4, null) : it;
        String label = VT100DerivedConstantsKt.CURSOR_XY_POS-HQPci0I(UShort.constructor-impl((short)tab.getX()), UShort.constructor-impl((short)tab.getY())) + tabName;
        if (!Intrinsics.areEqual(ArraysKt.getOrNull(this.openTabs, depth), tab)) {
            return label;
        }
        return VT100DerivedConstantsKt.SET_ATTRIBUTE(VT100DGraphicsAttributes.INTENSE_BG_BLACK) + label + VT100DerivedConstantsKt.SET_ATTRIBUTE(VT100DGraphicsAttributes.BG_WHITE);
    }

    /*
     * WARNING - void declaration
     */
    public final void processTopLevel(@NotNull ConsoleMessage.WindowSize window, @NotNull ConsoleMessage.MouseInput mouse, int x, int y) {
        Intrinsics.checkNotNullParameter(window, "window");
        Intrinsics.checkNotNullParameter(mouse, "mouse");
        int tabsX = 0;
        tabsX = x;
        Iterable $this$forEach$iv = this.tabs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ContextTab it = (ContextTab)element$iv;
            boolean bl = false;
            it.setX(tabsX);
            it.setY(y);
            it.setW(it.getName().length());
            it.setRenderCallback(() -> Console.processTopLevel$lambda$0$0(window, mouse, this));
            this.processTab(mouse, it, 0);
            tabsX += it.getName().length() + 1;
        }
        int openTabsI = 0;
        while (ArraysKt.getIndices(this.openTabs).contains(openTabsI)) {
            Comparable comparable;
            ContextTab processTab = this.openTabs[openTabsI];
            Iterator bl = ((Iterable)processTab.getTabs()).iterator();
            if (!bl.hasNext()) {
                comparable = null;
            } else {
                ContextTab it = (ContextTab)bl.next();
                boolean bl2 = false;
                Object object = it.getName().length();
                while (bl.hasNext()) {
                    Object it2 = (ContextTab)bl.next();
                    $i$a$-maxOfOrNull-Console$processTopLevel$w$1 = false;
                    if (object.compareTo(it2 = (Comparable)Integer.valueOf(((ContextTab)it2).getName().length())) >= 0) continue;
                    object = it2;
                }
                comparable = object;
            }
            Integer n = (Integer)comparable;
            int w = n != null ? n : 0;
            Iterable $this$forEachIndexed$iv = processTab.getTabs();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void subTab;
                int n2;
                if ((n2 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                ContextTab contextTab = (ContextTab)item$iv;
                int iS = n2;
                boolean bl3 = false;
                subTab.setX(processTab.getX() + (openTabsI == 0 ? 0 : processTab.getName().length()));
                subTab.setY((openTabsI == 0 ? 2 : processTab.getY()) + iS);
                subTab.setW(w);
                subTab.setRenderCallback(() -> Console.processTopLevel$lambda$2$0(window, mouse, this));
                this.processTab(mouse, (ContextTab)subTab, openTabsI + 1);
            }
            int n3 = openTabsI;
            openTabsI = n3 + 1;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String renderTopLevel() {
        Object built = null;
        built = "";
        Iterable $this$forEach$iv = this.tabs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ContextTab it = (ContextTab)element$iv;
            boolean bl = false;
            built = built + this.renderTab(it, 0);
        }
        ContextTab[] $this$forEachIndexed$iv = this.openTabs;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (ContextTab item$iv : $this$forEachIndexed$iv) {
            void processTab;
            int n = index$iv++;
            ContextTab contextTab = item$iv;
            int i = n;
            boolean bl = false;
            Iterable $this$forEachIndexed$iv2 = processTab.getTabs();
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            for (Object item$iv2 : $this$forEachIndexed$iv2) {
                int n2;
                if ((n2 = index$iv2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                ContextTab subTab = (ContextTab)item$iv2;
                boolean bl2 = false;
                built = built + this.renderTab(subTab, i + 1);
            }
        }
        return built + VT100DerivedConstantsKt.CURSOR_XY_POS-HQPci0I(UShort.constructor-impl((short)CollectionsKt.last(this.tabs).getX()), UShort.constructor-impl((short)CollectionsKt.last(this.tabs).getY()));
    }

    public final void render(@NotNull ConsoleMessage.WindowSize window, @NotNull ConsoleMessage.MouseInput mouse) {
        Intrinsics.checkNotNullParameter(window, "window");
        Intrinsics.checkNotNullParameter(mouse, "mouse");
        if (!mouse.getWheel()) {
            this.processTopLevel(window, mouse, 2, 1);
        } else if (!mouse.getCaptured()) {
            mouse.setCaptured(true);
            this.bank.setLine(Math.max(mouse.getButton() == 0 ? this.bank.getLine() - 1 : this.bank.getLine() + 1, 0));
        }
        OffsetDateTime timeNow = OffsetDateTime.now();
        Duration uptime = Duration.of(((SystemGetUptimeFeature)FeatureProvider.get$default(SystemProvider.INSTANCE, SystemFeatures.INSTANCE.getGET_UPTIME_MS(), false, 2, null)).getUptime-s-VKNKU(), ChronoUnit.MILLIS);
        String string = this.clockFormat.format(timeNow);
        Intrinsics.checkNotNull(uptime);
        String timeStats = string + " " + this.format(uptime);
        Duration logonDuration = Duration.between(this.logonTime, Instant.now());
        Intrinsics.checkNotNull(logonDuration);
        String userStats = this.userName + " " + this.format(logonDuration);
        String string2 = VT100DerivedConstantsKt.SET_ATTRIBUTE(VT100DGraphicsAttributes.DEFAULT);
        String string3 = VT100DerivedConstantsKt.ERASE_SCREEN(VT100DEraseTypes.ALL);
        String string4 = VT100DerivedConstantsKt.CURSOR_XY_POS-HQPci0I((short)1, (short)2);
        String string5 = this.bank.render(window, this);
        String string6 = VT100DerivedConstantsKt.SET_ATTRIBUTE(VT100DGraphicsAttributes.BG_WHITE);
        String string7 = VT100DerivedConstantsKt.SET_ATTRIBUTE(VT100DGraphicsAttributes.FG_BLACK);
        String string8 = VT100DerivedConstantsKt.CURSOR_XY_POS-HQPci0I(UShort.constructor-impl((short)(window.getX() - timeStats.length())), (short)1);
        String string9 = VT100DerivedConstantsKt.ERASE_LINE(VT100DEraseTypes.ALL);
        String string10 = VT100DerivedConstantsKt.CURSOR_XY_POS-HQPci0I((short)1, UShort.constructor-impl((short)window.getY()));
        String string11 = VT100DerivedConstantsKt.ERASE_LINE(VT100DEraseTypes.ALL);
        int n = window.getX();
        int n2 = window.getY();
        String string12 = VT100DerivedConstantsKt.CURSOR_X_POS-xj2QHRw(UShort.constructor-impl((short)(window.getX() - userStats.length())));
        String string13 = VT100DerivedConstantsKt.CURSOR_XY_POS-HQPci0I((short)1, (short)1);
        String string14 = this.renderTopLevel();
        String buffer = "\u001b[?25l" + string2 + string3 + string4 + string5 + string6 + string7 + string8 + string9 + timeStats + string10 + string11 + " " + n + " x " + n2 + string12 + userStats + string13 + string14 + VT100DerivedConstantsKt.SET_ATTRIBUTE(switch (mouse.getButton()) {
            case 0 -> VT100DGraphicsAttributes.BG_GREEN;
            case 1 -> VT100DGraphicsAttributes.BG_YELLOW;
            case 2 -> VT100DGraphicsAttributes.BG_RED;
            default -> VT100DGraphicsAttributes.BG_BLUE;
        }) + VT100DerivedConstantsKt.CURSOR_XY_POS-HQPci0I(UShort.constructor-impl((short)mouse.getX()), UShort.constructor-impl((short)mouse.getY())) + VT100DerivedConstantsKt.ERASE_CHARACTERS-xj2QHRw((short)1);
        this.cOutWrite.write(buffer, Charsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit processTopLevel$lambda$0$0(ConsoleMessage.WindowSize $window, ConsoleMessage.MouseInput $mouse, Console this$0) {
        void $context-MouseInput;
        ConsoleMessage.MouseInput mouseInput = $mouse;
        ConsoleMessage.WindowSize windowSize = $window;
        boolean bl = false;
        this$0.render(windowSize, (ConsoleMessage.MouseInput)$context-MouseInput);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit processTopLevel$lambda$2$0(ConsoleMessage.WindowSize $window, ConsoleMessage.MouseInput $mouse, Console this$0) {
        void $context-MouseInput;
        ConsoleMessage.MouseInput mouseInput = $mouse;
        ConsoleMessage.WindowSize windowSize = $window;
        boolean bl = false;
        this$0.render(windowSize, (ConsoleMessage.MouseInput)$context-MouseInput);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\r\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0012\u001a\u00020\u0006H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR$\u0010\u000e\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00038V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lorg/bread_experts_group/project_incubator/console/Console$ToggleTab;", "Lorg/bread_experts_group/project_incubator/console/ContextTab;", "propertyName", "", "toggles", "Lkotlin/reflect/KMutableProperty;", "", "<init>", "(Ljava/lang/String;Lkotlin/reflect/KMutableProperty;)V", "getPropertyName", "()Ljava/lang/String;", "getToggles", "()Lkotlin/reflect/KMutableProperty;", "_", "name", "getName", "setName", "(Ljava/lang/String;)V", "opened", "bread_server_lib"})
    public static final class ToggleTab
    extends ContextTab {
        @NotNull
        private final String propertyName;
        @NotNull
        private final KMutableProperty<Boolean> toggles;

        public ToggleTab(@NotNull String propertyName, @NotNull KMutableProperty<Boolean> toggles) {
            Intrinsics.checkNotNullParameter(propertyName, "propertyName");
            Intrinsics.checkNotNullParameter(toggles, "toggles");
            super(propertyName, null, null, 4, null);
            this.propertyName = propertyName;
            this.toggles = toggles;
        }

        @NotNull
        public final String getPropertyName() {
            return this.propertyName;
        }

        @NotNull
        public final KMutableProperty<Boolean> getToggles() {
            return this.toggles;
        }

        @Override
        @NotNull
        public String getName() {
            return "[" + ((Boolean)this.toggles.getGetter().call(new Object[0]) != false ? "\u2717" : " ") + "] " + this.propertyName;
        }

        @Override
        public void setName(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "_");
        }

        @Override
        public boolean opened() {
            Object[] objectArray = new Object[]{(Boolean)this.toggles.getGetter().call(new Object[0]) == false};
            this.toggles.getSetter().call(objectArray);
            return true;
        }
    }
}

