/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.project_incubator.console;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bread_experts_group.project_incubator.console.Console;
import org.bread_experts_group.project_incubator.console.ConsoleMessage;
import org.bread_experts_group.protocol.vt100d.VT100DGraphicsAttributes;
import org.bread_experts_group.protocol.vt100d.VT100DerivedConstantsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tJ#\u0010\u0013\u001a\u00020\tR\u00020\u0014R\u00020\u0016j\u0006\u0010\u0015\u001a\u00020\u0014j\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0018J\u0006\u0010\u0019\u001a\u00020\u0011R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lorg/bread_experts_group/project_incubator/console/ConsoleBank;", "", "messageQueue", "Ljava/util/Queue;", "Lorg/bread_experts_group/project_incubator/console/ConsoleMessage;", "<init>", "(Ljava/util/Queue;)V", "panel", "", "", "line", "", "getLine", "()I", "setLine", "(I)V", "write", "", "str", "render", "Lorg/bread_experts_group/project_incubator/console/ConsoleMessage$WindowSize;", "window", "Lorg/bread_experts_group/project_incubator/console/Console;", "console", "(Lorg/bread_experts_group/project_incubator/console/ConsoleMessage$WindowSize;Lorg/bread_experts_group/project_incubator/console/Console;)Ljava/lang/String;", "clear", "bread_server_lib"})
public final class ConsoleBank {
    @NotNull
    private final Queue<ConsoleMessage> messageQueue;
    @NotNull
    private final List<String> panel;
    private int line;

    public ConsoleBank(@NotNull Queue<ConsoleMessage> messageQueue) {
        Intrinsics.checkNotNullParameter(messageQueue, "messageQueue");
        this.messageQueue = messageQueue;
        List list = Collections.synchronizedList(new ArrayList());
        Intrinsics.checkNotNullExpressionValue(list, "synchronizedList(...)");
        this.panel = list;
    }

    public final int getLine() {
        return this.line;
    }

    public final void setLine(int n) {
        this.line = n;
    }

    public final void write(@NotNull String str) {
        Intrinsics.checkNotNullParameter(str, "str");
        String string = CollectionsKt.removeLastOrNull(this.panel);
        if (string == null) {
            string = "";
        }
        Object storage = string;
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            char c = str.charAt(i);
            storage = (String)storage + c;
            if (c != '\n') continue;
            this.panel.addLast((String)storage);
            storage = "";
        }
        this.panel.addLast((String)storage);
        this.messageQueue.add(new ConsoleMessage.Refresh());
    }

    @NotNull
    public final String render(@NotNull ConsoleMessage.WindowSize window, @NotNull Console console) {
        Intrinsics.checkNotNullParameter(window, "window");
        Intrinsics.checkNotNullParameter(console, "console");
        Object rendered = "";
        int i = this.line;
        while (i + 3 - this.line <= window.getY() && i < this.panel.size()) {
            int etxLength;
            String rawLine = this.panel.get(i++);
            Object newLine = "";
            boolean containsLF = false;
            int n = rawLine.length();
            for (int j = 0; j < n; ++j) {
                char c = rawLine.charAt(j);
                if (console.getControlStatus()) {
                    if (console.getControlSpaceStatus() && c == ' ') {
                        newLine = (String)newLine + console.getControlSpace();
                        continue;
                    }
                    if (c == '\t') {
                        newLine = (String)newLine + (console.getControlTabStatus() ? console.getControlTab() : "    ");
                        continue;
                    }
                    if (console.getControlCrStatus() && c == '\r') {
                        newLine = (String)newLine + console.getControlCr();
                        continue;
                    }
                    if (c == '\n') {
                        if (console.getControlLfStatus()) {
                            newLine = (String)newLine + console.getControlLf();
                        }
                        containsLF = true;
                        continue;
                    }
                    newLine = (String)newLine + c;
                    continue;
                }
                if (c == '\t') {
                    newLine = (String)newLine + "    ";
                    continue;
                }
                if (c == '\n') {
                    containsLF = true;
                    continue;
                }
                if (c == '\r') continue;
                newLine = (String)newLine + c;
            }
            int n2 = etxLength = i >= this.panel.size() ? ((String)newLine).length() + 1 : ((String)newLine).length();
            newLine = etxLength > window.getX() ? StringsKt.take((String)newLine, window.getX() - 1) + VT100DerivedConstantsKt.SET_ATTRIBUTE(VT100DGraphicsAttributes.FG_YELLOW) + ">" + VT100DerivedConstantsKt.SET_ATTRIBUTE(VT100DGraphicsAttributes.FG_DEFAULT) : (i >= this.panel.size() && etxLength <= window.getX() ? (String)newLine + console.getControlEtx() : StringsKt.take((String)newLine, window.getX()));
            rendered = (String)rendered + (String)newLine + (containsLF ? Character.valueOf('\n') : "");
            if (i < this.panel.size()) continue;
            break;
        }
        return rendered;
    }

    public final void clear() {
        this.panel.clear();
    }
}

