/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.computer;

import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UninitializedPropertyAccessException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bread_experts_group.FormattingKt;
import org.bread_experts_group.api.computer.BIOSProvider;
import org.bread_experts_group.api.computer.BinaryUtil;
import org.bread_experts_group.api.computer.MemoryModule;
import org.bread_experts_group.api.computer.Processor;
import org.bread_experts_group.api.computer.SimulationSteppable;
import org.bread_experts_group.api.computer.disc.ISO9660BootRecord;
import org.bread_experts_group.api.computer.disc.ISO9660Disc;
import org.bread_experts_group.api.computer.disc.ISO9660PrimaryVolume;
import org.bread_experts_group.api.computer.disc.ISO9660VolumeDescriptor;
import org.bread_experts_group.api.computer.ia32.IA32Processor;
import org.bread_experts_group.api.computer.ia32.bios.Read;
import org.bread_experts_group.api.computer.io.BreadModPollingVirtualKeyboard;
import org.bread_experts_group.api.computer.io.IODevice;
import org.bread_experts_group.api.computer.io.ProgrammableInterruptTimer;
import org.bread_experts_group.io.reader.ReadingByteBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0015\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020!\u00a2\u0006\u0004\b'\u0010(J\u0015\u0010)\u001a\u00020*2\u0006\u0010&\u001a\u00020!\u00a2\u0006\u0004\b+\u0010,J\u001d\u0010-\u001a\u00020.2\u0006\u0010&\u001a\u00020!2\u0006\u0010/\u001a\u00020*\u00a2\u0006\u0004\b0\u00101J\u001d\u00102\u001a\u00020.2\u0006\u0010&\u001a\u00020!2\u0006\u00103\u001a\u00020\u0017\u00a2\u0006\u0004\b4\u00105J\u001d\u00106\u001a\u00020.2\u0006\u0010&\u001a\u00020!2\u0006\u00103\u001a\u000207\u00a2\u0006\u0004\b8\u00109J\u0015\u0010:\u001a\u0002072\u0006\u0010&\u001a\u00020!\u00a2\u0006\u0004\b;\u0010<J\u0015\u0010=\u001a\u00020\u00172\u0006\u0010&\u001a\u00020!\u00a2\u0006\u0004\b>\u0010?J\u0015\u0010@\u001a\u00020!2\u0006\u0010&\u001a\u00020!\u00a2\u0006\u0004\bA\u0010BJ\u000e\u0010Y\u001a\u00020.2\u0006\u0010Z\u001a\u00020PJ\b\u0010c\u001a\u00020.H\u0016J\b\u0010d\u001a\u00020.H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR-\u0010\u001f\u001a\u001e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00040 j\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u0004`\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\"\u0010D\u001a\u0004\u0018\u00010C2\b\u00103\u001a\u0004\u0018\u00010C@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010FR\"\u0010H\u001a\u0004\u0018\u00010G2\b\u00103\u001a\u0004\u0018\u00010G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010JR\"\u0010L\u001a\u0004\u0018\u00010K2\b\u00103\u001a\u0004\u0018\u00010K@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010NR\u001c\u0010O\u001a\u0004\u0018\u00010PX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010R\"\u0004\bS\u0010TR\u0011\u0010U\u001a\u00020V8F\u00a2\u0006\u0006\u001a\u0004\bW\u0010XR'\u0010[\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020^\u0012\u0004\u0012\u00020_\u0018\u00010]0\\\u00a2\u0006\n\n\u0002\u0010b\u001a\u0004\b`\u0010a\u00a8\u0006e"}, d2={"Lorg/bread_experts_group/api/computer/Computer;", "Lorg/bread_experts_group/api/computer/SimulationSteppable;", "memory", "", "Lorg/bread_experts_group/api/computer/MemoryModule;", "processor", "Lorg/bread_experts_group/api/computer/Processor;", "bios", "Lorg/bread_experts_group/api/computer/BIOSProvider;", "<init>", "(Ljava/util/List;Lorg/bread_experts_group/api/computer/Processor;Lorg/bread_experts_group/api/computer/BIOSProvider;)V", "getMemory", "()Ljava/util/List;", "getProcessor", "()Lorg/bread_experts_group/api/computer/Processor;", "getBios", "()Lorg/bread_experts_group/api/computer/BIOSProvider;", "keyboard", "Lorg/bread_experts_group/api/computer/io/BreadModPollingVirtualKeyboard;", "getKeyboard", "()Lorg/bread_experts_group/api/computer/io/BreadModPollingVirtualKeyboard;", "ioMap", "", "Lkotlin/UInt;", "Lorg/bread_experts_group/api/computer/io/IODevice;", "getIoMap", "()Ljava/util/Map;", "getIODevice", "n", "getIODevice-WZ4Q5Ns", "(I)Lorg/bread_experts_group/api/computer/io/IODevice;", "busCache", "Ljava/util/LinkedHashMap;", "Lkotlin/ULong;", "Lkotlin/collections/LinkedHashMap;", "getBusCache", "()Ljava/util/LinkedHashMap;", "getResponsibleModule", "address", "getResponsibleModule-VKZWuLQ", "(J)Lorg/bread_experts_group/api/computer/MemoryModule;", "getMemoryAt", "Lkotlin/UByte;", "getMemoryAt-NsiRcpg", "(J)B", "setMemoryAt", "", "data", "setMemoryAt-RFc766c", "(JB)V", "setMemoryAt32", "value", "setMemoryAt32-8GdB7C8", "(JI)V", "setMemoryAt16", "Lkotlin/UShort;", "setMemoryAt16-E2t620U", "(JS)V", "getMemoryAt16", "getMemoryAt16-ZO3KGMw", "(J)S", "getMemoryAt32", "getMemoryAt32--4l20Xc", "(J)I", "getMemoryAt64", "getMemoryAt64-PUiSbYQ", "(J)J", "Lorg/bread_experts_group/api/computer/disc/ISO9660PrimaryVolume;", "discPrimaryVolume", "getDiscPrimaryVolume", "()Lorg/bread_experts_group/api/computer/disc/ISO9660PrimaryVolume;", "Lorg/bread_experts_group/api/computer/disc/ISO9660BootRecord;", "discBoot", "getDiscBoot", "()Lorg/bread_experts_group/api/computer/disc/ISO9660BootRecord;", "Lorg/bread_experts_group/api/computer/disc/ISO9660Disc;", "disc", "getDisc", "()Lorg/bread_experts_group/api/computer/disc/ISO9660Disc;", "discURL", "Ljava/net/URL;", "getDiscURL", "()Ljava/net/URL;", "setDiscURL", "(Ljava/net/URL;)V", "discStream", "Ljava/io/InputStream;", "getDiscStream", "()Ljava/io/InputStream;", "insertDisc", "at", "floppies", "", "Lkotlin/Pair;", "Ljava/nio/channels/SeekableByteChannel;", "Lorg/bread_experts_group/api/computer/ia32/bios/Read$FloppyGeometry;", "getFloppies", "()[Lkotlin/Pair;", "[Lkotlin/Pair;", "reset", "step", "bread_server_lib"})
@SourceDebugExtension(value={"SMAP\nComputer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Computer.kt\norg/bread_experts_group/api/computer/Computer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,142:1\n382#2,7:143\n1#3:150\n1869#4,2:151\n*S KotlinDebug\n*F\n+ 1 Computer.kt\norg/bread_experts_group/api/computer/Computer\n*L\n51#1:143,7\n134#1:151,2\n*E\n"})
public final class Computer
implements SimulationSteppable {
    @NotNull
    private final List<MemoryModule> memory;
    @NotNull
    private final Processor processor;
    @NotNull
    private final BIOSProvider bios;
    @NotNull
    private final BreadModPollingVirtualKeyboard keyboard;
    @NotNull
    private final Map<UInt, IODevice> ioMap;
    @NotNull
    private final LinkedHashMap<ULong, MemoryModule> busCache;
    @Nullable
    private ISO9660PrimaryVolume discPrimaryVolume;
    @Nullable
    private ISO9660BootRecord discBoot;
    @Nullable
    private ISO9660Disc disc;
    @Nullable
    private URL discURL;
    @NotNull
    private final Pair<SeekableByteChannel, Read.FloppyGeometry>[] floppies;

    public Computer(@NotNull List<MemoryModule> memory, @NotNull Processor processor, @NotNull BIOSProvider bios) {
        Intrinsics.checkNotNullParameter(memory, "memory");
        Intrinsics.checkNotNullParameter(processor, "processor");
        Intrinsics.checkNotNullParameter(bios, "bios");
        this.memory = memory;
        this.processor = processor;
        this.bios = bios;
        this.keyboard = new BreadModPollingVirtualKeyboard();
        Pair[] pairArray = new Pair[]{TuplesKt.to(UInt.box-impl(64), new ProgrammableInterruptTimer())};
        this.ioMap = MapsKt.mutableMapOf(pairArray);
        this.busCache = new LinkedHashMap<ULong, MemoryModule>(){

            protected boolean removeEldestEntry(Map.Entry<ULong, MemoryModule> eldest) {
                Intrinsics.checkNotNullParameter(eldest, "eldest");
                return this.size() > 512;
            }
        };
        this.floppies = new Pair[4];
    }

    @NotNull
    public final List<MemoryModule> getMemory() {
        return this.memory;
    }

    @NotNull
    public final Processor getProcessor() {
        return this.processor;
    }

    @NotNull
    public final BIOSProvider getBios() {
        return this.bios;
    }

    @NotNull
    public final BreadModPollingVirtualKeyboard getKeyboard() {
        return this.keyboard;
    }

    @NotNull
    public final Map<UInt, IODevice> getIoMap() {
        return this.ioMap;
    }

    @NotNull
    public final IODevice getIODevice-WZ4Q5Ns(int n) {
        IODevice iODevice = this.ioMap.get(UInt.box-impl(n));
        if (iODevice == null) {
            Computer $this$getIODevice_WZ4Q5Ns_u24lambda_u240 = this;
            boolean bl = false;
            Processor processor = $this$getIODevice_WZ4Q5Ns_u24lambda_u240.processor;
            Intrinsics.checkNotNull(processor, "null cannot be cast to non-null type org.bread_experts_group.api.computer.ia32.IA32Processor");
            ((IA32Processor)processor).getLogger().info("Access to unknown I/O device " + FormattingKt.hex-WZ4Q5Ns(n));
            iODevice = new IODevice(){

                public byte read-Wa3L5BU(Computer computer) {
                    Intrinsics.checkNotNullParameter(computer, "computer");
                    return 0;
                }

                public void write-EK-6454(Computer computer, byte d) {
                    Intrinsics.checkNotNullParameter(computer, "computer");
                }
            };
        }
        return iODevice;
    }

    @NotNull
    public final LinkedHashMap<ULong, MemoryModule> getBusCache() {
        return this.busCache;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MemoryModule getResponsibleModule-VKZWuLQ(long address) {
        Object object;
        void $this$getOrPut$iv;
        Map map = this.busCache;
        ULong key$iv = ULong.box-impl(address);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            MemoryModule module;
            block4: {
                boolean bl = false;
                int n = ((Collection)this.memory).size();
                for (int i = 0; i < n; ++i) {
                    long memoryAddress;
                    module = this.memory.get(i);
                    ULong uLong = module.getEffectiveAddress-6VbMDqA();
                    long l = memoryAddress = uLong != null ? uLong.unbox-impl() : 0L;
                    if (Long.compareUnsigned(address, memoryAddress) < 0 || Long.compareUnsigned(address, ULong.constructor-impl(memoryAddress + ULong.constructor-impl((long)module.getCapacity-pVg5ArA() & 0xFFFFFFFFL))) >= 0) {
                        continue;
                    }
                    break block4;
                }
                throw new IndexOutOfBoundsException("Memory address out of bounds, " + ULong.toString-impl(address));
            }
            MemoryModule answer$iv = module;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (MemoryModule)object;
    }

    public final byte getMemoryAt-NsiRcpg(long address) {
        MemoryModule module = this.getResponsibleModule-VKZWuLQ(address);
        ULong uLong = module.getEffectiveAddress-6VbMDqA();
        long l = uLong != null ? uLong.unbox-impl() : 0L;
        return module.get-Wa3L5BU((int)ULong.constructor-impl(address - l));
    }

    public final void setMemoryAt-RFc766c(long address, byte data) {
        MemoryModule module = this.getResponsibleModule-VKZWuLQ(address);
        ULong uLong = module.getEffectiveAddress-6VbMDqA();
        long l = uLong != null ? uLong.unbox-impl() : 0L;
        module.set-EK-6454((int)ULong.constructor-impl(address - l), data);
    }

    public final void setMemoryAt32-8GdB7C8(long address, int value) {
        this.setMemoryAt-RFc766c(address, UByte.constructor-impl((byte)UInt.constructor-impl(value & 0xFF)));
        this.setMemoryAt-RFc766c(ULong.constructor-impl(address + ULong.constructor-impl(1L & 0xFFFFFFFFL)), UByte.constructor-impl((byte)UInt.constructor-impl(UInt.constructor-impl(value >>> 8) & 0xFF)));
        this.setMemoryAt-RFc766c(ULong.constructor-impl(address + ULong.constructor-impl((long)2 & 0xFFFFFFFFL)), UByte.constructor-impl((byte)UInt.constructor-impl(UInt.constructor-impl(value >>> 16) & 0xFF)));
        this.setMemoryAt-RFc766c(ULong.constructor-impl(address + ULong.constructor-impl((long)3 & 0xFFFFFFFFL)), UByte.constructor-impl((byte)UInt.constructor-impl(UInt.constructor-impl(value >>> 24) & 0xFF)));
    }

    public final void setMemoryAt16-E2t620U(long address, short value) {
        int v = UInt.constructor-impl(value & 0xFFFF);
        this.setMemoryAt-RFc766c(address, UByte.constructor-impl((byte)UInt.constructor-impl(v & 0xFF)));
        this.setMemoryAt-RFc766c(ULong.constructor-impl(address + ULong.constructor-impl(1L & 0xFFFFFFFFL)), UByte.constructor-impl((byte)UInt.constructor-impl(UInt.constructor-impl(v >>> 8) & 0xFF)));
    }

    public final short getMemoryAt16-ZO3KGMw(long address) {
        Ref.IntRef offset = new Ref.IntRef();
        offset.element = 0;
        return BinaryUtil.INSTANCE.read16-BwKQO78(() -> Computer.getMemoryAt16_ZO3KGMw$lambda$2(this, address, offset));
    }

    public final int getMemoryAt32--4l20Xc(long address) {
        Ref.IntRef offset = new Ref.IntRef();
        offset.element = 0;
        return BinaryUtil.INSTANCE.read32-OGnWXxg(() -> Computer.getMemoryAt32__4l20Xc$lambda$3(this, address, offset));
    }

    public final long getMemoryAt64-PUiSbYQ(long address) {
        Ref.IntRef offset = new Ref.IntRef();
        offset.element = 0;
        return BinaryUtil.INSTANCE.read64-I7RO_PI(() -> Computer.getMemoryAt64_PUiSbYQ$lambda$4(this, address, offset));
    }

    @Nullable
    public final ISO9660PrimaryVolume getDiscPrimaryVolume() {
        return this.discPrimaryVolume;
    }

    @Nullable
    public final ISO9660BootRecord getDiscBoot() {
        return this.discBoot;
    }

    @Nullable
    public final ISO9660Disc getDisc() {
        return this.disc;
    }

    @Nullable
    public final URL getDiscURL() {
        return this.discURL;
    }

    public final void setDiscURL(@Nullable URL uRL) {
        this.discURL = uRL;
    }

    @NotNull
    public final InputStream getDiscStream() {
        if (this.discURL == null) {
            throw new UninitializedPropertyAccessException("Disc URL is not set");
        }
        URL uRL = this.discURL;
        Intrinsics.checkNotNull(uRL);
        InputStream inputStream = uRL.openStream();
        Intrinsics.checkNotNullExpressionValue(inputStream, "openStream(...)");
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void insertDisc(@NotNull URL at) {
        Intrinsics.checkNotNullParameter(at, "at");
        Closeable closeable = Channels.newChannel(at.openStream());
        Throwable throwable = null;
        try {
            ISO9660BootRecord iSO9660BootRecord;
            ISO9660VolumeDescriptor primary;
            ISO9660Disc newDisc;
            block9: {
                ISO9660VolumeDescriptor iSO9660VolumeDescriptor;
                block8: {
                    ReadableByteChannel it = (ReadableByteChannel)closeable;
                    boolean bl = false;
                    Intrinsics.checkNotNull(it);
                    ByteBuffer byteBuffer = ByteBuffer.allocate(32768);
                    Intrinsics.checkNotNullExpressionValue(byteBuffer, "allocate(...)");
                    ReadingByteBuffer reading = new ReadingByteBuffer(it, byteBuffer, null);
                    newDisc = ISO9660Disc.Companion.getLayout().read(reading);
                    for (ISO9660VolumeDescriptor v : (Iterable)newDisc.getVolumeDescriptors()) {
                        boolean bl2 = false;
                        if ((v = v instanceof ISO9660PrimaryVolume ? (ISO9660PrimaryVolume)v : null) == null) continue;
                        iSO9660VolumeDescriptor = v;
                        break block8;
                    }
                    iSO9660VolumeDescriptor = null;
                }
                if (iSO9660VolumeDescriptor == null) {
                    throw new IllegalArgumentException("Disc is invalid: no primary volume");
                }
                primary = iSO9660VolumeDescriptor;
                for (ISO9660VolumeDescriptor v : (Iterable)newDisc.getVolumeDescriptors()) {
                    boolean bl = false;
                    ISO9660BootRecord iSO9660BootRecord2 = v instanceof ISO9660BootRecord ? (ISO9660BootRecord)v : null;
                    if (iSO9660BootRecord2 == null) continue;
                    iSO9660BootRecord = iSO9660BootRecord2;
                    break block9;
                }
                iSO9660BootRecord = null;
            }
            ISO9660BootRecord bootRecord = iSO9660BootRecord;
            this.disc = newDisc;
            this.discPrimaryVolume = primary;
            this.discBoot = bootRecord;
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        this.discURL = at;
    }

    @NotNull
    public final Pair<SeekableByteChannel, Read.FloppyGeometry>[] getFloppies() {
        return this.floppies;
    }

    @Override
    public void reset() {
        Iterable $this$forEach$iv = this.memory;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MemoryModule it = (MemoryModule)element$iv;
            boolean bl = false;
            it.erase();
        }
        this.bios.initialize(this);
        this.processor.reset();
    }

    @Override
    public void step() {
        this.processor.step();
    }

    private static final UByte getMemoryAt16_ZO3KGMw$lambda$2(Computer this$0, long $address, Ref.IntRef $offset) {
        int n = $offset.element;
        $offset.element = UInt.constructor-impl(n + 1);
        return UByte.box-impl(this$0.getMemoryAt-NsiRcpg(ULong.constructor-impl($address + ULong.constructor-impl((long)n & 0xFFFFFFFFL))));
    }

    private static final UByte getMemoryAt32__4l20Xc$lambda$3(Computer this$0, long $address, Ref.IntRef $offset) {
        int n = $offset.element;
        $offset.element = UInt.constructor-impl(n + 1);
        return UByte.box-impl(this$0.getMemoryAt-NsiRcpg(ULong.constructor-impl($address + ULong.constructor-impl((long)n & 0xFFFFFFFFL))));
    }

    private static final UByte getMemoryAt64_PUiSbYQ$lambda$4(Computer this$0, long $address, Ref.IntRef $offset) {
        int n = $offset.element;
        $offset.element = UInt.constructor-impl(n + 1);
        return UByte.box-impl(this$0.getMemoryAt-NsiRcpg(ULong.constructor-impl($address + ULong.constructor-impl((long)n & 0xFFFFFFFFL))));
    }
}

