/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.computer.arm.v4;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import kotlin.text.StringsKt;
import kotlin.text.UStringsKt;
import org.bread_experts_group.FormattingKt;
import org.bread_experts_group.api.computer.Computer;
import org.bread_experts_group.api.computer.Processor;
import org.bread_experts_group.api.computer.arm.v4.ARMv4Processor;
import org.bread_experts_group.api.computer.arm.v4.instruction.InstructionConditionalExecutionSuffix;
import org.bread_experts_group.api.computer.arm.v4.register.Register;
import org.bread_experts_group.api.computer.arm.v4.register.StatusRegister;
import org.bread_experts_group.logging.ColoredHandler;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\r\u0010\u001f\u001a\u00020 \u00a2\u0006\u0004\b!\u0010\"J\r\u0010#\u001a\u00020$\u00a2\u0006\u0004\b%\u0010&J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*J\u001d\u0010+\u001a\u00020(2\u0006\u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020$\u00a2\u0006\u0004\b.\u0010/J\u001d\u00100\u001a\u00020(2\u0006\u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020$\u00a2\u0006\u0004\b1\u0010/J\u0015\u00102\u001a\u0002032\u0006\u00104\u001a\u00020 \u00a2\u0006\u0004\b5\u00106J\u0015\u00107\u001a\u0002032\u0006\u00104\u001a\u00020$\u00a2\u0006\u0004\b8\u00109J\u0006\u0010E\u001a\u00020\u001eJ\b\u0010F\u001a\u00020\u001eH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0019\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0010\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR)\u0010:\u001a\u001a\u0012\u0004\u0012\u00020$\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001e0<0;\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u001a\u0010?\u001a\u00020@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010B\"\u0004\bC\u0010D\u00a8\u0006G"}, d2={"Lorg/bread_experts_group/api/computer/arm/v4/ARMv4Processor;", "Lorg/bread_experts_group/api/computer/Processor;", "<init>", "()V", "computer", "Lorg/bread_experts_group/api/computer/Computer;", "getComputer", "()Lorg/bread_experts_group/api/computer/Computer;", "setComputer", "(Lorg/bread_experts_group/api/computer/Computer;)V", "registers", "", "Lorg/bread_experts_group/api/computer/arm/v4/register/Register;", "getRegisters", "()[Lorg/bread_experts_group/api/computer/arm/v4/register/Register;", "[Lorg/bread_experts_group/api/computer/arm/v4/register/Register;", "lr", "getLr", "()Lorg/bread_experts_group/api/computer/arm/v4/register/Register;", "pc", "getPc", "status", "Lorg/bread_experts_group/api/computer/arm/v4/register/StatusRegister;", "getStatus", "()Lorg/bread_experts_group/api/computer/arm/v4/register/StatusRegister;", "logger", "Ljava/util/logging/Logger;", "getLogger", "()Ljava/util/logging/Logger;", "step", "", "fetchThumb", "Lkotlin/UShort;", "fetchThumb-Mh2AYeg", "()S", "fetchArm", "Lkotlin/UInt;", "fetchArm-pVg5ArA", "()I", "checkConditional", "", "cond", "Lorg/bread_experts_group/api/computer/arm/v4/instruction/InstructionConditionalExecutionSuffix;", "carryFrom", "n", "m", "carryFrom-feOb9K0", "(II)Z", "overflowFrom", "overflowFrom-feOb9K0", "decodeThumb", "", "fetched", "decodeThumb-xj2QHRw", "(S)Ljava/lang/String;", "decodeArm", "decodeArm-WZ4Q5Ns", "(I)Ljava/lang/String;", "biosHooks", "", "Lkotlin/Function1;", "getBiosHooks", "()Ljava/util/Map;", "halt", "Ljava/util/concurrent/CountDownLatch;", "getHalt", "()Ljava/util/concurrent/CountDownLatch;", "setHalt", "(Ljava/util/concurrent/CountDownLatch;)V", "prefetch", "reset", "bread_server_lib"})
@SourceDebugExtension(value={"SMAP\nARMv4Processor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ARMv4Processor.kt\norg/bread_experts_group/api/computer/arm/v4/ARMv4Processor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,422:1\n1#2:423\n13472#3,2:424\n*S KotlinDebug\n*F\n+ 1 ARMv4Processor.kt\norg/bread_experts_group/api/computer/arm/v4/ARMv4Processor\n*L\n418#1:424,2\n*E\n"})
public final class ARMv4Processor
implements Processor {
    public Computer computer;
    @NotNull
    private final Register[] registers;
    @NotNull
    private final Register lr;
    @NotNull
    private final Register pc;
    @NotNull
    private final StatusRegister status;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Map<UInt, Function1<ARMv4Processor, Unit>> biosHooks;
    @NotNull
    private CountDownLatch halt;

    public ARMv4Processor() {
        Register[] registerArray = new Register[]{new Register("r0", 0, null), new Register("r1", 0, null), new Register("r2", 0, null), new Register("r3", 0, null), new Register("r4", 0, null), new Register("r5", 0, null), new Register("r6", 0, null), new Register("r7", 0, null), new Register("r8", 0, null), new Register("r9", 0, null), new Register("r10", 0, null), new Register("r11", 0, null), new Register("r12", 0, null), new Register("sp", 0, null), new Register("lr", 0, null), new Register("pc", 0, null)};
        this.registers = registerArray;
        this.lr = this.registers[14];
        this.pc = this.registers[15];
        this.status = new StatusRegister();
        this.logger = ColoredHandler.Companion.newLoggerResourced$default(ColoredHandler.Companion, "arm_v4_processor", null, 2, null);
        this.biosHooks = new LinkedHashMap();
        this.halt = new CountDownLatch(1);
    }

    @Override
    @NotNull
    public Computer getComputer() {
        Computer computer = this.computer;
        if (computer != null) {
            return computer;
        }
        Intrinsics.throwUninitializedPropertyAccessException("computer");
        return null;
    }

    @Override
    public void setComputer(@NotNull Computer computer) {
        Intrinsics.checkNotNullParameter(computer, "<set-?>");
        this.computer = computer;
    }

    @NotNull
    public final Register[] getRegisters() {
        return this.registers;
    }

    @NotNull
    public final Register getLr() {
        return this.lr;
    }

    @NotNull
    public final Register getPc() {
        return this.pc;
    }

    @NotNull
    public final StatusRegister getStatus() {
        return this.status;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @Override
    public void step() {
        this.prefetch();
        String log = this.status.getFlag(StatusRegister.FlagType.THUMB_MODE) ? this.decodeThumb-xj2QHRw(this.fetchThumb-Mh2AYeg()) : this.decodeArm-WZ4Q5Ns(this.fetchArm-pVg5ArA());
        this.logger.info(log);
    }

    public final short fetchThumb-Mh2AYeg() {
        short s;
        short it = s = this.getComputer().getMemoryAt16-ZO3KGMw(ULong.constructor-impl(ULong.constructor-impl((long)this.pc.getValue-pVg5ArA() & 0xFFFFFFFFL) - ULong.constructor-impl((long)4 & 0xFFFFFFFFL)));
        boolean bl = false;
        Register register2 = this.pc;
        register2.setValue-WZ4Q5Ns(UInt.constructor-impl(register2.getValue-pVg5ArA() + 2));
        return s;
    }

    public final int fetchArm-pVg5ArA() {
        int n;
        int it = n = this.getComputer().getMemoryAt32--4l20Xc(ULong.constructor-impl(ULong.constructor-impl((long)this.pc.getValue-pVg5ArA() & 0xFFFFFFFFL) - ULong.constructor-impl((long)8 & 0xFFFFFFFFL)));
        boolean bl = false;
        Register register2 = this.pc;
        register2.setValue-WZ4Q5Ns(UInt.constructor-impl(register2.getValue-pVg5ArA() + 4));
        return n;
    }

    public final boolean checkConditional(@NotNull InstructionConditionalExecutionSuffix cond) {
        Intrinsics.checkNotNullParameter((Object)cond, "cond");
        return switch (WhenMappings.$EnumSwitchMapping$0[cond.ordinal()]) {
            case 1 -> this.status.getFlag(StatusRegister.FlagType.ZERO);
            case 2 -> {
                if (!this.status.getFlag(StatusRegister.FlagType.ZERO)) {
                    yield true;
                }
                yield false;
            }
            case 3 -> this.status.getFlag(StatusRegister.FlagType.CARRY);
            case 4 -> {
                if (!this.status.getFlag(StatusRegister.FlagType.CARRY)) {
                    yield true;
                }
                yield false;
            }
            case 5 -> this.status.getFlag(StatusRegister.FlagType.NEGATIVE);
            case 6 -> {
                if (!this.status.getFlag(StatusRegister.FlagType.NEGATIVE)) {
                    yield true;
                }
                yield false;
            }
            case 7 -> this.status.getFlag(StatusRegister.FlagType.OVERFLOW);
            case 8 -> {
                if (!this.status.getFlag(StatusRegister.FlagType.OVERFLOW)) {
                    yield true;
                }
                yield false;
            }
            case 9 -> {
                if (this.status.getFlag(StatusRegister.FlagType.CARRY) && !this.status.getFlag(StatusRegister.FlagType.ZERO)) {
                    yield true;
                }
                yield false;
            }
            case 10 -> {
                if (!this.status.getFlag(StatusRegister.FlagType.CARRY) || this.status.getFlag(StatusRegister.FlagType.ZERO)) {
                    yield true;
                }
                yield false;
            }
            case 11 -> {
                if (this.status.getFlag(StatusRegister.FlagType.NEGATIVE) == this.status.getFlag(StatusRegister.FlagType.OVERFLOW)) {
                    yield true;
                }
                yield false;
            }
            case 12 -> {
                if (this.status.getFlag(StatusRegister.FlagType.NEGATIVE) != this.status.getFlag(StatusRegister.FlagType.OVERFLOW)) {
                    yield true;
                }
                yield false;
            }
            case 13 -> {
                if (!this.status.getFlag(StatusRegister.FlagType.ZERO) && this.status.getFlag(StatusRegister.FlagType.NEGATIVE) == this.status.getFlag(StatusRegister.FlagType.OVERFLOW)) {
                    yield true;
                }
                yield false;
            }
            case 14 -> {
                if (this.status.getFlag(StatusRegister.FlagType.ZERO) || this.status.getFlag(StatusRegister.FlagType.NEGATIVE) != this.status.getFlag(StatusRegister.FlagType.OVERFLOW)) {
                    yield true;
                }
                yield false;
            }
            case 15 -> true;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final boolean carryFrom-feOb9K0(int n, int m) {
        return Long.compareUnsigned(ULong.constructor-impl(ULong.constructor-impl((long)n & 0xFFFFFFFFL) + ULong.constructor-impl((long)m & 0xFFFFFFFFL)), ULong.constructor-impl((long)-1 & 0xFFFFFFFFL)) > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean overflowFrom-feOb9K0(int n, int m) {
        if (UInt.constructor-impl(UInt.constructor-impl(n ^ m) & Integer.MIN_VALUE) != 0) return false;
        if (UInt.constructor-impl(UInt.constructor-impl(n ^ UInt.constructor-impl(n + m)) & Integer.MIN_VALUE) == 0) return false;
        return true;
    }

    @NotNull
    public final String decodeThumb-xj2QHRw(short fetched) {
        StringBuilder disassembly = new StringBuilder(FormattingKt.hex-WZ4Q5Ns(UInt.constructor-impl(this.pc.getValue-pVg5ArA() - 2)));
        disassembly.append(":[");
        disassembly.append(StringsKt.padStart(UStringsKt.toString-olVBNx4(fetched, 2), 16, '0'));
        disassembly.append('/');
        disassembly.append(FormattingKt.hex-xj2QHRw(fetched));
        disassembly.append(']');
        int extFetched = UInt.constructor-impl(fetched & 0xFFFF);
        switch (UInt.constructor-impl(UInt.constructor-impl(extFetched >>> 13) & 7)) {
            case 0: {
                int maskA = UInt.constructor-impl(extFetched & 0x1C00);
                if (maskA == 6144) {
                    String string = "Add/sub reg " + disassembly;
                    throw new NotImplementedError("An operation is not implemented: " + string);
                }
                if (maskA == 7168) {
                    Register rd = this.registers[UInt.constructor-impl(extFetched & 7)];
                    Register rn = this.registers[UInt.constructor-impl(UInt.constructor-impl(extFetched >>> 3) & 7)];
                    int imm = UInt.constructor-impl(UInt.constructor-impl(extFetched >>> 6) & 7);
                    if (UInt.constructor-impl(UInt.constructor-impl(maskA >>> 9) & 1) == 1) {
                        String string = "!!! " + disassembly;
                        throw new NotImplementedError("An operation is not implemented: " + string);
                    }
                    disassembly.append(" add ");
                    disassembly.append(rd.getName());
                    disassembly.append(", ");
                    disassembly.append(rn.getName());
                    disassembly.append(", #");
                    disassembly.append(FormattingKt.hex-WZ4Q5Ns(imm));
                    rd.setValue-WZ4Q5Ns(UInt.constructor-impl(rn.getValue-pVg5ArA() + imm));
                    this.status.setFlag(StatusRegister.FlagType.NEGATIVE, UInt.constructor-impl(rd.getValue-pVg5ArA() & Integer.MIN_VALUE) != 0);
                    this.status.setFlag(StatusRegister.FlagType.ZERO, rd.getValue-pVg5ArA() == 0);
                    this.status.setFlag(StatusRegister.FlagType.CARRY, this.carryFrom-feOb9K0(rn.getValue-pVg5ArA(), imm));
                    this.status.setFlag(StatusRegister.FlagType.OVERFLOW, this.overflowFrom-feOb9K0(rn.getValue-pVg5ArA(), imm));
                    String string = disassembly.toString();
                    Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                    return string;
                }
                if (UInt.constructor-impl(UInt.constructor-impl(extFetched >>> 11) & 3) != 0) {
                    String rd = "!*! " + disassembly;
                    throw new NotImplementedError("An operation is not implemented: " + rd);
                }
                int imm = UInt.constructor-impl(UInt.constructor-impl(extFetched >>> 6) & 0x1F);
                Register rm = this.registers[UInt.constructor-impl(UInt.constructor-impl(extFetched >>> 3) & 7)];
                Register rd = this.registers[UInt.constructor-impl(extFetched & 7)];
                disassembly.append(" lsl ");
                disassembly.append(rd.getName());
                disassembly.append(", ");
                disassembly.append(rm.getName());
                disassembly.append(", ");
                disassembly.append('#');
                disassembly.append(FormattingKt.hex(imm));
                if (imm != 0) {
                    this.status.setFlag(StatusRegister.FlagType.CARRY, UInt.constructor-impl(rm.getValue-pVg5ArA() & UInt.constructor-impl(1 << 32 - imm)) != 0);
                }
                rd.setValue-WZ4Q5Ns(UInt.constructor-impl(rm.getValue-pVg5ArA() << imm));
                this.status.setFlag(StatusRegister.FlagType.NEGATIVE, UInt.constructor-impl(rd.getValue-pVg5ArA() & Integer.MIN_VALUE) != 0);
                this.status.setFlag(StatusRegister.FlagType.ZERO, rd.getValue-pVg5ArA() == 0);
                String string = disassembly.toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                return string;
            }
            case 1: {
                Register rdn = this.registers[UInt.constructor-impl(UInt.constructor-impl(extFetched >>> 8) & 7)];
                int imm = UInt.constructor-impl(extFetched & 0xFF);
                if (UInt.constructor-impl(UInt.constructor-impl(extFetched >>> 11) & 3) != 0) {
                    String rd = "ASCM Imm, " + rdn + ", " + UInt.toString-impl(imm) + ", " + disassembly;
                    throw new NotImplementedError("An operation is not implemented: " + rd);
                }
                disassembly.append(" mov ");
                disassembly.append(rdn.getName());
                disassembly.append(", #");
                disassembly.append(FormattingKt.hex-WZ4Q5Ns(imm));
                rdn.setValue-WZ4Q5Ns(imm);
                this.status.setFlag(StatusRegister.FlagType.NEGATIVE, UInt.constructor-impl(imm & Integer.MIN_VALUE) != 0);
                this.status.setFlag(StatusRegister.FlagType.ZERO, imm == 0);
                String string = disassembly.toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                return string;
            }
            case 2: {
                int maskA = UInt.constructor-impl(extFetched & 0x1F00);
                if (maskA == 1792) {
                    String imm = "BX/XCHG " + disassembly;
                    throw new NotImplementedError("An operation is not implemented: " + imm);
                }
                int maskB = UInt.constructor-impl(extFetched & 0x1C00);
                if (maskB == 0) {
                    String rm = "DP Reg " + disassembly;
                    throw new NotImplementedError("An operation is not implemented: " + rm);
                }
                if (maskB == 1024) {
                    Register rm = this.registers[UInt.constructor-impl(UInt.constructor-impl(UInt.constructor-impl(extFetched >>> 3) & 7) | UInt.constructor-impl(UInt.constructor-impl(extFetched >>> 3) & 8))];
                    Register rd = this.registers[UInt.constructor-impl(UInt.constructor-impl(extFetched & 7) | UInt.constructor-impl(UInt.constructor-impl(extFetched >>> 4) & 8))];
                    if (UInt.constructor-impl(UInt.constructor-impl(extFetched >>> 8) & 3) != 2) {
                        String string = "SpDP " + disassembly;
                        throw new NotImplementedError("An operation is not implemented: " + string);
                    }
                    disassembly.append(" mov ");
                    disassembly.append(rd.getName());
                    disassembly.append(", ");
                    disassembly.append(rm.getName());
                    rd.setValue-WZ4Q5Ns(rm.getValue-pVg5ArA());
                    String string = disassembly.toString();
                    Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                    return string;
                }
                int maskC = UInt.constructor-impl(extFetched & 0x1800);
                if (maskC == 2048) {
                    disassembly.append(" ldr ");
                    Register rd = this.registers[UInt.constructor-impl(UInt.constructor-impl(extFetched >>> 8) & 7)];
                    disassembly.append(rd.getName());
                    disassembly.append(", ");
                    int imm8 = UInt.constructor-impl(UInt.constructor-impl(extFetched & 0xFF) * 4);
                    disassembly.append("[pc, #");
                    disassembly.append(FormattingKt.hex-WZ4Q5Ns(imm8));
                    disassembly.append("] (");
                    int addr = UInt.constructor-impl(this.pc.getValue-pVg5ArA() + imm8);
                    disassembly.append(FormattingKt.hex-WZ4Q5Ns(addr));
                    disassembly.append(") (");
                    rd.setValue-WZ4Q5Ns(this.getComputer().getMemoryAt32--4l20Xc(ULong.constructor-impl((long)addr & 0xFFFFFFFFL)));
                    disassembly.append(FormattingKt.hex-WZ4Q5Ns(rd.getValue-pVg5ArA()));
                    disassembly.append(')');
                    String string = disassembly.toString();
                    Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                    return string;
                }
                int maskD = UInt.constructor-impl(extFetched & 0x1000);
                if (maskD == 4096) {
                    String string = "LR Reg " + disassembly;
                    throw new NotImplementedError("An operation is not implemented: " + string);
                }
                String string = "Delta " + disassembly;
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            case 3: {
                if (UInt.constructor-impl(UInt.constructor-impl(extFetched >>> 11) & 3) != 0) {
                    String maskA = "!*! " + disassembly;
                    throw new NotImplementedError("An operation is not implemented: " + maskA);
                }
                int imm = UInt.constructor-impl(UInt.constructor-impl(extFetched >>> 6) & 0x1F);
                Register rn = this.registers[UInt.constructor-impl(UInt.constructor-impl(extFetched >>> 3) & 7)];
                Register rd = this.registers[UInt.constructor-impl(extFetched & 7)];
                disassembly.append(" str ");
                disassembly.append(rd.getName());
                disassembly.append(", ");
                disassembly.append('[');
                disassembly.append(rn.getName());
                disassembly.append(" + #");
                disassembly.append(FormattingKt.hex-WZ4Q5Ns(imm));
                disassembly.append(" * 4 (");
                int addr = UInt.constructor-impl(UInt.constructor-impl(imm * 4) + rn.getValue-pVg5ArA());
                disassembly.append(FormattingKt.hex-WZ4Q5Ns(addr));
                disassembly.append(")] (");
                disassembly.append(FormattingKt.hex-WZ4Q5Ns(rd.getValue-pVg5ArA()));
                disassembly.append(')');
                this.getComputer().setMemoryAt32-8GdB7C8(ULong.constructor-impl((long)addr & 0xFFFFFFFFL), rd.getValue-pVg5ArA());
                String string = disassembly.toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                return string;
            }
            case 6: {
                int maskA = UInt.constructor-impl(extFetched & 0x1F00);
                if (maskA == 7936) {
                    String rn = "Int " + disassembly;
                    throw new NotImplementedError("An operation is not implemented: " + rn);
                }
                int maskB = UInt.constructor-impl(extFetched & 0x1000);
                if (maskB == 4096) {
                    disassembly.append(" b");
                    InstructionConditionalExecutionSuffix condition = MapsKt.getValue(InstructionConditionalExecutionSuffix.Companion.getMapping(), UInt.box-impl(UInt.constructor-impl(UInt.constructor-impl(extFetched >>> 8) & 0xF)));
                    disassembly.append(condition.getAssemblerName());
                    int imm = (byte)UInt.constructor-impl(extFetched & 0xFF) << 1;
                    disassembly.append(" #");
                    disassembly.append(FormattingKt.hex(imm));
                    if (this.checkConditional(condition)) {
                        this.pc.setValue-WZ4Q5Ns(UInt.constructor-impl(this.pc.getValue-pVg5ArA() + imm));
                    }
                    String string = disassembly.toString();
                    Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                    return string;
                }
                if (maskB == 0) {
                    String condition = "ls " + disassembly;
                    throw new NotImplementedError("An operation is not implemented: " + condition);
                }
                String condition = "Delta " + disassembly;
                throw new NotImplementedError("An operation is not implemented: " + condition);
            }
            case 7: {
                if (UInt.constructor-impl(UInt.constructor-impl(extFetched >>> 11) & 3) != 2) {
                    String maskA = "bad first half " + disassembly;
                    throw new NotImplementedError("An operation is not implemented: " + maskA);
                }
                this.lr.setValue-WZ4Q5Ns(UInt.constructor-impl(this.pc.getValue-pVg5ArA() + UInt.constructor-impl(UInt.constructor-impl(extFetched & 0x7FF) << 12)));
                short secondHalf = this.fetchThumb-Mh2AYeg();
                disassembly.append(":[" + FormattingKt.hex-xj2QHRw(secondHalf) + "]");
                int secondHalfExt = UInt.constructor-impl(secondHalf & 0xFFFF);
                int secondH = UInt.constructor-impl(UInt.constructor-impl(secondHalfExt >>> 11) & 3);
                if (secondH == 3) {
                    disassembly.append(" b ");
                    int savedPC = this.pc.getValue-pVg5ArA();
                    this.pc.setValue-WZ4Q5Ns(UInt.constructor-impl(this.lr.getValue-pVg5ArA() + UInt.constructor-impl(UInt.constructor-impl(secondHalfExt & 0x7FF) << 1)));
                    this.lr.setValue-WZ4Q5Ns(UInt.constructor-impl(savedPC | 1));
                    disassembly.append('#');
                    disassembly.append(FormattingKt.hex-WZ4Q5Ns(this.pc.getValue-pVg5ArA()));
                    String string = disassembly.toString();
                    Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                    return string;
                }
                if (secondH == 1) {
                    String string = "BLX " + disassembly;
                    throw new NotImplementedError("An operation is not implemented: " + string);
                }
                String string = "Delta " + disassembly;
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
        }
        String string = disassembly.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        throw new NotImplementedError(string);
    }

    @NotNull
    public final String decodeArm-WZ4Q5Ns(int fetched) {
        String disassembly = FormattingKt.hex-WZ4Q5Ns(UInt.constructor-impl(this.pc.getValue-pVg5ArA() - 4)) + ":[" + StringsKt.padStart(UStringsKt.toString-V7xB4Y4(fetched, 2), 32, '0') + "/" + FormattingKt.hex-WZ4Q5Ns(fetched) + ":";
        InstructionConditionalExecutionSuffix conditional = MapsKt.getValue(InstructionConditionalExecutionSuffix.Companion.getMapping(), UInt.box-impl(UInt.constructor-impl(fetched >>> 28)));
        if (!this.checkConditional(conditional)) {
            disassembly = disassembly + "\u2717]";
            return disassembly;
        }
        disassembly = disassembly + "\u2713]";
        block0 : switch (UInt.constructor-impl(UInt.constructor-impl(fetched >>> 25) & 7)) {
            case 0: {
                int maskA = UInt.constructor-impl(fetched & 0x1F000F0);
                if (maskA == 18874480) {
                    String string = "Swf Brk " + disassembly;
                    throw new NotImplementedError("An operation is not implemented: " + string);
                }
                if (maskA == 0x1600010) {
                    String string = "Clz " + disassembly;
                    throw new NotImplementedError("An operation is not implemented: " + string);
                }
                if (maskA == 18874416) {
                    String string = "BL XCHG IS " + disassembly;
                    throw new NotImplementedError("An operation is not implemented: " + string);
                }
                if (maskA == 0x1200010) {
                    Register target = this.registers[UInt.constructor-impl(fetched & 0xF)];
                    disassembly = disassembly + " bx " + conditional.getAssemblerName() + " " + target.getName() + " (" + FormattingKt.hex-WZ4Q5Ns(target.getValue-pVg5ArA()) + ")";
                    int instruction2 = target.getValue-pVg5ArA();
                    this.status.setFlag(StatusRegister.FlagType.THUMB_MODE, UInt.constructor-impl(instruction2 & 1) == 1);
                    this.pc.setValue-WZ4Q5Ns(UInt.constructor-impl(instruction2 & 0xFFFFFFFE));
                    return disassembly;
                }
                int maskB = UInt.constructor-impl(fetched & 0x1B000F0);
                if (maskB == 0x1200000) {
                    int mask;
                    int statusBits = UInt.constructor-impl(UInt.constructor-impl(fetched >>> 16) & 0xF);
                    disassembly = disassembly + " msr " + conditional.getAssemblerName() + " cpsr_";
                    Object disassemblyBits = "";
                    Register transfer = this.registers[UInt.constructor-impl(fetched & 0xF)];
                    int n = ProgressionUtilKt.getProgressionLastElement(24, 0, -8);
                    if (n <= (mask = 24)) {
                        while (true) {
                            int statusBit;
                            if ((statusBit = UInt.constructor-impl(UInt.constructor-impl(statusBits >>> (mask >> 3)) & 1)) == 1) {
                                disassembly = disassembly + (switch (mask) {
                                    case 24 -> 'f';
                                    case 16 -> 'x';
                                    case 8 -> 's';
                                    default -> 'c';
                                });
                                int transferData = UInt.constructor-impl(UInt.constructor-impl(transfer.getValue-pVg5ArA() >>> mask) & 0xFF);
                                this.status.setValue-WZ4Q5Ns(UInt.constructor-impl(UInt.constructor-impl(this.status.getValue-pVg5ArA() & UInt.constructor-impl(~UInt.constructor-impl(255 << mask))) | UInt.constructor-impl(transferData << mask)));
                                disassemblyBits = (String)disassemblyBits + StringsKt.padStart(UStringsKt.toString-V7xB4Y4(transferData, 2), 8, '0');
                            } else {
                                disassemblyBits = (String)disassemblyBits + StringsKt.repeat("x", 8);
                            }
                            if (mask == n) break;
                            mask -= 8;
                        }
                    }
                    disassembly = disassembly + ", " + transfer.getName() + " (" + (String)disassemblyBits + ")";
                    return disassembly;
                }
                if (maskB == 0x1000000) {
                    String statusBits = "Sts Reg to Reg";
                    throw new NotImplementedError("An operation is not implemented: " + statusBits);
                }
                int maskC = UInt.constructor-impl(fetched & 0x19000F0);
                if (maskC == 0x1000050) {
                    String disassemblyBits = "EDSP +/-";
                    throw new NotImplementedError("An operation is not implemented: " + disassemblyBits);
                }
                if (maskC == 0x1000080) {
                    String disassemblyBits = "EDSP *";
                    throw new NotImplementedError("An operation is not implemented: " + disassemblyBits);
                }
                int maskD = UInt.constructor-impl(fetched & 0x90);
                if (maskD == 144) {
                    String transfer = "* / v/^";
                    throw new NotImplementedError("An operation is not implemented: " + transfer);
                }
                if (maskD == 16) {
                    String transfer = "DP Reg";
                    throw new NotImplementedError("An operation is not implemented: " + transfer);
                }
                int maskE = UInt.constructor-impl(fetched & 0x10);
                if (maskE == 0) {
                    String string = "DP Imm";
                    throw new NotImplementedError("An operation is not implemented: " + string);
                }
                String string = "Delta";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            case 1: {
                boolean s;
                int checkA = UInt.constructor-impl(UInt.constructor-impl(fetched >>> 20) & 0x1B);
                if (checkA == 18) {
                    String maskB = "IMM STS REG";
                    throw new NotImplementedError("An operation is not implemented: " + maskB);
                }
                if (checkA == 16) {
                    String maskB = "UNDEF";
                    throw new NotImplementedError("An operation is not implemented: " + maskB);
                }
                int opcode = UInt.constructor-impl(UInt.constructor-impl(fetched >>> 21) & 0xF);
                boolean bl = s = UInt.constructor-impl(UInt.constructor-impl(fetched >>> 20) & 1) == 1;
                if (s) {
                    String maskD = "set cond";
                    throw new NotImplementedError("An operation is not implemented: " + maskD);
                }
                Register rn2 = this.registers[UInt.constructor-impl(UInt.constructor-impl(fetched >>> 16) & 0xF)];
                Register rd = this.registers[UInt.constructor-impl(UInt.constructor-impl(fetched >>> 12) & 0xF)];
                int rotate = UInt.constructor-impl(UInt.constructor-impl(fetched >>> 8) & 0xF);
                int immediate = UInt.constructor-impl(Integer.rotateRight(UInt.constructor-impl(fetched & 0xFF), UInt.constructor-impl(rotate * 2)));
                switch (opcode) {
                    case 0: {
                        String transferData = "AND";
                        throw new NotImplementedError("An operation is not implemented: " + transferData);
                    }
                    case 1: {
                        String transferData = "EOR";
                        throw new NotImplementedError("An operation is not implemented: " + transferData);
                    }
                    case 2: {
                        String transferData = "SUB";
                        throw new NotImplementedError("An operation is not implemented: " + transferData);
                    }
                    case 3: {
                        String transferData = "RSB";
                        throw new NotImplementedError("An operation is not implemented: " + transferData);
                    }
                    case 4: {
                        disassembly = disassembly + " add" + conditional.getAssemblerName() + " " + rd.getName() + ", " + rn2.getName() + ", #" + FormattingKt.hex-WZ4Q5Ns(immediate);
                        rd.setValue-WZ4Q5Ns(UInt.constructor-impl(rn2.getValue-pVg5ArA() + immediate));
                        break block0;
                    }
                    case 5: {
                        String transferData = "ADC";
                        throw new NotImplementedError("An operation is not implemented: " + transferData);
                    }
                    case 6: {
                        String transferData = "SBC";
                        throw new NotImplementedError("An operation is not implemented: " + transferData);
                    }
                    case 7: {
                        String transferData = "RSC";
                        throw new NotImplementedError("An operation is not implemented: " + transferData);
                    }
                    case 8: {
                        String transferData = "TST";
                        throw new NotImplementedError("An operation is not implemented: " + transferData);
                    }
                    case 9: {
                        String transferData = "TEQ";
                        throw new NotImplementedError("An operation is not implemented: " + transferData);
                    }
                    case 10: {
                        String transferData = "CMP";
                        throw new NotImplementedError("An operation is not implemented: " + transferData);
                    }
                    case 11: {
                        String transferData = "CMN";
                        throw new NotImplementedError("An operation is not implemented: " + transferData);
                    }
                    case 12: {
                        String transferData = "ORR";
                        throw new NotImplementedError("An operation is not implemented: " + transferData);
                    }
                    case 13: {
                        disassembly = disassembly + " mov" + conditional.getAssemblerName() + " " + rd.getName() + ", #" + FormattingKt.hex-WZ4Q5Ns(immediate);
                        rd.setValue-WZ4Q5Ns(immediate);
                        break block0;
                    }
                    case 14: {
                        String transferData = "BIC";
                        throw new NotImplementedError("An operation is not implemented: " + transferData);
                    }
                    case 15: {
                        String transferData = "MVN";
                        throw new NotImplementedError("An operation is not implemented: " + transferData);
                    }
                }
                break;
            }
            case 2: {
                boolean l;
                boolean w;
                boolean b;
                boolean p;
                Register rn = this.registers[UInt.constructor-impl(UInt.constructor-impl(fetched >>> 16) & 0xF)];
                Register rd = this.registers[UInt.constructor-impl(UInt.constructor-impl(fetched >>> 12) & 0xF)];
                boolean bl = p = UInt.constructor-impl(UInt.constructor-impl(fetched >>> 24) & 1) == 1;
                if (!p) {
                    String rn2 = "post-index addressing";
                    throw new NotImplementedError("An operation is not implemented: " + rn2);
                }
                boolean u = UInt.constructor-impl(UInt.constructor-impl(fetched >>> 23) & 1) == 1;
                boolean bl2 = b = UInt.constructor-impl(UInt.constructor-impl(fetched >>> 22) & 1) == 1;
                if (b) {
                    String rotate = "byte address";
                    throw new NotImplementedError("An operation is not implemented: " + rotate);
                }
                boolean bl3 = w = UInt.constructor-impl(UInt.constructor-impl(fetched >>> 21) & 1) == 1;
                if (w) {
                    String immediate = "writeback";
                    throw new NotImplementedError("An operation is not implemented: " + immediate);
                }
                boolean bl4 = l = UInt.constructor-impl(UInt.constructor-impl(fetched >>> 20) & 1) == 1;
                if (!l) {
                    String statusBit = "store";
                    throw new NotImplementedError("An operation is not implemented: " + statusBit);
                }
                int offset = UInt.constructor-impl(fetched & 0xFFF);
                int calculated2 = ((UInt)((Function2)((Object)(u ? (KFunction)decodeArm.calculated.1.INSTANCE : (KFunction)decodeArm.calculated.2.INSTANCE))).invoke(UInt.box-impl(rn.getValue-pVg5ArA()), UInt.box-impl(offset))).unbox-impl();
                rd.setValue-WZ4Q5Ns(this.getComputer().getMemoryAt32--4l20Xc(ULong.constructor-impl((long)calculated2 & 0xFFFFFFFFL)));
                disassembly = disassembly + " ldr" + conditional.getAssemblerName() + " " + rd.getName() + ", [" + rn.getName() + " " + (u ? (char)'+' : '-') + " #" + FormattingKt.hex-WZ4Q5Ns(offset) + " (" + FormattingKt.hex-WZ4Q5Ns(calculated2) + ")] (" + FormattingKt.hex-WZ4Q5Ns(rd.getValue-pVg5ArA()) + ")";
                break;
            }
            case 5: {
                boolean link;
                boolean bl = link = UInt.constructor-impl(UInt.constructor-impl(fetched >>> 24) & 1) == 1;
                if (link) {
                    String rd = "BL";
                    throw new NotImplementedError("An operation is not implemented: " + rd);
                }
                int offset = (UInt.constructor-impl(UInt.constructor-impl(fetched & 0xFFFFFF) << 8) >> 6) + 4;
                this.pc.setValue-WZ4Q5Ns(UInt.constructor-impl((int)(((long)this.pc.getValue-pVg5ArA() & 0xFFFFFFFFL) + (long)offset)));
                disassembly = disassembly + " b" + conditional.getAssemblerName() + " #" + FormattingKt.hex(offset) + " (" + FormattingKt.hex-WZ4Q5Ns(this.pc.getValue-pVg5ArA()) + ")";
                break;
            }
            default: {
                throw new NotImplementedError(disassembly);
            }
        }
        return disassembly;
    }

    @NotNull
    public final Map<UInt, Function1<ARMv4Processor, Unit>> getBiosHooks() {
        return this.biosHooks;
    }

    @NotNull
    public final CountDownLatch getHalt() {
        return this.halt;
    }

    public final void setHalt(@NotNull CountDownLatch countDownLatch) {
        Intrinsics.checkNotNullParameter(countDownLatch, "<set-?>");
        this.halt = countDownLatch;
    }

    public final void prefetch() {
        block0: {
            this.halt.await();
            Function1<ARMv4Processor, Unit> function1 = this.biosHooks.get(UInt.box-impl(this.pc.getValue-pVg5ArA()));
            if (function1 == null) break block0;
            function1.invoke(this);
        }
    }

    @Override
    public void reset() {
        Register[] $this$forEach$iv = this.registers;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Register element$iv;
            Register it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            it.setValue-WZ4Q5Ns(0);
        }
        this.status.setValue-WZ4Q5Ns(0);
        this.halt.countDown();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InstructionConditionalExecutionSuffix.values().length];
            try {
                nArray[InstructionConditionalExecutionSuffix.EQ.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InstructionConditionalExecutionSuffix.NE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InstructionConditionalExecutionSuffix.CS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InstructionConditionalExecutionSuffix.CC.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InstructionConditionalExecutionSuffix.MI.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InstructionConditionalExecutionSuffix.PL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InstructionConditionalExecutionSuffix.VS.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InstructionConditionalExecutionSuffix.VC.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InstructionConditionalExecutionSuffix.HI.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InstructionConditionalExecutionSuffix.LS.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InstructionConditionalExecutionSuffix.GE.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InstructionConditionalExecutionSuffix.LT.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InstructionConditionalExecutionSuffix.GT.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InstructionConditionalExecutionSuffix.LE.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InstructionConditionalExecutionSuffix.AL.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

