/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.computer.ia32;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlin.reflect.KProperty0;
import org.bread_experts_group.api.computer.BinaryUtil;
import org.bread_experts_group.api.computer.Computer;
import org.bread_experts_group.api.computer.Processor;
import org.bread_experts_group.api.computer.ia32.instruction.DecodingUtil;
import org.bread_experts_group.api.computer.ia32.instruction.InstructionCluster;
import org.bread_experts_group.api.computer.ia32.instruction.type.Instruction;
import org.bread_experts_group.api.computer.ia32.instruction.type.InstructionSelector;
import org.bread_experts_group.api.computer.ia32.register.ControlRegister0;
import org.bread_experts_group.api.computer.ia32.register.FlagsRegister;
import org.bread_experts_group.api.computer.ia32.register.Register;
import org.bread_experts_group.api.computer.ia32.register.SegmentRegister;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0015\u0010i\u001a\u00020\u000b2\u0006\u0010j\u001a\u00020k\u00a2\u0006\u0004\bl\u0010mJ\u0015\u0010n\u001a\u00020\u000b2\u0006\u0010j\u001a\u00020o\u00a2\u0006\u0004\bp\u0010qJ\r\u0010r\u001a\u00020k\u00a2\u0006\u0004\bs\u0010tJ\r\u0010u\u001a\u00020o\u00a2\u0006\u0004\bv\u0010wJ\b\u0010x\u001a\u00020\u000bH\u0016J4\u0010\u007f\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020{2\u0006\u0010_\u001a\u00020{2\u0013\u0010\u0080\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000b0|\u00a2\u0006\u0006\b\u0081\u0001\u0010\u0082\u0001J\u0018\u0010\u0089\u0001\u001a\u00020\u000b2\u0007\u0010\u008a\u0001\u001a\u00020c\u00a2\u0006\u0005\b\u008b\u0001\u0010gJ\u0007\u0010\u008c\u0001\u001a\u00020\u000bJ\b\u0010\u0097\u0001\u001a\u00030\u0094\u0001J\u0019\u0010\u0098\u0001\u001a\u00030\u0099\u00012\u000f\u0010\u009a\u0001\u001a\n\u0012\u0005\u0012\u00030\u0094\u00010\u009b\u0001J\u0007\u0010\u00a4\u0001\u001a\u00020\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0017\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0017\"\u0004\b\u001e\u0010\u001bR\u001a\u0010\u001f\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0017\"\u0004\b!\u0010\u001bR\u001a\u0010\"\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0017\"\u0004\b$\u0010\u001bR\u001a\u0010%\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0017\"\u0004\b'\u0010\u001bR\u001a\u0010(\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0017\"\u0004\b*\u0010\u001bR\u001a\u0010+\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0017\"\u0004\b-\u0010\u001bR\u001a\u0010.\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u001a\u00104\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00101\"\u0004\b6\u00103R\u001a\u00107\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00101\"\u0004\b9\u00103R\u001a\u0010:\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u00101\"\u0004\b<\u00103R\u001a\u0010=\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u00101\"\u0004\b?\u00103R\u001a\u0010@\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u00101\"\u0004\bB\u00103R\u001a\u0010C\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010\u0017\"\u0004\bE\u0010\u001bR\u001a\u0010F\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010\u0017\"\u0004\bH\u0010\u001bR\u001a\u0010I\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010\u0017\"\u0004\bK\u0010\u001bR\u001a\u0010L\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010\u0017\"\u0004\bN\u0010\u001bR\u0011\u0010O\u001a\u00020P\u00a2\u0006\b\n\u0000\u001a\u0004\bQ\u0010RR\u0011\u0010S\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\bT\u0010\u0017R\u0011\u0010U\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\bV\u0010\u0017R\u0011\u0010W\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\bX\u0010\u0017R\u001a\u0010Y\u001a\u00020ZX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b[\u0010\\\"\u0004\b]\u0010^R\u001a\u0010_\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b`\u0010\u0017\"\u0004\ba\u0010\u001bR\u001c\u0010b\u001a\u00020cX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010h\u001a\u0004\bd\u0010e\"\u0004\bf\u0010gR5\u0010y\u001a&\u0012\u0004\u0012\u00020{\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020{\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000b0|0z0z\u00a2\u0006\b\n\u0000\u001a\u0004\b}\u0010~R \u0010\u0083\u0001\u001a\u00030\u0084\u0001X\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0085\u0001\u0010\u0086\u0001\"\u0006\b\u0087\u0001\u0010\u0088\u0001R \u0010\u008d\u0001\u001a\u000f\u0012\u0004\u0012\u00020k\u0012\u0005\u0012\u00030\u008e\u00010z\u00a2\u0006\t\n\u0000\u001a\u0005\b\u008f\u0001\u0010~R\u001f\u0010\u0090\u0001\u001a\u0004\u0018\u00010/X\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0091\u0001\u00101\"\u0005\b\u0092\u0001\u00103R\u0010\u0010\u0093\u0001\u001a\u00030\u0094\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0095\u0001\u001a\u00030\u0094\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0096\u0001\u001a\u00030\u0094\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u009c\u0001\u001a\u00030\u0099\u00018F\u00a2\u0006\b\u001a\u0006\b\u009d\u0001\u0010\u009e\u0001R\u0015\u0010\u009f\u0001\u001a\u00030\u0099\u00018F\u00a2\u0006\b\u001a\u0006\b\u00a0\u0001\u0010\u009e\u0001R\u0012\u0010\u00a1\u0001\u001a\u00020kX\u0082\u000e\u00a2\u0006\u0005\n\u0003\u0010\u00a2\u0001R\u001e\u0010\u00a3\u0001\u001a\u0011\u0012\u0005\u0012\u00030\u008e\u0001\u0012\u0004\u0012\u00020\u000b\u0018\u00010|X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00a5\u0001"}, d2={"Lorg/bread_experts_group/api/computer/ia32/IA32Processor;", "Lorg/bread_experts_group/api/computer/Processor;", "<init>", "()V", "computer", "Lorg/bread_experts_group/api/computer/Computer;", "getComputer", "()Lorg/bread_experts_group/api/computer/Computer;", "setComputer", "(Lorg/bread_experts_group/api/computer/Computer;)V", "step", "", "decoding", "Lorg/bread_experts_group/api/computer/ia32/instruction/DecodingUtil;", "getDecoding", "()Lorg/bread_experts_group/api/computer/ia32/instruction/DecodingUtil;", "logger", "Ljava/util/logging/Logger;", "getLogger", "()Ljava/util/logging/Logger;", "a", "Lorg/bread_experts_group/api/computer/ia32/register/Register;", "getA", "()Lorg/bread_experts_group/api/computer/ia32/register/Register;", "b", "getB", "setB", "(Lorg/bread_experts_group/api/computer/ia32/register/Register;)V", "c", "getC", "setC", "d", "getD", "setD", "sp", "getSp", "setSp", "bp", "getBp", "setBp", "di", "getDi", "setDi", "si", "getSi", "setSi", "cs", "Lorg/bread_experts_group/api/computer/ia32/register/SegmentRegister;", "getCs", "()Lorg/bread_experts_group/api/computer/ia32/register/SegmentRegister;", "setCs", "(Lorg/bread_experts_group/api/computer/ia32/register/SegmentRegister;)V", "ds", "getDs", "setDs", "ss", "getSs", "setSs", "es", "getEs", "setEs", "fs", "getFs", "setFs", "gs", "getGs", "setGs", "gdtrLimit", "getGdtrLimit", "setGdtrLimit", "gdtrBase", "getGdtrBase", "setGdtrBase", "idtrLimit", "getIdtrLimit", "setIdtrLimit", "idtrBase", "getIdtrBase", "setIdtrBase", "cr0", "Lorg/bread_experts_group/api/computer/ia32/register/ControlRegister0;", "getCr0", "()Lorg/bread_experts_group/api/computer/ia32/register/ControlRegister0;", "cr2", "getCr2", "cr3", "getCr3", "cr4", "getCr4", "flags", "Lorg/bread_experts_group/api/computer/ia32/register/FlagsRegister;", "getFlags", "()Lorg/bread_experts_group/api/computer/ia32/register/FlagsRegister;", "setFlags", "(Lorg/bread_experts_group/api/computer/ia32/register/FlagsRegister;)V", "ip", "getIp", "setIp", "cir", "Lkotlin/UByte;", "getCir-w2LRezQ", "()B", "setCir-7apg3OU", "(B)V", "B", "push32", "value", "Lkotlin/UInt;", "push32-WZ4Q5Ns", "(I)V", "push16", "Lkotlin/UShort;", "push16-xj2QHRw", "(S)V", "pop32", "pop32-pVg5ArA", "()I", "pop16", "pop16-Mh2AYeg", "()S", "reset", "biosHooks", "", "Lkotlin/ULong;", "Lkotlin/Function1;", "getBiosHooks", "()Ljava/util/Map;", "setHook", "r", "setHook-twO9MuI", "(JJLkotlin/jvm/functions/Function1;)V", "halt", "Ljava/util/concurrent/CountDownLatch;", "getHalt", "()Ljava/util/concurrent/CountDownLatch;", "setHalt", "(Ljava/util/concurrent/CountDownLatch;)V", "initiateInterrupt", "selector", "initiateInterrupt-7apg3OU", "fetch", "instructionMap", "Lorg/bread_experts_group/api/computer/ia32/instruction/type/Instruction;", "getInstructionMap", "segment", "getSegment", "setSegment", "operandSizeOverride", "", "addressSizeOverride", "memoryLock", "realMode", "getAddressingLengthForSpecifier", "Lorg/bread_experts_group/api/computer/ia32/instruction/DecodingUtil$AddressingLength;", "specifier", "Lkotlin/reflect/KProperty0;", "operandSize", "getOperandSize", "()Lorg/bread_experts_group/api/computer/ia32/instruction/DecodingUtil$AddressingLength;", "addressSize", "getAddressSize", "readingOffPrefix", "I", "localExecutor", "decode", "bread_server_lib"})
@SourceDebugExtension(value={"SMAP\nIA32Processor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IA32Processor.kt\norg/bread_experts_group/api/computer/ia32/IA32Processor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,358:1\n1869#2:359\n1870#2:361\n1869#2,2:362\n1869#2:364\n1869#2,2:365\n1870#2:367\n1#3:360\n382#4,7:368\n*S KotlinDebug\n*F\n+ 1 IA32Processor.kt\norg/bread_experts_group/api/computer/ia32/IA32Processor\n*L\n224#1:359\n224#1:361\n228#1:362,2\n233#1:364\n234#1:365,2\n233#1:367\n166#1:368,7\n*E\n"})
public final class IA32Processor
implements Processor {
    public Computer computer;
    @NotNull
    private final DecodingUtil decoding = new DecodingUtil(this);
    @NotNull
    private final Logger logger;
    @NotNull
    private final Register a;
    @NotNull
    private Register b;
    @NotNull
    private Register c;
    @NotNull
    private Register d;
    @NotNull
    private Register sp;
    @NotNull
    private Register bp;
    @NotNull
    private Register di;
    @NotNull
    private Register si;
    @NotNull
    private SegmentRegister cs;
    @NotNull
    private SegmentRegister ds;
    @NotNull
    private SegmentRegister ss;
    @NotNull
    private SegmentRegister es;
    @NotNull
    private SegmentRegister fs;
    @NotNull
    private SegmentRegister gs;
    @NotNull
    private Register gdtrLimit;
    @NotNull
    private Register gdtrBase;
    @NotNull
    private Register idtrLimit;
    @NotNull
    private Register idtrBase;
    @NotNull
    private final ControlRegister0 cr0;
    @NotNull
    private final Register cr2;
    @NotNull
    private final Register cr3;
    @NotNull
    private final Register cr4;
    @NotNull
    private FlagsRegister flags;
    @NotNull
    private Register ip;
    private byte cir;
    @NotNull
    private final Map<ULong, Map<ULong, Function1<IA32Processor, Unit>>> biosHooks;
    @NotNull
    private CountDownLatch halt;
    @NotNull
    private final Map<UInt, Instruction> instructionMap;
    @Nullable
    private SegmentRegister segment;
    private boolean operandSizeOverride;
    private boolean addressSizeOverride;
    private boolean memoryLock;
    private int readingOffPrefix;
    @Nullable
    private Function1<? super Instruction, Unit> localExecutor;

    /*
     * WARNING - void declaration
     */
    public IA32Processor() {
        Object it;
        void it2;
        Logger logger = Logger.getLogger("ia32_processor", "org.bread_experts_group.resource.LoggerResource");
        Iterator iterator2 = logger;
        IA32Processor iA32Processor = this;
        boolean bl = false;
        it2.setUseParentHandlers(false);
        Logger logger2 = logger;
        Intrinsics.checkNotNullExpressionValue(logger2, "also(...)");
        iA32Processor.logger = logger2;
        this.a = new Register(this.logger, "a", 0L, null);
        this.b = new Register(this.logger, "b", 0L, null);
        this.c = new Register(this.logger, "c", 0L, null);
        this.d = new Register(this.logger, "d", 0L, null);
        this.sp = new Register(this.logger, "sp", 28480L, null);
        this.bp = new Register(this.logger, "bp", 0L, null);
        this.di = new Register(this.logger, "di", 0L, null);
        this.si = new Register(this.logger, "si", 0L, null);
        this.cs = new SegmentRegister(this, "cs", 61440L, null);
        this.ds = new SegmentRegister(this, "ds", 0L, null);
        this.ss = new SegmentRegister(this, "ss", 0L, null);
        this.es = new SegmentRegister(this, "es", 0L, null);
        this.fs = new SegmentRegister(this, "fs", 0L, null);
        this.gs = new SegmentRegister(this, "gs", 0L, null);
        this.gdtrLimit = new Register(this.logger, "gdtrLimit", 0L, null);
        this.gdtrBase = new Register(this.logger, "gdtrBase", 0L, null);
        this.idtrLimit = new Register(this.logger, "idtrLimit", 0L, null);
        this.idtrBase = new Register(this.logger, "idtrBase", 0L, null);
        ControlRegister0.FlagType[] flagTypeArray = new ControlRegister0.FlagType[]{ControlRegister0.FlagType.FPU_80387_OR_HIGHER};
        this.cr0 = new ControlRegister0(this.logger, "cr0", flagTypeArray);
        this.cr2 = new Register(this.logger, "cr2", 0L, null);
        this.cr3 = new Register(this.logger, "cr3", 0L, null);
        this.cr4 = new Register(this.logger, "cr4", 0L, null);
        this.flags = new FlagsRegister(this, "flags", new FlagsRegister.FlagType[0]);
        this.ip = new Register(this.logger, "ip", 65520L, null);
        this.biosHooks = new HashMap(255, 1.0f);
        this.halt = new CountDownLatch(1);
        this.instructionMap = new HashMap(512, 1.0f);
        ServiceLoader<Instruction> serviceLoader = ServiceLoader.load(Instruction.class);
        Intrinsics.checkNotNullExpressionValue(serviceLoader, "load(...)");
        Iterable $this$forEach$iv = serviceLoader;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Instruction)element$iv;
            boolean bl2 = false;
            if (!(!this.instructionMap.containsKey(UInt.box-impl(((Instruction)it).getOpcode-pVg5ArA())))) {
                boolean $i$a$-require-IA32Processor$1$22 = false;
                String $i$a$-require-IA32Processor$1$22 = "Multiple opcodes, " + BinaryUtil.INSTANCE.hex-WZ4Q5Ns(((Instruction)it).getOpcode-pVg5ArA());
                throw new IllegalArgumentException($i$a$-require-IA32Processor$1$22.toString());
            }
            this.instructionMap.put(UInt.box-impl(((Instruction)it).getOpcode-pVg5ArA()), (Instruction)it);
        }
        ServiceLoader<InstructionSelector> serviceLoader2 = ServiceLoader.load(InstructionSelector.class);
        Intrinsics.checkNotNullExpressionValue(serviceLoader2, "load(...)");
        $this$forEach$iv = serviceLoader2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (InstructionSelector)element$iv;
            boolean bl3 = false;
            ((InstructionSelector)it).initialize(this);
            if (!(!this.instructionMap.containsKey(UInt.box-impl(((Instruction)it).getOpcode-pVg5ArA())))) {
                boolean $i$a$-require-IA32Processor$2$22 = false;
                String $i$a$-require-IA32Processor$2$22 = "Multiple opcodes, " + BinaryUtil.INSTANCE.hex-WZ4Q5Ns(((Instruction)it).getOpcode-pVg5ArA());
                throw new IllegalArgumentException($i$a$-require-IA32Processor$2$22.toString());
            }
            this.instructionMap.put(UInt.box-impl(((Instruction)it).getOpcode-pVg5ArA()), (Instruction)it);
        }
        ServiceLoader<InstructionCluster> serviceLoader3 = ServiceLoader.load(InstructionCluster.class);
        Intrinsics.checkNotNullExpressionValue(serviceLoader3, "load(...)");
        $this$forEach$iv = serviceLoader3;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (InstructionCluster)element$iv;
            boolean bl4 = false;
            Iterable $this$forEach$iv2 = it.getInstructions(this);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Instruction f = (Instruction)element$iv2;
                boolean bl5 = false;
                if (!(!this.instructionMap.containsKey(UInt.box-impl(f.getOpcode-pVg5ArA())))) {
                    boolean bl6 = false;
                    String string = "Multiple opcodes, " + BinaryUtil.INSTANCE.hex-WZ4Q5Ns(f.getOpcode-pVg5ArA());
                    throw new IllegalArgumentException(string.toString());
                }
                this.instructionMap.put(UInt.box-impl(f.getOpcode-pVg5ArA()), f);
            }
        }
    }

    @Override
    @NotNull
    public Computer getComputer() {
        Computer computer = this.computer;
        if (computer != null) {
            return computer;
        }
        Intrinsics.throwUninitializedPropertyAccessException("computer");
        return null;
    }

    @Override
    public void setComputer(@NotNull Computer computer) {
        Intrinsics.checkNotNullParameter(computer, "<set-?>");
        this.computer = computer;
    }

    @Override
    public void step() {
        this.fetch();
        this.decode();
    }

    @NotNull
    public final DecodingUtil getDecoding() {
        return this.decoding;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final Register getA() {
        return this.a;
    }

    @NotNull
    public final Register getB() {
        return this.b;
    }

    public final void setB(@NotNull Register register2) {
        Intrinsics.checkNotNullParameter(register2, "<set-?>");
        this.b = register2;
    }

    @NotNull
    public final Register getC() {
        return this.c;
    }

    public final void setC(@NotNull Register register2) {
        Intrinsics.checkNotNullParameter(register2, "<set-?>");
        this.c = register2;
    }

    @NotNull
    public final Register getD() {
        return this.d;
    }

    public final void setD(@NotNull Register register2) {
        Intrinsics.checkNotNullParameter(register2, "<set-?>");
        this.d = register2;
    }

    @NotNull
    public final Register getSp() {
        return this.sp;
    }

    public final void setSp(@NotNull Register register2) {
        Intrinsics.checkNotNullParameter(register2, "<set-?>");
        this.sp = register2;
    }

    @NotNull
    public final Register getBp() {
        return this.bp;
    }

    public final void setBp(@NotNull Register register2) {
        Intrinsics.checkNotNullParameter(register2, "<set-?>");
        this.bp = register2;
    }

    @NotNull
    public final Register getDi() {
        return this.di;
    }

    public final void setDi(@NotNull Register register2) {
        Intrinsics.checkNotNullParameter(register2, "<set-?>");
        this.di = register2;
    }

    @NotNull
    public final Register getSi() {
        return this.si;
    }

    public final void setSi(@NotNull Register register2) {
        Intrinsics.checkNotNullParameter(register2, "<set-?>");
        this.si = register2;
    }

    @NotNull
    public final SegmentRegister getCs() {
        return this.cs;
    }

    public final void setCs(@NotNull SegmentRegister segmentRegister) {
        Intrinsics.checkNotNullParameter(segmentRegister, "<set-?>");
        this.cs = segmentRegister;
    }

    @NotNull
    public final SegmentRegister getDs() {
        return this.ds;
    }

    public final void setDs(@NotNull SegmentRegister segmentRegister) {
        Intrinsics.checkNotNullParameter(segmentRegister, "<set-?>");
        this.ds = segmentRegister;
    }

    @NotNull
    public final SegmentRegister getSs() {
        return this.ss;
    }

    public final void setSs(@NotNull SegmentRegister segmentRegister) {
        Intrinsics.checkNotNullParameter(segmentRegister, "<set-?>");
        this.ss = segmentRegister;
    }

    @NotNull
    public final SegmentRegister getEs() {
        return this.es;
    }

    public final void setEs(@NotNull SegmentRegister segmentRegister) {
        Intrinsics.checkNotNullParameter(segmentRegister, "<set-?>");
        this.es = segmentRegister;
    }

    @NotNull
    public final SegmentRegister getFs() {
        return this.fs;
    }

    public final void setFs(@NotNull SegmentRegister segmentRegister) {
        Intrinsics.checkNotNullParameter(segmentRegister, "<set-?>");
        this.fs = segmentRegister;
    }

    @NotNull
    public final SegmentRegister getGs() {
        return this.gs;
    }

    public final void setGs(@NotNull SegmentRegister segmentRegister) {
        Intrinsics.checkNotNullParameter(segmentRegister, "<set-?>");
        this.gs = segmentRegister;
    }

    @NotNull
    public final Register getGdtrLimit() {
        return this.gdtrLimit;
    }

    public final void setGdtrLimit(@NotNull Register register2) {
        Intrinsics.checkNotNullParameter(register2, "<set-?>");
        this.gdtrLimit = register2;
    }

    @NotNull
    public final Register getGdtrBase() {
        return this.gdtrBase;
    }

    public final void setGdtrBase(@NotNull Register register2) {
        Intrinsics.checkNotNullParameter(register2, "<set-?>");
        this.gdtrBase = register2;
    }

    @NotNull
    public final Register getIdtrLimit() {
        return this.idtrLimit;
    }

    public final void setIdtrLimit(@NotNull Register register2) {
        Intrinsics.checkNotNullParameter(register2, "<set-?>");
        this.idtrLimit = register2;
    }

    @NotNull
    public final Register getIdtrBase() {
        return this.idtrBase;
    }

    public final void setIdtrBase(@NotNull Register register2) {
        Intrinsics.checkNotNullParameter(register2, "<set-?>");
        this.idtrBase = register2;
    }

    @NotNull
    public final ControlRegister0 getCr0() {
        return this.cr0;
    }

    @NotNull
    public final Register getCr2() {
        return this.cr2;
    }

    @NotNull
    public final Register getCr3() {
        return this.cr3;
    }

    @NotNull
    public final Register getCr4() {
        return this.cr4;
    }

    @NotNull
    public final FlagsRegister getFlags() {
        return this.flags;
    }

    public final void setFlags(@NotNull FlagsRegister flagsRegister) {
        Intrinsics.checkNotNullParameter(flagsRegister, "<set-?>");
        this.flags = flagsRegister;
    }

    @NotNull
    public final Register getIp() {
        return this.ip;
    }

    public final void setIp(@NotNull Register register2) {
        Intrinsics.checkNotNullParameter(register2, "<set-?>");
        this.ip = register2;
    }

    public final byte getCir-w2LRezQ() {
        return this.cir;
    }

    public final void setCir-7apg3OU(byte by) {
        this.cir = by;
    }

    public final void push32-WZ4Q5Ns(int value) {
        switch (WhenMappings.$EnumSwitchMapping$0[this.getAddressSize().ordinal()]) {
            case 1: {
                Register register2 = this.sp;
                register2.setEx-VKZWuLQ(ULong.constructor-impl(register2.getEx-s-VKNKU() - ULong.constructor-impl((long)4 & 0xFFFFFFFFL)));
                break;
            }
            case 2: {
                Register register3 = this.sp;
                register3.setX-VKZWuLQ(ULong.constructor-impl(register3.getX-s-VKNKU() - ULong.constructor-impl((long)4 & 0xFFFFFFFFL)));
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        this.getComputer().setMemoryAt32-8GdB7C8(this.ss.offset-I7RO_PI(this.sp), value);
    }

    public final void push16-xj2QHRw(short value) {
        switch (WhenMappings.$EnumSwitchMapping$0[this.getAddressSize().ordinal()]) {
            case 1: {
                Register register2 = this.sp;
                register2.setEx-VKZWuLQ(ULong.constructor-impl(register2.getEx-s-VKNKU() - ULong.constructor-impl((long)2 & 0xFFFFFFFFL)));
                break;
            }
            case 2: {
                Register register3 = this.sp;
                register3.setX-VKZWuLQ(ULong.constructor-impl(register3.getX-s-VKNKU() - ULong.constructor-impl((long)2 & 0xFFFFFFFFL)));
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        this.getComputer().setMemoryAt16-E2t620U(this.ss.offset-I7RO_PI(this.sp), value);
    }

    public final int pop32-pVg5ArA() {
        int popped = this.getComputer().getMemoryAt32--4l20Xc(this.ss.offset-I7RO_PI(this.sp));
        switch (WhenMappings.$EnumSwitchMapping$0[this.getAddressSize().ordinal()]) {
            case 1: {
                Register register2 = this.sp;
                register2.setEx-VKZWuLQ(ULong.constructor-impl(register2.getEx-s-VKNKU() + ULong.constructor-impl((long)4 & 0xFFFFFFFFL)));
                break;
            }
            case 2: {
                Register register3 = this.sp;
                register3.setX-VKZWuLQ(ULong.constructor-impl(register3.getX-s-VKNKU() + ULong.constructor-impl((long)4 & 0xFFFFFFFFL)));
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return popped;
    }

    public final short pop16-Mh2AYeg() {
        short popped = this.getComputer().getMemoryAt16-ZO3KGMw(this.ss.offset-I7RO_PI(this.sp));
        switch (WhenMappings.$EnumSwitchMapping$0[this.getAddressSize().ordinal()]) {
            case 1: {
                Register register2 = this.sp;
                register2.setEx-VKZWuLQ(ULong.constructor-impl(register2.getEx-s-VKNKU() + ULong.constructor-impl((long)2 & 0xFFFFFFFFL)));
                break;
            }
            case 2: {
                Register register3 = this.sp;
                register3.setX-VKZWuLQ(ULong.constructor-impl(register3.getX-s-VKNKU() + ULong.constructor-impl((long)2 & 0xFFFFFFFFL)));
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return popped;
    }

    @Override
    public void reset() {
        this.a.setRx-VKZWuLQ(0L);
        this.b.setRx-VKZWuLQ(0L);
        this.c.setRx-VKZWuLQ(0L);
        this.d.setRx-VKZWuLQ(0L);
        this.sp.setRx-VKZWuLQ(28480L);
        this.bp.setRx-VKZWuLQ(0L);
        this.di.setRx-VKZWuLQ(0L);
        this.si.setRx-VKZWuLQ(0L);
        this.cs.setRx-VKZWuLQ(61440L);
        this.gdtrLimit.setRx-VKZWuLQ(0L);
        this.gdtrBase.setRx-VKZWuLQ(0L);
        this.idtrLimit.setRx-VKZWuLQ(0L);
        this.idtrBase.setRx-VKZWuLQ(0L);
        this.ip.setRx-VKZWuLQ(65520L);
        this.ds.setRx-VKZWuLQ(0L);
        this.ss.setRx-VKZWuLQ(0L);
        this.es.setRx-VKZWuLQ(0L);
        this.fs.setRx-VKZWuLQ(0L);
        this.gs.setRx-VKZWuLQ(0L);
        this.cr0.setRx-VKZWuLQ(0L);
        this.cr2.setRx-VKZWuLQ(0L);
        this.cr3.setRx-VKZWuLQ(0L);
        this.cr4.setRx-VKZWuLQ(0L);
        this.flags.setRx-VKZWuLQ(0L);
        this.cir = 0;
        this.halt.countDown();
    }

    @NotNull
    public final Map<ULong, Map<ULong, Function1<IA32Processor, Unit>>> getBiosHooks() {
        return this.biosHooks;
    }

    /*
     * WARNING - void declaration
     */
    public final void setHook-twO9MuI(long cs, long ip, @NotNull Function1<? super IA32Processor, Unit> r) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter(r, "r");
        Map map = this.biosHooks;
        ULong key$iv = ULong.box-impl(cs);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Map answer$iv = new LinkedHashMap();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        map = (Map)object;
        ULong uLong = ULong.box-impl(ip);
        map.put(uLong, r);
    }

    @NotNull
    public final CountDownLatch getHalt() {
        return this.halt;
    }

    public final void setHalt(@NotNull CountDownLatch countDownLatch) {
        Intrinsics.checkNotNullParameter(countDownLatch, "<set-?>");
        this.halt = countDownLatch;
    }

    public final void initiateInterrupt-7apg3OU(byte selector) {
        this.halt.countDown();
        if (!this.realMode()) {
            String string = "Protected mode interrupts";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
        this.push16-xj2QHRw(this.flags.getTx-Mh2AYeg());
        this.flags.setFlag(FlagsRegister.FlagType.INTERRUPT_ENABLE_FLAG, false);
        this.flags.setFlag(FlagsRegister.FlagType.TRAP_FLAG, false);
        this.flags.setFlag(FlagsRegister.FlagType.AUXILIARY_CARRY_FLAG, false);
        this.logger.warning("!!! INTERRUPT RECEIVED (" + BinaryUtil.INSTANCE.hex-7apg3OU(selector) + ") !!!");
        this.push16-xj2QHRw(this.cs.getTx-Mh2AYeg());
        this.push16-xj2QHRw(this.ip.getTx-Mh2AYeg());
        long addr = ULong.constructor-impl(ULong.constructor-impl((long)selector & 0xFFL) * ULong.constructor-impl((long)4 & 0xFFFFFFFFL));
        this.ip.setTex-WZ4Q5Ns(UInt.constructor-impl(this.getComputer().getMemoryAt16-ZO3KGMw(addr) & 0xFFFF));
        this.cs.setTx-xj2QHRw(this.getComputer().getMemoryAt16-ZO3KGMw(ULong.constructor-impl(addr + ULong.constructor-impl((long)2 & 0xFFFFFFFFL))));
    }

    public final void fetch() {
        Object object;
        this.halt.await();
        if (this.realMode() && (object = this.biosHooks.get(ULong.box-impl(this.cs.getRx-s-VKNKU()))) != null && (object = object.get(ULong.box-impl(this.ip.getRx-s-VKNKU()))) != null) {
            object.invoke(this);
        }
        this.cir = this.getComputer().getMemoryAt-NsiRcpg(this.cs.offset-I7RO_PI(this.ip));
        Register register2 = this.ip;
        long l = register2.getRx-s-VKNKU();
        register2.setRx-VKZWuLQ(ULong.constructor-impl(l + 1L));
    }

    @NotNull
    public final Map<UInt, Instruction> getInstructionMap() {
        return this.instructionMap;
    }

    @Nullable
    public final SegmentRegister getSegment() {
        return this.segment;
    }

    public final void setSegment(@Nullable SegmentRegister segmentRegister) {
        this.segment = segmentRegister;
    }

    public final boolean realMode() {
        return !this.cr0.getFlag(ControlRegister0.FlagType.PROTECTED_MODE_ENABLE);
    }

    @NotNull
    public final DecodingUtil.AddressingLength getAddressingLengthForSpecifier(@NotNull KProperty0<Boolean> specifier) {
        Intrinsics.checkNotNullParameter(specifier, "specifier");
        if (!this.realMode()) {
            if (Integer.compareUnsigned(UInt.constructor-impl(this.cs.readSegmentDescriptor().getFlags-pVg5ArA() & 4), 0) > 0) {
                return specifier.get() != false ? DecodingUtil.AddressingLength.R16 : DecodingUtil.AddressingLength.R32;
            }
            return specifier.get() != false ? DecodingUtil.AddressingLength.R32 : DecodingUtil.AddressingLength.R16;
        }
        return specifier.get() != false ? DecodingUtil.AddressingLength.R32 : DecodingUtil.AddressingLength.R16;
    }

    @NotNull
    public final DecodingUtil.AddressingLength getOperandSize() {
        return this.getAddressingLengthForSpecifier(new MutablePropertyReference0Impl(this){

            public Object get() {
                return IA32Processor.access$getOperandSizeOverride$p((IA32Processor)this.receiver);
            }

            public void set(Object value) {
                IA32Processor.access$setOperandSizeOverride$p((IA32Processor)this.receiver, (Boolean)value);
            }
        });
    }

    @NotNull
    public final DecodingUtil.AddressingLength getAddressSize() {
        return this.getAddressingLengthForSpecifier(new MutablePropertyReference0Impl(this){

            public Object get() {
                return IA32Processor.access$getAddressSizeOverride$p((IA32Processor)this.receiver);
            }

            public void set(Object value) {
                IA32Processor.access$setAddressSizeOverride$p((IA32Processor)this.receiver, (Boolean)value);
            }
        });
    }

    public final void decode() {
        Instruction instruction2;
        switch (UInt.constructor-impl(this.cir & 0xFF)) {
            case 38: {
                this.segment = this.es;
                return;
            }
            case 46: {
                this.segment = this.cs;
                return;
            }
            case 54: {
                this.segment = this.ss;
                return;
            }
            case 62: {
                this.segment = this.ds;
                return;
            }
            case 100: {
                this.segment = this.fs;
                return;
            }
            case 101: {
                this.segment = this.gs;
                return;
            }
            case 102: {
                this.operandSizeOverride = true;
                return;
            }
            case 103: {
                this.addressSizeOverride = true;
                return;
            }
            case 15: {
                instruction2 = this.instructionMap.get(UInt.box-impl(UInt.constructor-impl(UInt.constructor-impl(15 << 8) | UInt.constructor-impl(this.decoding.readFetch-w2LRezQ() & 0xFF))));
                if (instruction2 != null) break;
                throw new IllegalArgumentException("Missing two-byte opcode (0F) for " + BinaryUtil.INSTANCE.hex-7apg3OU(this.cir) + " [" + BinaryUtil.INSTANCE.hex-VKZWuLQ(this.ip.getRx-s-VKNKU()) + "]");
            }
            case 240: {
                this.memoryLock = true;
                return;
            }
            case 242: {
                this.localExecutor = arg_0 -> IA32Processor.decode$lambda$9(this, arg_0);
                return;
            }
            case 243: {
                this.localExecutor = arg_0 -> IA32Processor.decode$lambda$10(this, arg_0);
                return;
            }
            default: {
                if (Integer.compareUnsigned(this.readingOffPrefix, 0) > 0) {
                    Instruction instruction3;
                    Instruction instruction4 = this.instructionMap.get(UInt.box-impl(UInt.constructor-impl(UInt.constructor-impl(this.readingOffPrefix << 8) | UInt.constructor-impl(this.cir & 0xFF))));
                    if (instruction4 == null) {
                        throw new IllegalArgumentException("Missing two-byte opcode (" + BinaryUtil.INSTANCE.hex-WZ4Q5Ns(this.readingOffPrefix) + ") for " + BinaryUtil.INSTANCE.hex-7apg3OU(this.cir) + " [" + BinaryUtil.INSTANCE.hex-VKZWuLQ(this.ip.getRx-s-VKNKU()) + "]");
                    }
                    Instruction it = instruction3 = instruction4;
                    boolean bl = false;
                    this.readingOffPrefix = 0;
                    instruction2 = instruction3;
                    break;
                }
                instruction2 = this.instructionMap.get(UInt.box-impl(UInt.constructor-impl(this.cir & 0xFF)));
                if (instruction2 != null) break;
                throw new IllegalArgumentException("Missing opcode for " + BinaryUtil.INSTANCE.hex-7apg3OU(this.cir) + " [" + this.cs.hex-VKZWuLQ(ULong.constructor-impl(this.ip.getRx-s-VKNKU() - ULong.constructor-impl(1L & 0xFFFFFFFFL))) + "]");
            }
        }
        Instruction instruction5 = instruction2;
        Function1<? super Instruction, Unit> function1 = this.localExecutor;
        if (function1 != null) {
            function1.invoke(instruction5);
        } else {
            instruction5.handle(this);
        }
        this.localExecutor = null;
        this.segment = null;
        this.operandSizeOverride = false;
        this.addressSizeOverride = false;
        this.memoryLock = false;
    }

    private static final Unit decode$lambda$9(IA32Processor this$0, Instruction it) {
        Intrinsics.checkNotNullParameter(it, "it");
        KMutableProperty0 c2 = switch (WhenMappings.$EnumSwitchMapping$0[this$0.getAddressSize().ordinal()]) {
            case 1 -> new MutablePropertyReference0Impl(this$0.c){

                public Object get() {
                    return ULong.box-impl(((Register)this.receiver).getEx-s-VKNKU());
                }

                public void set(Object value) {
                    ((Register)this.receiver).setEx-VKZWuLQ(((ULong)value).unbox-impl());
                }
            };
            case 2 -> new MutablePropertyReference0Impl(this$0.c){

                public Object get() {
                    return ULong.box-impl(((Register)this.receiver).getX-s-VKNKU());
                }

                public void set(Object value) {
                    ((Register)this.receiver).setX-VKZWuLQ(((ULong)value).unbox-impl());
                }
            };
            default -> throw new UnsupportedOperationException();
        };
        while (Long.compareUnsigned(((ULong)c2.get()).unbox-impl(), ULong.constructor-impl(0L & 0xFFFFFFFFL)) > 0) {
            it.handle(this$0);
            c2.set(ULong.box-impl(ULong.constructor-impl(((ULong)c2.get()).unbox-impl() - ULong.constructor-impl(1L & 0xFFFFFFFFL))));
            if (it.getOpcode-pVg5ArA() != 166 && it.getOpcode-pVg5ArA() != 167 && it.getOpcode-pVg5ArA() != 174 && it.getOpcode-pVg5ArA() != 175 || !this$0.flags.getFlag(FlagsRegister.FlagType.ZERO_FLAG)) continue;
            break;
        }
        return Unit.INSTANCE;
    }

    private static final Unit decode$lambda$10(IA32Processor this$0, Instruction it) {
        Intrinsics.checkNotNullParameter(it, "it");
        KMutableProperty0 c2 = switch (WhenMappings.$EnumSwitchMapping$0[this$0.getAddressSize().ordinal()]) {
            case 1 -> new MutablePropertyReference0Impl(this$0.c){

                public Object get() {
                    return ULong.box-impl(((Register)this.receiver).getEx-s-VKNKU());
                }

                public void set(Object value) {
                    ((Register)this.receiver).setEx-VKZWuLQ(((ULong)value).unbox-impl());
                }
            };
            case 2 -> new MutablePropertyReference0Impl(this$0.c){

                public Object get() {
                    return ULong.box-impl(((Register)this.receiver).getX-s-VKNKU());
                }

                public void set(Object value) {
                    ((Register)this.receiver).setX-VKZWuLQ(((ULong)value).unbox-impl());
                }
            };
            default -> throw new UnsupportedOperationException();
        };
        this$0.flags.setFlag(FlagsRegister.FlagType.ZERO_FLAG, true);
        while (Long.compareUnsigned(((ULong)c2.get()).unbox-impl(), ULong.constructor-impl(0L & 0xFFFFFFFFL)) > 0) {
            it.handle(this$0);
            c2.set(ULong.box-impl(ULong.constructor-impl(((ULong)c2.get()).unbox-impl() - ULong.constructor-impl(1L & 0xFFFFFFFFL))));
            if (it.getOpcode-pVg5ArA() != 166 && it.getOpcode-pVg5ArA() != 167 && it.getOpcode-pVg5ArA() != 174 && it.getOpcode-pVg5ArA() != 175 || this$0.flags.getFlag(FlagsRegister.FlagType.ZERO_FLAG)) continue;
            break;
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ boolean access$getOperandSizeOverride$p(IA32Processor $this) {
        return $this.operandSizeOverride;
    }

    public static final /* synthetic */ void access$setOperandSizeOverride$p(IA32Processor $this, boolean bl) {
        $this.operandSizeOverride = bl;
    }

    public static final /* synthetic */ boolean access$getAddressSizeOverride$p(IA32Processor $this) {
        return $this.addressSizeOverride;
    }

    public static final /* synthetic */ void access$setAddressSizeOverride$p(IA32Processor $this, boolean bl) {
        $this.addressSizeOverride = bl;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DecodingUtil.AddressingLength.values().length];
            try {
                nArray[DecodingUtil.AddressingLength.R32.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DecodingUtil.AddressingLength.R16.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

