/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.computer.ia32.bios;

import java.nio.channels.SeekableByteChannel;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.api.computer.ia32.IA32Processor;
import org.bread_experts_group.api.computer.ia32.bios.StandardBIOS;
import org.bread_experts_group.api.computer.ia32.bios.StandardBIOSInterruptProvider;
import org.bread_experts_group.api.computer.ia32.instruction.impl.InterruptReturn;
import org.bread_experts_group.api.computer.ia32.register.FlagsRegister;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lorg/bread_experts_group/api/computer/ia32/bios/Read;", "Lorg/bread_experts_group/api/computer/ia32/bios/StandardBIOSInterruptProvider;", "<init>", "()V", "bios", "Lorg/bread_experts_group/api/computer/ia32/bios/StandardBIOS;", "getBios", "()Lorg/bread_experts_group/api/computer/ia32/bios/StandardBIOS;", "setBios", "(Lorg/bread_experts_group/api/computer/ia32/bios/StandardBIOS;)V", "int", "Lkotlin/UByte;", "getInt-w2LRezQ", "()B", "B", "matches", "", "processor", "Lorg/bread_experts_group/api/computer/ia32/IA32Processor;", "handle", "", "FloppyGeometry", "bread_server_lib"})
public final class Read
implements StandardBIOSInterruptProvider {
    public StandardBIOS bios;
    private final byte int = (byte)19;

    @Override
    @NotNull
    public StandardBIOS getBios() {
        StandardBIOS standardBIOS = this.bios;
        if (standardBIOS != null) {
            return standardBIOS;
        }
        Intrinsics.throwUninitializedPropertyAccessException("bios");
        return null;
    }

    @Override
    public void setBios(@NotNull StandardBIOS standardBIOS) {
        Intrinsics.checkNotNullParameter(standardBIOS, "<set-?>");
        this.bios = standardBIOS;
    }

    @Override
    public byte getInt-w2LRezQ() {
        return this.int;
    }

    @Override
    public boolean matches(@NotNull IA32Processor processor) {
        Intrinsics.checkNotNullParameter(processor, "processor");
        return processor.getA().getH-s-VKNKU() == 2L;
    }

    @Override
    public void handle(@NotNull IA32Processor processor) {
        Intrinsics.checkNotNullParameter(processor, "processor");
        InterruptReturn.Companion.getBIOS_RETURN().handle(processor);
        Pair<SeekableByteChannel, FloppyGeometry> floppy = ArraysKt.getOrNull(processor.getComputer().getFloppies(), (int)processor.getD().getL-s-VKNKU());
        if (floppy != null) {
            int cylinder = UInt.constructor-impl(processor.getC().getTh-w2LRezQ() & 0xFF);
            int head = UInt.constructor-impl(processor.getD().getTh-w2LRezQ() & 0xFF);
            long sector = ULong.constructor-impl(processor.getC().getL-s-VKNKU() & 0x3FL);
            if (sector == 0L) {
                String string = "Invalid sector 0";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            int n = UInt.constructor-impl(UInt.constructor-impl(UInt.constructor-impl(cylinder * floppy.getSecond().getHeads-pVg5ArA()) + head) * floppy.getSecond().getSectorsPerTrack-pVg5ArA());
            long l = ULong.constructor-impl(sector - ULong.constructor-impl(1L & 0xFFFFFFFFL));
            long lba = ULong.constructor-impl(ULong.constructor-impl((long)n & 0xFFFFFFFFL) + l);
            long startByte = ULong.constructor-impl(lba * ULong.constructor-impl((long)floppy.getSecond().getBytesPerSector-pVg5ArA() & 0xFFFFFFFFL));
            long endByte = ULong.constructor-impl(ULong.constructor-impl(startByte + ULong.constructor-impl((long)UInt.constructor-impl(UInt.constructor-impl((int)processor.getA().getL-s-VKNKU()) * floppy.getSecond().getBytesPerSector-pVg5ArA()) & 0xFFFFFFFFL)) - ULong.constructor-impl(1L & 0xFFFFFFFFL));
            processor.getLogger().info("Floppy copy, cylinder # " + UInt.toString-impl(cylinder) + ", sector " + ULong.toString-impl(sector) + ", head " + UInt.toString-impl(head));
            processor.getDecoding().loadFloppyIntoMemory-tc6d2E8(floppy.getFirst(), startByte, endByte, processor.getEs().offset-PUiSbYQ(processor.getB().getX-s-VKNKU()));
            processor.getA().setH-VKZWuLQ(0L);
            processor.getFlags().setFlag(FlagsRegister.FlagType.CARRY_FLAG, false);
        } else {
            processor.getA().setH-VKZWuLQ(49L);
            processor.getA().setL-VKZWuLQ(0L);
            processor.getFlags().setFlag(FlagsRegister.FlagType.CARRY_FLAG, true);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\r\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\tJ\u0010\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\tJ\u0010\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\tJ.\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0013\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\u000b\u0010\tR\u0013\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\f\u0010\t\u00a8\u0006\u001e"}, d2={"Lorg/bread_experts_group/api/computer/ia32/bios/Read$FloppyGeometry;", "", "sectorsPerTrack", "Lkotlin/UInt;", "heads", "bytesPerSector", "<init>", "(IIILkotlin/jvm/internal/DefaultConstructorMarker;)V", "getSectorsPerTrack-pVg5ArA", "()I", "I", "getHeads-pVg5ArA", "getBytesPerSector-pVg5ArA", "component1", "component1-pVg5ArA", "component2", "component2-pVg5ArA", "component3", "component3-pVg5ArA", "copy", "copy-zly0blg", "(III)Lorg/bread_experts_group/api/computer/ia32/bios/Read$FloppyGeometry;", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "bread_server_lib"})
    public static final class FloppyGeometry {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int sectorsPerTrack;
        private final int heads;
        private final int bytesPerSector;
        @NotNull
        private static final FloppyGeometry floppy3_5_144M = new FloppyGeometry(18, 2, 512, null);
        @NotNull
        private static final FloppyGeometry floppy5_14_160K = new FloppyGeometry(8, 1, 512, null);
        @NotNull
        private static final FloppyGeometry floppy5_14_320K = new FloppyGeometry(8, 2, 512, null);
        @NotNull
        private static final FloppyGeometry floppy5_14_360K = new FloppyGeometry(9, 2, 512, null);

        private FloppyGeometry(int sectorsPerTrack, int heads, int bytesPerSector) {
            this.sectorsPerTrack = sectorsPerTrack;
            this.heads = heads;
            this.bytesPerSector = bytesPerSector;
        }

        public final int getSectorsPerTrack-pVg5ArA() {
            return this.sectorsPerTrack;
        }

        public final int getHeads-pVg5ArA() {
            return this.heads;
        }

        public final int getBytesPerSector-pVg5ArA() {
            return this.bytesPerSector;
        }

        public final int component1-pVg5ArA() {
            return this.sectorsPerTrack;
        }

        public final int component2-pVg5ArA() {
            return this.heads;
        }

        public final int component3-pVg5ArA() {
            return this.bytesPerSector;
        }

        @NotNull
        public final FloppyGeometry copy-zly0blg(int sectorsPerTrack, int heads, int bytesPerSector) {
            return new FloppyGeometry(sectorsPerTrack, heads, bytesPerSector, null);
        }

        public static /* synthetic */ FloppyGeometry copy-zly0blg$default(FloppyGeometry floppyGeometry, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = floppyGeometry.sectorsPerTrack;
            }
            if ((n4 & 2) != 0) {
                n2 = floppyGeometry.heads;
            }
            if ((n4 & 4) != 0) {
                n3 = floppyGeometry.bytesPerSector;
            }
            return floppyGeometry.copy-zly0blg(n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "FloppyGeometry(sectorsPerTrack=" + UInt.toString-impl(this.sectorsPerTrack) + ", heads=" + UInt.toString-impl(this.heads) + ", bytesPerSector=" + UInt.toString-impl(this.bytesPerSector) + ")";
        }

        public int hashCode() {
            int result = UInt.hashCode-impl(this.sectorsPerTrack);
            result = result * 31 + UInt.hashCode-impl(this.heads);
            result = result * 31 + UInt.hashCode-impl(this.bytesPerSector);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FloppyGeometry)) {
                return false;
            }
            FloppyGeometry floppyGeometry = (FloppyGeometry)other;
            if (this.sectorsPerTrack != floppyGeometry.sectorsPerTrack) {
                return false;
            }
            if (this.heads != floppyGeometry.heads) {
                return false;
            }
            return this.bytesPerSector == floppyGeometry.bytesPerSector;
        }

        public /* synthetic */ FloppyGeometry(int sectorsPerTrack, int heads, int bytesPerSector, DefaultConstructorMarker $constructor_marker) {
            this(sectorsPerTrack, heads, bytesPerSector);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/bread_experts_group/api/computer/ia32/bios/Read$FloppyGeometry$Companion;", "", "<init>", "()V", "floppy3_5_144M", "Lorg/bread_experts_group/api/computer/ia32/bios/Read$FloppyGeometry;", "getFloppy3_5_144M", "()Lorg/bread_experts_group/api/computer/ia32/bios/Read$FloppyGeometry;", "floppy5_14_160K", "getFloppy5_14_160K", "floppy5_14_320K", "getFloppy5_14_320K", "floppy5_14_360K", "getFloppy5_14_360K", "bread_server_lib"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final FloppyGeometry getFloppy3_5_144M() {
                return floppy3_5_144M;
            }

            @NotNull
            public final FloppyGeometry getFloppy5_14_160K() {
                return floppy5_14_160K;
            }

            @NotNull
            public final FloppyGeometry getFloppy5_14_320K() {
                return floppy5_14_320K;
            }

            @NotNull
            public final FloppyGeometry getFloppy5_14_360K() {
                return floppy5_14_360K;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

