/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.computer.ia32.bios;

import kotlin.Metadata;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.UnsignedKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.UIntRange;
import kotlin.ranges.URangesKt;
import org.bread_experts_group.api.computer.ia32.IA32Processor;
import org.bread_experts_group.api.computer.ia32.bios.StandardBIOS;
import org.bread_experts_group.api.computer.ia32.bios.StandardBIOSInterruptProvider;
import org.bread_experts_group.api.computer.ia32.instruction.impl.InterruptReturn;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u0000 +2\u00020\u0001:\u0001+B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J%\u0010 \u001a\u00020!2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000b\u00a2\u0006\u0004\b$\u0010%J\u001d\u0010&\u001a\u00020!2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u000b\u00a2\u0006\u0004\b(\u0010)J\u0010\u0010*\u001a\u00020!2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u001c\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0019\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0016\u0010\u001a\u001a\u00020\u0014X\u0086D\u00a2\u0006\n\n\u0002\u0010\u0019\u001a\u0004\b\u001b\u0010\u0016R\u0016\u0010\u001c\u001a\u00020\u0014X\u0086D\u00a2\u0006\n\n\u0002\u0010\u0019\u001a\u0004\b\u001d\u0010\u0016R\u0011\u0010\u001e\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0016\u00a8\u0006,"}, d2={"Lorg/bread_experts_group/api/computer/ia32/bios/TeletypeOutput;", "Lorg/bread_experts_group/api/computer/ia32/bios/StandardBIOSInterruptProvider;", "<init>", "()V", "bios", "Lorg/bread_experts_group/api/computer/ia32/bios/StandardBIOS;", "getBios", "()Lorg/bread_experts_group/api/computer/ia32/bios/StandardBIOS;", "setBios", "(Lorg/bread_experts_group/api/computer/ia32/bios/StandardBIOS;)V", "int", "Lkotlin/UByte;", "getInt-w2LRezQ", "()B", "B", "matches", "", "processor", "Lorg/bread_experts_group/api/computer/ia32/IA32Processor;", "position", "Lkotlin/UInt;", "getPosition-pVg5ArA", "()I", "setPosition-WZ4Q5Ns", "(I)V", "I", "rows", "getRows-pVg5ArA", "cols", "getCols-pVg5ArA", "characters", "getCharacters-pVg5ArA", "writeCharacter", "", "char", "attribute", "writeCharacter-8olNwgk", "(Lorg/bread_experts_group/api/computer/ia32/IA32Processor;BB)V", "scroll", "n", "scroll-EK-6454", "(Lorg/bread_experts_group/api/computer/ia32/IA32Processor;B)V", "handle", "Companion", "bread_server_lib"})
public final class TeletypeOutput
implements StandardBIOSInterruptProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public StandardBIOS bios;
    private final byte int = (byte)16;
    private int position;
    private final int rows;
    private final int cols;
    public static final long COLOR_ADDR = 753664L;

    public TeletypeOutput() {
        this.rows = 25;
        this.cols = 80;
    }

    @Override
    @NotNull
    public StandardBIOS getBios() {
        StandardBIOS standardBIOS = this.bios;
        if (standardBIOS != null) {
            return standardBIOS;
        }
        Intrinsics.throwUninitializedPropertyAccessException("bios");
        return null;
    }

    @Override
    public void setBios(@NotNull StandardBIOS standardBIOS) {
        Intrinsics.checkNotNullParameter(standardBIOS, "<set-?>");
        this.bios = standardBIOS;
    }

    @Override
    public byte getInt-w2LRezQ() {
        return this.int;
    }

    @Override
    public boolean matches(@NotNull IA32Processor processor) {
        Intrinsics.checkNotNullParameter(processor, "processor");
        return processor.getA().getH-s-VKNKU() == 14L;
    }

    public final int getPosition-pVg5ArA() {
        return this.position;
    }

    public final void setPosition-WZ4Q5Ns(int n) {
        this.position = n;
    }

    public final int getRows-pVg5ArA() {
        return this.rows;
    }

    public final int getCols-pVg5ArA() {
        return this.cols;
    }

    public final int getCharacters-pVg5ArA() {
        return UInt.constructor-impl(this.rows * this.cols);
    }

    public final void writeCharacter-8olNwgk(@NotNull IA32Processor processor, byte by, byte attribute) {
        Intrinsics.checkNotNullParameter(processor, "processor");
        switch ((char)(UShort.constructor-impl((short)((short)by & 0xFF)) & 0xFFFF)) {
            case '\n': {
                this.position = UInt.constructor-impl(UInt.constructor-impl(Integer.divideUnsigned(this.position, this.cols) + 1) * this.cols);
                break;
            }
            case '\r': {
                this.position = UInt.constructor-impl(Integer.divideUnsigned(this.position, this.cols) * this.cols);
                break;
            }
            default: {
                long l = 753664L;
                int n = this.position;
                this.position = UInt.constructor-impl(n + 1);
                int n2 = 2;
                n = UInt.constructor-impl(n * n2);
                processor.getComputer().setMemoryAt16-E2t620U(ULong.constructor-impl(l + ULong.constructor-impl((long)n & 0xFFFFFFFFL)), UShort.constructor-impl((short)UInt.constructor-impl(UInt.constructor-impl(UInt.constructor-impl(by & 0xFF) << 8) | UInt.constructor-impl(attribute & 0xFF))));
            }
        }
        if (Integer.compareUnsigned(this.position, UInt.constructor-impl(this.cols * this.rows)) >= 0) {
            this.scroll-EK-6454(processor, (byte)1);
        }
    }

    public final void scroll-EK-6454(@NotNull IA32Processor processor, byte n) {
        Intrinsics.checkNotNullParameter(processor, "processor");
        UIntRange topMost = URangesKt.until-J1ME1BU(0, UInt.constructor-impl(this.getCharacters-pVg5ArA() - this.cols));
        int n2 = n & 0xFF;
        for (int i = 0; i < n2; ++i) {
            int it = i;
            boolean bl = false;
            int n3 = 0;
            int n4 = this.getCharacters-pVg5ArA();
            while (UnsignedKt.uintCompare(n3, n4) < 0) {
                int position = n3;
                int n5 = topMost.getFirst-pVg5ArA();
                processor.getComputer().setMemoryAt16-E2t620U(ULong.constructor-impl(753664L + ULong.constructor-impl((long)UInt.constructor-impl(position * 2) & 0xFFFFFFFFL)), (UnsignedKt.uintCompare(position, topMost.getLast-pVg5ArA()) <= 0 ? 0 <= UnsignedKt.uintCompare(position, n5) : false) ? processor.getComputer().getMemoryAt16-ZO3KGMw(ULong.constructor-impl(753664L + ULong.constructor-impl((long)UInt.constructor-impl(UInt.constructor-impl(position + this.cols) * 2) & 0xFFFFFFFFL))) : (short)0);
                ++n3;
            }
        }
        int subtract = UInt.constructor-impl(this.cols * UInt.constructor-impl(n & 0xFF));
        this.position = Integer.compareUnsigned(subtract, this.position) > 0 ? 0 : UInt.constructor-impl(this.position - subtract);
    }

    @Override
    public void handle(@NotNull IA32Processor processor) {
        Intrinsics.checkNotNullParameter(processor, "processor");
        InterruptReturn.Companion.getBIOS_RETURN().handle(processor);
        this.writeCharacter-8olNwgk(processor, processor.getA().getTl-w2LRezQ(), processor.getB().getTl-w2LRezQ());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/bread_experts_group/api/computer/ia32/bios/TeletypeOutput$Companion;", "", "<init>", "()V", "COLOR_ADDR", "Lkotlin/ULong;", "J", "bread_server_lib"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

