/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.computer.ia32.bios;

import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UnsignedKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.api.computer.ia32.IA32Processor;
import org.bread_experts_group.api.computer.ia32.bios.Read;
import org.bread_experts_group.api.computer.ia32.bios.StandardBIOS;
import org.bread_experts_group.api.computer.ia32.bios.StandardBIOSInterruptProvider;
import org.bread_experts_group.api.computer.ia32.instruction.impl.InterruptReturn;
import org.bread_experts_group.api.computer.ia32.register.FlagsRegister;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lorg/bread_experts_group/api/computer/ia32/bios/Write;", "Lorg/bread_experts_group/api/computer/ia32/bios/StandardBIOSInterruptProvider;", "<init>", "()V", "bios", "Lorg/bread_experts_group/api/computer/ia32/bios/StandardBIOS;", "getBios", "()Lorg/bread_experts_group/api/computer/ia32/bios/StandardBIOS;", "setBios", "(Lorg/bread_experts_group/api/computer/ia32/bios/StandardBIOS;)V", "int", "Lkotlin/UByte;", "getInt-w2LRezQ", "()B", "B", "matches", "", "processor", "Lorg/bread_experts_group/api/computer/ia32/IA32Processor;", "handle", "", "bread_server_lib"})
public final class Write
implements StandardBIOSInterruptProvider {
    public StandardBIOS bios;
    private final byte int = (byte)19;

    @Override
    @NotNull
    public StandardBIOS getBios() {
        StandardBIOS standardBIOS = this.bios;
        if (standardBIOS != null) {
            return standardBIOS;
        }
        Intrinsics.throwUninitializedPropertyAccessException("bios");
        return null;
    }

    @Override
    public void setBios(@NotNull StandardBIOS standardBIOS) {
        Intrinsics.checkNotNullParameter(standardBIOS, "<set-?>");
        this.bios = standardBIOS;
    }

    @Override
    public byte getInt-w2LRezQ() {
        return this.int;
    }

    @Override
    public boolean matches(@NotNull IA32Processor processor) {
        Intrinsics.checkNotNullParameter(processor, "processor");
        return processor.getA().getH-s-VKNKU() == 3L;
    }

    @Override
    public void handle(@NotNull IA32Processor processor) {
        Intrinsics.checkNotNullParameter(processor, "processor");
        InterruptReturn.Companion.getBIOS_RETURN().handle(processor);
        Pair<SeekableByteChannel, Read.FloppyGeometry> floppy = ArraysKt.getOrNull(processor.getComputer().getFloppies(), (int)processor.getD().getL-s-VKNKU());
        if (floppy != null) {
            int cylinder = UInt.constructor-impl(processor.getC().getTh-w2LRezQ() & 0xFF);
            int head = UInt.constructor-impl(processor.getD().getTh-w2LRezQ() & 0xFF);
            long sector = ULong.constructor-impl(processor.getC().getL-s-VKNKU() & 0x3FL);
            if (sector == 0L) {
                String string = "Invalid sector 0";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            int n = UInt.constructor-impl(UInt.constructor-impl(UInt.constructor-impl(cylinder * floppy.getSecond().getHeads-pVg5ArA()) + head) * floppy.getSecond().getSectorsPerTrack-pVg5ArA());
            long l = ULong.constructor-impl(sector - ULong.constructor-impl(1L & 0xFFFFFFFFL));
            long lba = ULong.constructor-impl(ULong.constructor-impl((long)n & 0xFFFFFFFFL) + l);
            long startByte = ULong.constructor-impl(lba * ULong.constructor-impl((long)floppy.getSecond().getBytesPerSector-pVg5ArA() & 0xFFFFFFFFL));
            long endByte = ULong.constructor-impl(ULong.constructor-impl(startByte + ULong.constructor-impl((long)UInt.constructor-impl(UInt.constructor-impl((int)processor.getA().getL-s-VKNKU()) * floppy.getSecond().getBytesPerSector-pVg5ArA()) & 0xFFFFFFFFL)) - ULong.constructor-impl(1L & 0xFFFFFFFFL));
            processor.getLogger().info("Floppy write, cylinder # " + UInt.toString-impl(cylinder) + ", sector " + ULong.toString-impl(sector) + ", head " + UInt.toString-impl(head));
            floppy.getFirst().position(startByte);
            long memoryStart = processor.getEs().offset-PUiSbYQ(processor.getB().getX-s-VKNKU());
            ByteBuffer buffer = ByteBuffer.allocate((int)ULong.constructor-impl(endByte - startByte) + 1);
            long l2 = memoryStart;
            long l3 = ULong.constructor-impl(memoryStart + ULong.constructor-impl(endByte - startByte));
            if (UnsignedKt.ulongCompare(l2, l3) <= 0) {
                long offset;
                do {
                    offset = l2++;
                    buffer.put(processor.getComputer().getMemoryAt-NsiRcpg(offset));
                } while (offset != l3);
            }
            buffer.clear();
            floppy.getFirst().write(buffer);
            processor.getA().setH-VKZWuLQ(0L);
            processor.getFlags().setFlag(FlagsRegister.FlagType.CARRY_FLAG, false);
        } else {
            processor.getA().setH-VKZWuLQ(49L);
            processor.getA().setL-VKZWuLQ(0L);
            processor.getFlags().setFlag(FlagsRegister.FlagType.CARRY_FLAG, true);
        }
    }
}

