/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.computer.ia32.instruction.impl;

import java.util.List;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.FormattingKt;
import org.bread_experts_group.api.computer.ia32.IA32Processor;
import org.bread_experts_group.api.computer.ia32.instruction.InstructionCluster;
import org.bread_experts_group.api.computer.ia32.instruction.impl.AddKt;
import org.bread_experts_group.api.computer.ia32.instruction.impl.LogicalCommonKt;
import org.bread_experts_group.api.computer.ia32.instruction.type.Instruction;
import org.bread_experts_group.api.computer.ia32.instruction.type.InstructionOperandsKt;
import org.bread_experts_group.api.computer.ia32.register.FlagsRegister;
import org.bread_experts_group.api.computer.ia32.register.Register;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\t\n\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\f"}, d2={"Lorg/bread_experts_group/api/computer/ia32/instruction/impl/BinaryCodedDecimal;", "Lorg/bread_experts_group/api/computer/ia32/instruction/InstructionCluster;", "<init>", "()V", "getInstructions", "", "Lorg/bread_experts_group/api/computer/ia32/instruction/type/Instruction;", "processor", "Lorg/bread_experts_group/api/computer/ia32/IA32Processor;", "DecimalAdjustALAfterAddition", "ASCIIAdjustAXAfterMultiply", "ASCIIAdjustAXBeforeDivision", "bread_server_lib"})
public final class BinaryCodedDecimal
implements InstructionCluster {
    @Override
    @NotNull
    public List<Instruction> getInstructions(@NotNull IA32Processor processor) {
        Intrinsics.checkNotNullParameter(processor, "processor");
        Instruction[] instructionArray = new Instruction[]{DecimalAdjustALAfterAddition.INSTANCE, ASCIIAdjustAXAfterMultiply.INSTANCE, ASCIIAdjustAXBeforeDivision.INSTANCE};
        return CollectionsKt.listOf(instructionArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lorg/bread_experts_group/api/computer/ia32/instruction/impl/BinaryCodedDecimal$ASCIIAdjustAXAfterMultiply;", "Lorg/bread_experts_group/api/computer/ia32/instruction/type/Instruction;", "<init>", "()V", "operands", "", "processor", "Lorg/bread_experts_group/api/computer/ia32/IA32Processor;", "handle", "", "bread_server_lib"})
    public static final class ASCIIAdjustAXAfterMultiply
    extends Instruction {
        @NotNull
        public static final ASCIIAdjustAXAfterMultiply INSTANCE = new ASCIIAdjustAXAfterMultiply();

        private ASCIIAdjustAXAfterMultiply() {
            super(212, "aam", null);
        }

        @Override
        @NotNull
        public String operands(@NotNull IA32Processor processor) {
            Intrinsics.checkNotNullParameter(processor, "processor");
            return FormattingKt.hex-7apg3OU(InstructionOperandsKt.imm8(processor));
        }

        @Override
        public void handle(@NotNull IA32Processor processor) {
            Intrinsics.checkNotNullParameter(processor, "processor");
            long sAL = processor.getA().getL-s-VKNKU();
            byte imm8 = InstructionOperandsKt.imm8(processor);
            processor.getA().setH-VKZWuLQ(Long.divideUnsigned(sAL, ULong.constructor-impl((long)imm8 & 0xFFL)));
            processor.getA().setL-VKZWuLQ(Long.remainderUnsigned(sAL, ULong.constructor-impl((long)imm8 & 0xFFL)));
            LogicalCommonKt.setFlagsSFZFPF8-EK-6454(processor, processor.getA().getTl-w2LRezQ());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lorg/bread_experts_group/api/computer/ia32/instruction/impl/BinaryCodedDecimal$ASCIIAdjustAXBeforeDivision;", "Lorg/bread_experts_group/api/computer/ia32/instruction/type/Instruction;", "<init>", "()V", "operands", "", "processor", "Lorg/bread_experts_group/api/computer/ia32/IA32Processor;", "handle", "", "bread_server_lib"})
    public static final class ASCIIAdjustAXBeforeDivision
    extends Instruction {
        @NotNull
        public static final ASCIIAdjustAXBeforeDivision INSTANCE = new ASCIIAdjustAXBeforeDivision();

        private ASCIIAdjustAXBeforeDivision() {
            super(213, "aad", null);
        }

        @Override
        @NotNull
        public String operands(@NotNull IA32Processor processor) {
            Intrinsics.checkNotNullParameter(processor, "processor");
            return FormattingKt.hex-7apg3OU(InstructionOperandsKt.imm8(processor));
        }

        @Override
        public void handle(@NotNull IA32Processor processor) {
            Intrinsics.checkNotNullParameter(processor, "processor");
            byte by = processor.getA().getTl-w2LRezQ();
            int n = processor.getA().getTh-w2LRezQ();
            byte by2 = InstructionOperandsKt.imm8(processor);
            n = UInt.constructor-impl(UInt.constructor-impl(n & 0xFF) * UInt.constructor-impl(by2 & 0xFF));
            processor.getA().setTl-7apg3OU(UByte.constructor-impl((byte)UInt.constructor-impl(UInt.constructor-impl(by & 0xFF) + n)));
            processor.getA().setTh-7apg3OU((byte)0);
            LogicalCommonKt.setFlagsSFZFPF8-EK-6454(processor, processor.getA().getTl-w2LRezQ());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lorg/bread_experts_group/api/computer/ia32/instruction/impl/BinaryCodedDecimal$DecimalAdjustALAfterAddition;", "Lorg/bread_experts_group/api/computer/ia32/instruction/type/Instruction;", "<init>", "()V", "operands", "", "processor", "Lorg/bread_experts_group/api/computer/ia32/IA32Processor;", "handle", "", "bread_server_lib"})
    public static final class DecimalAdjustALAfterAddition
    extends Instruction {
        @NotNull
        public static final DecimalAdjustALAfterAddition INSTANCE = new DecimalAdjustALAfterAddition();

        private DecimalAdjustALAfterAddition() {
            super(39, "daa", null);
        }

        @Override
        @NotNull
        public String operands(@NotNull IA32Processor processor) {
            Intrinsics.checkNotNullParameter(processor, "processor");
            return "";
        }

        @Override
        public void handle(@NotNull IA32Processor processor) {
            Intrinsics.checkNotNullParameter(processor, "processor");
            long sAL = processor.getA().getL-s-VKNKU();
            boolean sCF = processor.getFlags().getFlag(FlagsRegister.FlagType.CARRY_FLAG);
            processor.getFlags().setFlag(FlagsRegister.FlagType.CARRY_FLAG, false);
            if (Long.compareUnsigned(ULong.constructor-impl(sAL & 0xFL), ULong.constructor-impl((long)9 & 0xFFFFFFFFL)) > 0 || processor.getFlags().getFlag(FlagsRegister.FlagType.AUXILIARY_CARRY_FLAG)) {
                byte result = AddKt.addAndSetFlagsAFCFOF8-8olNwgk(processor, processor.getA().getTl-w2LRezQ(), (byte)6);
                processor.getA().setTl-7apg3OU(result);
                if (!processor.getFlags().getFlag(FlagsRegister.FlagType.CARRY_FLAG)) {
                    processor.getFlags().setFlag(FlagsRegister.FlagType.CARRY_FLAG, sCF);
                }
                processor.getFlags().setFlag(FlagsRegister.FlagType.AUXILIARY_CARRY_FLAG, true);
            } else {
                processor.getFlags().setFlag(FlagsRegister.FlagType.AUXILIARY_CARRY_FLAG, false);
            }
            if (Long.compareUnsigned(sAL, ULong.constructor-impl((long)153 & 0xFFFFFFFFL)) > 0 || sCF) {
                Register register2 = processor.getA();
                register2.setL-VKZWuLQ(ULong.constructor-impl(register2.getL-s-VKNKU() + ULong.constructor-impl((long)96 & 0xFFFFFFFFL)));
                processor.getFlags().setFlag(FlagsRegister.FlagType.CARRY_FLAG, true);
            } else {
                processor.getFlags().setFlag(FlagsRegister.FlagType.CARRY_FLAG, false);
            }
            LogicalCommonKt.setFlagsSFZFPF8-EK-6454(processor, processor.getA().getTl-w2LRezQ());
        }
    }
}

