/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.computer.ia32.instruction.impl;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.FormattingKt;
import org.bread_experts_group.api.computer.ia32.IA32Processor;
import org.bread_experts_group.api.computer.ia32.instruction.InstructionCluster;
import org.bread_experts_group.api.computer.ia32.instruction.type.Instruction;
import org.bread_experts_group.api.computer.ia32.instruction.type.InstructionOperandsKt;
import org.bread_experts_group.api.computer.ia32.register.FlagsRegister;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\t\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/bread_experts_group/api/computer/ia32/instruction/impl/Interrupt;", "Lorg/bread_experts_group/api/computer/ia32/instruction/InstructionCluster;", "<init>", "()V", "getInstructions", "", "Lorg/bread_experts_group/api/computer/ia32/instruction/type/Instruction;", "processor", "Lorg/bread_experts_group/api/computer/ia32/IA32Processor;", "OneOperand", "ZeroOperandOverflow", "bread_server_lib"})
public final class Interrupt
implements InstructionCluster {
    @Override
    @NotNull
    public List<Instruction> getInstructions(@NotNull IA32Processor processor) {
        Intrinsics.checkNotNullParameter(processor, "processor");
        Instruction[] instructionArray = new Instruction[]{OneOperand.INSTANCE, ZeroOperandOverflow.INSTANCE};
        return CollectionsKt.listOf(instructionArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lorg/bread_experts_group/api/computer/ia32/instruction/impl/Interrupt$OneOperand;", "Lorg/bread_experts_group/api/computer/ia32/instruction/type/Instruction;", "<init>", "()V", "operands", "", "processor", "Lorg/bread_experts_group/api/computer/ia32/IA32Processor;", "handle", "", "bread_server_lib"})
    public static final class OneOperand
    extends Instruction {
        @NotNull
        public static final OneOperand INSTANCE = new OneOperand();

        private OneOperand() {
            super(205, "int", null);
        }

        @Override
        @NotNull
        public String operands(@NotNull IA32Processor processor) {
            Intrinsics.checkNotNullParameter(processor, "processor");
            return FormattingKt.hex-7apg3OU(InstructionOperandsKt.imm8(processor));
        }

        @Override
        public void handle(@NotNull IA32Processor processor) {
            Intrinsics.checkNotNullParameter(processor, "processor");
            processor.initiateInterrupt-7apg3OU(InstructionOperandsKt.imm8(processor));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lorg/bread_experts_group/api/computer/ia32/instruction/impl/Interrupt$ZeroOperandOverflow;", "Lorg/bread_experts_group/api/computer/ia32/instruction/type/Instruction;", "<init>", "()V", "operands", "", "processor", "Lorg/bread_experts_group/api/computer/ia32/IA32Processor;", "handle", "", "bread_server_lib"})
    public static final class ZeroOperandOverflow
    extends Instruction {
        @NotNull
        public static final ZeroOperandOverflow INSTANCE = new ZeroOperandOverflow();

        private ZeroOperandOverflow() {
            super(206, "into", null);
        }

        @Override
        @NotNull
        public String operands(@NotNull IA32Processor processor) {
            Intrinsics.checkNotNullParameter(processor, "processor");
            return "";
        }

        @Override
        public void handle(@NotNull IA32Processor processor) {
            Intrinsics.checkNotNullParameter(processor, "processor");
            if (processor.getFlags().getFlag(FlagsRegister.FlagType.OVERFLOW_FLAG)) {
                processor.initiateInterrupt-7apg3OU((byte)4);
            }
        }
    }
}

