/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.computer.ia32.instruction.impl;

import java.util.List;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.api.computer.BinaryUtil;
import org.bread_experts_group.api.computer.ia32.IA32Processor;
import org.bread_experts_group.api.computer.ia32.instruction.DecodingUtil;
import org.bread_experts_group.api.computer.ia32.instruction.InstructionCluster;
import org.bread_experts_group.api.computer.ia32.instruction.type.Instruction;
import org.bread_experts_group.api.computer.ia32.instruction.type.InstructionOperandsKt;
import org.bread_experts_group.api.computer.ia32.register.FlagsRegister;
import org.bread_experts_group.api.computer.ia32.register.Register;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/bread_experts_group/api/computer/ia32/instruction/impl/Loop;", "Lorg/bread_experts_group/api/computer/ia32/instruction/InstructionCluster;", "<init>", "()V", "getInstructions", "", "Lorg/bread_experts_group/api/computer/ia32/instruction/type/Instruction;", "processor", "Lorg/bread_experts_group/api/computer/ia32/IA32Processor;", "ZeroOperand", "bread_server_lib"})
public final class Loop
implements InstructionCluster {
    @Override
    @NotNull
    public List<Instruction> getInstructions(@NotNull IA32Processor processor) {
        Intrinsics.checkNotNullParameter(processor, "processor");
        ZeroOperand[] zeroOperandArray = new ZeroOperand[]{new ZeroOperand(224, "nz", arg_0 -> Loop.getInstructions$lambda$0(processor, arg_0), arg_0 -> Loop.getInstructions$lambda$1(processor, arg_0), null), new ZeroOperand(225, "z", arg_0 -> Loop.getInstructions$lambda$2(processor, arg_0), arg_0 -> Loop.getInstructions$lambda$3(processor, arg_0), null), new ZeroOperand(226, "", arg_0 -> Loop.getInstructions$lambda$4(processor, arg_0), arg_0 -> Loop.getInstructions$lambda$5(processor, arg_0), null)};
        return CollectionsKt.listOf(zeroOperandArray);
    }

    private static final boolean getInstructions$lambda$0(IA32Processor $processor, IA32Processor it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Register register2 = $processor.getC();
        long l = register2.getX-s-VKNKU();
        register2.setX-VKZWuLQ(ULong.constructor-impl(l + -1L));
        return Long.compareUnsigned($processor.getC().getX-s-VKNKU(), 0L) > 0 && !$processor.getFlags().getFlag(FlagsRegister.FlagType.ZERO_FLAG);
    }

    private static final boolean getInstructions$lambda$1(IA32Processor $processor, IA32Processor it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Register register2 = $processor.getC();
        long l = register2.getEx-s-VKNKU();
        register2.setEx-VKZWuLQ(ULong.constructor-impl(l + -1L));
        return Long.compareUnsigned($processor.getC().getEx-s-VKNKU(), 0L) > 0 && !$processor.getFlags().getFlag(FlagsRegister.FlagType.ZERO_FLAG);
    }

    private static final boolean getInstructions$lambda$2(IA32Processor $processor, IA32Processor it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Register register2 = $processor.getC();
        long l = register2.getX-s-VKNKU();
        register2.setX-VKZWuLQ(ULong.constructor-impl(l + -1L));
        return Long.compareUnsigned($processor.getC().getX-s-VKNKU(), 0L) > 0 && $processor.getFlags().getFlag(FlagsRegister.FlagType.ZERO_FLAG);
    }

    private static final boolean getInstructions$lambda$3(IA32Processor $processor, IA32Processor it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Register register2 = $processor.getC();
        long l = register2.getEx-s-VKNKU();
        register2.setEx-VKZWuLQ(ULong.constructor-impl(l + -1L));
        return Long.compareUnsigned($processor.getC().getEx-s-VKNKU(), 0L) > 0 && $processor.getFlags().getFlag(FlagsRegister.FlagType.ZERO_FLAG);
    }

    private static final boolean getInstructions$lambda$4(IA32Processor $processor, IA32Processor it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Register register2 = $processor.getC();
        long l = register2.getX-s-VKNKU();
        register2.setX-VKZWuLQ(ULong.constructor-impl(l + -1L));
        return Long.compareUnsigned($processor.getC().getX-s-VKNKU(), 0L) > 0;
    }

    private static final boolean getInstructions$lambda$5(IA32Processor $processor, IA32Processor it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Register register2 = $processor.getC();
        long l = register2.getEx-s-VKNKU();
        register2.setEx-VKZWuLQ(ULong.constructor-impl(l + -1L));
        return Long.compareUnsigned($processor.getC().getEx-s-VKNKU(), 0L) > 0;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\bH\u0016R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lorg/bread_experts_group/api/computer/ia32/instruction/impl/Loop$ZeroOperand;", "Lorg/bread_experts_group/api/computer/ia32/instruction/type/Instruction;", "opcode", "Lkotlin/UInt;", "s", "", "branch16", "Lkotlin/Function1;", "Lorg/bread_experts_group/api/computer/ia32/IA32Processor;", "", "branch32", "<init>", "(ILjava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getBranch16", "()Lkotlin/jvm/functions/Function1;", "getBranch32", "operands", "processor", "handle", "", "bread_server_lib"})
    public static final class ZeroOperand
    extends Instruction {
        @NotNull
        private final Function1<IA32Processor, Boolean> branch16;
        @NotNull
        private final Function1<IA32Processor, Boolean> branch32;

        private ZeroOperand(int opcode, String s, Function1<? super IA32Processor, Boolean> branch16, Function1<? super IA32Processor, Boolean> branch32) {
            Intrinsics.checkNotNullParameter(s, "s");
            Intrinsics.checkNotNullParameter(branch16, "branch16");
            Intrinsics.checkNotNullParameter(branch32, "branch32");
            super(opcode, "loop" + s, null);
            this.branch16 = branch16;
            this.branch32 = branch32;
        }

        @NotNull
        public final Function1<IA32Processor, Boolean> getBranch16() {
            return this.branch16;
        }

        @NotNull
        public final Function1<IA32Processor, Boolean> getBranch32() {
            return this.branch32;
        }

        @Override
        @NotNull
        public String operands(@NotNull IA32Processor processor) {
            Intrinsics.checkNotNullParameter(processor, "processor");
            byte rel8 = InstructionOperandsKt.rel8(processor);
            return BinaryUtil.INSTANCE.hex(rel8) + " [" + BinaryUtil.INSTANCE.hex-WZ4Q5Ns(UInt.constructor-impl(processor.getIp().getTex-pVg5ArA() + rel8)) + "]";
        }

        @Override
        public void handle(@NotNull IA32Processor processor) {
            Intrinsics.checkNotNullParameter(processor, "processor");
            byte rel8 = InstructionOperandsKt.rel8(processor);
            if (switch (WhenMappings.$EnumSwitchMapping$0[processor.getOperandSize().ordinal()]) {
                case 1 -> this.branch32.invoke(processor);
                case 2 -> this.branch16.invoke(processor);
                default -> throw new UnsupportedOperationException();
            }) {
                processor.getIp().setTex-WZ4Q5Ns(UInt.constructor-impl(processor.getIp().getTex-pVg5ArA() + rel8));
            }
        }

        public /* synthetic */ ZeroOperand(int opcode, String s, Function1 branch16, Function1 branch32, DefaultConstructorMarker $constructor_marker) {
            this(opcode, s, branch16, branch32);
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[DecodingUtil.AddressingLength.values().length];
                try {
                    nArray[DecodingUtil.AddressingLength.R32.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DecodingUtil.AddressingLength.R16.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

