/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.computer.ia32.instruction.impl;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.api.computer.BinaryUtil;
import org.bread_experts_group.api.computer.ia32.IA32Processor;
import org.bread_experts_group.api.computer.ia32.instruction.DecodingUtil;
import org.bread_experts_group.api.computer.ia32.instruction.InstructionCluster;
import org.bread_experts_group.api.computer.ia32.instruction.type.Instruction;
import org.bread_experts_group.api.computer.ia32.register.Register;
import org.bread_experts_group.api.computer.ia32.register.SegmentRegister;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\t\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/bread_experts_group/api/computer/ia32/instruction/impl/PushFromRegisterDefinitions;", "Lorg/bread_experts_group/api/computer/ia32/instruction/InstructionCluster;", "<init>", "()V", "getInstructions", "", "Lorg/bread_experts_group/api/computer/ia32/instruction/type/Instruction;", "processor", "Lorg/bread_experts_group/api/computer/ia32/IA32Processor;", "PushFromRegister", "PushFromSegmentRegister", "bread_server_lib"})
public final class PushFromRegisterDefinitions
implements InstructionCluster {
    @Override
    @NotNull
    public List<Instruction> getInstructions(@NotNull IA32Processor processor) {
        Intrinsics.checkNotNullParameter(processor, "processor");
        Instruction[] instructionArray = new Instruction[]{new PushFromRegister(80, "eax", "ax", processor.getA(), null), new PushFromRegister(81, "ecx", "cx", processor.getC(), null), new PushFromRegister(82, "edx", "dx", processor.getD(), null), new PushFromRegister(83, "ebx", "bx", processor.getB(), null), new PushFromRegister(84, "esp", "sp", processor.getSp(), null), new PushFromRegister(85, "ebp", "bp", processor.getBp(), null), new PushFromRegister(86, "esi", "si", processor.getSi(), null), new PushFromRegister(87, "edi", "di", processor.getDi(), null), new PushFromRegister(156, "eflags", "flags", processor.getFlags(), null), new PushFromSegmentRegister(14, 'c', processor.getCs(), null), new PushFromSegmentRegister(22, 's', processor.getSs(), null), new PushFromSegmentRegister(30, 'd', processor.getDs(), null), new PushFromSegmentRegister(6, 'e', processor.getEs(), null), new PushFromSegmentRegister(4000, 'f', processor.getFs(), null), new PushFromSegmentRegister(4008, 'g', processor.getGs(), null)};
        return CollectionsKt.listOf(instructionArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lorg/bread_experts_group/api/computer/ia32/instruction/impl/PushFromRegisterDefinitions$PushFromRegister;", "Lorg/bread_experts_group/api/computer/ia32/instruction/type/Instruction;", "opcode", "Lkotlin/UInt;", "r32n", "", "r16n", "register", "Lorg/bread_experts_group/api/computer/ia32/register/Register;", "<init>", "(ILjava/lang/String;Ljava/lang/String;Lorg/bread_experts_group/api/computer/ia32/register/Register;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getR32n", "()Ljava/lang/String;", "getR16n", "getRegister", "()Lorg/bread_experts_group/api/computer/ia32/register/Register;", "operands", "processor", "Lorg/bread_experts_group/api/computer/ia32/IA32Processor;", "handle", "", "bread_server_lib"})
    public static final class PushFromRegister
    extends Instruction {
        @NotNull
        private final String r32n;
        @NotNull
        private final String r16n;
        @NotNull
        private final Register register;

        private PushFromRegister(int opcode, String r32n, String r16n, Register register2) {
            Intrinsics.checkNotNullParameter(r32n, "r32n");
            Intrinsics.checkNotNullParameter(r16n, "r16n");
            Intrinsics.checkNotNullParameter(register2, "register");
            super(opcode, "push", null);
            this.r32n = r32n;
            this.r16n = r16n;
            this.register = register2;
        }

        @NotNull
        public final String getR32n() {
            return this.r32n;
        }

        @NotNull
        public final String getR16n() {
            return this.r16n;
        }

        @NotNull
        public final Register getRegister() {
            return this.register;
        }

        @Override
        @NotNull
        public String operands(@NotNull IA32Processor processor) {
            Intrinsics.checkNotNullParameter(processor, "processor");
            return switch (WhenMappings.$EnumSwitchMapping$0[processor.getOperandSize().ordinal()]) {
                case 1 -> this.r32n + " [" + BinaryUtil.INSTANCE.hex-WZ4Q5Ns(this.register.getTex-pVg5ArA()) + "]";
                case 2 -> this.r16n + " [" + BinaryUtil.INSTANCE.hex-xj2QHRw(this.register.getTx-Mh2AYeg()) + "]";
                default -> throw new IllegalArgumentException("Unsupported mode");
            };
        }

        @Override
        public void handle(@NotNull IA32Processor processor) {
            Intrinsics.checkNotNullParameter(processor, "processor");
            switch (WhenMappings.$EnumSwitchMapping$0[processor.getOperandSize().ordinal()]) {
                case 1: {
                    processor.push32-WZ4Q5Ns(this.register.getTex-pVg5ArA());
                    break;
                }
                case 2: {
                    processor.push16-xj2QHRw(this.register.getTx-Mh2AYeg());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported mode");
                }
            }
        }

        public /* synthetic */ PushFromRegister(int opcode, String r32n, String r16n, Register register2, DefaultConstructorMarker $constructor_marker) {
            this(opcode, r32n, r16n, register2);
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[DecodingUtil.AddressingLength.values().length];
                try {
                    nArray[DecodingUtil.AddressingLength.R32.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DecodingUtil.AddressingLength.R16.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lorg/bread_experts_group/api/computer/ia32/instruction/impl/PushFromRegisterDefinitions$PushFromSegmentRegister;", "Lorg/bread_experts_group/api/computer/ia32/instruction/type/Instruction;", "opcode", "Lkotlin/UInt;", "n", "", "register", "Lorg/bread_experts_group/api/computer/ia32/register/SegmentRegister;", "<init>", "(ICLorg/bread_experts_group/api/computer/ia32/register/SegmentRegister;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getN", "()C", "getRegister", "()Lorg/bread_experts_group/api/computer/ia32/register/SegmentRegister;", "operands", "", "processor", "Lorg/bread_experts_group/api/computer/ia32/IA32Processor;", "handle", "", "bread_server_lib"})
    public static final class PushFromSegmentRegister
    extends Instruction {
        private final char n;
        @NotNull
        private final SegmentRegister register;

        private PushFromSegmentRegister(int opcode, char n, SegmentRegister register2) {
            Intrinsics.checkNotNullParameter(register2, "register");
            super(opcode, "push", null);
            this.n = n;
            this.register = register2;
        }

        public final char getN() {
            return this.n;
        }

        @NotNull
        public final SegmentRegister getRegister() {
            return this.register;
        }

        @Override
        @NotNull
        public String operands(@NotNull IA32Processor processor) {
            Intrinsics.checkNotNullParameter(processor, "processor");
            return this.n + "s [" + BinaryUtil.INSTANCE.hex-xj2QHRw(this.register.getTx-Mh2AYeg()) + "]";
        }

        @Override
        public void handle(@NotNull IA32Processor processor) {
            Intrinsics.checkNotNullParameter(processor, "processor");
            processor.push16-xj2QHRw(this.register.getTx-Mh2AYeg());
        }

        public /* synthetic */ PushFromSegmentRegister(int opcode, char n, SegmentRegister register2, DefaultConstructorMarker $constructor_marker) {
            this(opcode, n, register2);
        }
    }
}

