/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.computer.ia32.instruction.impl;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.api.computer.ia32.IA32Processor;
import org.bread_experts_group.api.computer.ia32.instruction.InstructionCluster;
import org.bread_experts_group.api.computer.ia32.instruction.type.Instruction;
import org.bread_experts_group.api.computer.ia32.register.FlagsRegister;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/bread_experts_group/api/computer/ia32/instruction/impl/SpecificFlagModificationDefinitions;", "Lorg/bread_experts_group/api/computer/ia32/instruction/InstructionCluster;", "<init>", "()V", "getInstructions", "", "Lorg/bread_experts_group/api/computer/ia32/instruction/type/Instruction;", "processor", "Lorg/bread_experts_group/api/computer/ia32/IA32Processor;", "SpecificFlagModification", "bread_server_lib"})
public final class SpecificFlagModificationDefinitions
implements InstructionCluster {
    @Override
    @NotNull
    public List<Instruction> getInstructions(@NotNull IA32Processor processor) {
        Intrinsics.checkNotNullParameter(processor, "processor");
        SpecificFlagModification[] specificFlagModificationArray = new SpecificFlagModification[]{new SpecificFlagModification(248, 'c', FlagsRegister.FlagType.CARRY_FLAG, false, null), new SpecificFlagModification(249, 'c', FlagsRegister.FlagType.CARRY_FLAG, true, null), new SpecificFlagModification(250, 'i', FlagsRegister.FlagType.INTERRUPT_ENABLE_FLAG, false, null), new SpecificFlagModification(251, 'i', FlagsRegister.FlagType.INTERRUPT_ENABLE_FLAG, true, null), new SpecificFlagModification(252, 'd', FlagsRegister.FlagType.DIRECTION_FLAG, false, null), new SpecificFlagModification(253, 'd', FlagsRegister.FlagType.DIRECTION_FLAG, true, null)};
        return CollectionsKt.listOf(specificFlagModificationArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lorg/bread_experts_group/api/computer/ia32/instruction/impl/SpecificFlagModificationDefinitions$SpecificFlagModification;", "Lorg/bread_experts_group/api/computer/ia32/instruction/type/Instruction;", "opcode", "Lkotlin/UInt;", "n", "", "flag", "Lorg/bread_experts_group/api/computer/ia32/register/FlagsRegister$FlagType;", "state", "", "<init>", "(ICLorg/bread_experts_group/api/computer/ia32/register/FlagsRegister$FlagType;ZLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getFlag", "()Lorg/bread_experts_group/api/computer/ia32/register/FlagsRegister$FlagType;", "getState", "()Z", "operands", "", "processor", "Lorg/bread_experts_group/api/computer/ia32/IA32Processor;", "handle", "", "bread_server_lib"})
    public static final class SpecificFlagModification
    extends Instruction {
        @NotNull
        private final FlagsRegister.FlagType flag;
        private final boolean state;

        private SpecificFlagModification(int opcode, char n, FlagsRegister.FlagType flag, boolean state) {
            Intrinsics.checkNotNullParameter((Object)flag, "flag");
            super(opcode, (state ? "st" : "cl") + n, null);
            this.flag = flag;
            this.state = state;
        }

        @NotNull
        public final FlagsRegister.FlagType getFlag() {
            return this.flag;
        }

        public final boolean getState() {
            return this.state;
        }

        @Override
        @NotNull
        public String operands(@NotNull IA32Processor processor) {
            Intrinsics.checkNotNullParameter(processor, "processor");
            return "";
        }

        @Override
        public void handle(@NotNull IA32Processor processor) {
            Intrinsics.checkNotNullParameter(processor, "processor");
            processor.getFlags().setFlag(this.flag, this.state);
        }

        public /* synthetic */ SpecificFlagModification(int opcode, char n, FlagsRegister.FlagType flag, boolean state, DefaultConstructorMarker $constructor_marker) {
            this(opcode, n, flag, state);
        }
    }
}

