/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.computer.mos6502;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bread_experts_group.FormattingKt;
import org.bread_experts_group.api.computer.Computer;
import org.bread_experts_group.api.computer.Processor;
import org.bread_experts_group.api.computer.mos6502.instruction.Instruction;
import org.bread_experts_group.api.computer.mos6502.instruction.impl.BranchIfMinus;
import org.bread_experts_group.api.computer.mos6502.instruction.impl.BranchResultNotZero;
import org.bread_experts_group.api.computer.mos6502.instruction.impl.BranchResultZero;
import org.bread_experts_group.api.computer.mos6502.instruction.impl.Break;
import org.bread_experts_group.api.computer.mos6502.instruction.impl.ClearDecimalMode;
import org.bread_experts_group.api.computer.mos6502.instruction.impl.CompareMemoryWithAccumulator;
import org.bread_experts_group.api.computer.mos6502.instruction.impl.DecrementMemoryByOne;
import org.bread_experts_group.api.computer.mos6502.instruction.impl.DecrementX;
import org.bread_experts_group.api.computer.mos6502.instruction.impl.IncrementMemoryByOne;
import org.bread_experts_group.api.computer.mos6502.instruction.impl.JMPAbsolute;
import org.bread_experts_group.api.computer.mos6502.instruction.impl.LoadAccumulatorWithMemoryAbsolute;
import org.bread_experts_group.api.computer.mos6502.instruction.impl.LoadAccumulatorWithMemoryImmediate;
import org.bread_experts_group.api.computer.mos6502.instruction.impl.LoadRegisterXFromMemory;
import org.bread_experts_group.api.computer.mos6502.instruction.impl.StoreAccumulatorInMemory;
import org.bread_experts_group.api.computer.mos6502.instruction.impl.TransferIndexXToStackPointer;
import org.bread_experts_group.api.computer.mos6502.register.ByteRegister;
import org.bread_experts_group.api.computer.mos6502.register.ShortRegister;
import org.bread_experts_group.api.computer.mos6502.register.StatusRegister;
import org.bread_experts_group.logging.ColoredHandler;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010.\u001a\u00020\"H\u0016J\r\u0010/\u001a\u000200\u00a2\u0006\u0004\b1\u00102J\u0015\u00103\u001a\u0002042\u0006\u00105\u001a\u000200\u00a2\u0006\u0004\b6\u00107J\b\u00108\u001a\u00020\"H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\u0012\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR)\u0010\u001e\u001a\u001a\u0012\u0004\u0012\u00020 \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\"0!0\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u001d\u0010)\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020,0*\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010$\u00a8\u00069"}, d2={"Lorg/bread_experts_group/api/computer/mos6502/MOS6502Processor;", "Lorg/bread_experts_group/api/computer/Processor;", "<init>", "()V", "computer", "Lorg/bread_experts_group/api/computer/Computer;", "getComputer", "()Lorg/bread_experts_group/api/computer/Computer;", "setComputer", "(Lorg/bread_experts_group/api/computer/Computer;)V", "a", "Lorg/bread_experts_group/api/computer/mos6502/register/ByteRegister;", "getA", "()Lorg/bread_experts_group/api/computer/mos6502/register/ByteRegister;", "s", "getS", "x", "getX", "y", "getY", "pc", "Lorg/bread_experts_group/api/computer/mos6502/register/ShortRegister;", "getPc", "()Lorg/bread_experts_group/api/computer/mos6502/register/ShortRegister;", "setPc", "(Lorg/bread_experts_group/api/computer/mos6502/register/ShortRegister;)V", "status", "Lorg/bread_experts_group/api/computer/mos6502/register/StatusRegister;", "getStatus", "()Lorg/bread_experts_group/api/computer/mos6502/register/StatusRegister;", "biosHooks", "", "Lkotlin/UShort;", "Lkotlin/Function1;", "", "getBiosHooks", "()Ljava/util/Map;", "logger", "Ljava/util/logging/Logger;", "getLogger", "()Ljava/util/logging/Logger;", "instructionMap", "", "Lkotlin/UInt;", "Lorg/bread_experts_group/api/computer/mos6502/instruction/Instruction;", "getInstructionMap", "reset", "fetch", "Lkotlin/UByte;", "fetch-w2LRezQ", "()B", "decode", "", "byte", "decode-7apg3OU", "(B)Ljava/lang/String;", "step", "bread_server_lib"})
@SourceDebugExtension(value={"SMAP\nMOS6502Processor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MOS6502Processor.kt\norg/bread_experts_group/api/computer/mos6502/MOS6502Processor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1#2:101\n*E\n"})
public final class MOS6502Processor
implements Processor {
    public Computer computer;
    @NotNull
    private final ByteRegister a = new ByteRegister("a", 0, null);
    @NotNull
    private final ByteRegister s = new ByteRegister("s", 0, null);
    @NotNull
    private final ByteRegister x = new ByteRegister("x", 0, null);
    @NotNull
    private final ByteRegister y = new ByteRegister("y", 0, null);
    @NotNull
    private ShortRegister pc = new ShortRegister("pc", 1024, null);
    @NotNull
    private final StatusRegister status = new StatusRegister();
    @NotNull
    private final Map<UShort, Function1<MOS6502Processor, Unit>> biosHooks = new LinkedHashMap();
    @NotNull
    private final Logger logger = ColoredHandler.Companion.newLoggerResourced$default(ColoredHandler.Companion, "mos6502_processor", null, 2, null);
    @NotNull
    private final Map<UInt, Instruction> instructionMap;

    public MOS6502Processor() {
        Pair[] pairArray = new Pair[]{TuplesKt.to(UInt.box-impl(0), Break.INSTANCE), TuplesKt.to(UInt.box-impl(76), JMPAbsolute.INSTANCE), TuplesKt.to(UInt.box-impl(216), ClearDecimalMode.INSTANCE), TuplesKt.to(UInt.box-impl(162), LoadRegisterXFromMemory.INSTANCE), TuplesKt.to(UInt.box-impl(154), TransferIndexXToStackPointer.INSTANCE), TuplesKt.to(UInt.box-impl(169), LoadAccumulatorWithMemoryImmediate.INSTANCE), TuplesKt.to(UInt.box-impl(141), StoreAccumulatorInMemory.INSTANCE), TuplesKt.to(UInt.box-impl(208), BranchResultNotZero.INSTANCE), TuplesKt.to(UInt.box-impl(202), DecrementX.INSTANCE), TuplesKt.to(UInt.box-impl(240), BranchResultZero.INSTANCE), TuplesKt.to(UInt.box-impl(222), DecrementMemoryByOne.INSTANCE), TuplesKt.to(UInt.box-impl(48), BranchIfMinus.INSTANCE), TuplesKt.to(UInt.box-impl(173), LoadAccumulatorWithMemoryAbsolute.INSTANCE), TuplesKt.to(UInt.box-impl(201), CompareMemoryWithAccumulator.INSTANCE), TuplesKt.to(UInt.box-impl(254), IncrementMemoryByOne.INSTANCE)};
        this.instructionMap = MapsKt.mapOf(pairArray);
    }

    @Override
    @NotNull
    public Computer getComputer() {
        Computer computer = this.computer;
        if (computer != null) {
            return computer;
        }
        Intrinsics.throwUninitializedPropertyAccessException("computer");
        return null;
    }

    @Override
    public void setComputer(@NotNull Computer computer) {
        Intrinsics.checkNotNullParameter(computer, "<set-?>");
        this.computer = computer;
    }

    @NotNull
    public final ByteRegister getA() {
        return this.a;
    }

    @NotNull
    public final ByteRegister getS() {
        return this.s;
    }

    @NotNull
    public final ByteRegister getX() {
        return this.x;
    }

    @NotNull
    public final ByteRegister getY() {
        return this.y;
    }

    @NotNull
    public final ShortRegister getPc() {
        return this.pc;
    }

    public final void setPc(@NotNull ShortRegister shortRegister) {
        Intrinsics.checkNotNullParameter(shortRegister, "<set-?>");
        this.pc = shortRegister;
    }

    @NotNull
    public final StatusRegister getStatus() {
        return this.status;
    }

    @NotNull
    public final Map<UShort, Function1<MOS6502Processor, Unit>> getBiosHooks() {
        return this.biosHooks;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final Map<UInt, Instruction> getInstructionMap() {
        return this.instructionMap;
    }

    @Override
    public void reset() {
        this.a.setValue-7apg3OU((byte)0);
        this.s.setValue-7apg3OU((byte)0);
        this.x.setValue-7apg3OU((byte)0);
        this.y.setValue-7apg3OU((byte)0);
        this.pc.setValue-xj2QHRw((short)-4);
        this.status.setValue-7apg3OU((byte)0);
        this.status.setFlag(StatusRegister.FlagType.INTERRUPT, true);
    }

    public final byte fetch-w2LRezQ() {
        byte by;
        Function1<MOS6502Processor, Unit> function1 = this.biosHooks.get(UShort.box-impl(this.pc.getValue-Mh2AYeg()));
        if (function1 != null) {
            function1.invoke(this);
        }
        byte it = by = this.getComputer().getMemoryAt-NsiRcpg(ULong.constructor-impl((long)this.pc.getValue-Mh2AYeg() & 0xFFFFL));
        boolean bl = false;
        ShortRegister shortRegister = this.pc;
        short s = shortRegister.getValue-Mh2AYeg();
        shortRegister.setValue-xj2QHRw(UShort.constructor-impl((short)(s + 1)));
        return by;
    }

    @NotNull
    public final String decode-7apg3OU(byte by) {
        short s = this.pc.getValue-Mh2AYeg();
        int n = 1;
        StringBuilder disassembly = new StringBuilder(FormattingKt.hex-xj2QHRw(UShort.constructor-impl((short)UInt.constructor-impl(UInt.constructor-impl(s & 0xFFFF) - n))));
        disassembly.append(":[");
        disassembly.append(UByte.box-impl(by));
        disassembly.append('/');
        disassembly.append(FormattingKt.hex-7apg3OU(by));
        disassembly.append(']');
        int intFetched = UInt.constructor-impl(by & 0xFF);
        Instruction instruction2 = this.instructionMap.get(UInt.box-impl(intFetched));
        if (instruction2 == null) {
            short s2 = this.pc.getValue-Mh2AYeg();
            int n2 = 1;
            String string = "Unimplemented instruction(?): " + FormattingKt.hex-xj2QHRw(UShort.constructor-impl((short)UInt.constructor-impl(UInt.constructor-impl(s2 & 0xFFFF) - n2))) + " : " + FormattingKt.hex-7apg3OU(by);
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
        Instruction instruction3 = instruction2;
        instruction3.handle(this, disassembly);
        String string = disassembly.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @Override
    public void step() {
        this.logger.info(this.decode-7apg3OU(this.fetch-w2LRezQ()));
    }
}

