/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.graphics.feature.window;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.Semaphore;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.api.FeatureExpression;
import org.bread_experts_group.api.FeatureProvider;
import org.bread_experts_group.api.PreInitializableClosable;
import org.bread_experts_group.api.graphics.feature.window.feature.GraphicsWindowFeatureImplementation;
import org.bread_experts_group.logging.ColoredHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\u00020\u0003B#\u0012\u001a\u0010\u0004\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00020\u0005\"\u0006\u0012\u0002\b\u00030\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR6\u0010\u000f\u001a$\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00020\u0011\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\f0\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lorg/bread_experts_group/api/graphics/feature/window/GraphicsWindow;", "Lorg/bread_experts_group/api/FeatureProvider;", "Lorg/bread_experts_group/api/graphics/feature/window/feature/GraphicsWindowFeatureImplementation;", "Lorg/bread_experts_group/api/PreInitializableClosable;", "features", "", "<init>", "([Lorg/bread_experts_group/api/graphics/feature/window/feature/GraphicsWindowFeatureImplementation;)V", "logger", "Ljava/util/logging/Logger;", "getLogger", "()Ljava/util/logging/Logger;", "", "getFeatures", "()Ljava/util/List;", "supportedFeatures", "", "Lorg/bread_experts_group/api/FeatureExpression;", "getSupportedFeatures", "()Ljava/util/Map;", "processingLock", "Ljava/util/concurrent/Semaphore;", "getProcessingLock", "()Ljava/util/concurrent/Semaphore;", "bread_server_lib"})
public abstract class GraphicsWindow
implements FeatureProvider<GraphicsWindowFeatureImplementation<?>>,
PreInitializableClosable {
    @NotNull
    private final Logger logger;
    @NotNull
    private final List<GraphicsWindowFeatureImplementation<?>> features;
    @NotNull
    private final Map<FeatureExpression<? extends GraphicsWindowFeatureImplementation<?>>, List<GraphicsWindowFeatureImplementation<?>>> supportedFeatures;
    @NotNull
    private final Semaphore processingLock;

    public GraphicsWindow(GraphicsWindowFeatureImplementation<?> ... features) {
        Intrinsics.checkNotNullParameter(features, "features");
        this.logger = ColoredHandler.Companion.newLogger$default(ColoredHandler.Companion, "TMP logger", null, 2, null);
        ServiceLoader<GraphicsWindowFeatureImplementation> serviceLoader = ServiceLoader.load(GraphicsWindowFeatureImplementation.class);
        Intrinsics.checkNotNullExpressionValue(serviceLoader, "load(...)");
        this.features = CollectionsKt.toMutableList((Iterable)serviceLoader);
        this.supportedFeatures = new LinkedHashMap();
        this.processingLock = new Semaphore(1);
    }

    @Override
    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    @NotNull
    public List<GraphicsWindowFeatureImplementation<?>> getFeatures() {
        return this.features;
    }

    @Override
    @NotNull
    public Map<FeatureExpression<? extends GraphicsWindowFeatureImplementation<?>>, List<GraphicsWindowFeatureImplementation<?>>> getSupportedFeatures() {
        return this.supportedFeatures;
    }

    @NotNull
    public final Semaphore getProcessingLock() {
        return this.processingLock;
    }

    @Override
    @NotNull
    public <I extends GraphicsWindowFeatureImplementation<?>, E extends FeatureExpression<I>> I get(@NotNull E feature, boolean allowEmulated) {
        return (I)((GraphicsWindowFeatureImplementation)FeatureProvider.super.get(feature, allowEmulated));
    }
}

