/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.graphics.feature.window.feature.opengl;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.bread_experts_group.api.graphics.feature.window.feature.GraphicsWindowOpenGLContextFeature;
import org.bread_experts_group.api.graphics.feature.window.feature.opengl.OpenGLErrorKt;
import org.bread_experts_group.api.graphics.feature.window.feature.opengl.OpenGLProgramParameterName;
import org.bread_experts_group.api.graphics.feature.window.feature.opengl.OpenGLShader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014J\b\u0010\u0016\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lorg/bread_experts_group/api/graphics/feature/window/feature/opengl/OpenGLProgram;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "from", "Lorg/bread_experts_group/api/graphics/feature/window/feature/GraphicsWindowOpenGLContextFeature;", "<init>", "(Lorg/bread_experts_group/api/graphics/feature/window/feature/GraphicsWindowOpenGLContextFeature;)V", "handle", "", "getHandle", "()I", "attach", "", "shaders", "", "Lorg/bread_experts_group/api/graphics/feature/window/feature/opengl/OpenGLShader;", "([Lorg/bread_experts_group/api/graphics/feature/window/feature/opengl/OpenGLShader;)V", "link", "", "linkInfoLog", "", "kotlin.jvm.PlatformType", "close", "bread_server_lib"})
@SourceDebugExtension(value={"SMAP\nOpenGLProgram.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenGLProgram.kt\norg/bread_experts_group/api/graphics/feature/window/feature/opengl/OpenGLProgram\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,41:1\n13472#2,2:42\n*S KotlinDebug\n*F\n+ 1 OpenGLProgram.kt\norg/bread_experts_group/api/graphics/feature/window/feature/opengl/OpenGLProgram\n*L\n11#1:42,2\n*E\n"})
public final class OpenGLProgram
implements AutoCloseable {
    @NotNull
    private final GraphicsWindowOpenGLContextFeature from;
    private final int handle;

    public OpenGLProgram(@NotNull GraphicsWindowOpenGLContextFeature from) {
        Intrinsics.checkNotNullParameter(from, "from");
        this.from = from;
        this.handle = this.from.glCreateProgram();
    }

    public final int getHandle() {
        return this.handle;
    }

    public final void attach(OpenGLShader ... shaders) {
        Intrinsics.checkNotNullParameter(shaders, "shaders");
        OpenGLShader[] $this$forEach$iv = shaders;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            OpenGLShader element$iv;
            OpenGLShader shader = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            this.from.glAttachShader(this.handle, shader.getHandle());
            OpenGLErrorKt.checkAndThrow(this.from.glGetError());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean link() {
        boolean bl;
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            Arena arena = (Arena)autoCloseable;
            boolean bl2 = false;
            this.from.glLinkProgram(this.handle);
            OpenGLErrorKt.checkAndThrow(this.from.glGetError());
            MemorySegment linkStatus = arena.allocate(ValueLayout.JAVA_BOOLEAN);
            Intrinsics.checkNotNull(linkStatus);
            this.from.glGetProgramiv(this.handle, OpenGLProgramParameterName.GL_LINK_STATUS, linkStatus);
            OpenGLErrorKt.checkAndThrow(this.from.glGetError());
            bl = linkStatus.get(ValueLayout.JAVA_BOOLEAN, 0L);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String linkInfoLog() {
        String string;
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            Arena arena = (Arena)autoCloseable;
            boolean bl = false;
            MemorySegment length = arena.allocate(ValueLayout.JAVA_INT);
            Intrinsics.checkNotNull(length);
            this.from.glGetProgramiv(this.handle, OpenGLProgramParameterName.GL_INFO_LOG_LENGTH, length);
            OpenGLErrorKt.checkAndThrow(this.from.glGetError());
            int infoLogLength = length.get(ValueLayout.JAVA_INT, 0L);
            MemorySegment infoLog = arena.allocate(infoLogLength);
            Intrinsics.checkNotNull(infoLog);
            this.from.glGetProgramInfoLog(this.handle, infoLogLength, length, infoLog);
            OpenGLErrorKt.checkAndThrow(this.from.glGetError());
            string = infoLog.getString(0L, Charsets.US_ASCII);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return string;
    }

    @Override
    public void close() {
        this.from.glDeleteProgram(this.handle);
        OpenGLErrorKt.checkAndThrow(this.from.glGetError());
    }
}

