/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.graphics.windows.window;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.VarHandle;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.bread_experts_group.api.FeatureImplementation;
import org.bread_experts_group.api.FeatureProvider;
import org.bread_experts_group.api.PreInitializableClosable;
import org.bread_experts_group.api.graphics.feature.window.GraphicsWindow;
import org.bread_experts_group.api.graphics.feature.window.feature.GraphicsWindowFeatureImplementation;
import org.bread_experts_group.api.graphics.feature.window.feature.GraphicsWindowFeatures;
import org.bread_experts_group.api.graphics.feature.window.feature.GraphicsWindowNameFeature;
import org.bread_experts_group.api.graphics.windows.window.WindowsGraphicsWindowDirectXContext;
import org.bread_experts_group.api.graphics.windows.window.WindowsGraphicsWindowNameFeature;
import org.bread_experts_group.api.graphics.windows.window.WindowsGraphicsWindowOpenGLContextFeature;
import org.bread_experts_group.api.graphics.windows.window.WindowsGraphicsWindowRenderEventFeature;
import org.bread_experts_group.api.graphics.windows.window.WindowsGraphicsWindowResizeEventFeature;
import org.bread_experts_group.api.graphics.windows.window.WindowsGraphicsWindowTemplate;
import org.bread_experts_group.coder.Flaggable;
import org.bread_experts_group.ffi.ForeignFunctionInterfaceKt;
import org.bread_experts_group.ffi.windows.COMException;
import org.bread_experts_group.ffi.windows.WindowsGDIHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsKernelHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsLayoutsKt;
import org.bread_experts_group.ffi.windows.WindowsMessageTypes;
import org.bread_experts_group.ffi.windows.WindowsPixelFormatDescriptorFlags;
import org.bread_experts_group.ffi.windows.WindowsPixelTypes;
import org.bread_experts_group.ffi.windows.WindowsUserHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010 \u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u001dJ\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020%H\u0016J%\u0010'\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020(2\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b)R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R;\u0010\u0019\u001a,\u0012\u0004\u0012\u00020\u001b\u0012\"\u0012 \u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0\u001c0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006*"}, d2={"Lorg/bread_experts_group/api/graphics/windows/window/WindowsGraphicsWindow;", "Lorg/bread_experts_group/api/graphics/feature/window/GraphicsWindow;", "template", "Lorg/bread_experts_group/api/graphics/windows/window/WindowsGraphicsWindowTemplate;", "<init>", "(Lorg/bread_experts_group/api/graphics/windows/window/WindowsGraphicsWindowTemplate;)V", "arena", "Ljava/lang/foreign/Arena;", "hdc", "Ljava/lang/foreign/MemorySegment;", "getHdc$bread_server_lib", "()Ljava/lang/foreign/MemorySegment;", "setHdc$bread_server_lib", "(Ljava/lang/foreign/MemorySegment;)V", "hWnd", "getHWnd$bread_server_lib", "setHWnd$bread_server_lib", "renderFeature", "Lorg/bread_experts_group/api/graphics/windows/window/WindowsGraphicsWindowRenderEventFeature;", "getRenderFeature", "()Lorg/bread_experts_group/api/graphics/windows/window/WindowsGraphicsWindowRenderEventFeature;", "resizeFeature", "Lorg/bread_experts_group/api/graphics/windows/window/WindowsGraphicsWindowResizeEventFeature;", "getResizeFeature", "()Lorg/bread_experts_group/api/graphics/windows/window/WindowsGraphicsWindowResizeEventFeature;", "procedures", "", "", "Lkotlin/Function4;", "", "getProcedures", "()Ljava/util/Map;", "wndProc", "message", "wParam", "lParam", "open", "", "close", "sendMessage", "Lorg/bread_experts_group/ffi/windows/WindowsMessageTypes;", "sendMessage$bread_server_lib", "bread_server_lib"})
public final class WindowsGraphicsWindow
extends GraphicsWindow {
    @NotNull
    private final WindowsGraphicsWindowTemplate template;
    @NotNull
    private final Arena arena;
    public MemorySegment hdc;
    public MemorySegment hWnd;
    @NotNull
    private final WindowsGraphicsWindowRenderEventFeature renderFeature;
    @NotNull
    private final WindowsGraphicsWindowResizeEventFeature resizeFeature;
    @NotNull
    private final Map<Integer, Function4<MemorySegment, Integer, Long, Long, Long>> procedures;

    public WindowsGraphicsWindow(@NotNull WindowsGraphicsWindowTemplate template) {
        Intrinsics.checkNotNullParameter(template, "template");
        super(new GraphicsWindowFeatureImplementation[0]);
        this.template = template;
        Arena arena = Arena.ofShared();
        Intrinsics.checkNotNullExpressionValue(arena, "ofShared(...)");
        this.arena = arena;
        this.renderFeature = new WindowsGraphicsWindowRenderEventFeature();
        this.resizeFeature = new WindowsGraphicsWindowResizeEventFeature();
        ((Collection)this.getFeatures()).add(new WindowsGraphicsWindowNameFeature(this));
        ((Collection)this.getFeatures()).add(new WindowsGraphicsWindowOpenGLContextFeature(this));
        ((Collection)this.getFeatures()).add(new WindowsGraphicsWindowDirectXContext(this));
        ((Collection)this.getFeatures()).add(this.renderFeature);
        ((Collection)this.getFeatures()).add(this.resizeFeature);
        Pair[] pairArray = new Pair[]{TuplesKt.to((int)WindowsMessageTypes.WM_DESTROY.getPosition(), WindowsGraphicsWindow::procedures$lambda$0), TuplesKt.to((int)WindowsMessageTypes.WM_PAINT.getPosition(), (arg_0, arg_1, arg_2, arg_3) -> WindowsGraphicsWindow.procedures$lambda$1(this, arg_0, arg_1, arg_2, arg_3)), TuplesKt.to((int)WindowsMessageTypes.WM_SIZE.getPosition(), (arg_0, arg_1, arg_2, arg_3) -> WindowsGraphicsWindow.procedures$lambda$2(this, arg_0, arg_1, arg_2, arg_3))};
        this.procedures = MapsKt.mutableMapOf(pairArray);
    }

    @NotNull
    public final MemorySegment getHdc$bread_server_lib() {
        MemorySegment memorySegment = this.hdc;
        if (memorySegment != null) {
            return memorySegment;
        }
        Intrinsics.throwUninitializedPropertyAccessException("hdc");
        return null;
    }

    public final void setHdc$bread_server_lib(@NotNull MemorySegment memorySegment) {
        Intrinsics.checkNotNullParameter(memorySegment, "<set-?>");
        this.hdc = memorySegment;
    }

    @NotNull
    public final MemorySegment getHWnd$bread_server_lib() {
        MemorySegment memorySegment = this.hWnd;
        if (memorySegment != null) {
            return memorySegment;
        }
        Intrinsics.throwUninitializedPropertyAccessException("hWnd");
        return null;
    }

    public final void setHWnd$bread_server_lib(@NotNull MemorySegment memorySegment) {
        Intrinsics.checkNotNullParameter(memorySegment, "<set-?>");
        this.hWnd = memorySegment;
    }

    @NotNull
    public final WindowsGraphicsWindowRenderEventFeature getRenderFeature() {
        return this.renderFeature;
    }

    @NotNull
    public final WindowsGraphicsWindowResizeEventFeature getResizeFeature() {
        return this.resizeFeature;
    }

    @NotNull
    public final Map<Integer, Function4<MemorySegment, Integer, Long, Long, Long>> getProcedures() {
        return this.procedures;
    }

    public final long wndProc(@NotNull MemorySegment hWnd, int message, long wParam, long lParam) {
        Intrinsics.checkNotNullParameter(hWnd, "hWnd");
        Function4<MemorySegment, Integer, Long, Long, Long> function4 = this.procedures.get(message);
        if (function4 == null) {
            MethodHandle methodHandle = WindowsUserHandlesKt.getNativeDefWindowProcW();
            Intrinsics.checkNotNull(methodHandle);
            return methodHandle.invokeExact(hWnd, message, wParam, lParam);
        }
        Function4<MemorySegment, Integer, Long, Long, Long> proc = function4;
        return ((Number)proc.invoke(hWnd, message, wParam, lParam)).longValue();
    }

    @Override
    public void open() {
        CountDownLatch initLatch = new CountDownLatch(1);
        this.getProcessingLock().acquire();
        Thread.ofPlatform().daemon().start(() -> WindowsGraphicsWindow.open$lambda$3(this, initLatch));
        initLatch.await();
    }

    @Override
    public void close() {
        for (GraphicsWindowFeatureImplementation<?> feature : this.getFeatures()) {
            if (!(feature instanceof AutoCloseable)) continue;
            ((AutoCloseable)((Object)feature)).close();
        }
        MethodHandle methodHandle = WindowsUserHandlesKt.getNativeReleaseDC();
        Intrinsics.checkNotNull(methodHandle);
        methodHandle.invokeExact(this.getHWnd$bread_server_lib(), this.getHdc$bread_server_lib());
        this.arena.close();
    }

    public final long sendMessage$bread_server_lib(@NotNull WindowsMessageTypes message, long wParam, long lParam) {
        Intrinsics.checkNotNullParameter(message, "message");
        MethodHandle methodHandle = WindowsUserHandlesKt.getNativeSendMessageW();
        Intrinsics.checkNotNull(methodHandle);
        return methodHandle.invokeExact(this.getHWnd$bread_server_lib(), (int)message.getPosition(), wParam, lParam);
    }

    private static final long procedures$lambda$0(MemorySegment memorySegment, int n, long l, long l2) {
        Intrinsics.checkNotNullParameter(memorySegment, "<unused var>");
        MethodHandle methodHandle = WindowsUserHandlesKt.getNativePostQuitMessage();
        Intrinsics.checkNotNull(methodHandle);
        methodHandle.invokeExact(0);
        return 0L;
    }

    private static final long procedures$lambda$1(WindowsGraphicsWindow this$0, MemorySegment memorySegment, int n, long l, long l2) {
        Intrinsics.checkNotNullParameter(memorySegment, "<unused var>");
        this$0.renderFeature.getLambda().invoke();
        return 0L;
    }

    private static final long procedures$lambda$2(WindowsGraphicsWindow this$0, MemorySegment memorySegment, int n, long l, long clientSize) {
        Intrinsics.checkNotNullParameter(memorySegment, "<unused var>");
        this$0.resizeFeature.getLambda().invoke(clientSize & 0xFFFFL, clientSize >> 16 & 0xFFFFL);
        return 0L;
    }

    private static final void open$lambda$3(WindowsGraphicsWindow this$0, CountDownLatch $initLatch) {
        MethodHandle methodHandle = WindowsKernelHandlesKt.getNativeGetModuleHandleW();
        Intrinsics.checkNotNull(methodHandle);
        MemorySegment localHandle = methodHandle.invokeExact(MemorySegment.NULL);
        MethodHandle methodHandle2 = WindowsUserHandlesKt.getNativeCreateWindowExW();
        Intrinsics.checkNotNull(methodHandle2);
        MemorySegment memorySegment = ForeignFunctionInterfaceKt.getCapturedStateSegment();
        MemorySegment memorySegment2 = MemorySegment.ofAddress((long)this$0.template.getClassAtom() & 0xFFFFL);
        Arena arena = this$0.arena;
        FeatureImplementation featureImplementation = FeatureProvider.get$default(this$0, GraphicsWindowFeatures.INSTANCE.getWINDOW_NAME(), false, 2, null);
        Intrinsics.checkNotNull(featureImplementation);
        this$0.setHWnd$bread_server_lib(methodHandle2.invokeExact(memorySegment, 768, memorySegment2, arena.allocateFrom(((GraphicsWindowNameFeature)featureImplementation).getName(), Charsets.UTF_16LE), 0x10CC0000, 0, 0, 300, 400, MemorySegment.NULL, MemorySegment.NULL, localHandle, MemorySegment.NULL));
        if (Intrinsics.areEqual(this$0.getHWnd$bread_server_lib(), MemorySegment.NULL)) {
            WindowsUtilitiesKt.decodeLastError(this$0.arena);
        }
        Thread.currentThread().setName(this$0.getHWnd$bread_server_lib() + " Message Management");
        this$0.template.getWindows().put(this$0.getHWnd$bread_server_lib(), new Function4<MemorySegment, Integer, Long, Long, Long>((Object)this$0){

            public final Long invoke(MemorySegment p0, int p1, long p2, long p3) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ((WindowsGraphicsWindow)this.receiver).wndProc(p0, p1, p2, p3);
            }
        });
        MethodHandle methodHandle3 = WindowsUserHandlesKt.getNativeGetDCEx();
        Intrinsics.checkNotNull(methodHandle3);
        this$0.setHdc$bread_server_lib(methodHandle3.invokeExact(this$0.getHWnd$bread_server_lib(), MemorySegment.NULL, 2));
        if (Intrinsics.areEqual(this$0.getHdc$bread_server_lib(), MemorySegment.NULL)) {
            throw new COMException("Failed to retrieve window device context.");
        }
        MemorySegment pixelFormatDescriptor = this$0.arena.allocate(WindowsLayoutsKt.getPIXELFORMATDESCRIPTOR());
        WindowsLayoutsKt.getPIXELFORMATDESCRIPTOR_nSize().set(pixelFormatDescriptor, 0, (short)pixelFormatDescriptor.byteSize());
        WindowsLayoutsKt.getPIXELFORMATDESCRIPTOR_nVersion().set(pixelFormatDescriptor, 0, (short)1);
        VarHandle varHandle = WindowsLayoutsKt.getPIXELFORMATDESCRIPTOR_dwFlags();
        EnumSet<Enum> enumSet = EnumSet.of((Enum)WindowsPixelFormatDescriptorFlags.PFD_DRAW_TO_WINDOW, (Enum)WindowsPixelFormatDescriptorFlags.PFD_SUPPORT_OPENGL, (Enum)WindowsPixelFormatDescriptorFlags.PFD_DOUBLEBUFFER);
        Intrinsics.checkNotNullExpressionValue(enumSet, "of(...)");
        varHandle.set(pixelFormatDescriptor, 0, (int)Flaggable.Companion.raw((Collection<? extends Flaggable>)enumSet));
        WindowsLayoutsKt.getPIXELFORMATDESCRIPTOR_iPixelType().set(pixelFormatDescriptor, 0, (byte)WindowsPixelTypes.PFD_TYPE_RGBA.getPosition());
        WindowsLayoutsKt.getPIXELFORMATDESCRIPTOR_cColorBits().set(pixelFormatDescriptor, 0, (byte)24);
        WindowsLayoutsKt.getPIXELFORMATDESCRIPTOR_cDepthBits().set(pixelFormatDescriptor, 0, (byte)32);
        MethodHandle methodHandle4 = WindowsGDIHandlesKt.getNativeChoosePixelFormat();
        Intrinsics.checkNotNull(methodHandle4);
        int pixelFormat = methodHandle4.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), this$0.getHdc$bread_server_lib(), pixelFormatDescriptor);
        if (pixelFormat == 0) {
            WindowsUtilitiesKt.decodeLastError(this$0.arena);
        }
        MethodHandle methodHandle5 = WindowsGDIHandlesKt.getNativeSetPixelFormat();
        Intrinsics.checkNotNull(methodHandle5);
        int formatSet = methodHandle5.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), this$0.getHdc$bread_server_lib(), pixelFormat, pixelFormatDescriptor);
        if (formatSet == 0) {
            WindowsUtilitiesKt.decodeLastError(this$0.arena);
        }
        for (GraphicsWindowFeatureImplementation<?> feature : this$0.getFeatures()) {
            if (!(feature instanceof PreInitializableClosable)) continue;
            ((PreInitializableClosable)((Object)feature)).open();
        }
        $initLatch.countDown();
        MemorySegment message = this$0.arena.allocate(WindowsLayoutsKt.getMSG());
        block5: while (true) {
            MethodHandle methodHandle6 = WindowsUserHandlesKt.getNativeGetMessageW();
            Intrinsics.checkNotNull(methodHandle6);
            int status = methodHandle6.invokeExact(ForeignFunctionInterfaceKt.getCapturedStateSegment(), message, MemorySegment.NULL, 0, 0);
            switch (status) {
                case -1: {
                    WindowsUtilitiesKt.decodeLastError(this$0.arena);
                    continue block5;
                }
                case 0: {
                    break block5;
                }
                default: {
                    MethodHandle methodHandle7 = WindowsUserHandlesKt.getNativeTranslateMessage();
                    Intrinsics.checkNotNull(methodHandle7);
                    methodHandle7.invokeExact(message);
                    MethodHandle methodHandle8 = WindowsUserHandlesKt.getNativeDispatchMessageW();
                    Intrinsics.checkNotNull(methodHandle8);
                    methodHandle8.invokeExact(message);
                    continue block5;
                }
            }
            break;
        }
        this$0.getProcessingLock().release();
    }
}

