/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.secure.blob.feature.windows;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.invoke.MethodHandle;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.api.secure.blob.windows.WindowsSecureDataBlob;
import org.bread_experts_group.ffi.windows.WindowsCryptHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsCryptProtectMemoryFlags;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"initializeOff", "", "parent", "Lorg/bread_experts_group/api/secure/blob/windows/WindowsSecureDataBlob;", "size", "", "flags", "Lorg/bread_experts_group/ffi/windows/WindowsCryptProtectMemoryFlags;", "bread_server_lib"})
public final class WindowsCommonEncryptedKt {
    public static final void initializeOff(@NotNull WindowsSecureDataBlob parent, long size, @NotNull WindowsCryptProtectMemoryFlags flags) {
        long l;
        Intrinsics.checkNotNullParameter(parent, "parent");
        Intrinsics.checkNotNullParameter(flags, "flags");
        long it = l = (long)Math.ceil((double)size / 16.0) * 16L;
        boolean bl = false;
        if (it > ((long)-1 & 0xFFFFFFFFL)) {
            throw new IllegalArgumentException("Encryption block size too large, " + it + " > " + ((long)-1 & 0xFFFFFFFFL));
        }
        long padded = l;
        parent.setEncrypt(() -> WindowsCommonEncryptedKt.initializeOff$lambda$1(parent, padded, flags));
        parent.setDecrypt(() -> WindowsCommonEncryptedKt.initializeOff$lambda$2(parent, padded, flags));
        parent.setManagedSegmentRealSize$bread_server_lib(padded);
        MemorySegment memorySegment = parent.getArena$bread_server_lib().allocate(padded).reinterpret(size);
        Intrinsics.checkNotNullExpressionValue(memorySegment, "reinterpret(...)");
        parent.setManagedSegment$bread_server_lib(memorySegment);
    }

    private static final Unit initializeOff$lambda$1(WindowsSecureDataBlob $parent, long $padded, WindowsCryptProtectMemoryFlags $flags) {
        MethodHandle methodHandle = WindowsCryptHandlesKt.getNativeCryptProtectMemory();
        Intrinsics.checkNotNull(methodHandle);
        int r = methodHandle.invokeExact($parent.getManagedSegment$bread_server_lib(), (int)$padded, $flags.getId-pVg5ArA());
        if (r == 0) {
            Arena arena = $parent.getArena$bread_server_lib();
            Intrinsics.checkNotNullExpressionValue(arena, "<get-arena>(...)");
            WindowsUtilitiesKt.decodeLastError(arena);
        }
        return Unit.INSTANCE;
    }

    private static final Unit initializeOff$lambda$2(WindowsSecureDataBlob $parent, long $padded, WindowsCryptProtectMemoryFlags $flags) {
        MethodHandle methodHandle = WindowsCryptHandlesKt.getNativeCryptUnprotectMemory();
        Intrinsics.checkNotNull(methodHandle);
        int r = methodHandle.invokeExact($parent.getManagedSegment$bread_server_lib(), (int)$padded, $flags.getId-pVg5ArA());
        if (r == 0) {
            Arena arena = $parent.getArena$bread_server_lib();
            Intrinsics.checkNotNullExpressionValue(arena, "<get-arena>(...)");
            WindowsUtilitiesKt.decodeLastError(arena);
        }
        return Unit.INSTANCE;
    }
}

