/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.secure.cryptography;

import java.lang.ref.Cleaner;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.api.FeatureExpression;
import org.bread_experts_group.api.FeatureProvider;
import org.bread_experts_group.api.secure.cryptography.feature.CryptographySystemFeatureImplementation;
import org.bread_experts_group.logging.ColoredHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u001a2\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\u00060\u0003j\u0002`\u0004:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0017\u001a\u00020\u0018H&J\u0006\u0010\u0019\u001a\u00020\u0018R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR6\u0010\u000f\u001a$\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00020\u0011\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\f0\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/bread_experts_group/api/secure/cryptography/CryptographySystem;", "Lorg/bread_experts_group/api/FeatureProvider;", "Lorg/bread_experts_group/api/secure/cryptography/feature/CryptographySystemFeatureImplementation;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "<init>", "()V", "logger", "Ljava/util/logging/Logger;", "getLogger", "()Ljava/util/logging/Logger;", "features", "", "getFeatures", "()Ljava/util/List;", "supportedFeatures", "", "Lorg/bread_experts_group/api/FeatureExpression;", "getSupportedFeatures", "()Ljava/util/Map;", "cleanOp", "Ljava/lang/ref/Cleaner$Cleanable;", "kotlin.jvm.PlatformType", "clean", "", "close", "Companion", "bread_server_lib"})
public abstract class CryptographySystem
implements FeatureProvider<CryptographySystemFeatureImplementation<?>>,
AutoCloseable {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger = ColoredHandler.Companion.newLogger$default(ColoredHandler.Companion, "TMP logger", null, 2, null);
    @NotNull
    private final List<CryptographySystemFeatureImplementation<?>> features;
    @NotNull
    private final Map<FeatureExpression<? extends CryptographySystemFeatureImplementation<?>>, List<CryptographySystemFeatureImplementation<?>>> supportedFeatures;
    private final Cleaner.Cleanable cleanOp;
    @NotNull
    private static final Cleaner csCleaner;

    public CryptographySystem() {
        ServiceLoader<CryptographySystemFeatureImplementation> serviceLoader = ServiceLoader.load(CryptographySystemFeatureImplementation.class);
        Intrinsics.checkNotNullExpressionValue(serviceLoader, "load(...)");
        this.features = CollectionsKt.toMutableList((Iterable)serviceLoader);
        this.supportedFeatures = new LinkedHashMap();
        this.cleanOp = csCleaner.register(this, () -> CryptographySystem.cleanOp$lambda$0(this));
    }

    @Override
    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    @NotNull
    public List<CryptographySystemFeatureImplementation<?>> getFeatures() {
        return this.features;
    }

    @Override
    @NotNull
    public Map<FeatureExpression<? extends CryptographySystemFeatureImplementation<?>>, List<CryptographySystemFeatureImplementation<?>>> getSupportedFeatures() {
        return this.supportedFeatures;
    }

    public abstract void clean();

    @Override
    public final void close() {
        this.cleanOp.clean();
    }

    @Override
    @NotNull
    public <I extends CryptographySystemFeatureImplementation<?>, E extends FeatureExpression<I>> I get(@NotNull E feature, boolean allowEmulated) {
        return (I)((CryptographySystemFeatureImplementation)FeatureProvider.super.get(feature, allowEmulated));
    }

    private static final void cleanOp$lambda$0(CryptographySystem this$0) {
        this$0.clean();
    }

    static {
        Cleaner cleaner = Cleaner.create();
        Intrinsics.checkNotNullExpressionValue(cleaner, "create(...)");
        csCleaner = cleaner;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/bread_experts_group/api/secure/cryptography/CryptographySystem$Companion;", "", "<init>", "()V", "csCleaner", "Ljava/lang/ref/Cleaner;", "getCsCleaner", "()Ljava/lang/ref/Cleaner;", "bread_server_lib"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Cleaner getCsCleaner() {
            return csCleaner;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

