/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.secure.cryptography.windows;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UInt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.LongIterator;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.bread_experts_group.api.ImplementationSource;
import org.bread_experts_group.api.secure.cryptography.CryptographySystem;
import org.bread_experts_group.api.secure.cryptography.CryptographySystemFeatures;
import org.bread_experts_group.api.secure.cryptography.CryptographySystemProvider;
import org.bread_experts_group.api.secure.cryptography.windows.WindowsBCryptCryptographySystem;
import org.bread_experts_group.api.secure.cryptography.windows.feature.hash.WindowsCSHAKEXOFHashingFeature;
import org.bread_experts_group.api.secure.cryptography.windows.feature.hash.WindowsCommonHashingKt;
import org.bread_experts_group.api.secure.cryptography.windows.feature.hash.WindowsHashingFeature;
import org.bread_experts_group.api.secure.cryptography.windows.feature.hash.WindowsKMACXOFHashingFeature;
import org.bread_experts_group.api.secure.cryptography.windows.feature.hash.WindowsMACHashingFeature;
import org.bread_experts_group.api.secure.cryptography.windows.feature.hash.WindowsMACSIMDHashingFeature;
import org.bread_experts_group.api.secure.cryptography.windows.feature.hash.WindowsSIMDHashingFeature;
import org.bread_experts_group.api.secure.cryptography.windows.feature.hash.WindowsXOFHashingFeature;
import org.bread_experts_group.api.secure.cryptography.windows.feature.random.WindowsRandomFeature;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.bread_experts_group.ffi.windows.bcrypt.WindowsBCryptAlgorithmFlags;
import org.bread_experts_group.ffi.windows.bcrypt.WindowsBCryptHandlesKt;
import org.bread_experts_group.ffi.windows.bcrypt.WindowsBCryptInterface;
import org.bread_experts_group.ffi.windows.bcrypt.WindowsBCryptProviderDescription;
import org.bread_experts_group.ffi.windows.bcrypt.WindowsBCryptProviderImageDescription;
import org.bread_experts_group.ffi.windows.bcrypt.WindowsBCryptProviderInterfaceDescription;
import org.bread_experts_group.ffi.windows.bcrypt.WindowsBCryptProviderMode;
import org.bread_experts_group.logging.ColoredHandler;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R,\u0010\b\u001a \u0012\u0004\u0012\u00020\n\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\r0\u000b0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/bread_experts_group/api/secure/cryptography/windows/WindowsBCryptCryptographySystemProvider;", "Lorg/bread_experts_group/api/secure/cryptography/CryptographySystemProvider;", "<init>", "()V", "source", "Lorg/bread_experts_group/api/ImplementationSource;", "getSource", "()Lorg/bread_experts_group/api/ImplementationSource;", "providerInterfaceMap", "", "Lorg/bread_experts_group/ffi/windows/bcrypt/WindowsBCryptInterface;", "", "", "", "logger", "Ljava/util/logging/Logger;", "supported", "", "new", "Lorg/bread_experts_group/api/secure/cryptography/CryptographySystem;", "bread_server_lib"})
@SourceDebugExtension(value={"SMAP\nWindowsBCryptCryptographySystemProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsBCryptCryptographySystemProvider.kt\norg/bread_experts_group/api/secure/cryptography/windows/WindowsBCryptCryptographySystemProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,493:1\n1869#2,2:494\n1285#2,2:496\n1299#2,4:498\n1285#2,2:502\n1299#2,2:504\n1869#2:506\n1870#2:514\n1302#2:515\n382#3,7:507\n*S KotlinDebug\n*F\n+ 1 WindowsBCryptCryptographySystemProvider.kt\norg/bread_experts_group/api/secure/cryptography/windows/WindowsBCryptCryptographySystemProvider\n*L\n40#1:494,2\n46#1:496,2\n46#1:498,4\n47#1:502,2\n47#1:504,2\n67#1:506\n67#1:514\n47#1:515\n69#1:507,7\n*E\n"})
public final class WindowsBCryptCryptographySystemProvider
extends CryptographySystemProvider {
    @NotNull
    private final ImplementationSource source = ImplementationSource.SYSTEM_NATIVE;
    @NotNull
    private Map<WindowsBCryptInterface, ? extends Map<String, Set<String>>> providerInterfaceMap = MapsKt.emptyMap();
    @NotNull
    private final Logger logger = ColoredHandler.Companion.newLogger$default(ColoredHandler.Companion, "TMP logger", null, 2, null);

    @Override
    @NotNull
    public ImplementationSource getSource() {
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public boolean supported() {
        boolean bl;
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            boolean bl2;
            block19: {
                MethodHandle methodHandle;
                List<String> list;
                Arena arena = (Arena)autoCloseable;
                boolean bl3 = false;
                MemorySegment bufferSz = arena.allocate(WindowsUtilitiesKt.getULONG());
                MemorySegment bufferLoc = arena.allocate(ValueLayout.ADDRESS);
                List<String> $this$supported_u24lambda_u248_u24lambda_u242 = list = CollectionsKt.createListBuilder();
                boolean bl4 = false;
                if (WindowsBCryptHandlesKt.getNativeBCryptEnumRegisteredProviders() == null) {
                    boolean bl5 = false;
                    return bl5;
                }
                Intrinsics.checkNotNull(bufferSz);
                Intrinsics.checkNotNull(bufferLoc);
                WindowsUtilitiesKt.returnsNTSTATUS(methodHandle, bufferSz, bufferLoc);
                MemorySegment buffer = bufferLoc.get(ValueLayout.ADDRESS, 0L).reinterpret((long)UInt.constructor-impl(bufferSz.get(WindowsUtilitiesKt.getULONG(), 0L)) & 0xFFFFFFFFL, arena, WindowsBCryptCryptographySystemProvider::supported$lambda$8$lambda$2$lambda$0);
                long count = (long)UInt.constructor-impl(buffer.get(WindowsUtilitiesKt.getULONG(), 0L)) & 0xFFFFFFFFL;
                if (count == 0L) {
                    bl2 = false;
                } else {
                    MemorySegment memorySegment;
                    WindowsBCryptInterface it;
                    Object object;
                    Object object2;
                    MemorySegment array = buffer.get(ValueLayout.ADDRESS, 8L).reinterpret(ValueLayout.ADDRESS.byteSize() * count);
                    long offset = 0L;
                    Object $this$forEach$iv = RangesKt.until(0, count);
                    boolean $i$f$forEach = false;
                    Iterator iterator2 = $this$forEach$iv.iterator();
                    while (iterator2.hasNext()) {
                        long element$iv = ((LongIterator)iterator2).nextLong();
                        boolean bl6 = false;
                        MemorySegment string = array.get(ValueLayout.ADDRESS, offset);
                        $this$supported_u24lambda_u248_u24lambda_u242.add(string.reinterpret(Long.MAX_VALUE).getString(0L, Charsets.UTF_16LE));
                        offset += ValueLayout.ADDRESS.byteSize();
                    }
                    List<String> readStrings = CollectionsKt.build(list);
                    Iterable $this$associateWith$iv = readStrings;
                    boolean $i$f$associateWith = false;
                    LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
                    Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
                    boolean $i$f$associateWithTo = false;
                    for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                        $this$forEach$iv = (String)element$iv$iv;
                        object2 = element$iv$iv;
                        object = result$iv;
                        boolean bl7 = false;
                        memorySegment = arena.allocateFrom((String)((Object)it), Charsets.UTF_16LE);
                        object.put(object2, memorySegment);
                    }
                    Map allocatedStrings = result$iv;
                    $this$associateWith$iv = WindowsBCryptInterface.getEntries();
                    object = this;
                    $i$f$associateWith = false;
                    result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
                    $this$associateWithTo$iv$iv = $this$associateWith$iv;
                    $i$f$associateWithTo = false;
                    for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                        it = (WindowsBCryptInterface)element$iv$iv;
                        memorySegment = element$iv$iv;
                        object2 = result$iv;
                        boolean bl8 = false;
                        Map functionMap = new LinkedHashMap();
                        for (String providerName : readStrings) {
                            void bcInterface;
                            bufferSz.set(WindowsUtilitiesKt.getULONG(), 0L, 0);
                            bufferLoc.set(ValueLayout.ADDRESS, 0L, MemorySegment.NULL);
                            MethodHandle methodHandle2 = WindowsBCryptHandlesKt.getNativeBCryptQueryProviderRegistration();
                            if (methodHandle2 == null) {
                                bl2 = false;
                                break block19;
                            }
                            Object v = allocatedStrings.get(providerName);
                            Intrinsics.checkNotNull(v);
                            WindowsUtilitiesKt.returnsNTSTATUS(methodHandle2, v, WindowsBCryptProviderMode.CRYPT_ANY.getId-pVg5ArA(), bcInterface.getId-pVg5ArA(), bufferSz, bufferLoc);
                            MemorySegment memorySegment2 = bufferLoc.get(ValueLayout.ADDRESS, 0L).reinterpret((long)UInt.constructor-impl(bufferSz.get(WindowsUtilitiesKt.getULONG(), 0L)) & 0xFFFFFFFFL, arena, WindowsBCryptCryptographySystemProvider::supported$lambda$8$lambda$7$lambda$4);
                            Intrinsics.checkNotNullExpressionValue(memorySegment2, "reinterpret(...)");
                            WindowsBCryptProviderDescription provider = new WindowsBCryptProviderDescription(memorySegment2);
                            Object object3 = provider.getUserMode();
                            if (object3 == null || (object3 = ((WindowsBCryptProviderImageDescription)object3).getInterfaces()) == null) continue;
                            Iterable $this$forEach$iv2 = (Iterable)object3;
                            boolean $i$f$forEach2 = false;
                            for (Object element$iv : $this$forEach$iv2) {
                                WindowsBCryptProviderInterfaceDescription it2 = (WindowsBCryptProviderInterfaceDescription)element$iv;
                                boolean bl9 = false;
                                for (String function : it2.getBcFunctions()) {
                                    Object object4;
                                    void $this$getOrPut$iv;
                                    Map map = functionMap;
                                    String key$iv = function;
                                    boolean $i$f$getOrPut = false;
                                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                                    if (value$iv == null) {
                                        boolean bl10 = false;
                                        Set answer$iv = new LinkedHashSet();
                                        $this$getOrPut$iv.put(key$iv, answer$iv);
                                        object4 = answer$iv;
                                    } else {
                                        object4 = value$iv;
                                    }
                                    Set aliasMap = (Set)object4;
                                    aliasMap.addAll((Collection)provider.getAliases());
                                    Intrinsics.checkNotNull(providerName);
                                    aliasMap.add(providerName);
                                }
                            }
                        }
                        Map map = functionMap;
                        object2.put((MemorySegment)memorySegment, (Map)map);
                    }
                    ((WindowsBCryptCryptographySystemProvider)object).providerInterfaceMap = result$iv;
                    boolean bl11 = true;
                    return bl11;
                }
            }
            bl = bl2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return bl;
    }

    @Override
    @NotNull
    public CryptographySystem new() {
        WindowsBCryptCryptographySystem system = new WindowsBCryptCryptographySystem();
        system.getExposedFeatures$bread_server_lib().add(new WindowsRandomFeature(CryptographySystemFeatures.INSTANCE.getRANDOM_SYSTEM_PREFERRED(), null));
        block63: for (Map.Entry<WindowsBCryptInterface, ? extends Map<String, Set<String>>> entry : this.providerInterfaceMap.entrySet()) {
            WindowsBCryptInterface iface = entry.getKey();
            Map<String, Set<String>> functions = entry.getValue();
            switch (WhenMappings.$EnumSwitchMapping$0[iface.ordinal()]) {
                case 1: {
                    Set<String> providers;
                    String function;
                    for (Map.Entry<String, Set<String>> entry2 : functions.entrySet()) {
                        function = entry2.getKey();
                        providers = entry2.getValue();
                        this.logger.info(() -> WindowsBCryptCryptographySystemProvider.new$lambda$9(iface, function));
                    }
                    continue block63;
                }
                case 2: {
                    MemorySegment algorithm;
                    Arena it;
                    Set<String> providers;
                    String function;
                    block65: for (Map.Entry<String, Set<String>> entry2 : functions.entrySet()) {
                        function = entry2.getKey();
                        providers = entry2.getValue();
                        switch (function) {
                            case "AES-GMAC": {
                                continue block65;
                            }
                            case "MD2": {
                                system.getExposedFeatures$bread_server_lib().add(new WindowsHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_MD2(), WindowsBCryptHandlesKt.getBCRYPT_MD2_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_MD2_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_MD2_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_MD2_HMAC(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_MD2_ALG_HANDLE(), null, 4, null));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_MD2_HMAC_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_MD2_ALG_HANDLE(), null, 4, null));
                                continue block65;
                            }
                            case "MD4": {
                                system.getExposedFeatures$bread_server_lib().add(new WindowsHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_MD4(), WindowsBCryptHandlesKt.getBCRYPT_MD4_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_MD4_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_MD4_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_MD4_HMAC(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_MD4_ALG_HANDLE(), null, 4, null));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_MD4_HMAC_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_MD4_ALG_HANDLE(), null, 4, null));
                                continue block65;
                            }
                            case "MD5": {
                                system.getExposedFeatures$bread_server_lib().add(new WindowsHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_MD5(), WindowsBCryptHandlesKt.getBCRYPT_MD5_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_MD5_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_MD5_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_MD5_HMAC(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_MD5_ALG_HANDLE(), null, 4, null));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_MD5_HMAC_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_MD5_ALG_HANDLE(), null, 4, null));
                                continue block65;
                            }
                            case "SHA1": {
                                system.getExposedFeatures$bread_server_lib().add(new WindowsHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA1(), WindowsBCryptHandlesKt.getBCRYPT_SHA1_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA1_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_SHA1_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA1_HMAC(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_SHA1_ALG_HANDLE(), null, 4, null));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA1_HMAC_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_SHA1_ALG_HANDLE(), null, 4, null));
                                continue block65;
                            }
                            case "SHA256": {
                                system.getExposedFeatures$bread_server_lib().add(new WindowsHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA256(), WindowsBCryptHandlesKt.getBCRYPT_SHA256_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA256_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_SHA256_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA256_HMAC(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_SHA256_ALG_HANDLE(), null, 4, null));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA256_HMAC_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_SHA256_ALG_HANDLE(), null, 4, null));
                                continue block65;
                            }
                            case "SHA384": {
                                system.getExposedFeatures$bread_server_lib().add(new WindowsHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA384(), WindowsBCryptHandlesKt.getBCRYPT_SHA384_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA384_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_SHA384_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA384_HMAC(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_SHA384_ALG_HANDLE(), null, 4, null));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA384_HMAC_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_SHA384_ALG_HANDLE(), null, 4, null));
                                continue block65;
                            }
                            case "SHA512": {
                                system.getExposedFeatures$bread_server_lib().add(new WindowsHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA512(), WindowsBCryptHandlesKt.getBCRYPT_SHA512_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA512_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_SHA512_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA512_HMAC(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_SHA512_ALG_HANDLE(), null, 4, null));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA512_HMAC_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_SHA512_ALG_HANDLE(), null, 4, null));
                                continue block65;
                            }
                            case "SHA3-256": {
                                system.getExposedFeatures$bread_server_lib().add(new WindowsHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA3_256(), WindowsBCryptHandlesKt.getBCRYPT_SHA3_256_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA3_256_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_SHA3_256_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA3_256_HMAC(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_SHA3_256_ALG_HANDLE(), null, 4, null));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA3_256_HMAC_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_SHA3_256_ALG_HANDLE(), null, 4, null));
                                continue block65;
                            }
                            case "SHA3-384": {
                                system.getExposedFeatures$bread_server_lib().add(new WindowsHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA3_384(), WindowsBCryptHandlesKt.getBCRYPT_SHA3_384_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA3_384_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_SHA3_384_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA3_384_HMAC(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_SHA3_384_ALG_HANDLE(), null, 4, null));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA3_384_HMAC_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_SHA3_384_ALG_HANDLE(), null, 4, null));
                                continue block65;
                            }
                            case "SHA3-512": {
                                system.getExposedFeatures$bread_server_lib().add(new WindowsHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA3_512(), WindowsBCryptHandlesKt.getBCRYPT_SHA3_512_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA3_512_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_SHA3_512_ALG_HANDLE()));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA3_512_HMAC(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_SHA3_512_ALG_HANDLE(), null, 4, null));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHA3_512_HMAC_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_HMAC_SHA3_512_ALG_HANDLE(), null, 4, null));
                                continue block65;
                            }
                            case "SHAKE128": {
                                it = Arena.ofShared();
                                boolean bl = false;
                                String string = (String)CollectionsKt.first((Iterable)providers);
                                Intrinsics.checkNotNull(it);
                                EnumSet<Enum> enumSet = EnumSet.of((Enum)WindowsBCryptAlgorithmFlags.BCRYPT_HASH_REUSABLE_FLAG);
                                Intrinsics.checkNotNullExpressionValue(enumSet, "of(...)");
                                algorithm = WindowsCommonHashingKt.createBCryptAlgorithm(function, string, it, enumSet);
                                system.getExposedFeatures$bread_server_lib().add(new WindowsXOFHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHAKE128(), algorithm, it));
                                continue block65;
                            }
                            case "SHAKE256": {
                                it = Arena.ofShared();
                                boolean bl = false;
                                String string = (String)CollectionsKt.first((Iterable)providers);
                                Intrinsics.checkNotNull(it);
                                EnumSet<Enum> enumSet = EnumSet.of((Enum)WindowsBCryptAlgorithmFlags.BCRYPT_HASH_REUSABLE_FLAG);
                                Intrinsics.checkNotNullExpressionValue(enumSet, "of(...)");
                                algorithm = WindowsCommonHashingKt.createBCryptAlgorithm(function, string, it, enumSet);
                                system.getExposedFeatures$bread_server_lib().add(new WindowsXOFHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHAKE256(), algorithm, it));
                                continue block65;
                            }
                            case "CSHAKE128": {
                                system.getExposedFeatures$bread_server_lib().add(new WindowsCSHAKEXOFHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_CSHAKE128(), WindowsBCryptHandlesKt.getBCRYPT_CSHAKE128_ALG_HANDLE()));
                                continue block65;
                            }
                            case "CSHAKE256": {
                                system.getExposedFeatures$bread_server_lib().add(new WindowsCSHAKEXOFHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_CSHAKE256(), WindowsBCryptHandlesKt.getBCRYPT_CSHAKE256_ALG_HANDLE()));
                                continue block65;
                            }
                            case "AES-CMAC": {
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_AES_CMAC(), WindowsBCryptHandlesKt.getBCRYPT_AES_CMAC_ALG_HANDLE(), null, 4, null));
                                system.getExposedFeatures$bread_server_lib().add(new WindowsMACSIMDHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_AES_CMAC_SIMD(), WindowsBCryptHandlesKt.getBCRYPT_AES_CMAC_ALG_HANDLE(), null, 4, null));
                                continue block65;
                            }
                            case "KMAC128": {
                                system.getExposedFeatures$bread_server_lib().add(new WindowsKMACXOFHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_KMAC128(), WindowsBCryptHandlesKt.getBCRYPT_KMAC128_ALG_HANDLE(), null, 4, null));
                                continue block65;
                            }
                            case "KMAC256": {
                                system.getExposedFeatures$bread_server_lib().add(new WindowsKMACXOFHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_KMAC256(), WindowsBCryptHandlesKt.getBCRYPT_KMAC256_ALG_HANDLE(), null, 4, null));
                                continue block65;
                            }
                        }
                        this.logger.info(() -> WindowsBCryptCryptographySystemProvider.new$lambda$12(iface, function));
                    }
                    continue block63;
                }
                case 3: {
                    Set<String> providers;
                    String function;
                    for (Map.Entry<String, Set<String>> entry2 : functions.entrySet()) {
                        function = entry2.getKey();
                        providers = entry2.getValue();
                        this.logger.info(() -> WindowsBCryptCryptographySystemProvider.new$lambda$13(iface, function));
                    }
                    continue block63;
                }
                case 4: {
                    Set<String> providers;
                    String function;
                    for (Map.Entry<String, Set<String>> entry2 : functions.entrySet()) {
                        function = entry2.getKey();
                        providers = entry2.getValue();
                        this.logger.info(() -> WindowsBCryptCryptographySystemProvider.new$lambda$14(iface, function));
                    }
                    continue block63;
                }
                case 5: {
                    Set<String> providers;
                    String function;
                    for (Map.Entry<String, Set<String>> entry2 : functions.entrySet()) {
                        function = entry2.getKey();
                        providers = entry2.getValue();
                        this.logger.info(() -> WindowsBCryptCryptographySystemProvider.new$lambda$15(iface, function));
                    }
                    continue block63;
                }
                case 6: {
                    MemorySegment algorithm;
                    Arena it;
                    Set<String> providers;
                    String function;
                    block69: for (Map.Entry<String, Set<String>> entry2 : functions.entrySet()) {
                        function = entry2.getKey();
                        providers = entry2.getValue();
                        switch (function) {
                            case "DUALECRNG": {
                                continue block69;
                            }
                            case "RNG": {
                                system.getExposedFeatures$bread_server_lib().add(new WindowsRandomFeature(CryptographySystemFeatures.INSTANCE.getRANDOM(), WindowsBCryptHandlesKt.getBCRYPT_RNG_ALG_HANDLE()));
                                continue block69;
                            }
                            case "FIPS186DSARNG": {
                                it = Arena.ofShared();
                                boolean bl = false;
                                String string = (String)CollectionsKt.first((Iterable)providers);
                                Intrinsics.checkNotNull(it);
                                EnumSet<WindowsBCryptAlgorithmFlags> enumSet = EnumSet.noneOf(WindowsBCryptAlgorithmFlags.class);
                                Intrinsics.checkNotNullExpressionValue(enumSet, "noneOf(...)");
                                algorithm = WindowsCommonHashingKt.createBCryptAlgorithm(function, string, it, enumSet);
                                system.getExposedFeatures$bread_server_lib().add(new WindowsRandomFeature(CryptographySystemFeatures.INSTANCE.getRANDOM_FIPS_186_2_DSA(), algorithm));
                                continue block69;
                            }
                        }
                        this.logger.info(() -> WindowsBCryptCryptographySystemProvider.new$lambda$17(iface, function));
                    }
                    continue block63;
                }
                case 7: {
                    Set<String> providers;
                    String function;
                    for (Map.Entry<String, Set<String>> entry2 : functions.entrySet()) {
                        function = entry2.getKey();
                        providers = entry2.getValue();
                        this.logger.info(() -> WindowsBCryptCryptographySystemProvider.new$lambda$18(iface, function));
                    }
                    continue block63;
                }
                case 8: {
                    Set<String> providers;
                    String function;
                    for (Map.Entry<String, Set<String>> entry2 : functions.entrySet()) {
                        function = entry2.getKey();
                        providers = entry2.getValue();
                        this.logger.info(() -> WindowsBCryptCryptographySystemProvider.new$lambda$19(iface, function));
                    }
                    continue block63;
                }
                case 9: {
                    Set<String> providers;
                    String function;
                    for (Map.Entry<String, Set<String>> entry2 : functions.entrySet()) {
                        function = entry2.getKey();
                        providers = entry2.getValue();
                        this.logger.info(() -> WindowsBCryptCryptographySystemProvider.new$lambda$20(iface, function));
                    }
                    continue block63;
                }
                case 10: {
                    Set<String> providers;
                    String function;
                    for (Map.Entry<String, Set<String>> entry2 : functions.entrySet()) {
                        function = entry2.getKey();
                        providers = entry2.getValue();
                        this.logger.info(() -> WindowsBCryptCryptographySystemProvider.new$lambda$21(iface, function));
                    }
                    continue block63;
                }
                case 11: {
                    Set<String> providers;
                    String function;
                    for (Map.Entry<String, Set<String>> entry2 : functions.entrySet()) {
                        function = entry2.getKey();
                        providers = entry2.getValue();
                        this.logger.info(() -> WindowsBCryptCryptographySystemProvider.new$lambda$22(iface, function));
                    }
                    continue block63;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        return system;
    }

    private static final void supported$lambda$8$lambda$2$lambda$0(MemorySegment it) {
        MethodHandle methodHandle = WindowsBCryptHandlesKt.getNativeBCryptFreeBuffer();
        Intrinsics.checkNotNull(methodHandle);
        methodHandle.invokeExact(it);
    }

    private static final void supported$lambda$8$lambda$7$lambda$4(MemorySegment it) {
        MethodHandle methodHandle = WindowsBCryptHandlesKt.getNativeBCryptFreeBuffer();
        Intrinsics.checkNotNull(methodHandle);
        methodHandle.invokeExact(it);
    }

    private static final String new$lambda$9(WindowsBCryptInterface $iface, String $function) {
        return $iface + ": Needs implementation: " + $function;
    }

    private static final String new$lambda$12(WindowsBCryptInterface $iface, String $function) {
        return $iface + ": Needs implementation: " + $function;
    }

    private static final String new$lambda$13(WindowsBCryptInterface $iface, String $function) {
        return $iface + ": Needs implementation: " + $function;
    }

    private static final String new$lambda$14(WindowsBCryptInterface $iface, String $function) {
        return $iface + ": Needs implementation: " + $function;
    }

    private static final String new$lambda$15(WindowsBCryptInterface $iface, String $function) {
        return $iface + ": Needs implementation: " + $function;
    }

    private static final String new$lambda$17(WindowsBCryptInterface $iface, String $function) {
        return $iface + ": Needs implementation: " + $function;
    }

    private static final String new$lambda$18(WindowsBCryptInterface $iface, String $function) {
        return $iface + ": Needs implementation: " + $function;
    }

    private static final String new$lambda$19(WindowsBCryptInterface $iface, String $function) {
        return $iface + ": Needs implementation: " + $function;
    }

    private static final String new$lambda$20(WindowsBCryptInterface $iface, String $function) {
        return $iface + ": Needs implementation: " + $function;
    }

    private static final String new$lambda$21(WindowsBCryptInterface $iface, String $function) {
        return $iface + ": Needs implementation: " + $function;
    }

    private static final String new$lambda$22(WindowsBCryptInterface $iface, String $function) {
        return $iface + ": Needs implementation: " + $function;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WindowsBCryptInterface.values().length];
            try {
                nArray[WindowsBCryptInterface.BCRYPT_CIPHER_INTERFACE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WindowsBCryptInterface.BCRYPT_HASH_INTERFACE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WindowsBCryptInterface.BCRYPT_ASYMMETRIC_ENCRYPTION_INTERFACE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WindowsBCryptInterface.BCRYPT_SECRET_AGREEMENT_INTERFACE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WindowsBCryptInterface.BCRYPT_SIGNATURE_INTERFACE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WindowsBCryptInterface.BCRYPT_RNG_INTERFACE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WindowsBCryptInterface.BCRYPT_KEY_DERIVATION_INTERFACE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WindowsBCryptInterface.NCRYPT_KEY_STORAGE_INTERFACE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WindowsBCryptInterface.NCRYPT_SCHANNEL_INTERFACE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WindowsBCryptInterface.NCRYPT_SCHANNEL_SIGNATURE_INTERFACE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WindowsBCryptInterface.NCRYPT_KEY_PROTECTION_INTERFACE.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

