/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.secure.cryptography.windows.feature.hash;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.bread_experts_group.api.FeatureExpression;
import org.bread_experts_group.api.ImplementationSource;
import org.bread_experts_group.api.secure.cryptography.CryptographySystemFeatures;
import org.bread_experts_group.api.secure.cryptography.feature.hash.CSHAKEXOFHashingFeature;
import org.bread_experts_group.api.secure.cryptography.windows.feature.hash.WindowsXOFHashingFeature;
import org.bread_experts_group.ffi.windows.WindowsNTSTATUSException;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.bread_experts_group.ffi.windows.bcrypt.WindowsBCryptHandlesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0011H\u0016J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0011\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0096\u0002J\u0011\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0011H\u0096\u0002J\b\u0010\u001c\u001a\u00020\u0019H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u0011H\u0016J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u0011H\u0016R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/bread_experts_group/api/secure/cryptography/windows/feature/hash/WindowsCSHAKEXOFHashingFeature;", "Lorg/bread_experts_group/api/secure/cryptography/feature/hash/CSHAKEXOFHashingFeature;", "expresses", "Lorg/bread_experts_group/api/FeatureExpression;", "algorithm", "Ljava/lang/foreign/MemorySegment;", "<init>", "(Lorg/bread_experts_group/api/FeatureExpression;Ljava/lang/foreign/MemorySegment;)V", "getExpresses", "()Lorg/bread_experts_group/api/FeatureExpression;", "source", "Lorg/bread_experts_group/api/ImplementationSource;", "getSource", "()Lorg/bread_experts_group/api/ImplementationSource;", "deference", "Lorg/bread_experts_group/api/secure/cryptography/windows/feature/hash/WindowsXOFHashingFeature;", "export", "", "exportIncremental", "length", "", "exportX", "flush", "flushX", "plusAssign", "", "b", "", "reset", "supported", "", "setFunctionName", "n", "setCustomizationString", "s", "bread_server_lib"})
public final class WindowsCSHAKEXOFHashingFeature
extends CSHAKEXOFHashingFeature {
    @NotNull
    private final FeatureExpression<CSHAKEXOFHashingFeature> expresses;
    @NotNull
    private final ImplementationSource source;
    @NotNull
    private final WindowsXOFHashingFeature deference;

    public WindowsCSHAKEXOFHashingFeature(@NotNull FeatureExpression<CSHAKEXOFHashingFeature> expresses, @NotNull MemorySegment algorithm) {
        Intrinsics.checkNotNullParameter(expresses, "expresses");
        Intrinsics.checkNotNullParameter(algorithm, "algorithm");
        this.expresses = expresses;
        this.source = ImplementationSource.SYSTEM_NATIVE;
        this.deference = new WindowsXOFHashingFeature(CryptographySystemFeatures.INSTANCE.getHASHING_SHAKE128(), algorithm, null, 4, null);
    }

    @Override
    @NotNull
    public FeatureExpression<CSHAKEXOFHashingFeature> getExpresses() {
        return this.expresses;
    }

    @Override
    @NotNull
    public ImplementationSource getSource() {
        return this.source;
    }

    @Override
    @NotNull
    public byte[] export() {
        return this.deference.export();
    }

    @Override
    @NotNull
    public byte[] exportIncremental(int length) {
        return this.deference.exportIncremental(length);
    }

    @Override
    @NotNull
    public byte[] exportX(int length) {
        return this.deference.exportX(length);
    }

    @Override
    @NotNull
    public byte[] flush() {
        return this.deference.flush();
    }

    @Override
    @NotNull
    public byte[] flushX(int length) {
        return this.deference.flushX(length);
    }

    @Override
    public void plusAssign(byte b) {
        this.deference.plusAssign(b);
    }

    @Override
    public void plusAssign(@NotNull byte[] b) {
        Intrinsics.checkNotNullParameter(b, "b");
        this.deference.plusAssign(b);
    }

    @Override
    public void reset() {
        this.deference.reset();
    }

    @Override
    public boolean supported() {
        try {
            byte[] byArray = new byte[]{1, 2, 3};
            this.setFunctionName(byArray);
            byArray = new byte[]{1, 2, 3};
            this.setCustomizationString(byArray);
            this.plusAssign((byte)1);
            this.flush();
            this.deference.setInternalHash(null);
        }
        catch (WindowsNTSTATUSException windowsNTSTATUSException) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFunctionName(@NotNull byte[] n) {
        Intrinsics.checkNotNullParameter(n, "n");
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            Arena tempArena = (Arena)autoCloseable;
            boolean bl = false;
            MemorySegment fs = tempArena.allocateFrom("FunctionNameString", Charsets.UTF_16LE);
            MemorySegment fsA = tempArena.allocate(n.length);
            MemorySegment.copy(n, 0, fsA, ValueLayout.JAVA_BYTE, 0L, n.length);
            MethodHandle methodHandle = WindowsBCryptHandlesKt.getNativeBCryptSetProperty();
            Intrinsics.checkNotNull(methodHandle);
            MemorySegment memorySegment = this.deference.getHash();
            Intrinsics.checkNotNull(fs);
            Intrinsics.checkNotNull(fsA);
            WindowsUtilitiesKt.returnsNTSTATUS(methodHandle, memorySegment, fs, fsA, n.length, 0);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCustomizationString(@NotNull byte[] s) {
        Intrinsics.checkNotNullParameter(s, "s");
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            Arena tempArena = (Arena)autoCloseable;
            boolean bl = false;
            MemorySegment cs = tempArena.allocateFrom("CustomizationString", Charsets.UTF_16LE);
            MemorySegment csA = tempArena.allocate(s.length);
            MemorySegment.copy(s, 0, csA, ValueLayout.JAVA_BYTE, 0L, s.length);
            MethodHandle methodHandle = WindowsBCryptHandlesKt.getNativeBCryptSetProperty();
            Intrinsics.checkNotNull(methodHandle);
            MemorySegment memorySegment = this.deference.getHash();
            Intrinsics.checkNotNull(cs);
            Intrinsics.checkNotNull(csA);
            WindowsUtilitiesKt.returnsNTSTATUS(methodHandle, memorySegment, cs, csA, s.length, 0);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }
}

