/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.secure.cryptography.windows.feature.hash;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.util.Collection;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.bread_experts_group.coder.Flaggable;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.bread_experts_group.ffi.windows.bcrypt.WindowsBCryptAlgorithmFlags;
import org.bread_experts_group.ffi.windows.bcrypt.WindowsBCryptHandlesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\t\u001a,\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u001a.\u0010\n\u001a\u0016\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00010\u0001\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u001a\"\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u001a*\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u001a\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0001\u001a\u0016\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0001\u001a\u0016\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a'\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u00012\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010 \u001a\u000e\u0010!\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u0001\"2\u0010\u0014\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00010\u0001 \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00010\u0001\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"createBCryptAlgorithm", "Ljava/lang/foreign/MemorySegment;", "algorithmID", "", "algorithmProvider", "arena", "Ljava/lang/foreign/Arena;", "flags", "Ljava/util/EnumSet;", "Lorg/bread_experts_group/ffi/windows/bcrypt/WindowsBCryptAlgorithmFlags;", "secretPair", "Lkotlin/Pair;", "kotlin.jvm.PlatformType", "", "secret", "", "createBCryptHashHandle", "algorithm", "createBCryptMultiHashHandle", "n", "singleAlloc", "Ljava/lang/ThreadLocal;", "hashAddSingle", "", "b", "", "hashHandle", "hashAddArray", "hashGetDigestLength", "hashFlush", "hashObject", "length", "(Ljava/lang/foreign/MemorySegment;Ljava/lang/foreign/MemorySegment;Ljava/lang/Integer;)[B", "dupeHash", "bread_server_lib"})
public final class WindowsCommonHashingKt {
    private static final ThreadLocal<MemorySegment> singleAlloc = ThreadLocal.withInitial(WindowsCommonHashingKt::singleAlloc$lambda$7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final MemorySegment createBCryptAlgorithm(@NotNull String algorithmID, @NotNull String algorithmProvider, @NotNull Arena arena, @NotNull EnumSet<WindowsBCryptAlgorithmFlags> flags) {
        MemorySegment memorySegment;
        Intrinsics.checkNotNullParameter(algorithmID, "algorithmID");
        Intrinsics.checkNotNullParameter(algorithmProvider, "algorithmProvider");
        Intrinsics.checkNotNullParameter(arena, "arena");
        Intrinsics.checkNotNullParameter(flags, "flags");
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            Arena tempArena = (Arena)autoCloseable;
            boolean bl = false;
            MemorySegment handleRec = tempArena.allocate(ValueLayout.ADDRESS);
            MethodHandle methodHandle = WindowsBCryptHandlesKt.getNativeBCryptOpenAlgorithmProvider();
            Intrinsics.checkNotNull(methodHandle);
            Intrinsics.checkNotNull(handleRec);
            MemorySegment memorySegment2 = tempArena.allocateFrom(algorithmID, Charsets.UTF_16LE);
            Intrinsics.checkNotNullExpressionValue(memorySegment2, "allocateFrom(...)");
            MemorySegment memorySegment3 = tempArena.allocateFrom(algorithmProvider, Charsets.UTF_16LE);
            Intrinsics.checkNotNullExpressionValue(memorySegment3, "allocateFrom(...)");
            WindowsUtilitiesKt.returnsNTSTATUS(methodHandle, handleRec, memorySegment2, memorySegment3, (int)Flaggable.Companion.raw((Collection<? extends Flaggable>)flags));
            MemorySegment memorySegment4 = handleRec.get(ValueLayout.ADDRESS, 0L).reinterpret(arena, WindowsCommonHashingKt::createBCryptAlgorithm$lambda$1$lambda$0);
            memorySegment = memorySegment4;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        Intrinsics.checkNotNullExpressionValue(memorySegment, "use(...)");
        return memorySegment;
    }

    private static final Pair<MemorySegment, Integer> secretPair(Arena arena, byte[] secret) {
        Pair<MemorySegment, Integer> pair;
        if (secret != null) {
            MemorySegment memorySegment;
            MemorySegment it = memorySegment = arena.allocate(secret.length);
            boolean bl = false;
            MemorySegment.copy(secret, 0, it, ValueLayout.JAVA_BYTE, 0L, secret.length);
            pair = TuplesKt.to(memorySegment, secret.length);
        } else {
            pair = TuplesKt.to(MemorySegment.NULL, 0);
        }
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final MemorySegment createBCryptHashHandle(@NotNull MemorySegment algorithm, @NotNull Arena arena, @Nullable byte[] secret) {
        Intrinsics.checkNotNullParameter(algorithm, "algorithm");
        Intrinsics.checkNotNullParameter(arena, "arena");
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            Arena tempArena = (Arena)autoCloseable;
            boolean bl = false;
            MemorySegment objectHandle = tempArena.allocate(WindowsBCryptHandlesKt.getBCRYPT_HASH_HANDLE());
            Intrinsics.checkNotNull(tempArena);
            Pair<MemorySegment, Integer> pair = WindowsCommonHashingKt.secretPair(tempArena, secret);
            MemorySegment secretAlloc = pair.component1();
            int secretSize = ((Number)pair.component2()).intValue();
            MethodHandle methodHandle = WindowsBCryptHandlesKt.getNativeBCryptCreateHash();
            Intrinsics.checkNotNull(methodHandle);
            Intrinsics.checkNotNull(objectHandle);
            MemorySegment memorySegment = MemorySegment.NULL;
            Intrinsics.checkNotNullExpressionValue(memorySegment, "NULL");
            Integer n = 0;
            Intrinsics.checkNotNull(secretAlloc);
            WindowsUtilitiesKt.returnsNTSTATUS(methodHandle, algorithm, objectHandle, memorySegment, n, secretAlloc, secretSize, (int)WindowsBCryptAlgorithmFlags.BCRYPT_HASH_REUSABLE_FLAG.getPosition());
            MemorySegment memorySegment2 = objectHandle.get(WindowsBCryptHandlesKt.getBCRYPT_HASH_HANDLE(), 0L).reinterpret(arena, WindowsCommonHashingKt::createBCryptHashHandle$lambda$4$lambda$3);
            Intrinsics.checkNotNullExpressionValue(memorySegment2, "reinterpret(...)");
            MemorySegment memorySegment3 = memorySegment2;
            return memorySegment3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    public static /* synthetic */ MemorySegment createBCryptHashHandle$default(MemorySegment memorySegment, Arena arena, byte[] byArray, int n, Object object) {
        if ((n & 4) != 0) {
            byArray = null;
        }
        return WindowsCommonHashingKt.createBCryptHashHandle(memorySegment, arena, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final MemorySegment createBCryptMultiHashHandle(@NotNull MemorySegment algorithm, @NotNull Arena arena, int n, @Nullable byte[] secret) {
        Intrinsics.checkNotNullParameter(algorithm, "algorithm");
        Intrinsics.checkNotNullParameter(arena, "arena");
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            Arena tempArena = (Arena)autoCloseable;
            boolean bl = false;
            MemorySegment objectHandle = tempArena.allocate(WindowsBCryptHandlesKt.getBCRYPT_HASH_HANDLE());
            Intrinsics.checkNotNull(tempArena);
            Pair<MemorySegment, Integer> pair = WindowsCommonHashingKt.secretPair(tempArena, secret);
            MemorySegment secretAlloc = pair.component1();
            int secretSize = ((Number)pair.component2()).intValue();
            MethodHandle methodHandle = WindowsBCryptHandlesKt.getNativeBCryptCreateMultiHash();
            Intrinsics.checkNotNull(methodHandle);
            Intrinsics.checkNotNull(objectHandle);
            Integer n2 = n;
            MemorySegment memorySegment = MemorySegment.NULL;
            Intrinsics.checkNotNullExpressionValue(memorySegment, "NULL");
            Integer n3 = 0;
            Intrinsics.checkNotNull(secretAlloc);
            WindowsUtilitiesKt.returnsNTSTATUS(methodHandle, algorithm, objectHandle, n2, memorySegment, n3, secretAlloc, secretSize, (int)WindowsBCryptAlgorithmFlags.BCRYPT_HASH_REUSABLE_FLAG.getPosition());
            MemorySegment memorySegment2 = objectHandle.get(WindowsBCryptHandlesKt.getBCRYPT_HASH_HANDLE(), 0L).reinterpret(arena, WindowsCommonHashingKt::createBCryptMultiHashHandle$lambda$6$lambda$5);
            Intrinsics.checkNotNullExpressionValue(memorySegment2, "reinterpret(...)");
            MemorySegment memorySegment3 = memorySegment2;
            return memorySegment3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    public static /* synthetic */ MemorySegment createBCryptMultiHashHandle$default(MemorySegment memorySegment, Arena arena, int n, byte[] byArray, int n2, Object object) {
        if ((n2 & 8) != 0) {
            byArray = null;
        }
        return WindowsCommonHashingKt.createBCryptMultiHashHandle(memorySegment, arena, n, byArray);
    }

    public static final void hashAddSingle(byte b, @NotNull MemorySegment hashHandle) {
        Intrinsics.checkNotNullParameter(hashHandle, "hashHandle");
        MemorySegment it = singleAlloc.get();
        boolean bl = false;
        it.set(ValueLayout.JAVA_BYTE, 0L, b);
        MethodHandle methodHandle = WindowsBCryptHandlesKt.getNativeBCryptHashData();
        Intrinsics.checkNotNull(methodHandle);
        Intrinsics.checkNotNull(it);
        WindowsUtilitiesKt.returnsNTSTATUS(methodHandle, hashHandle, it, 1, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void hashAddArray(@NotNull byte[] b, @NotNull MemorySegment hashHandle) {
        Intrinsics.checkNotNullParameter(b, "b");
        Intrinsics.checkNotNullParameter(hashHandle, "hashHandle");
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            Arena tempArena = (Arena)autoCloseable;
            boolean bl = false;
            MemorySegment copy = tempArena.allocate(b.length);
            MemorySegment.copy(b, 0, copy, ValueLayout.JAVA_BYTE, 0L, b.length);
            MethodHandle methodHandle = WindowsBCryptHandlesKt.getNativeBCryptHashData();
            Intrinsics.checkNotNull(methodHandle);
            Intrinsics.checkNotNull(copy);
            WindowsUtilitiesKt.returnsNTSTATUS(methodHandle, hashHandle, copy, b.length, 0);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    public static final int hashGetDigestLength(@NotNull MemorySegment algorithm, @NotNull Arena arena) {
        Intrinsics.checkNotNullParameter(algorithm, "algorithm");
        Intrinsics.checkNotNullParameter(arena, "arena");
        MemorySegment length = arena.allocate(WindowsUtilitiesKt.getDWORD());
        MemorySegment lengthSz = arena.allocate(WindowsUtilitiesKt.getULONG());
        MethodHandle methodHandle = WindowsBCryptHandlesKt.getNativeBCryptGetProperty();
        Intrinsics.checkNotNull(methodHandle);
        MemorySegment memorySegment = arena.allocateFrom("HashDigestLength", Charsets.UTF_16LE);
        Intrinsics.checkNotNullExpressionValue(memorySegment, "allocateFrom(...)");
        Intrinsics.checkNotNull(length);
        Integer n = (int)length.byteSize();
        Intrinsics.checkNotNull(lengthSz);
        WindowsUtilitiesKt.returnsNTSTATUS(methodHandle, algorithm, memorySegment, length, n, lengthSz, 0);
        return length.get(WindowsUtilitiesKt.getDWORD(), 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] hashFlush(@NotNull MemorySegment algorithm, @NotNull MemorySegment hashObject, @Nullable Integer length) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter(algorithm, "algorithm");
        Intrinsics.checkNotNullParameter(hashObject, "hashObject");
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            int n;
            Arena tempArena = (Arena)autoCloseable;
            boolean bl = false;
            Integer n2 = length;
            if (n2 != null) {
                n = n2;
            } else {
                Intrinsics.checkNotNull(tempArena);
                n = WindowsCommonHashingKt.hashGetDigestLength(algorithm, tempArena);
            }
            int digestLength = n;
            MemorySegment allocated = tempArena.allocate(digestLength);
            MethodHandle methodHandle = WindowsBCryptHandlesKt.getNativeBCryptFinishHash();
            Intrinsics.checkNotNull(methodHandle);
            Intrinsics.checkNotNull(allocated);
            WindowsUtilitiesKt.returnsNTSTATUS(methodHandle, hashObject, allocated, digestLength, 0);
            byArray = allocated.toArray(ValueLayout.JAVA_BYTE);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        Intrinsics.checkNotNullExpressionValue(byArray, "use(...)");
        return byArray;
    }

    public static /* synthetic */ byte[] hashFlush$default(MemorySegment memorySegment, MemorySegment memorySegment2, Integer n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = null;
        }
        return WindowsCommonHashingKt.hashFlush(memorySegment, memorySegment2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final MemorySegment dupeHash(@NotNull MemorySegment hashObject) {
        MemorySegment memorySegment;
        Intrinsics.checkNotNullParameter(hashObject, "hashObject");
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            Arena tempArena = (Arena)autoCloseable;
            boolean bl = false;
            MemorySegment newHandle = tempArena.allocate(WindowsBCryptHandlesKt.getBCRYPT_HASH_HANDLE());
            MethodHandle methodHandle = WindowsBCryptHandlesKt.getNativeBCryptDuplicateHash();
            Intrinsics.checkNotNull(methodHandle);
            Intrinsics.checkNotNull(newHandle);
            MemorySegment memorySegment2 = MemorySegment.NULL;
            Intrinsics.checkNotNullExpressionValue(memorySegment2, "NULL");
            WindowsUtilitiesKt.returnsNTSTATUS(methodHandle, hashObject, newHandle, memorySegment2, 0, 0);
            MemorySegment memorySegment3 = newHandle.get(WindowsBCryptHandlesKt.getBCRYPT_HASH_HANDLE(), 0L);
            memorySegment = memorySegment3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        Intrinsics.checkNotNullExpressionValue(memorySegment, "use(...)");
        return memorySegment;
    }

    private static final void createBCryptAlgorithm$lambda$1$lambda$0(MemorySegment it) {
        MethodHandle methodHandle = WindowsBCryptHandlesKt.getNativeBCryptCloseAlgorithmProvider();
        Intrinsics.checkNotNull(methodHandle);
        Intrinsics.checkNotNull(it);
        WindowsUtilitiesKt.returnsNTSTATUS(methodHandle, it, 0);
    }

    private static final void createBCryptHashHandle$lambda$4$lambda$3(MemorySegment it) {
        MethodHandle methodHandle = WindowsBCryptHandlesKt.getNativeBCryptDestroyHash();
        Intrinsics.checkNotNull(methodHandle);
        Intrinsics.checkNotNull(it);
        WindowsUtilitiesKt.returnsNTSTATUS(methodHandle, it);
    }

    private static final void createBCryptMultiHashHandle$lambda$6$lambda$5(MemorySegment it) {
        MethodHandle methodHandle = WindowsBCryptHandlesKt.getNativeBCryptDestroyHash();
        Intrinsics.checkNotNull(methodHandle);
        Intrinsics.checkNotNull(it);
        WindowsUtilitiesKt.returnsNTSTATUS(methodHandle, it);
    }

    private static final MemorySegment singleAlloc$lambda$7() {
        return Arena.ofConfined().allocate(ValueLayout.JAVA_BYTE);
    }
}

