/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.secure.cryptography.windows.feature.hash;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.api.FeatureExpression;
import org.bread_experts_group.api.ImplementationSource;
import org.bread_experts_group.api.secure.cryptography.feature.hash.HashingFeature;
import org.bread_experts_group.api.secure.cryptography.windows.feature.hash.WindowsCommonHashingKt;
import org.bread_experts_group.ffi.windows.WindowsNTSTATUSException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\u0010\u0012\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0011\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0096\u0002J\u0011\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001aH\u0096\u0002J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u001aH\u0016J\b\u0010\u001d\u001a\u00020\u0017H\u0016R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lorg/bread_experts_group/api/secure/cryptography/windows/feature/hash/WindowsHashingFeature;", "Lorg/bread_experts_group/api/secure/cryptography/feature/hash/HashingFeature;", "expresses", "Lorg/bread_experts_group/api/FeatureExpression;", "algorithm", "Ljava/lang/foreign/MemorySegment;", "<init>", "(Lorg/bread_experts_group/api/FeatureExpression;Ljava/lang/foreign/MemorySegment;)V", "getExpresses", "()Lorg/bread_experts_group/api/FeatureExpression;", "source", "Lorg/bread_experts_group/api/ImplementationSource;", "getSource", "()Lorg/bread_experts_group/api/ImplementationSource;", "arena", "Ljava/lang/foreign/Arena;", "internalHash", "hash", "getHash", "()Ljava/lang/foreign/MemorySegment;", "supported", "", "plusAssign", "", "b", "", "", "flush", "export", "reset", "bread_server_lib"})
public final class WindowsHashingFeature
extends HashingFeature {
    @NotNull
    private final FeatureExpression<HashingFeature> expresses;
    @NotNull
    private final MemorySegment algorithm;
    @NotNull
    private final ImplementationSource source;
    @NotNull
    private final Arena arena;
    @Nullable
    private MemorySegment internalHash;

    public WindowsHashingFeature(@NotNull FeatureExpression<HashingFeature> expresses, @NotNull MemorySegment algorithm) {
        Intrinsics.checkNotNullParameter(expresses, "expresses");
        Intrinsics.checkNotNullParameter(algorithm, "algorithm");
        this.expresses = expresses;
        this.algorithm = algorithm;
        this.source = ImplementationSource.SYSTEM_NATIVE;
        Arena arena = Arena.ofShared();
        Intrinsics.checkNotNullExpressionValue(arena, "ofShared(...)");
        this.arena = arena;
    }

    @Override
    @NotNull
    public FeatureExpression<HashingFeature> getExpresses() {
        return this.expresses;
    }

    @Override
    @NotNull
    public ImplementationSource getSource() {
        return this.source;
    }

    /*
     * WARNING - void declaration
     */
    private final MemorySegment getHash() {
        MemorySegment memorySegment = this.internalHash;
        if (memorySegment == null) {
            void var3_3;
            MemorySegment newHash;
            WindowsHashingFeature $this$_get_hash__u24lambda_u240 = this;
            boolean bl = false;
            $this$_get_hash__u24lambda_u240.internalHash = newHash = WindowsCommonHashingKt.createBCryptHashHandle$default($this$_get_hash__u24lambda_u240.algorithm, $this$_get_hash__u24lambda_u240.arena, null, 4, null);
            memorySegment = var3_3;
        }
        return memorySegment;
    }

    @Override
    public boolean supported() {
        try {
            this.plusAssign((byte)1);
            this.flush();
            this.internalHash = null;
        }
        catch (WindowsNTSTATUSException windowsNTSTATUSException) {
            return false;
        }
        return true;
    }

    @Override
    public void plusAssign(byte b) {
        WindowsCommonHashingKt.hashAddSingle(b, this.getHash());
    }

    @Override
    public void plusAssign(@NotNull byte[] b) {
        Intrinsics.checkNotNullParameter(b, "b");
        WindowsCommonHashingKt.hashAddArray(b, this.getHash());
    }

    @Override
    @NotNull
    public byte[] flush() {
        return WindowsCommonHashingKt.hashFlush$default(this.algorithm, this.getHash(), null, 4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public byte[] export() {
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            Arena tempArena = (Arena)autoCloseable;
            boolean bl = false;
            MemorySegment duped = WindowsCommonHashingKt.dupeHash(this.getHash());
            byte[] exported = this.flush();
            this.internalHash = duped;
            byte[] byArray = exported;
            return byArray;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    @Override
    public void reset() {
        this.internalHash = null;
    }
}

