/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.secure.cryptography.windows.feature.hash;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.bread_experts_group.api.FeatureExpression;
import org.bread_experts_group.api.ImplementationSource;
import org.bread_experts_group.api.secure.cryptography.feature.hash.KMACXOFHashingFeature;
import org.bread_experts_group.api.secure.cryptography.windows.feature.hash.WindowsCommonHashingKt;
import org.bread_experts_group.ffi.windows.WindowsNTSTATUSException;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.bread_experts_group.ffi.windows.bcrypt.WindowsBCryptAlgorithmFlags;
import org.bread_experts_group.ffi.windows.bcrypt.WindowsBCryptHandlesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0019H\u0016J\b\u0010\u001c\u001a\u00020\u0019H\u0016J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0019H\u0016J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0011\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%H\u0096\u0002J\u0011\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u0019H\u0096\u0002J\b\u0010&\u001a\u00020\u0017H\u0016R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006'"}, d2={"Lorg/bread_experts_group/api/secure/cryptography/windows/feature/hash/WindowsKMACXOFHashingFeature;", "Lorg/bread_experts_group/api/secure/cryptography/feature/hash/KMACXOFHashingFeature;", "expresses", "Lorg/bread_experts_group/api/FeatureExpression;", "algorithm", "Ljava/lang/foreign/MemorySegment;", "arena", "Ljava/lang/foreign/Arena;", "<init>", "(Lorg/bread_experts_group/api/FeatureExpression;Ljava/lang/foreign/MemorySegment;Ljava/lang/foreign/Arena;)V", "getExpresses", "()Lorg/bread_experts_group/api/FeatureExpression;", "source", "Lorg/bread_experts_group/api/ImplementationSource;", "getSource", "()Lorg/bread_experts_group/api/ImplementationSource;", "internalHash", "hash", "getHash", "()Ljava/lang/foreign/MemorySegment;", "supported", "", "setSecret", "", "key", "", "setCustomizationString", "s", "export", "exportX", "length", "", "flush", "flushX", "exportIncremental", "plusAssign", "b", "", "reset", "bread_server_lib"})
public final class WindowsKMACXOFHashingFeature
extends KMACXOFHashingFeature {
    @NotNull
    private final FeatureExpression<KMACXOFHashingFeature> expresses;
    @NotNull
    private final MemorySegment algorithm;
    @NotNull
    private final Arena arena;
    @NotNull
    private final ImplementationSource source;
    @Nullable
    private MemorySegment internalHash;

    public WindowsKMACXOFHashingFeature(@NotNull FeatureExpression<KMACXOFHashingFeature> expresses, @NotNull MemorySegment algorithm, @NotNull Arena arena) {
        Intrinsics.checkNotNullParameter(expresses, "expresses");
        Intrinsics.checkNotNullParameter(algorithm, "algorithm");
        Intrinsics.checkNotNullParameter(arena, "arena");
        this.expresses = expresses;
        this.algorithm = algorithm;
        this.arena = arena;
        this.source = ImplementationSource.SYSTEM_NATIVE;
    }

    public /* synthetic */ WindowsKMACXOFHashingFeature(FeatureExpression featureExpression, MemorySegment memorySegment, Arena arena, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            Arena arena2 = Arena.ofShared();
            Intrinsics.checkNotNullExpressionValue(arena2, "ofShared(...)");
            arena = arena2;
        }
        this(featureExpression, memorySegment, arena);
    }

    @Override
    @NotNull
    public FeatureExpression<KMACXOFHashingFeature> getExpresses() {
        return this.expresses;
    }

    @Override
    @NotNull
    public ImplementationSource getSource() {
        return this.source;
    }

    private final MemorySegment getHash() {
        MemorySegment memorySegment = this.internalHash;
        if (memorySegment == null) {
            throw new IllegalStateException("Secret not initialized");
        }
        return memorySegment;
    }

    @Override
    public boolean supported() {
        try {
            byte[] byArray = new byte[]{1, 2, 3};
            this.setSecret(byArray);
            byArray = new byte[]{1, 2, 3};
            this.setCustomizationString(byArray);
            this.plusAssign((byte)1);
            this.flush();
            this.internalHash = null;
        }
        catch (WindowsNTSTATUSException windowsNTSTATUSException) {
            return false;
        }
        return true;
    }

    @Override
    public void setSecret(@NotNull byte[] key) {
        Intrinsics.checkNotNullParameter(key, "key");
        this.internalHash = WindowsCommonHashingKt.createBCryptHashHandle(this.algorithm, this.arena, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCustomizationString(@NotNull byte[] s) {
        Intrinsics.checkNotNullParameter(s, "s");
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            Arena tempArena = (Arena)autoCloseable;
            boolean bl = false;
            MemorySegment cs = tempArena.allocateFrom("CustomizationString", Charsets.UTF_16LE);
            MemorySegment csA = tempArena.allocate(s.length);
            MemorySegment.copy(s, 0, csA, ValueLayout.JAVA_BYTE, 0L, s.length);
            MethodHandle methodHandle = WindowsBCryptHandlesKt.getNativeBCryptSetProperty();
            Intrinsics.checkNotNull(methodHandle);
            MemorySegment memorySegment = this.getHash();
            Intrinsics.checkNotNull(cs);
            Intrinsics.checkNotNull(csA);
            WindowsUtilitiesKt.returnsNTSTATUS(methodHandle, memorySegment, cs, csA, s.length, 0);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public byte[] export() {
        byte[] byArray;
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            Arena tempArena = (Arena)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull(tempArena);
            byArray = this.exportX(WindowsCommonHashingKt.hashGetDigestLength(this.algorithm, tempArena));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return byArray;
    }

    @Override
    @NotNull
    public byte[] exportX(int length) {
        MemorySegment duped = WindowsCommonHashingKt.dupeHash(this.getHash());
        byte[] exported = this.flushX(length);
        this.internalHash = duped;
        return exported;
    }

    @Override
    @NotNull
    public byte[] flush() {
        return WindowsCommonHashingKt.hashFlush$default(this.algorithm, this.getHash(), null, 4, null);
    }

    @Override
    @NotNull
    public byte[] flushX(int length) {
        return WindowsCommonHashingKt.hashFlush(this.algorithm, this.getHash(), length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public byte[] exportIncremental(int length) {
        byte[] byArray;
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            Arena tempArena = (Arena)autoCloseable;
            boolean bl = false;
            MemorySegment allocated = tempArena.allocate(length);
            MethodHandle methodHandle = WindowsBCryptHandlesKt.getNativeBCryptFinishHash();
            Intrinsics.checkNotNull(methodHandle);
            MemorySegment memorySegment = this.getHash();
            Intrinsics.checkNotNull(allocated);
            WindowsUtilitiesKt.returnsNTSTATUS(methodHandle, memorySegment, allocated, (int)allocated.byteSize(), (int)WindowsBCryptAlgorithmFlags.BCRYPT_HASH_DONT_RESET_FLAG.getPosition());
            byArray = allocated.toArray(ValueLayout.JAVA_BYTE);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        Intrinsics.checkNotNullExpressionValue(byArray, "use(...)");
        return byArray;
    }

    @Override
    public void plusAssign(byte b) {
        WindowsCommonHashingKt.hashAddSingle(b, this.getHash());
    }

    @Override
    public void plusAssign(@NotNull byte[] b) {
        Intrinsics.checkNotNullParameter(b, "b");
        WindowsCommonHashingKt.hashAddArray(b, this.getHash());
    }

    @Override
    public void reset() {
        this.internalHash = null;
    }
}

