/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.secure.cryptography.windows.feature.random;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.bread_experts_group.api.FeatureExpression;
import org.bread_experts_group.api.ImplementationSource;
import org.bread_experts_group.api.secure.cryptography.feature.random.RandomFeature;
import org.bread_experts_group.api.secure.cryptography.windows.feature.random.WindowsCommonRandomKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0015H\u0016R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001e"}, d2={"Lorg/bread_experts_group/api/secure/cryptography/windows/feature/random/WindowsRandomFeature;", "Lorg/bread_experts_group/api/secure/cryptography/feature/random/RandomFeature;", "expresses", "Lorg/bread_experts_group/api/FeatureExpression;", "algorithm", "Ljava/lang/foreign/MemorySegment;", "<init>", "(Lorg/bread_experts_group/api/FeatureExpression;Ljava/lang/foreign/MemorySegment;)V", "getExpresses", "()Lorg/bread_experts_group/api/FeatureExpression;", "source", "Lorg/bread_experts_group/api/ImplementationSource;", "getSource", "()Lorg/bread_experts_group/api/ImplementationSource;", "supported", "", "nextByte", "", "nextShort", "", "nextInt", "", "nextLong", "", "fill", "", "b", "", "offset", "length", "bread_server_lib"})
public final class WindowsRandomFeature
extends RandomFeature {
    @NotNull
    private final FeatureExpression<RandomFeature> expresses;
    @Nullable
    private final MemorySegment algorithm;
    @NotNull
    private final ImplementationSource source;

    public WindowsRandomFeature(@NotNull FeatureExpression<RandomFeature> expresses, @Nullable MemorySegment algorithm) {
        Intrinsics.checkNotNullParameter(expresses, "expresses");
        this.expresses = expresses;
        this.algorithm = algorithm;
        this.source = ImplementationSource.SYSTEM_NATIVE;
    }

    @Override
    @NotNull
    public FeatureExpression<RandomFeature> getExpresses() {
        return this.expresses;
    }

    @Override
    @NotNull
    public ImplementationSource getSource() {
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supported() {
        boolean bl;
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            Arena tempArena = (Arena)autoCloseable;
            boolean bl2 = false;
            MemorySegment memorySegment = tempArena.allocate(16L);
            Intrinsics.checkNotNullExpressionValue(memorySegment, "allocate(...)");
            WindowsCommonRandomKt.fillRandom(this.algorithm, memorySegment);
            bl = true;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte nextByte() {
        byte by;
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            Arena tempArena = (Arena)autoCloseable;
            boolean bl = false;
            MemorySegment area = tempArena.allocate(ValueLayout.JAVA_BYTE);
            Intrinsics.checkNotNull(area);
            WindowsCommonRandomKt.fillRandom(this.algorithm, area);
            by = area.get(ValueLayout.JAVA_BYTE, 0L);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return by;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short nextShort() {
        short s;
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            Arena tempArena = (Arena)autoCloseable;
            boolean bl = false;
            MemorySegment area = tempArena.allocate(ValueLayout.JAVA_SHORT);
            Intrinsics.checkNotNull(area);
            WindowsCommonRandomKt.fillRandom(this.algorithm, area);
            s = area.get(ValueLayout.JAVA_SHORT, 0L);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int nextInt() {
        int n;
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            Arena tempArena = (Arena)autoCloseable;
            boolean bl = false;
            MemorySegment area = tempArena.allocate(ValueLayout.JAVA_INT);
            Intrinsics.checkNotNull(area);
            WindowsCommonRandomKt.fillRandom(this.algorithm, area);
            n = area.get(ValueLayout.JAVA_INT, 0L);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long nextLong() {
        long l;
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            Arena tempArena = (Arena)autoCloseable;
            boolean bl = false;
            MemorySegment area = tempArena.allocate(ValueLayout.JAVA_LONG);
            Intrinsics.checkNotNull(area);
            WindowsCommonRandomKt.fillRandom(this.algorithm, area);
            l = area.get(ValueLayout.JAVA_LONG, 0L);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fill(@NotNull byte[] b, int offset, int length) {
        Intrinsics.checkNotNullParameter(b, "b");
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            Arena tempArena = (Arena)autoCloseable;
            boolean bl = false;
            MemorySegment area = tempArena.allocate(length);
            Intrinsics.checkNotNull(area);
            WindowsCommonRandomKt.fillRandom(this.algorithm, area);
            MemorySegment.copy(area, ValueLayout.JAVA_BYTE, 0L, b, offset, length);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }
}

