/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.api.serial.windows;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.invoke.MethodHandle;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.bread_experts_group.api.ImplementationSource;
import org.bread_experts_group.api.serial.SerialInterface;
import org.bread_experts_group.api.serial.SerialParityScheme;
import org.bread_experts_group.coder.Mappable;
import org.bread_experts_group.coder.MappedEnumeration;
import org.bread_experts_group.ffi.ForeignFunctionInterfaceKt;
import org.bread_experts_group.ffi.windows.SerialCommunicationDeviceControl;
import org.bread_experts_group.ffi.windows.WindowsBaudRate;
import org.bread_experts_group.ffi.windows.WindowsCreationDisposition;
import org.bread_experts_group.ffi.windows.WindowsFileSharingTypes;
import org.bread_experts_group.ffi.windows.WindowsGenericAccessRights;
import org.bread_experts_group.ffi.windows.WindowsKernelHandlesKt;
import org.bread_experts_group.ffi.windows.WindowsParityScheme;
import org.bread_experts_group.ffi.windows.WindowsStopBits;
import org.bread_experts_group.ffi.windows.WindowsUtilitiesKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016J7\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0019H\u0016J\u0010\u0010\u0018\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\tH\u0016J\b\u0010 \u001a\u00020\rH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/bread_experts_group/api/serial/windows/WindowsSerialInterface;", "Lorg/bread_experts_group/api/serial/SerialInterface;", "<init>", "()V", "source", "Lorg/bread_experts_group/api/ImplementationSource;", "getSource", "()Lorg/bread_experts_group/api/ImplementationSource;", "supported", "", "serialHandle", "Ljava/lang/foreign/MemorySegment;", "configure", "", "device", "Lkotlin/UByte;", "baudRate", "Lkotlin/UInt;", "dataBits", "stopBits", "parityScheme", "Lorg/bread_experts_group/api/serial/SerialParityScheme;", "configure-0-2fA3g", "(BIBBLorg/bread_experts_group/api/serial/SerialParityScheme;)V", "read", "", "b", "length", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "close", "bread_server_lib"})
@SourceDebugExtension(value={"SMAP\nWindowsSerialInterface.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsSerialInterface.kt\norg/bread_experts_group/api/serial/windows/WindowsSerialInterface\n+ 2 Mappable.kt\norg/bread_experts_group/coder/Mappable$Companion\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n14#2,2:92\n16#2:95\n18#2,2:97\n295#3:94\n296#3:96\n*S KotlinDebug\n*F\n+ 1 WindowsSerialInterface.kt\norg/bread_experts_group/api/serial/windows/WindowsSerialInterface\n*L\n46#1:92,2\n46#1:95\n46#1:97,2\n46#1:94\n46#1:96\n*E\n"})
public final class WindowsSerialInterface
extends SerialInterface {
    @NotNull
    private final ImplementationSource source = ImplementationSource.SYSTEM_NATIVE;
    private MemorySegment serialHandle;

    @Override
    @NotNull
    public ImplementationSource getSource() {
        return this.source;
    }

    @Override
    public boolean supported() {
        WindowsKernelHandlesKt.getNativeCreateFile3();
        WindowsKernelHandlesKt.getNativeGetCommState();
        WindowsKernelHandlesKt.getNativeSetCommState();
        WindowsKernelHandlesKt.getNativeReadFile();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected void configure-0-2fA3g(byte device, int baudRate, byte dataBits, byte stopBits, @NotNull SerialParityScheme parityScheme) {
        Intrinsics.checkNotNullParameter((Object)parityScheme, "parityScheme");
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            Object v6;
            void n$iv;
            SerialCommunicationDeviceControl serialCommunicationDeviceControl;
            SerialCommunicationDeviceControl dcb;
            Arena arena;
            block16: {
                void $this$id$iv;
                arena = (Arena)autoCloseable;
                boolean bl = false;
                Intrinsics.checkNotNull(arena);
                String string = "\\\\.\\COM" + UByte.toString-impl(device);
                EnumSet<Enum> enumSet = EnumSet.of((Enum)WindowsGenericAccessRights.GENERIC_READ, (Enum)WindowsGenericAccessRights.GENERIC_WRITE);
                Intrinsics.checkNotNullExpressionValue(enumSet, "of(...)");
                EnumSet<WindowsFileSharingTypes> enumSet2 = EnumSet.noneOf(WindowsFileSharingTypes.class);
                Intrinsics.checkNotNullExpressionValue(enumSet2, "noneOf(...)");
                this.serialHandle = WindowsKernelHandlesKt.createFile3(arena, string, enumSet, enumSet2, WindowsCreationDisposition.OPEN_EXISTING);
                dcb = new SerialCommunicationDeviceControl(arena);
                MethodHandle methodHandle = WindowsKernelHandlesKt.getNativeGetCommState();
                Intrinsics.checkNotNull(methodHandle);
                MemorySegment memorySegment = ForeignFunctionInterfaceKt.getCapturedStateSegment();
                MemorySegment memorySegment2 = this.serialHandle;
                if (memorySegment2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("serialHandle");
                    memorySegment2 = null;
                }
                if (methodHandle.invokeExact(memorySegment, memorySegment2, dcb.getPtr()) == 0) {
                    WindowsUtilitiesKt.decodeLastError(arena);
                }
                Mappable.Companion companion = Mappable.Companion;
                EnumEntries<WindowsBaudRate> enumEntries = WindowsBaudRate.getEntries();
                UInt uInt = UInt.box-impl(baudRate);
                serialCommunicationDeviceControl = dcb;
                boolean $i$f$id = false;
                Iterable $this$firstOrNull$iv$iv = (Iterable)$this$id$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                    Enum it$iv = (Enum)element$iv$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(((Mappable)((Object)it$iv)).getId(), n$iv)) continue;
                    v6 = element$iv$iv;
                    break block16;
                }
                v6 = null;
            }
            void var22_24 = n$iv;
            Enum enum_ = v6;
            serialCommunicationDeviceControl.setBaudRate(new MappedEnumeration<void, Enum>(enum_, var22_24));
            dcb.setDataBits-7apg3OU(dataBits);
            dcb.setStopBits(new MappedEnumeration(switch (UInt.constructor-impl(stopBits & 0xFF)) {
                case 1 -> WindowsStopBits.ONESTOPBOT;
                case 15 -> WindowsStopBits.ONE5STOPBITS;
                case 2 -> WindowsStopBits.TWOSTOPBITS;
                default -> throw new UnsupportedOperationException("Stop bit count " + UByte.toString-impl(stopBits) + " is not supported");
            }));
            if (WhenMappings.$EnumSwitchMapping$0[parityScheme.ordinal()] != 1) {
                throw new NoWhenBranchMatchedException();
            }
            dcb.setParityScheme(new MappedEnumeration(WindowsParityScheme.NOPARITY));
            MethodHandle methodHandle = WindowsKernelHandlesKt.getNativeSetCommState();
            Intrinsics.checkNotNull(methodHandle);
            MemorySegment memorySegment = ForeignFunctionInterfaceKt.getCapturedStateSegment();
            MemorySegment memorySegment3 = this.serialHandle;
            if (memorySegment3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("serialHandle");
                memorySegment3 = null;
            }
            if (methodHandle.invokeExact(memorySegment, memorySegment3, dcb.getPtr()) == 0) {
                WindowsUtilitiesKt.decodeLastError(arena);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long read(@NotNull MemorySegment b, long length) {
        Intrinsics.checkNotNullParameter(b, "b");
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            Arena arena = (Arena)autoCloseable;
            boolean bl = false;
            MemorySegment read = arena.allocate(WindowsUtilitiesKt.getDWORD());
            MethodHandle methodHandle = WindowsKernelHandlesKt.getNativeReadFile();
            Intrinsics.checkNotNull(methodHandle);
            MemorySegment memorySegment = ForeignFunctionInterfaceKt.getCapturedStateSegment();
            MemorySegment memorySegment2 = this.serialHandle;
            if (memorySegment2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("serialHandle");
                memorySegment2 = null;
            }
            if (methodHandle.invokeExact(memorySegment, memorySegment2, b, (int)RangesKt.coerceAtMost(length, Integer.MAX_VALUE), read, MemorySegment.NULL) == 0) {
                Intrinsics.checkNotNull(arena);
                WindowsUtilitiesKt.decodeLastError(arena);
            }
            long l = read.get(WindowsUtilitiesKt.getDWORD(), 0L);
            return l;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    @Override
    public int read(@NotNull ByteBuffer dst) {
        Intrinsics.checkNotNullParameter(dst, "dst");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public boolean isOpen() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public void close() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SerialParityScheme.values().length];
            try {
                nArray[SerialParityScheme.NO_PARITY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

