/*
 * Decompiled with CFR 0.152.
 */
package org.bread_experts_group.channel;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0011\u001a\u00020\u0012*\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0007\u001a\u001a\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\b\u001a+\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0007R\u00020\u0018R\u00020\bj\u0006\u0010\u001b\u001a\u00020\u0018j\u0006\u0010\u0019\u001a\u00020\b\u00a2\u0006\u0002\u0010\u001c\u001a\u0014\u0010\u001e\u001a\u00020\u0012*\u00020\u000e2\b\b\u0002\u0010\u001f\u001a\u00020 \"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0015\u0010\u0006\u001a\u00020\u0007*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u0015\u0010\u000b\u001a\u00020\u0007*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\"\u0015\u0010\r\u001a\u00020\u000e*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\"\u000e\u0010\u001d\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"CRLFi", "", "getCRLFi", "()[I", "SPi", "getSPi", "byteInt", "", "Ljava/nio/ByteBuffer;", "getByteInt", "(Ljava/nio/ByteBuffer;)I", "shortInt", "getShortInt", "intLong", "", "getIntLong", "(Ljava/nio/ByteBuffer;)J", "array", "", "n", "transferTo", "", "Ljava/nio/channels/ReadableByteChannel;", "channel", "Ljava/nio/channels/WritableByteChannel;", "buffer", "ensureCapacity", "to", "(Ljava/nio/channels/WritableByteChannel;Ljava/nio/ByteBuffer;I)V", "longBuffer", "bytes", "order", "Ljava/nio/ByteOrder;", "bread_server_lib"})
public final class BufferUtilKt {
    @NotNull
    private static final int[] CRLFi;
    @NotNull
    private static final int[] SPi;
    @NotNull
    private static final ByteBuffer longBuffer;

    @NotNull
    public static final int[] getCRLFi() {
        return CRLFi;
    }

    @NotNull
    public static final int[] getSPi() {
        return SPi;
    }

    public static final int getByteInt(@NotNull ByteBuffer $this$byteInt) {
        Intrinsics.checkNotNullParameter($this$byteInt, "<this>");
        return $this$byteInt.get() & 0xFF;
    }

    public static final int getShortInt(@NotNull ByteBuffer $this$shortInt) {
        Intrinsics.checkNotNullParameter($this$shortInt, "<this>");
        return $this$shortInt.getShort() & 0xFFFF;
    }

    public static final long getIntLong(@NotNull ByteBuffer $this$intLong) {
        Intrinsics.checkNotNullParameter($this$intLong, "<this>");
        return (long)$this$intLong.getInt() & 0xFFFFFFFFL;
    }

    @NotNull
    public static final byte[] array(@NotNull ByteBuffer $this$array, int n) {
        Intrinsics.checkNotNullParameter($this$array, "<this>");
        byte[] array = new byte[n];
        $this$array.get(array);
        return array;
    }

    public static final void transferTo(@NotNull ReadableByteChannel $this$transferTo, @NotNull WritableByteChannel channel, @NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter($this$transferTo, "<this>");
        Intrinsics.checkNotNullParameter(channel, "channel");
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        while (true) {
            buffer.clear();
            int written = $this$transferTo.read(buffer);
            if (written == -1) break;
            buffer.flip();
            channel.write(buffer);
        }
    }

    public static final void ensureCapacity(@NotNull WritableByteChannel to, @NotNull ByteBuffer buffer, int n) {
        Intrinsics.checkNotNullParameter(to, "to");
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        if (buffer.remaining() < n) {
            buffer.flip();
            to.write(buffer);
            buffer.clear();
        }
    }

    @NotNull
    public static final byte[] bytes(long $this$bytes, @NotNull ByteOrder order) {
        Intrinsics.checkNotNullParameter(order, "order");
        longBuffer.order(order);
        longBuffer.putLong(0, $this$bytes);
        byte[] byArray = longBuffer.array();
        Intrinsics.checkNotNullExpressionValue(byArray, "array(...)");
        return byArray;
    }

    public static /* synthetic */ byte[] bytes$default(long l, ByteOrder byteOrder, int n, Object object) {
        if ((n & 1) != 0) {
            ByteOrder byteOrder2 = ByteOrder.BIG_ENDIAN;
            Intrinsics.checkNotNullExpressionValue(byteOrder2, "BIG_ENDIAN");
            byteOrder = byteOrder2;
        }
        return BufferUtilKt.bytes(l, byteOrder);
    }

    static {
        int[] nArray = new int[]{13, 10};
        CRLFi = nArray;
        nArray = new int[]{32};
        SPi = nArray;
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "allocate(...)");
        longBuffer = byteBuffer;
    }
}

